/*
 * Decompiled with CFR 0.152.
 */
package com.appon.miniframework.controls;

import com.appon.miniframework.Control;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Settings;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class ProgressBar
extends Control {
    private int progressBarColor = -1;
    private int maxProgress = 100;
    private int currentProgress = 50;
    private Image progressImage;
    private int infiniteProgressBarWidthPercent = 4;
    private int progressBarType;
    private static final int MIN_WIDTH_PERCENT = 3;
    private int imageResourceId = -1;
    private int currentX;
    public static final int PROGRESS_TYPE_PROGRESSIVE = 0;
    public static final int PROGRESS_TYPE_INFINITE = 1;
    private int updateSpeed = 1;

    public ProgressBar(int id) {
        super(id);
    }

    public void paint(Graphics g) {
        int clipX = g.getClipX();
        int clipY = g.getClipY();
        int clipWidth = g.getClipWidth();
        int clipHeight = g.getClipHeight();
        if (this.progressBarType == 1) {
            g.clipRect(0, 0, this.getBoundWidth(), this.getBoundHeight());
            int w = this.getBoundWidth() * this.infiniteProgressBarWidthPercent / 100;
            if (w < 3) {
                w = 3;
            }
            g.clipRect(this.currentX, 0, w, this.getBoundHeight());
            this.currentX += this.getUpdateSpeed();
            if (this.currentX > this.getBoundWidth()) {
                this.currentX = 0;
            }
            if (this.progressBarColor != -1) {
                g.setColor(Util.getColor(this.getProgressBarColor()));
                g.fillRect(this.currentX, 0, w, this.getBoundHeight());
            }
            if (this.progressImage != null) {
                this.fillImageRect(g, this.currentX, 0, w, this.getBoundHeight(), this.progressImage);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        } else {
            int per = this.currentProgress * 100 / this.maxProgress;
            this.currentX = this.getBoundWidth() * per / 100;
            g.clipRect(0, 0, this.currentX, this.getBoundHeight());
            if (this.progressBarColor != -1) {
                g.setColor(Util.getColor(this.getProgressBarColor()));
                g.fillRect(0, 0, this.currentX, this.getBoundHeight());
            }
            if (this.progressImage != null) {
                this.fillImageRect(g, 0, 0, this.currentX, this.getBoundHeight(), this.progressImage);
            }
            g.setClip(clipX, clipY, clipWidth, clipHeight);
        }
    }

    private void fillImageRect(Graphics g, int x, int y, int width, int height, Image image) {
        int _maxW = x + width + Util.getImageWidth(image);
        int w = Util.getImageWidth(image);
        int _maxH = y + height + Util.getImageHeight(image);
        int h = Util.getImageHeight(image);
        for (int i = x; i <= _maxW; i += w) {
            for (int j = y; j <= _maxH; j += h) {
                Util.drawImage(g, image, i, j);
            }
        }
    }

    public void showNotify() {
        super.showNotify();
        this.currentX = 0;
    }

    public void setUpdateSpeed(int updateSpeed) {
        this.updateSpeed = updateSpeed;
    }

    public int getUpdateSpeed() {
        return this.updateSpeed;
    }

    public int getClassCode() {
        return 1014;
    }

    public int getProgressBarColor() {
        return this.progressBarColor;
    }

    public void setProgressBarColor(int scrollBarColor) {
        this.progressBarColor = scrollBarColor;
    }

    public int getMaxProgress() {
        return this.maxProgress;
    }

    public void setMaxProgress(int maxProgress) {
        this.maxProgress = maxProgress;
    }

    public int getCurrentProgress() {
        return this.currentProgress;
    }

    public void setCurrentProgress(int currentProgress) {
        this.currentProgress = currentProgress;
    }

    public int getInfiniteProgressBarWidthPercent() {
        return this.infiniteProgressBarWidthPercent;
    }

    public void setInfiniteProgressBarWidthPercent(int infiniteProgressBarWidthPercent) {
        this.infiniteProgressBarWidthPercent = infiniteProgressBarWidthPercent;
    }

    public int getProgressBarType() {
        return this.progressBarType;
    }

    public void setProgressBarType(int progressBarType) {
        this.progressBarType = progressBarType;
    }

    public int getImageResourceId() {
        return this.imageResourceId;
    }

    public void setImageResourceId(int imageResourceId) {
        this.imageResourceId = imageResourceId;
    }

    public Image getProgressImage() {
        return this.progressImage;
    }

    public void setProgressImage(Image progressImage) {
        this.progressImage = progressImage;
    }

    public byte[] serialize() throws Exception {
        return null;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.setProgressBarType(Util.readInt(bis, 1));
        this.setProgressBarColor(Util.readColor(bis));
        this.setImageResourceId(Util.readSignedInt(bis, 2));
        this.setProgressImage(ResourceManager.getInstance().getImageResource(this.getImageResourceId()));
        this.setMaxProgress(Util.readInt(bis, 2));
        this.setInfiniteProgressBarWidthPercent(Util.readInt(bis, 1));
        this.setUpdateSpeed(Util.readInt(bis, 1));
        if (Settings.VERSION_NUMBER_FOUND >= 3) {
            this.setCurrentProgress(Util.readInt(bis, 1));
        }
        bis.close();
        return null;
    }
}

