/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.customShapes;

import com.appon.knighttestgame.helper.LineWalker;
import com.appon.knighttestgame.helper.ProjectileMotion;
import com.appon.runner.RunnerManager;
import com.appon.runner.model.AddedShape;
import com.appon.runner.model.CustomShape;
import com.appon.runner.util.Util;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.Hero;
import com.indiagames.arjunprince.KnightTestEngine;
import javax.microedition.lcdui.Graphics;

public class Rope
extends CustomShape {
    private int x1;
    private int y1;
    private int _ropeAngle = 90;
    private int ropeheight;
    int _y1;
    int _y2;
    int radius;
    private boolean isRopeHold = false;
    private boolean ropeLeave = false;
    private boolean ropeCut = false;
    private boolean ropeCutSet = false;
    private LineWalker lineCordinate = new LineWalker();

    public void paint(Graphics g, int x, int y) {
        if (this.isRopeHold && !this.isRopeCut()) {
            this.x1 = KnightTestEngine.hero.getHeroX() + KnightTestEngine.hero.collsionRectToHoldRope[0];
            this.y1 = y + (Constant.RADIUS * ProjectileMotion.sin(Math.abs(this._ropeAngle)) >> 14);
        } else if (!(this.isRopeHold || this.isRopeLeave() || this.isRopeCut())) {
            this.x1 = x;
            this.y1 = y + (Constant.RADIUS * ProjectileMotion.sin(Math.abs(this._ropeAngle)) >> 14);
        } else if (this.isRopeLeave() && !this.isRopeCut()) {
            this.x1 = x + (Constant.RADIUS * ProjectileMotion.cos(Math.abs(this._ropeAngle)) >> 14);
            this.y1 = y + (Constant.RADIUS * ProjectileMotion.sin(Math.abs(this._ropeAngle)) >> 14);
        } else if (this.isRopeCut()) {
            this.x1 = x + (this.radius * ProjectileMotion.cos(Math.abs(this._ropeAngle)) >> 14);
            this.y1 = y + (this.radius * ProjectileMotion.sin(Math.abs(this._ropeAngle)) >> 14);
        }
        this.ropeheight = this.y1 - y;
        if (!this.isRopeCut()) {
            this.lineCordinate.init(x, y, this.x1, this.y1);
        } else {
            this.lineCordinate.init(x, y, this.x1, this.y1);
        }
        while (!this.lineCordinate.isOver()) {
            g.drawImage(Constant.IMG_ROPE.getImage(), this.lineCordinate.getX() - 5, this.lineCordinate.getY() - 5, 0);
            this.lineCordinate.update(Constant.IMG_ROPE.getHeight());
        }
    }

    public int getHeight() {
        return this.ropeheight;
    }

    public int getWidth() {
        return 0;
    }

    public void update(AddedShape addedShape) {
        if (this.isRopeHold) {
            addedShape.setX(addedShape.getX() - Constant.MIN_GAME_SPEED);
            if (Hero.getHeroState() != 6 && !this.isRopeLeave()) {
                this.setRopeLeave(true);
                this._ropeAngle = 0;
                this.setIsRopeHold(false);
            }
        } else if ((this.isRopeLeave() || this.isRopeCut()) && !this.isRopeHold) {
            if (this._ropeAngle < 90) {
                this._ropeAngle += 20;
            } else {
                RunnerManager.getManager().removeAddedShape(addedShape);
            }
        }
    }

    public void reset() {
        this.setIsRopeHold(false);
        this.setRopeLeave(false);
        this._ropeAngle = 90;
        this.ropeCutSet = false;
        this.setRopeCut(false);
        this.ropeheight = Constant.RADIUS;
    }

    public AddedShape checkCollision(int rectX, int rectY, int rectWidth, int rectHeight, AddedShape addedShape) {
        if (!this.isRopeHold && !this.isRopeLeave()) {
            this.x1 = addedShape.getX() - RunnerManager.getManager().getCurrentCamX();
            this.y1 = addedShape.getY() + (Constant.RADIUS * ProjectileMotion.sin(Math.abs(this._ropeAngle)) >> 14);
        }
        if (Util.lineToRectangle(addedShape.getX(), addedShape.getY(), this.x1, this.y1, KnightTestEngine.hero.getHeroX() + KnightTestEngine.hero.collisionRectToCatchRope[0], KnightTestEngine.hero.getHeroY() + KnightTestEngine.hero.collisionRectToCatchRope[1], KnightTestEngine.hero.collisionRectToCatchRope[2], KnightTestEngine.hero.collisionRectToCatchRope[3]) && !this.isRopeHold && Hero.getHeroState() != 8 && KnightTestEngine.getInstance().ropCollideID != addedShape.getId()) {
            int tempY = addedShape.getY() + addedShape.getAdditionalY() + (Constant.RADIUS * ProjectileMotion.sin(Math.abs(this._ropeAngle)) >> 14);
            KnightTestEngine.hero.setHeroY(tempY + Hero.getHeroInstance().heroTantra.getFrameHeight(21) - Constant.IMG_ROPE.getHeight());
            this.setIsRopeHold(true);
            Hero.setHeroState(6);
            KnightTestEngine.getInstance().ropCollideID = addedShape.getId();
            KnightTestEngine.hero.collisionRectToCatchRope[0] = 0;
            KnightTestEngine.hero.collisionRectToCatchRope[1] = 0;
            KnightTestEngine.hero.collisionRectToCatchRope[2] = 0;
            KnightTestEngine.hero.collisionRectToCatchRope[3] = 0;
            return addedShape;
        }
        return null;
    }

    public boolean isIsRopeHold() {
        return this.isRopeHold;
    }

    public boolean isRopeLeave() {
        return this.ropeLeave;
    }

    public void setRopeLeave(boolean ropeLeave) {
        this.ropeLeave = ropeLeave;
    }

    public void setIsRopeHold(boolean isRopeHold) {
        this.isRopeHold = isRopeHold;
    }

    public boolean isRopeCut() {
        return this.ropeCut;
    }

    public void setRopeCut(boolean ropeCut) {
        this.ropeCut = ropeCut;
        if (ropeCut && !this.ropeCutSet) {
            this.ropeCutSet = true;
            this.radius = Constant.RADIUS << 1;
            this._ropeAngle = 20;
        }
    }
}

