/*
 * Decompiled with CFR 0.152.
 */
package com.appon.effectengine;

import com.appon.effectengine.EShape;
import com.appon.effectengine.Effect;
import com.appon.effectengine.EffectUtil;
import com.appon.effectengine.Point;
import com.appon.gtantra.GFont;
import com.appon.miniframework.ResourceManager;
import com.appon.miniframework.Util;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class EGFont
extends EShape {
    private int fillType;
    private int fontId = -1;
    private String text;
    private GFont font;
    private int pallet = 0;
    private int additionPadding;

    public EGFont(int id) {
        super(id);
    }

    public EShape clone() {
        EGFont arc = new EGFont(-1);
        this.copyProperties(arc);
        arc.setFillType(this.getFillType());
        arc.setFontId(this.getFontId());
        arc.setText(this.getText());
        arc.setFont(this.getFont());
        arc.setPallet(this.getPallet());
        arc.setAdditionPadding(this.getAdditionPadding());
        return arc;
    }

    public int getFillType() {
        return this.fillType;
    }

    public void setFillType(int fillType) {
        this.fillType = fillType;
    }

    public int getHeight() {
        if (this.font != null && this.text != null) {
            return this.font.getStringHeight(this.text) + (this.additionPadding << 1);
        }
        return 50;
    }

    public GFont getFont() {
        return this.font;
    }

    public void setFont(GFont font) {
        this.font = font;
    }

    public int getFontId() {
        return this.fontId;
    }

    public void setFontId(int fontId) {
        this.fontId = fontId;
    }

    public String getText() {
        return this.text;
    }

    public void setText(String text) {
        this.text = text;
    }

    public void setPallet(int pallet) {
        this.pallet = pallet;
    }

    public int getWidth() {
        if (this.font != null && this.text != null) {
            return this.font.getStringWidth(this.text) + (this.additionPadding << 1);
        }
        return 50;
    }

    public void setAdditionPadding(int additionPadding) {
        this.additionPadding = additionPadding;
    }

    public int getAdditionPadding() {
        return this.additionPadding;
    }

    public int getPallet() {
        return this.pallet;
    }

    public void paint(Graphics g, int _x, int _y, int theta, int zoom, int anchorX, int anchorY, Effect parent) {
        Point p = EffectUtil.pointToRotate;
        p.setPoints(this.getX(), this.getY());
        EffectUtil.rotatePoint(p, anchorX, anchorY, theta, zoom, this);
        if (this.getFillType() == 1 && this.getBgColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBgColor()));
            g.fillRect(p.getX() + _x, p.getY() + _y, this.getWidth(), this.getHeight());
        }
        if (this.getBorderColor() != -1) {
            g.setColor(EffectUtil.getColor(this.getBorderColor()));
            EffectUtil.drawRectangle(g, p.getX() + _x, p.getY() + _y, this.getWidth(), this.getHeight(), this.getBorderThickness());
        }
        if (this.font != null && this.text != null) {
            this.font.setColor(this.pallet);
            this.font.drawString(g, this.text, p.getX() + _x + this.additionPadding, p.getY() + _y + this.additionPadding, 0);
        }
    }

    public String toString() {
        return "EGFont: " + this.getId();
    }

    public byte[] serialize() throws Exception {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        bos.write(super.serialize());
        Util.writeSignedInt(bos, this.fontId, 1);
        Util.writeInt(bos, this.fillType, 1);
        Util.writeString(bos, this.text);
        Util.writeInt(bos, this.pallet, 1);
        Util.writeInt(bos, this.additionPadding, 1);
        bos.flush();
        byte[] data = bos.toByteArray();
        bos.close();
        bos = null;
        return data;
    }

    public ByteArrayInputStream deserialize(ByteArrayInputStream bis) throws Exception {
        super.deserialize(bis);
        this.fontId = Util.readSignedInt(bis, 1);
        this.setFont(ResourceManager.getInstance().getFontResource(this.fontId));
        this.fillType = Util.readInt(bis, 1);
        this.text = Util.readString(bis);
        this.pallet = Util.readInt(bis, 1);
        this.additionPadding = Util.readInt(bis, 1);
        bis.close();
        return null;
    }

    public int getClassCode() {
        return 2012;
    }
}

