/*
 * Decompiled with CFR 0.152.
 */
package com.appon.knighttestgame.ui;

import com.appon.gtantra.GFont;
import com.appon.knighttestgame.adapter.GameEventListener;
import com.appon.knighttestgame.ui.CustomCanvas;
import com.appon.util.Serilize;
import com.appon.util.Util;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.KnightTestCanvas;
import com.indiagames.arjunprince.KnightTestEngine;
import com.indiagames.arjunprince.RmsDataStore;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import javax.microedition.lcdui.Graphics;

public class ChallengesMenu
extends CustomCanvas
implements GameEventListener {
    private GFont gfont;
    private int maxChallenges;
    private int _y;
    int screen_Id = 0;
    int total_Screen_Id;
    private int totalCells;
    public int selectedIndex = 0;
    public static final int TOTAL_ROWS = 3;
    public static final int TOTAL_COLUMNS = 3;
    public static int MENU_PADDING_Y = 8;
    public static int MENU_PADDING_X = 8;
    private static int MAX_UNLOCKED_LEVELS = 10;
    private static int MAX_UNLOACK_LEVEL_EASY = 5;
    private static int MAX_UNLOACK_LEVEL_HARD = 5;
    public static int TOTAL_LEVELS = 10;
    private String title;
    int distance;
    private static int UNLOCKED_LEVELS_COUNTER_PADDING = 10;
    public static int MAIN_MENU_START_Y;
    private int[] levelWiseHeart = new int[50];
    int boxHeight;
    int stringY;
    private int totalHeart;
    private int modeX;
    private int modeY;
    private int pointerpressX;
    private int pointerpressY;

    public ChallengesMenu(GFont gfont, String lsk, String rsk, String title) {
        super(gfont, lsk, rsk, title);
        this.gfont = gfont;
        this.maxChallenges = TOTAL_LEVELS;
        this.totalCells = 9;
        this.total_Screen_Id = this.maxChallenges / this.totalCells;
        this.title = title;
        this.setListener(this);
    }

    public void reset() {
        super.init();
        this.distance = 20;
        this.maxChallenges = TOTAL_LEVELS;
        this.totalCells = 9;
        this.total_Screen_Id = this.maxChallenges / this.totalCells;
        for (int j = 0; j < KnightTestEngine.rmsVector.size(); ++j) {
            RmsDataStore rmsObj = (RmsDataStore)KnightTestEngine.rmsVector.elementAt(j);
            this.levelWiseHeart[j] = rmsObj.getHeart();
        }
    }

    public void updateChallange(int level) {
        if (level == MAX_UNLOCKED_LEVELS) {
            MAX_UNLOCKED_LEVELS = level + 1;
            if (KnightTestCanvas.challangeMode == 1) {
                ++MAX_UNLOACK_LEVEL_EASY;
            } else {
                ++MAX_UNLOACK_LEVEL_HARD;
            }
            try {
                ByteArrayOutputStream bos = new ByteArrayOutputStream();
                Serilize.serialize(new Integer(MAX_UNLOACK_LEVEL_EASY), bos);
                Serilize.serialize(new Integer(MAX_UNLOACK_LEVEL_HARD), bos);
                bos.flush();
                Util.updateRecord(Constant.CHALLANGE_RMS_NAME, bos.toByteArray());
                bos.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public void setGMenufont(GFont gfont) {
        this.gfont = gfont;
    }

    public void loadchallagesScreen() {
        Constant.IMG_CHALLENGE_ARROW.loadImage();
        Constant.IMG_NEW.loadImage();
        Constant.IMG_CHALLENGE_BOX.loadImage();
        Constant.IMG_LEVEL_SELECTED.loadImage();
        Constant.IMG_CHALLENGE_LOCK.loadImage();
        MAIN_MENU_START_Y = Constant.IMG_CHALLENGE_BOX.getHeight() >> 1;
        this.modeX = 100;
        this.modeY = 2;
        this.stringY = 12;
        this.boxHeight = (Constant.IMG_CHALLENGE_BOX.getHeight() << 2) + (Constant.IMG_CHALLENGE_BOX.getHeight() >> 1);
        byte[] data = Util.getRmsData(Constant.CHALLANGE_RMS_NAME);
        if (data == null) {
            MAX_UNLOACK_LEVEL_EASY = 1;
            MAX_UNLOACK_LEVEL_HARD = 1;
        } else {
            try {
                ByteArrayInputStream bis = new ByteArrayInputStream(data);
                MAX_UNLOACK_LEVEL_EASY = (Integer)Serilize.deserialize(bis, null);
                MAX_UNLOACK_LEVEL_HARD = (Integer)Serilize.deserialize(bis, null);
                bis.close();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        MAX_UNLOCKED_LEVELS = KnightTestCanvas.challangeMode == 1 ? MAX_UNLOACK_LEVEL_EASY : MAX_UNLOACK_LEVEL_HARD;
        this.screen_Id = MAX_UNLOCKED_LEVELS / this.totalCells;
        this.selectedIndex = 0;
        this.screen_Id = 0;
    }

    public void unload() {
        Constant.IMG_CHALLENGE_ARROW.clear();
        Constant.IMG_CHALLENGE_BOX.clear();
        Constant.IMG_LEVEL_SELECTED.clear();
        Constant.IMG_CHALLENGE_LOCK.clear();
        Constant.IMG_NEW.clear();
    }

    protected void paint(Graphics g) {
        g.drawImage(Constant.BGIMAGE_1.getImage(), 0, 0, 0);
        this._y = MAIN_MENU_START_Y;
        int paddingY = (this.boxHeight - Constant.SMALLFONT.getFontHeight() - MENU_PADDING_Y * 3 - 3 * Constant.IMG_CHALLENGE_BOX.getHeight()) / 2;
        int initialPaddingX = Constant.IMG_CHALLENGE_BOX.getWidth() * 3 + 2 * MENU_PADDING_X;
        int drawX = initialPaddingX = Constant.SCREEN_WIDTH - initialPaddingX >> 1;
        int startIndex = this.screen_Id * this.totalCells;
        int endIndex = startIndex + this.totalCells;
        if (endIndex > this.maxChallenges) {
            endIndex = this.maxChallenges;
        }
        if (this.selectedIndex < startIndex) {
            this.selectedIndex = startIndex;
        }
        if (this.selectedIndex > endIndex) {
            this.selectedIndex = endIndex - 1;
        }
        if (this.screen_Id <= this.total_Screen_Id) {
            this._y += MENU_PADDING_Y;
            if (endIndex < this.maxChallenges) {
                g.drawImage(Constant.IMG_CHALLENGE_ARROW.getImage(), Constant.SCREEN_WIDTH - initialPaddingX + (initialPaddingX - Constant.IMG_CHALLENGE_ARROW.getWidth() >> 1), MAIN_MENU_START_Y + (this.boxHeight - Constant.IMG_CHALLENGE_ARROW.getHeight() >> 1), 0);
            }
            if (this.screen_Id > 0) {
                g.drawRegion(Constant.IMG_CHALLENGE_ARROW.getImage(), 0, 0, Constant.IMG_CHALLENGE_ARROW.getWidth(), Constant.IMG_CHALLENGE_ARROW.getHeight(), 2, initialPaddingX - Constant.IMG_CHALLENGE_ARROW.getWidth() >> 1, MAIN_MENU_START_Y + (this.boxHeight - Constant.IMG_CHALLENGE_ARROW.getHeight() >> 1), 0);
            }
            Constant.SMALLFONT.setColor(0);
            if (KnightTestCanvas.challangeMode == 1) {
                // empty if block
            }
            this._y += MENU_PADDING_Y + Constant.SMALLFONT.getFontHeight();
            int counter = 0;
            for (int i = startIndex; i < endIndex; ++i) {
                g.drawImage(Constant.IMG_CHALLENGE_BOX.getImage(), drawX, this._y, 20);
                if (i == this.selectedIndex) {
                    g.drawImage(Constant.IMG_LEVEL_SELECTED.getImage(), drawX - (Constant.IMG_LEVEL_SELECTED.getWidth() - Constant.IMG_LEVEL_SELECTED.getWidth() >> 1), this._y - (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.IMG_CHALLENGE_BOX.getHeight() >> 1) - 1, 20);
                }
                if (i < MAX_UNLOCKED_LEVELS) {
                    this.totalHeart = KnightTestCanvas.challangeMode == 1 ? this.levelWiseHeart[i] : this.levelWiseHeart[10 + i];
                    int tempX = 10;
                    int tempY = this._y + Constant.SMALLFONT.getFontHeight() + (this.distance << 1);
                    Constant.SMALLFONT.setColor(0);
                    Constant.SMALLFONT.drawString(g, "" + (i + 1), drawX + Math.abs(Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.SMALLFONT.getStringWidth("" + (i + 1)) >> 1), this._y + this.distance + (this.distance >> 1), 20);
                    for (int j = 0; j < 3; ++j) {
                    }
                    for (int k = 0; k < this.totalHeart; ++k) {
                    }
                    if (MAX_UNLOCKED_LEVELS == 1) {
                        g.drawImage(Constant.IMG_NEW.getImage(), drawX + (Math.abs(Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.IMG_NEW.getWidth()) >> 1), this._y - (Constant.IMG_NEW.getHeight() >> 1), 20);
                    } else if (i == MAX_UNLOCKED_LEVELS - 1) {
                        g.drawImage(Constant.IMG_NEW.getImage(), drawX + (Math.abs(Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.IMG_NEW.getWidth()) >> 1), this._y - (Constant.IMG_NEW.getHeight() >> 1), 20);
                    }
                } else {
                    this.gfont.setColor(1);
                    g.drawImage(Constant.IMG_CHALLENGE_LOCK.getImage(), drawX + (Constant.IMG_CHALLENGE_BOX.getWidth() - Constant.IMG_CHALLENGE_LOCK.getWidth() >> 1), this._y + (Constant.IMG_CHALLENGE_BOX.getHeight() - Constant.IMG_CHALLENGE_LOCK.getHeight() >> 1), 0);
                }
                drawX += Constant.IMG_CHALLENGE_BOX.getWidth() + MENU_PADDING_X;
                if (++counter % 3 == 0) {
                    this._y += Constant.IMG_CHALLENGE_BOX.getHeight() + paddingY;
                }
                if (counter % 3 != 0) continue;
                drawX = initialPaddingX;
            }
        }
    }

    public boolean handlePointerPressed(int x, int y) {
        if (!super.handlePointerPressed(x, y)) {
            this._y = MAIN_MENU_START_Y;
            int startIndex = this.screen_Id * this.totalCells;
            int endIndex = startIndex + this.totalCells;
            if (endIndex > this.maxChallenges) {
                endIndex = this.maxChallenges;
            }
            this._y += (MENU_PADDING_Y << 1) + (this.gfont.getFontHeight() >> 1) + this.gfont.getFontHeight();
            int paddingY = (this.boxHeight - Constant.SMALLFONT.getFontHeight() - MENU_PADDING_Y * 3 - 3 * Constant.IMG_CHALLENGE_BOX.getHeight()) / 2;
            int initialPaddingX = Constant.IMG_CHALLENGE_BOX.getWidth() * 3 + 2 * MENU_PADDING_X;
            int drawX = initialPaddingX = Constant.SCREEN_WIDTH - initialPaddingX >> 1;
            int counter = 0;
            if (endIndex < this.maxChallenges && Util.isInRect(Constant.SCREEN_WIDTH - initialPaddingX + (initialPaddingX - Constant.IMG_CHALLENGE_ARROW.getWidth() >> 1) - (Constant.IMG_CHALLENGE_ARROW.getWidth() + (Constant.IMG_CHALLENGE_ARROW.getWidth() >> 1)), MAIN_MENU_START_Y + (this.boxHeight - Constant.IMG_CHALLENGE_ARROW.getHeight() >> 1) - (Constant.IMG_CHALLENGE_ARROW.getHeight() + (Constant.IMG_CHALLENGE_ARROW.getHeight() >> 1)), (Constant.IMG_CHALLENGE_ARROW.getWidth() << 2) + Constant.IMG_CHALLENGE_ARROW.getWidth(), Constant.IMG_CHALLENGE_ARROW.getHeight() << 2, x, y)) {
                ++this.screen_Id;
            }
            if (this.screen_Id > 0 && Util.isInRect((initialPaddingX - Constant.IMG_CHALLENGE_ARROW.getWidth() >> 1) - (Constant.IMG_CHALLENGE_ARROW.getWidth() << 1), MAIN_MENU_START_Y + (this.boxHeight - Constant.IMG_CHALLENGE_ARROW.getHeight() >> 1) - (Constant.IMG_CHALLENGE_ARROW.getHeight() + (Constant.IMG_CHALLENGE_ARROW.getHeight() >> 1)), Constant.IMG_CHALLENGE_ARROW.getWidth() << 2, Constant.IMG_CHALLENGE_ARROW.getHeight() << 2, x, y)) {
                --this.screen_Id;
            }
            for (int i = startIndex; i < endIndex; ++i) {
                if (Util.isInRect(drawX, this._y, Constant.IMG_CHALLENGE_BOX.getWidth(), Constant.IMG_CHALLENGE_BOX.getHeight(), x, y)) {
                    this.pointerpressX = drawX;
                    this.pointerpressY = this._y;
                    this.selectedIndex = i;
                    break;
                }
                drawX += Constant.IMG_CHALLENGE_BOX.getWidth() + MENU_PADDING_X;
                if (++counter % 3 == 0) {
                    this._y += Constant.IMG_CHALLENGE_BOX.getHeight() + paddingY;
                }
                if (counter % 3 != 0) continue;
                drawX = initialPaddingX;
            }
            return true;
        }
        return false;
    }

    public int getColFromIndex(int index) {
        return index % 3;
    }

    public int getRowFromIndex(int index) {
        return index / 3;
    }

    public void pointerDragged(int x, int y) {
    }

    public void pointerReleased(int x, int y) {
        if (Util.isInRect(this.pointerpressX, this.pointerpressY, Constant.IMG_CHALLENGE_BOX.getWidth(), Constant.IMG_CHALLENGE_BOX.getHeight(), x, y)) {
            this.levelSelected();
        }
    }

    public void listenMenu(int menuIndex) {
    }

    public void listenSoftKeys(int key) {
        if (key == 0) {
            KnightTestEngine.getInstance().levelGenerator.setInLevelMode(false);
            KnightTestCanvas.getInstance().setGameState(11);
        } else if (key == 1 && this.selectedIndex < MAX_UNLOCKED_LEVELS) {
            this.levelSelected();
        }
    }

    private void levelSelected() {
        if (this.selectedIndex < MAX_UNLOCKED_LEVELS) {
            KnightTestEngine.getInstance().levelGenerator.setInLevelMode(true);
            KnightTestEngine.getInstance().levelGenerator.setCurrentLevel(this.selectedIndex);
            KnightTestCanvas.getInstance().setGameState(12);
        }
    }

    public void itemClicked(int index) {
    }

    protected void keyPressed(int keyCode) {
        int row = this.getRowFromIndex(this.selectedIndex);
        int col = this.getColFromIndex(this.selectedIndex);
        if (Util.isUpPressed(keyCode)) {
            if (row > 3 * (this.screen_Id - 1) + 3 && row < 3 * this.screen_Id + 3) {
                --row;
            }
            this.selectedIndex = row * 3 + col;
        } else if (Util.isDownPressed(keyCode)) {
            if (row < 3 * this.screen_Id + 3 - 1 && row > 3 * (this.screen_Id - 1) + 3 - 1) {
                ++row;
            }
            this.selectedIndex = row * 3 + col;
        } else if (Util.isLeftPressed(keyCode)) {
            if (col > -1) {
                --col;
            }
            if (col == -1) {
                --this.screen_Id;
                col = 2;
                row = this.screen_Id * 3 + 3 - 1;
            }
            if (this.screen_Id == -1) {
                this.screen_Id = 0;
                row = 0;
                col = 0;
            }
            this.selectedIndex = row * 3 + col;
        } else if (Util.isRightPressed(keyCode)) {
            if (col < 3) {
                ++col;
            }
            if (col == 3) {
                ++this.screen_Id;
                col = 0;
                row = this.screen_Id * 3;
            }
            if (this.screen_Id == this.total_Screen_Id + 1) {
                this.screen_Id = this.total_Screen_Id;
                col = 0;
                row = this.screen_Id * 3;
            }
            this.selectedIndex = row * 3 + col;
        } else if (Util.isFirePressed(keyCode)) {
            this.levelSelected();
        }
    }
}

