/*
 * Decompiled with CFR 0.152.
 */
package com.appon.util;

import com.appon.effectengine.EffectsSerilize;
import com.appon.miniframework.MenuSerilize;
import com.appon.miniframework.Util;
import com.appon.util.Serilizable;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;

public abstract class Serilize {
    private static final byte TYPE_INT = 0;
    private static final byte TYPE_STRING = 1;
    private static final byte TYPE_VECTOR = 2;
    private static final byte TYPE_HASHTABLE = 3;
    private static final byte TYPE_SERILIZABLE = 4;
    private static final byte TYPE_BYTE_ARRY = 5;
    private static final byte TYPE_LONG = 6;
    private static final byte TYPE_BOOLEAN = 7;
    private static final byte TYPE_INT_ARRY = 8;
    private static final byte TYPE_2DINT_ARRY = 9;
    private static final byte TYPE_BOOLEAN_ARRY = 10;

    public static void serialize(Object obj, ByteArrayOutputStream bos) throws Exception {
        block6: {
            DataOutputStream dos;
            block15: {
                block14: {
                    block13: {
                        block12: {
                            block11: {
                                block10: {
                                    block9: {
                                        block8: {
                                            block7: {
                                                block5: {
                                                    dos = new DataOutputStream(bos);
                                                    if (!(obj instanceof Serilizable)) break block5;
                                                    dos.writeByte(4);
                                                    int classcode = ((Serilizable)obj).getClassCode();
                                                    dos.writeInt(classcode);
                                                    byte[] data = ((Serilizable)obj).serialize();
                                                    dos.writeInt(data.length);
                                                    dos.write(data);
                                                    break block6;
                                                }
                                                if (!(obj instanceof String)) break block7;
                                                dos.writeByte(1);
                                                dos.writeUTF((String)obj);
                                                break block6;
                                            }
                                            if (!(obj instanceof Integer)) break block8;
                                            dos.writeByte(0);
                                            dos.writeInt((Integer)obj);
                                            break block6;
                                        }
                                        if (!(obj instanceof Long)) break block9;
                                        dos.writeByte(6);
                                        dos.writeLong((Long)obj);
                                        break block6;
                                    }
                                    if (!(obj instanceof Vector)) break block10;
                                    Vector vct = (Vector)obj;
                                    dos.writeByte(2);
                                    dos.writeInt(vct.size());
                                    for (int i = 0; i < vct.size(); ++i) {
                                        Serilize.serialize(vct.elementAt(i), bos);
                                    }
                                    break block6;
                                }
                                if (!(obj instanceof Hashtable)) break block11;
                                dos.writeByte(3);
                                Hashtable hashtable = (Hashtable)obj;
                                dos.writeInt(hashtable.size());
                                Enumeration enm = hashtable.keys();
                                while (enm.hasMoreElements()) {
                                    Object key = enm.nextElement();
                                    Object value = hashtable.get(key);
                                    Serilize.serialize(key, bos);
                                    Serilize.serialize(value, bos);
                                }
                                break block6;
                            }
                            if (!(obj instanceof byte[])) break block12;
                            byte[] data = (byte[])obj;
                            dos.writeByte(5);
                            dos.writeInt(data.length);
                            dos.write(data, 0, data.length);
                            break block6;
                        }
                        if (!(obj instanceof int[])) break block13;
                        int[] data = (int[])obj;
                        dos.writeByte(8);
                        dos.writeInt(data.length);
                        for (int i = 0; i < data.length; ++i) {
                            dos.writeInt(data[i]);
                        }
                        break block6;
                    }
                    if (!(obj instanceof Boolean)) break block14;
                    dos.writeByte(7);
                    dos.writeBoolean((Boolean)obj);
                    break block6;
                }
                if (!(obj instanceof int[][])) break block15;
                int[][] data = (int[][])obj;
                dos.writeByte(9);
                dos.writeInt(data.length);
                for (int i = 0; i < data.length; ++i) {
                    Serilize.serialize(data[i], bos);
                }
                break block6;
            }
            if (!(obj instanceof boolean[])) break block6;
            boolean[] data = (boolean[])obj;
            dos.writeByte(10);
            dos.writeInt(data.length);
            for (int i = 0; i < data.length; ++i) {
                dos.writeBoolean(data[i]);
            }
        }
    }

    public static Object deserialize(ByteArrayInputStream bis, Serilize serilize) throws Exception {
        Object obj = new Object();
        DataInputStream dis = new DataInputStream(bis);
        byte type = dis.readByte();
        switch (type) {
            case 4: {
                int classcode = dis.readInt();
                int size = dis.readInt();
                if (MenuSerilize.isControlType(classcode) || EffectsSerilize.isShapeType(classcode)) {
                    int id = Util.readInt(bis, 2);
                    int addiotnalId = -1;
                    if (classcode == 1004) {
                        addiotnalId = Util.readInt(bis, 2);
                    }
                    obj = serilize.getClassObject(classcode, id, addiotnalId);
                } else {
                    obj = serilize.getClassObject(classcode, -1, -1);
                }
                ((Serilizable)obj).deserialize(bis);
                break;
            }
            case 0: {
                obj = new Integer(dis.readInt());
                break;
            }
            case 6: {
                obj = new Long(dis.readLong());
                break;
            }
            case 1: {
                obj = dis.readUTF();
                break;
            }
            case 2: {
                int size = dis.readInt();
                Vector<Object> vct = new Vector<Object>(size);
                for (int i = 0; i < size; ++i) {
                    vct.addElement(Serilize.deserialize(bis, serilize));
                }
                obj = vct;
                break;
            }
            case 3: {
                int size = dis.readInt();
                Hashtable<Object, Object> hashtable = new Hashtable<Object, Object>(size);
                for (int i = 0; i < size; ++i) {
                    hashtable.put(Serilize.deserialize(bis, serilize), Serilize.deserialize(bis, serilize));
                }
                obj = hashtable;
                break;
            }
            case 5: {
                int size = dis.readInt();
                obj = new byte[size];
                dis.read((byte[])obj);
                break;
            }
            case 8: {
                int size = dis.readInt();
                obj = new int[size];
                for (int i = 0; i < size; ++i) {
                    ((int[])obj)[i] = dis.readInt();
                }
                break;
            }
            case 9: {
                int size = dis.readInt();
                obj = new int[size][];
                for (int i = 0; i < size; ++i) {
                    ((int[][])obj)[i] = (int[])Serilize.deserialize(bis, serilize);
                }
                break;
            }
            case 7: {
                obj = new Boolean(dis.readBoolean());
                break;
            }
            case 10: {
                int size = dis.readInt();
                obj = new boolean[size];
                for (int i = 0; i < size; ++i) {
                    ((boolean[])obj)[i] = dis.readBoolean();
                }
                break;
            }
        }
        return obj;
    }

    public abstract Serilizable getClassObject(int var1, int var2, int var3);
}

