/*
 * Decompiled with CFR 0.152.
 */
package com.indiagames.arjunprince;

import com.appon.gtantra.GAnim;
import com.appon.gtantra.GTantra;
import com.indiagames.arjunprince.Constant;
import com.indiagames.arjunprince.FighterHero;
import com.indiagames.arjunprince.KnightTestEngine;
import java.util.Random;
import javax.microedition.lcdui.Graphics;

public abstract class FighterCharactor {
    protected GAnim runRight;
    protected GAnim runLeft;
    protected GAnim standRight;
    protected GAnim standLeft;
    protected GAnim bloodRight;
    protected GAnim bloodLeft;
    protected GAnim jumpAttackRight;
    protected GAnim jumpAttackLeft;
    protected GAnim[] attackRight;
    protected GAnim[] attackLeft;
    protected GAnim[] leftAttackEffect = new GAnim[2];
    protected GAnim[] rightAttackEffect = new GAnim[2];
    protected GAnim rightAttack_Jump_Effect = new GAnim(Constant.effectsTantra, 2);
    protected GAnim leftAttack_Jump_Effect = new GAnim(Constant.effectsTantra, 15);
    private int healthbarX;
    protected static final int TOTAL_ATTACK_TYPES = 2;
    public static int healthBar = 50;
    public static int healthBarHeight = 5;
    protected int heroX;
    protected int heroY;
    protected static final int LEFT_DIRECTION = 0;
    protected static final int RIGHT_DIRECTION = 1;
    protected int direction = 1;
    public static int SCREEN_WIDTH;
    public static final int STATE_STANDING = 0;
    public static final int STATE_RUNNING = 1;
    public static final int STATE_HITTING = 2;
    public static final int STATE_JUMP_HIT = 3;
    protected int state = 0;
    protected int hittingAnimId;
    protected int movedSoFar;
    protected int[] collisionRect = new int[4];
    protected GTantra tantra;
    int characterCurrHealth = 0;
    int characterHealth = 0;
    private int lastAttackId = -1;
    private static int ATTACK_PUSH_WIDTH;
    protected int COMBO_ATTACK_RANGE;
    private boolean paintBlood;
    private GAnim bloodAnim;
    protected static final int HERO_SPEED = 5;
    protected static final int HERO_MOVEMENT_RANGE = 25;
    protected static int GROUND_Y;
    protected int charactorType;
    int cycle;
    int bloodX;
    int bloodY;
    public static Random random;

    public FighterCharactor(GTantra tantra, int screenWidth) {
        this(tantra, screenWidth, 0, 0, 0);
    }

    public FighterCharactor(GTantra tantra, int screenWidth, int charactorType, int health, int damage) {
        this.charactorType = charactorType;
        SCREEN_WIDTH = screenWidth;
        this.characterCurrHealth = health;
        this.characterHealth = health;
        this.tantra = tantra;
        this.heroY = Constant.SCREEN_HEIGHT >> 1;
        this.init();
        this.COMBO_ATTACK_RANGE = this.jumpAttackRight.getNumberOfFrames() * 5 + tantra.getFrameWidth(this.jumpAttackLeft.getCurrentFrame());
        this.leftAttackEffect[0] = new GAnim(Constant.effectsTantra, 13);
        this.leftAttackEffect[1] = new GAnim(Constant.effectsTantra, 14);
        this.rightAttackEffect[0] = new GAnim(Constant.effectsTantra, 0);
        this.rightAttackEffect[1] = new GAnim(Constant.effectsTantra, 1);
    }

    public abstract void init();

    public boolean isHitting() {
        return this.state == 2 || this.state == 3;
    }

    public void setLastAttackId(int lastAttackId) {
        this.lastAttackId = lastAttackId;
    }

    public int getLastAttackId() {
        return this.lastAttackId;
    }

    public void paint(Graphics g) {
        switch (this.state) {
            case 0: {
                if (this.direction == 0) {
                    this.standLeft.renderWithoutTimer(g, this.heroX, this.heroY, 0, true);
                    break;
                }
                this.standRight.renderWithoutTimer(g, this.heroX, this.heroY, 0, true);
                break;
            }
            case 1: {
                if (this.direction == 0) {
                    this.runLeft.renderWithoutTimer(g, this.heroX, this.heroY, 0, true);
                    break;
                }
                this.runRight.renderWithoutTimer(g, this.heroX, this.heroY, 0, true);
                break;
            }
            case 2: {
                if (this.direction == 0) {
                    this.attackLeft[this.hittingAnimId].renderWithoutTimer(g, this.heroX, this.heroY, 0, false);
                } else {
                    this.attackRight[this.hittingAnimId].renderWithoutTimer(g, this.heroX, this.heroY, 0, false);
                }
                if (!(this instanceof FighterHero)) break;
                this.cycle = this.hittingAnimId == 0 ? 1 : 2;
                if (this.direction == 0) {
                    if (this.leftAttackEffect[this.hittingAnimId].isAnimationOver() || this.attackLeft[this.hittingAnimId].getAnimationCurrentCycle() <= this.cycle) break;
                    this.leftAttackEffect[this.hittingAnimId].renderWithoutTimer(g, this.heroX, this.heroY, 0, false);
                    break;
                }
                if (this.rightAttackEffect[this.hittingAnimId].isAnimationOver() || this.attackRight[this.hittingAnimId].getAnimationCurrentCycle() <= this.cycle) break;
                this.rightAttackEffect[this.hittingAnimId].renderWithoutTimer(g, this.heroX, this.heroY, 0, false);
                break;
            }
            case 3: {
                if (this.direction == 0) {
                    this.jumpAttackLeft.renderWithoutTimer(g, this.heroX, this.heroY, 0, false);
                } else {
                    this.jumpAttackRight.renderWithoutTimer(g, this.heroX, this.heroY, 0, false);
                }
                if (!(this instanceof FighterHero)) break;
                if (this.direction == 0) {
                    if (this.leftAttack_Jump_Effect.isAnimationOver() || this.jumpAttackLeft.getAnimationCurrentCycle() <= 3) break;
                    this.leftAttack_Jump_Effect.render(g, this.heroX, this.heroY, 0, false);
                    break;
                }
                if (this.rightAttack_Jump_Effect.isAnimationOver() || this.jumpAttackRight.getAnimationCurrentCycle() <= 3) break;
                this.rightAttack_Jump_Effect.render(g, this.heroX, this.heroY, 0, false);
            }
        }
        if (this.paintBlood) {
            if (KnightTestEngine.getInstance().getInGameStatus() != 3 && KnightTestEngine.getInstance().getInGameStatus() != 2) {
                this.bloodAnim.render(g, this.bloodX, this.bloodY, 0, false);
            }
            if (this.bloodAnim.isAnimationOver()) {
                this.paintBlood = false;
            }
        }
        this.healthbarX = this.direction == 0 ? this.getX() - this.getCurrentGAnim().getCurrentFrameWidth() : this.getX();
        g.setColor(10050862);
        g.drawRect(this.healthbarX - 1, this.getY() - Math.abs(this.getCurrentGAnim().getCurrentFrameMinimumY()) - healthBarHeight - 1, healthBar + 1, healthBarHeight + 1);
        g.setColor(6110240);
        g.fillRect(this.healthbarX, this.getY() - Math.abs(this.getCurrentGAnim().getCurrentFrameMinimumY()) - healthBarHeight, healthBar, healthBarHeight);
        g.setColor(65280);
        g.fillRect(this.healthbarX, this.getY() - Math.abs(this.getCurrentGAnim().getCurrentFrameMinimumY()) - healthBarHeight, healthBar * this.characterCurrHealth / this.characterHealth, healthBarHeight);
    }

    public void setState(int state) {
        this.state = state;
    }

    public static int getDistance(FighterCharactor charactor1, FighterCharactor charactor2) {
        int x1 = charactor1.getX();
        if (charactor1.getDirection() == 1) {
            x1 += charactor1.getCurrentFrameWidth();
        }
        int x2 = charactor2.getX();
        if (charactor2.getDirection() == 1) {
            x2 += charactor2.getCurrentFrameWidth();
        }
        return x1 - x2;
    }

    public int getX() {
        return this.heroX;
    }

    public int getY() {
        return this.heroY;
    }

    public int getDirection() {
        return this.direction;
    }

    public void setDirection(int direction) {
        if (this.direction != direction) {
            this.heroX = direction == 0 ? (this.heroX += this.getCurrentGAnim().getCurrentFrameWidth()) : (this.heroX -= this.getCurrentGAnim().getCurrentFrameWidth());
        }
        this.direction = direction;
    }

    public int getState() {
        return this.state;
    }

    public void successfullyHitted(int intersectionx, int intersectiony, int intersectionW, int intersectionH) {
        this.bloodX = intersectionx + (intersectionW >> 1);
        this.bloodY = intersectiony + (intersectionH >> 1);
        this.paintBlood = true;
        this.bloodAnim = this.getDirection() == 0 ? this.bloodLeft : this.bloodRight;
        this.bloodAnim.reset();
    }

    public abstract void update();

    public final boolean attackOccured(int damage, int id, boolean pushLeft) {
        if (id != this.lastAttackId) {
            this.characterCurrHealth -= damage;
            this.lastAttackId = id;
            ATTACK_PUSH_WIDTH = 10;
            if (pushLeft) {
                this.heroX -= ATTACK_PUSH_WIDTH;
                if (this.heroX < 0 && this.getDirection() == 1 || this.heroX < this.getCurrentFrameWidth() && this.getDirection() == 0) {
                    this.heroX = 0;
                    if (this.getDirection() == 0) {
                        this.heroX = this.getCurrentFrameWidth();
                    }
                }
            } else {
                this.heroX += ATTACK_PUSH_WIDTH;
                if (this.heroX > SCREEN_WIDTH && this.getDirection() == 0 || this.heroX > SCREEN_WIDTH - this.getCurrentFrameWidth() && this.getDirection() == 1) {
                    this.heroX = SCREEN_WIDTH;
                    if (this.getDirection() == 1) {
                        this.heroX = SCREEN_WIDTH - this.getCurrentFrameWidth();
                    }
                }
            }
            return this.gotAttacked(damage);
        }
        return false;
    }

    public abstract boolean gotAttacked(int var1);

    public static boolean isInRect(int xPos, int yPos, int width, int height, int x, int y) {
        return x >= xPos && x <= xPos + width && y >= yPos && y <= yPos + height;
    }

    public static int getRandomNumber(int min, int max) {
        if (max == min) {
            return 0;
        }
        int randomNum = Math.abs(random.nextInt());
        return min + Math.abs(randomNum % (max - min));
    }

    public int[] getCurrentBodyCollisionRect() {
        try {
            if (this.state == 2) {
                this.tantra.getCollisionRect(this.getCurrentGAnim().getCurrentFrame(), this.collisionRect, 0);
            } else if (this.state == 3) {
                this.tantra.getCollisionRect(this.getCurrentGAnim().getCurrentFrame(), this.collisionRect, 0);
            } else {
                this.tantra.getCollisionRect(this.getCurrentGAnim().getCurrentFrame(), this.collisionRect, 0);
            }
            if (this.direction == 0) {
                this.collisionRect[0] = -this.collisionRect[0] - this.collisionRect[2];
            }
            this.collisionRect[0] = this.collisionRect[0] + this.getX();
            this.collisionRect[1] = this.collisionRect[1] + this.getY();
            return this.collisionRect;
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    public int[] getCurrentSwordCollsionRect() {
        if (this.state == 2) {
            this.tantra.getCollisionRect(this.getCurrentGAnim().getCurrentFrame(), this.collisionRect, 2);
        } else if (this.state == 3) {
            this.tantra.getCollisionRect(this.getCurrentGAnim().getCurrentFrame(), this.collisionRect, 2);
        } else {
            return null;
        }
        if (this.direction == 0) {
            this.collisionRect[0] = -this.collisionRect[0] - this.collisionRect[2];
        }
        this.collisionRect[0] = this.collisionRect[0] + this.getX();
        this.collisionRect[1] = this.collisionRect[1] + this.getY();
        return this.collisionRect;
    }

    public int getCurrentFrameWidth() {
        return this.getCurrentGAnim().getCurrentFrameWidth();
    }

    public int getCurrentFrameHeight() {
        return this.getCurrentGAnim().getCurrentFrameHeight();
    }

    public GAnim getCurrentGAnim() {
        switch (this.state) {
            case 3: {
                if (this.direction == 0) {
                    return this.jumpAttackLeft;
                }
                return this.jumpAttackRight;
            }
            case 0: {
                if (this.direction == 0) {
                    return this.standLeft;
                }
                return this.standRight;
            }
            case 1: {
                if (this.direction == 0) {
                    return this.runLeft;
                }
                return this.runRight;
            }
            case 2: {
                if (this.direction == 0) {
                    return this.attackLeft[this.hittingAnimId];
                }
                return this.attackRight[this.hittingAnimId];
            }
        }
        return null;
    }

    static {
        GROUND_Y = 180;
        random = new Random();
    }
}

