/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDFile;
import com.ea.game.DDImage;
import com.ea.game.DDMath;
import com.ea.sdk.SDKGraphics;

public class Animation {
    private static final boolean DEBUG_ANIMS = false;
    private static final String ANIM_FILE_EXTENSION = ".anim";
    public static final String SPRITE_FILE_EXTENSION = ".spr";
    public static final String PALETTE_FILE_EXTENSION = "pal.bin";
    public static final int DIR_EAST = 0;
    public static final int DIR_SOUTHEAST = 1;
    public static final int DIR_SOUTH = 2;
    public static final int DIR_SOUTHWEST = 3;
    public static final int DIR_WEST = 4;
    public static final int DIR_NORTHWEST = 5;
    public static final int DIR_NORTH = 6;
    public static final int DIR_NORTHEAST = 7;
    private static final int DIR_COUNT = 8;
    private static final int DIR_MASK = 7;
    private static final int METADATA = 0;
    private static final int METADATA_DIRECTIONS = 0;
    private static final int METADATA_CONTROLTYPE = 1;
    private static final int METADATA_TEMPO = 2;
    private static final int METADATA_ACTION_FRAME = 3;
    private static final int METADATA_FRAMECOUNT = 4;
    private static final int METADATA_SIZE = 5;
    private static final int CONTROL_TYPE_EXTEND_LAST_FRAME = 0;
    private static final int CONTROL_TYPE_LOOP = 1;
    private static final int CONTROL_TYPE_PING_PONG = 2;
    private static final int FILEINFO_BYTES = 1;
    public DDImage m_sprite;
    private int[][][] m_data;

    public Animation(String string, int n2) {
        this(string, "/" + string + PALETTE_FILE_EXTENSION, n2);
    }

    public Animation(String string, String string2, int n2) {
        string = "/" + string;
        this.m_sprite = DDImage.createSprite(string + SPRITE_FILE_EXTENSION, string2, n2);
        this.m_data = Animation.loadAnimationData(string + ANIM_FILE_EXTENSION);
        System.gc();
    }

    public Animation(String string) {
        string = "/" + string;
        this.m_sprite = DDImage.createSprite(string + SPRITE_FILE_EXTENSION);
        this.m_data = Animation.loadAnimationData(string + ANIM_FILE_EXTENSION);
        System.gc();
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5, int n6, int n7, int n8, int n9) {
        int n10 = this.getSpriteFrameId(n4, n5, n6);
        if (n10 != -1) {
            this.m_sprite.drawFrame(sDKGraphics, n2, n3, n10, n7, n8, n9);
        }
    }

    public int getSequenceLength(int n2) {
        return this.m_data[n2][0][4] * this.m_data[n2][0][2];
    }

    public int getKeyFrame(int n2) {
        return this.m_data[n2][0][3] * this.m_data[n2][0][2];
    }

    public int getSpriteFrameId(int n2, int n3, int n4) {
        if (n2 < this.m_data.length) {
            int n5;
            int n6;
            int n7 = 0;
            int[] nArray = null;
            do {
                n6 = (n4 + n7 & 7) + 1;
                n5 = (n4 - n7 & 7) + 1;
                if (this.m_data[n2][n6] != null) {
                    nArray = this.m_data[n2][n6];
                    continue;
                }
                if (this.m_data[n2][n5] != null) {
                    nArray = this.m_data[n2][n5];
                    continue;
                }
                ++n7;
            } while (nArray == null);
            n3 /= this.m_data[n2][0][2];
            n6 = this.m_data[n2][0][4];
            switch (this.m_data[n2][0][1]) {
                case 0: {
                    return nArray[DDMath.min(n3, n6 - 1)];
                }
                case 1: {
                    return nArray[n3 % n6];
                }
                case 2: {
                    n5 = (n6 - 1) * 2;
                    int n8 = (n3 + (n6 - 1)) % n5;
                    return nArray[DDMath.abs(n8 - (n6 - 1))];
                }
            }
            return 0;
        }
        return -1;
    }

    private static int[][][] loadAnimationData(String string) {
        int n2;
        int n3;
        Object object = null;
        int n4 = 0;
        boolean bl = true;
        byte[] byArray = DDFile.loadFileBytes(string);
        int n5 = byArray[n4++] & 0xFF;
        n4 += 2;
        if ((n3 = byArray[n4++] & 0xFF) >= 2) {
            bl = ((n2 = byArray[n4++] & 0xFF) & 1) != 0;
        }
        n2 = byArray[n4 + 0] & 0xFF | byArray[n4 + 1] << 8;
        n4 += 2;
        object = new int[n2][][];
        n4 += 2;
        n4 += 2 * n2;
        n4 += 2;
        for (int i2 = 0; i2 < n2; ++i2) {
            int n6 = byArray[n4++] & 0xFF;
            int n7 = DDMath.countSetBits(n6);
            int n8 = ++n4;
            int n9 = byArray[n8] & 0xFF;
            int n10 = ++n4;
            ++n4;
            int n11 = byArray[n10] & 0xFF;
            int n12 = ++n4;
            int n13 = byArray[n12] & 0xFF;
            int n14 = byArray[++n4 + 0] & 0xFF | byArray[n4 + 1] << 8;
            n4 += 2;
            object[i2] = new int[9][];
            object[i2][0] = new int[5];
            object[i2][0][0] = n6;
            object[i2][0][1] = n9;
            object[i2][0][2] = n13;
            object[i2][0][3] = n11;
            object[i2][0][4] = n14;
            for (int i3 = 1; i3 <= n7; ++i3) {
                int n15 = byArray[n4++] + 1;
                object[i2][n15] = new int[n14];
                for (int i4 = 0; i4 < n14; ++i4) {
                    if (bl) {
                        object[i2][n15][i4] = byArray[n4++] & 0xFF;
                        continue;
                    }
                    object[i2][n15][i4] = byArray[n4 + 0] & 0xFF | byArray[n4 + 1] << 8;
                    n4 += 2;
                }
            }
        }
        return object;
    }
}

