/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDFile;
import com.ea.sdk.SDKGraphics;
import com.ea.sdk.SDKImage;
import com.ea.sdk.SDKUtils;

class DDImage {
    public static final int TRANS_NONE = 0;
    public static final int TRANS_MIRROR_ROT180 = 1;
    public static final int TRANS_MIRROR = 2;
    public static final int TRANS_ROT180 = 3;
    public static final int TRANS_MIRROR_ROT270 = 4;
    public static final int TRANS_ROT90 = 5;
    public static final int TRANS_ROT270 = 6;
    public static final int TRANS_MIRROR_ROT90 = 7;
    public static final int G_TOP = 16;
    public static final int G_BOTTOM = 32;
    public static final int G_LEFT = 4;
    public static final int G_HCENTER = 1;
    public static final int G_VCENTER = 2;
    public static final int G_RIGHT = 8;
    private static final int HD_CHUNK = 0;
    private static final int FR_CHUNK = 1;
    private static final int FM_CHUNK = 2;
    private static final int F_CHUNK = 3;
    private static final int S_CHUNK = 4;
    private static final int D_CHUNK = 5;
    private static final int O_CHUNK = 6;
    private static final int FH_CHUNK = 7;
    private static final int FA_CHUNK = 8;
    private static final int FU_CHUNK = 9;
    private static final int NUM_CHUNK = 10;
    private static final int BINFILE_HEADER_STRUCTLEN = 4;
    private static final int CHUNK_HEADER_STRUCTLEN = 4;
    private static final int HD_CHUNK_NUMFRAMES = 0;
    private static final int HD_CHUNK_NUMMAPFRAMES = 2;
    private static final int HD_CHUNK_NUMIMAGES = 4;
    private static final int HD_CHUNK_FLAGS = 5;
    private static final int HD_CHUNK_STRUCTLEN = 6;
    private static final int FM_CHUNK_ORIGINAL = 0;
    private static final int FM_CHUNK_ACTUAL = 2;
    private static final int FM_CHUNK_STRUCTLEN = 4;
    private static final int FR_CHUNK_NUMSUBFRAMES = 0;
    private static final int FR_CHUNK_STRUCTLEN = 1;
    private static final int FH_CHUNK_SPACEWIDTH = 0;
    private static final int FH_CHUNK_CHARSPACING = 1;
    private static final int FH_CHUNK_UNICODECHARCOUNT = 2;
    private static final int FH_CHUNK_FONTWIDTH = 4;
    private static final int FH_CHUNK_FONTHEIGHT = 5;
    private static final int FH_CHUNK_FONTBASELINE = 6;
    private static final int FH_CHUNK_STRUCTLEN = 7;
    private static final int PALETTE_FILE_HEADER_BYTES_LENGTH = 8;
    private static final int PALETTE_FILE_BYTES_PER_ENTRY = 3;
    private static final int UTF8_FONTFORMAT1_ASCIICOUNT = 96;
    private static final int UTF8_FONTFORMAT1_ASCIIRANGESTART = 32;
    private static final int UTF8_FONTFORMAT1_ASCIIRANGEEND = 128;
    private static final int SUBFRAME_SHORT0_LO = 0;
    private static final int SUBFRAME_SHORT0_HI = 1;
    private static final int SUBFRAME_SHORT1_LO = 2;
    private static final int SUBFRAME_SHORT1_HI = 3;
    private static final int SUBFRAME_BYTE0 = 0;
    private static final int SUBFRAME_BYTE1 = 1;
    private static final int SUBFRAME_HFLIP_SHIFT = 7;
    private static final int SUBFRAME_VFLIP_SHIFT = 6;
    private static final int SUBFRAME_NUM_MASK = 31;
    private static final int BYTES_SF_BYTEDATA = 2;
    private static final int BYTES_SF_SHORTDATA = 4;
    private static final boolean DEBUG = false;
    private static final boolean DEBUG_VERBOSE = true;
    private static final char[][] m_chunkIDs = new char[][]{{'H', 'D'}, {'F', 'R'}, {'F', 'M'}, {'F', 'b'}, {'S', 'b'}, {'D', 'b'}, {'O', 'b'}, {'f', 'H'}, {'f', 'A'}, {'f', 'U'}};
    private static final int MAX_FILENAME = 32;
    private static StringBuffer m_filename = new StringBuffer(32);
    private SDKImage[][] m_images = null;
    private byte[] m_spriteData = null;
    private short[] m_frameOffsets = null;
    private int[] m_chunkOffsets = null;
    private byte[] m_chunkDataSize = null;
    private short[] m_frameWidths = null;
    private int m_numImages = 0;
    private int m_numFrames = 0;
    private int m_numPalettes = 0;
    private Object m_eaFont = null;

    public void dispose() {
        if (this.m_images != null) {
            for (int i2 = 0; i2 < this.m_numPalettes; ++i2) {
                for (int i3 = 0; i3 < this.m_numImages; ++i3) {
                    if (this.m_images[i2][i3] == null) continue;
                    this.m_images[i2][i3] = null;
                }
                this.m_images[i2] = null;
            }
        }
        this.m_images = null;
        this.m_spriteData = null;
        this.m_frameOffsets = null;
        this.m_chunkOffsets = null;
        this.m_chunkDataSize = null;
        this.m_frameWidths = null;
        this.m_eaFont = null;
        this.m_eaFont = null;
        System.gc();
    }

    public static DDImage createSprite(String string) {
        DDImage dDImage = new DDImage();
        if (!DDImage.loadSpriteData(string, dDImage, null, 0, 0, 0, 0, false)) {
            dDImage = null;
        }
        return dDImage;
    }

    public static DDImage createSprite(String string, byte[] byArray, int n2, int n3, int n4, boolean bl) {
        DDImage dDImage = new DDImage();
        int n5 = 0;
        for (int i2 = 0; i2 < n4; ++i2) {
            n5 |= 1 << i2;
        }
        if (!DDImage.loadSpriteData(string, dDImage, byArray, n2, n3, n5, n4, bl)) {
            dDImage = null;
        }
        return dDImage;
    }

    public static DDImage createSprite(byte[] byArray, int n2, String string) {
        DDImage dDImage = new DDImage();
        try {
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            dDImage.m_numPalettes = 1;
            dDImage.m_images = new SDKImage[1][1];
            dDImage.m_images[0][0] = SDKUtils.createImage(byArray, 0, n2);
            if (string != null && DDImage.loadSpriteChunkData(string, dDImage)) {
                DDImage.calculateFrameOffsets(dDImage);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return dDImage;
    }

    public static DDImage createSprite(String string, String string2, int n2) {
        int n3 = 0;
        DDImage dDImage = new DDImage();
        byte[] byArray = DDFile.loadFileBytes(string2);
        if (byArray == null) {
            n2 = 0;
        } else {
            int n4 = byArray[4] & 0xFF | (byArray[5] & 0xFF) << 8;
            n3 = 8 + n2 * n4;
        }
        if (!DDImage.loadSpriteData(string, dDImage, byArray, n3, 0, 1, 1, true)) {
            dDImage = null;
        }
        return dDImage;
    }

    public static DDImage createPalletizedSpriteSingle(String string, int n2, int n3) {
        int n4 = 1 << n2;
        return DDImage.createPalletizedSpriteMulti(string, n4, n3);
    }

    public static DDImage createPalletizedSpriteMulti(String string, int n2, int n3) {
        m_filename.setLength(0);
        m_filename.append(string);
        if (string.endsWith(".spr")) {
            m_filename.setLength(string.length() - 4);
        }
        byte[] byArray = DDFile.loadFileBytes(m_filename + "pal.bin");
        DDImage dDImage = new DDImage();
        if (byArray != null) {
            int n4 = DDFile.retrieveShort(byArray, 4, true) / 3;
            if (!DDImage.loadSpriteData(string, dDImage, byArray, 8, n4, n2, n3, true)) {
                dDImage = null;
            }
        } else if (n3 == 1) {
            if (!DDImage.loadSpriteData(m_filename + ".spr", dDImage, null, 0, 0, 0, 0, false)) {
                dDImage = null;
            }
        } else {
            dDImage = null;
        }
        return dDImage;
    }

    public static SDKImage createPalletizedImage(String string, int n2) {
        byte[] byArray = DDFile.loadFileBytes(string + ".png");
        byte[] byArray2 = DDFile.loadFileBytes(string + "pal.bin");
        return DDImage.createPalletizedImage(byArray, byArray2, n2);
    }

    private static SDKImage createPalletizedImage(byte[] byArray, byte[] byArray2, int n2) {
        SDKImage sDKImage = null;
        try {
            int n3 = byArray.length;
            int n4 = DDImage.pngFindPLTE(byArray, n3);
            int n5 = DDFile.retrieveShort(byArray2, 4, true);
            int n6 = 8 + n2 * n5;
            for (int i2 = 0; i2 < n5; ++i2) {
                byArray[n4 + i2] = byArray2[n6 + i2];
            }
            DDImage.pngCalcCRC(byArray, n4);
            sDKImage = SDKUtils.createImage(byArray, 0, n3);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return sDKImage;
    }

    public int getFrameCount() {
        if (this.m_spriteData == null || this.m_eaFont != null) {
            return 1;
        }
        return this.m_numFrames;
    }

    public int getFrameWidth(int n2) {
        int n3 = -1;
        if (n2 >= 0 && n2 <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n3 = this.m_images[0][0].getWidth();
            } else if (this.m_frameWidths != null) {
                n3 = this.m_frameWidths[n2];
            } else {
                int n4 = this.m_spriteData[this.m_chunkOffsets[1] + n2 * 1 + 0] & 0x1F;
                int n5 = this.m_chunkOffsets[5] + this.m_frameOffsets[n2] * this.m_chunkDataSize[5];
                int n6 = this.m_chunkOffsets[6] + this.m_frameOffsets[n2] * this.m_chunkDataSize[6];
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n10;
                    if (this.m_chunkDataSize[5] == 4) {
                        n10 = (this.m_spriteData[n5 + 0] & 0xFF | (this.m_spriteData[n5 + 1] & 0xFF) << 8) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 0] & 0xFF | this.m_spriteData[n6 + 1] << 8;
                        }
                    } else {
                        n10 = (this.m_spriteData[n5 + 0] & 0xFF) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 0];
                        }
                    }
                    if (i2 == 0 || n9 < n8) {
                        n8 = n9;
                    }
                    if (i2 == 0 || n9 + n10 > n7) {
                        n7 = n9 + n10;
                    }
                    n5 += this.m_chunkDataSize[5];
                    n6 += this.m_chunkDataSize[6];
                }
                n3 = n7 - n8;
            }
        }
        return n3;
    }

    public int getFrameHeight(int n2) {
        int n3 = -1;
        if (n2 >= 0 && n2 <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n3 = this.m_images[0][0].getHeight();
            } else {
                int n4 = this.m_spriteData[this.m_chunkOffsets[1] + n2 * 1 + 0] & 0x1F;
                int n5 = this.m_chunkOffsets[5] + this.m_frameOffsets[n2] * this.m_chunkDataSize[5];
                int n6 = this.m_chunkOffsets[6] + this.m_frameOffsets[n2] * this.m_chunkDataSize[6];
                int n7 = 0;
                int n8 = 0;
                int n9 = 0;
                for (int i2 = 0; i2 < n4; ++i2) {
                    int n10;
                    if (this.m_chunkDataSize[4] == 4) {
                        n10 = (this.m_spriteData[n5 + 2] & 0xFF | (this.m_spriteData[n5 + 3] & 0xFF) << 8) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 2] & 0xFF | this.m_spriteData[n6 + 3] << 8;
                        }
                    } else {
                        n10 = (this.m_spriteData[n5 + 1] & 0xFF) >> 1;
                        if (this.m_chunkOffsets[6] > 0) {
                            n9 = this.m_spriteData[n6 + 1];
                        }
                    }
                    if (i2 == 0 || n9 < n8) {
                        n8 = n9;
                    }
                    if (i2 == 0 || n9 + n10 > n7) {
                        n7 = n9 + n10;
                    }
                    n5 += this.m_chunkDataSize[5];
                    n6 += this.m_chunkDataSize[6];
                }
                n3 = n7 - n8;
            }
        }
        return n3;
    }

    public int getFrameOriginX(int n2) {
        int n3 = 0;
        if (n2 >= 0 && n2 <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n3 = 0;
            } else {
                int n4 = 0;
                if (this.m_chunkOffsets[3] > 0) {
                    int n5 = this.m_chunkOffsets[3] + n2 * this.m_chunkDataSize[3];
                    n4 = this.m_chunkDataSize[3] == 4 ? this.m_spriteData[n5 + 0] & 0xFF | (this.m_spriteData[n5 + 1] & 0xFF) << 8 : this.m_spriteData[n5 + 0] & 0xFF;
                }
                int n6 = this.m_spriteData[this.m_chunkOffsets[1] + n2 * 1 + 0] & 0x1F;
                int n7 = this.m_chunkOffsets[5] + this.m_frameOffsets[n2] * this.m_chunkDataSize[5];
                int n8 = this.m_chunkOffsets[6] + this.m_frameOffsets[n2] * this.m_chunkDataSize[6];
                int n9 = 0;
                int n10 = 0;
                n3 = 0;
                for (int i2 = 0; i2 < n6; ++i2) {
                    if (this.m_chunkDataSize[4] == 4) {
                        if (this.m_chunkOffsets[6] > 0) {
                            n3 = this.m_spriteData[n8 + 0] & 0xFF | this.m_spriteData[n8 + 1] << 8;
                        }
                    } else if (this.m_chunkOffsets[6] > 0) {
                        n3 = this.m_spriteData[n8 + 0];
                    }
                    if (i2 == 0 || n3 < n10) {
                        n10 = n3;
                    }
                    n7 += this.m_chunkDataSize[5];
                    n8 += this.m_chunkDataSize[6];
                }
                n3 = n4 - n10;
            }
        }
        return n3;
    }

    public int getFrameOriginY(int n2) {
        int n3 = 0;
        if (n2 >= 0 && n2 <= this.m_numFrames && this.m_numImages > 0) {
            if (this.m_spriteData == null || this.m_eaFont != null) {
                n3 = 0;
            } else {
                int n4 = 0;
                if (this.m_chunkOffsets[3] > 0) {
                    int n5 = this.m_chunkOffsets[3] + n2 * this.m_chunkDataSize[3];
                    n4 = this.m_chunkDataSize[3] == 4 ? this.m_spriteData[n5 + 2] & 0xFF | (this.m_spriteData[n5 + 3] & 0xFF) << 8 : this.m_spriteData[n5 + 1] & 0xFF;
                }
                int n6 = this.m_spriteData[this.m_chunkOffsets[1] + n2 * 1 + 0] & 0x1F;
                int n7 = this.m_chunkOffsets[5] + this.m_frameOffsets[n2] * this.m_chunkDataSize[5];
                int n8 = this.m_chunkOffsets[6] + this.m_frameOffsets[n2] * this.m_chunkDataSize[6];
                int n9 = 0;
                int n10 = 0;
                n3 = 0;
                for (int i2 = 0; i2 < n6; ++i2) {
                    if (this.m_chunkDataSize[4] == 4) {
                        if (this.m_chunkOffsets[6] > 0) {
                            n3 = this.m_spriteData[n8 + 2] & 0xFF | this.m_spriteData[n8 + 3] << 8;
                        }
                    } else if (this.m_chunkOffsets[6] > 0) {
                        n3 = this.m_spriteData[n8 + 1];
                    }
                    if (i2 == 0 || n3 < n10) {
                        n10 = n3;
                    }
                    n7 += this.m_chunkDataSize[5];
                    n8 += this.m_chunkDataSize[6];
                }
                n3 = n4 - n10;
            }
        }
        return n3;
    }

    public void drawFrame(SDKGraphics sDKGraphics, int n2, int n3, int n4, int n5, int n6, int n7) {
        block50: {
            int n8;
            int n9;
            block49: {
                n9 = n7;
                if (n6 == 0) {
                    n6 = 20;
                }
                if (this.m_spriteData != null && this.m_eaFont == null) break block49;
                if (this.m_images == null || this.m_images[0] == null) break block50;
                int n10 = this.getFrameWidth(0);
                int n11 = this.getFrameHeight(0);
                int n12 = n2;
                int n13 = n3;
                if (n5 < 0 || n5 >= this.m_numPalettes) {
                    n5 = 0;
                }
                if (n7 != 0) {
                    sDKGraphics.drawRegion(this.m_images[n5][0], 0, 0, n10, n11, n7, n12, n13, n6);
                } else {
                    sDKGraphics.drawImage(this.m_images[n5][0], n12, n13, n6);
                }
                break block50;
            }
            if (n4 < 0 || n4 >= this.m_numFrames || n5 < 0 || n5 >= this.m_numPalettes) {
                return;
            }
            if ((n6 & 1) != 0) {
                n2 -= this.getFrameWidth(n4) >> 1;
            } else if ((n6 & 8) != 0) {
                n2 -= this.getFrameWidth(n4);
            }
            if ((n6 & 2) != 0) {
                n3 -= this.getFrameHeight(n4) >> 1;
            } else if ((n6 & 0x20) != 0) {
                n3 -= this.getFrameHeight(n4);
            }
            int n14 = this.m_spriteData[this.m_chunkOffsets[1] + n4 * 1 + 0];
            int n15 = n14 & 0x1F;
            boolean bl = (n14 >> 7 & 1) == 1;
            boolean bl2 = (n14 >> 6 & 1) == 1;
            int n16 = this.getFrameWidth(n4);
            int n17 = this.getFrameHeight(n4);
            if (bl) {
                n9 = n9 == 2 ? 0 : (n9 == 5 ? 7 : (n9 == 3 ? 1 : (n9 == 6 ? 4 : (n9 == 7 ? 5 : (n9 == 1 ? 3 : (n9 == 4 ? 6 : 2))))));
            }
            int n18 = 0;
            int n19 = 0;
            if (this.m_chunkOffsets[3] > 0) {
                n8 = this.m_chunkOffsets[3] + n4 * this.m_chunkDataSize[3];
                if (this.m_chunkDataSize[3] == 4) {
                    n18 = this.m_spriteData[n8 + 0] & 0xFF | (this.m_spriteData[n8 + 1] & 0xFF) << 8;
                    n19 = this.m_spriteData[n8 + 2] & 0xFF | (this.m_spriteData[n8 + 3] & 0xFF) << 8;
                } else {
                    n18 = this.m_spriteData[n8 + 0] & 0xFF;
                    n19 = this.m_spriteData[n8 + 1] & 0xFF;
                }
            }
            n8 = this.m_frameOffsets[n4];
            int n20 = this.m_chunkOffsets[4] + n8 * this.m_chunkDataSize[4];
            int n21 = this.m_chunkOffsets[5] + n8 * this.m_chunkDataSize[5];
            int n22 = this.m_chunkOffsets[6] + n8 * this.m_chunkDataSize[6];
            int n23 = 0;
            int n24 = 0;
            if (this.m_chunkDataSize[4] == 4) {
                for (n14 = 0; n14 < n15; ++n14) {
                    int n25;
                    int n26;
                    int n27 = this.m_spriteData[n20 + 0] & 0xFF | (this.m_spriteData[n20 + 1] & 0xFF) << 8;
                    int n28 = this.m_spriteData[n20 + 2] & 0xFF | (this.m_spriteData[n20 + 3] & 0xFF) << 8;
                    int n29 = this.m_spriteData[n21 + 0] & 0xFF | (this.m_spriteData[n21 + 1] & 0xFF) << 8;
                    int n30 = this.m_spriteData[n21 + 2] & 0xFF | (this.m_spriteData[n21 + 3] & 0xFF) << 8;
                    if (this.m_chunkOffsets[6] > 0) {
                        n23 = this.m_spriteData[n22 + 0] & 0xFF | this.m_spriteData[n22 + 1] << 8;
                        n24 = this.m_spriteData[n22 + 2] & 0xFF | this.m_spriteData[n22 + 3] << 8;
                    }
                    int n31 = (n29 & 1) << 1 | n30 & 1;
                    n29 >>= 1;
                    n30 >>= 1;
                    if (n9 == 2) {
                        n26 = n2 - n29 - n23 + n18;
                        n25 = n3 + n24;
                    } else if (n9 == 5) {
                        n26 = n2 + (n18 - (n30 + n24)) - n18;
                        n25 = n3 + n23 - n18;
                    } else if (n9 == 3) {
                        n26 = n2 + 2 * n18 - n29 - n23 - n18;
                        n25 = n3 + (n18 - (n30 + n24)) - n18;
                    } else if (n9 == 6) {
                        n26 = n2 + (n18 + n24) - n18;
                        n25 = n3 + 2 * n18 - n29 - n23 - n18;
                    } else if (n9 == 7) {
                        n26 = n2 + (n18 - (n30 + n24)) - n18;
                        n25 = n3 + n23 - n18;
                    } else if (n9 == 1) {
                        n26 = n2 + 2 * n18 - n29 - n23 - n18;
                        n25 = n3 + (n18 - (n30 + n24)) - n18;
                    } else if (n9 == 4) {
                        n26 = n2 + (n18 + n24) - n18;
                        n25 = n3 + 2 * n18 - n29 - n23 - n18;
                    } else {
                        n26 = n2 + n23 - n18;
                        n25 = n3 + n24 - n19;
                    }
                    sDKGraphics.drawRegion(this.m_images[n5][n31], n27, n28, n29, n30, n9, n26, n25, 20);
                    n20 += this.m_chunkDataSize[4];
                    n21 += this.m_chunkDataSize[5];
                    n22 += this.m_chunkDataSize[6];
                }
            } else {
                for (n14 = 0; n14 < n15; ++n14) {
                    int n32;
                    int n33;
                    int n34 = this.m_spriteData[n20 + 0] & 0xFF;
                    int n35 = this.m_spriteData[n20 + 1] & 0xFF;
                    int n36 = this.m_spriteData[n21 + 0] & 0xFF;
                    int n37 = this.m_spriteData[n21 + 1] & 0xFF;
                    if (this.m_chunkOffsets[6] > 0) {
                        n23 = this.m_spriteData[n22 + 0];
                        n24 = this.m_spriteData[n22 + 1];
                    }
                    int n38 = (n36 & 1) << 1 | n37 & 1;
                    n36 >>= 1;
                    n37 >>= 1;
                    if (n9 == 2) {
                        n33 = n2 - n36 - n23 + n18;
                        n32 = n3 + n24;
                    } else if (n9 == 5) {
                        n33 = n2 + (n18 - (n37 + n24)) - n18;
                        n32 = n3 + n23 - n18;
                    } else if (n9 == 3) {
                        n33 = n2 + 2 * n18 - n36 - n23 - n18;
                        n32 = n3 + (n18 - (n37 + n24)) - n18;
                    } else if (n9 == 6) {
                        n33 = n2 + (n18 + n24) - n18;
                        n32 = n3 + 2 * n18 - n36 - n23 - n18;
                    } else if (n9 == 7) {
                        n33 = n2 + (n18 - (n37 + n24)) - n18;
                        n32 = n3 + n23 - n18;
                    } else if (n9 == 1) {
                        n33 = n2 + 2 * n18 - n36 - n23 - n18;
                        n32 = n3 + (n18 - (n37 + n24)) - n18;
                    } else if (n9 == 4) {
                        n33 = n2 + (n18 + n24) - n18;
                        n32 = n3 + 2 * n18 - n36 - n23 - n18;
                    } else {
                        n33 = n2 + n23 - n18;
                        n32 = n3 + n24 - n19;
                    }
                    sDKGraphics.drawRegion(this.m_images[n5][n38], n34, n35, n36, n37, n9, n33, n32, 20);
                    n20 += this.m_chunkDataSize[4];
                    n21 += this.m_chunkDataSize[5];
                    n22 += this.m_chunkDataSize[6];
                }
            }
        }
    }

    public Object setEAFont(int n2) {
        if (n2 >= 0 && n2 < this.m_numPalettes && this.m_eaFont != null) {
            SDKUtils.setFont(this.m_eaFont);
            SDKUtils.setFontImage(this.m_images[n2][0]);
            return SDKUtils.getFont();
        }
        return null;
    }

    public int getStringWidth(char[] cArray, int n2, int n3) {
        int n4 = 0;
        int n5 = 0;
        if (this.m_chunkOffsets[7] > 0) {
            n4 = this.m_spriteData[this.m_chunkOffsets[7] + 0] & 0xFF;
            n5 = this.m_spriteData[this.m_chunkOffsets[7] + 1];
        }
        int n6 = 0;
        while (n3 > 0) {
            int n7 = this.fontGetCharFrame(cArray[n2]);
            n6 = n7 > 0 ? (n6 += this.getFrameWidth(n7) + n5) : (n6 += n4);
            ++n2;
            --n3;
        }
        return n6;
    }

    public void drawString(SDKGraphics sDKGraphics, char[] cArray, int n2, int n3, int n4, int n5, int n6, int n7) {
        int n8 = 0;
        int n9 = 0;
        byte by = 0;
        if (this.m_chunkOffsets[7] > 0) {
            n8 = this.m_spriteData[this.m_chunkOffsets[7] + 0] & 0xFF;
            n9 = this.m_spriteData[this.m_chunkOffsets[7] + 6] & 0xFF;
            by = this.m_spriteData[this.m_chunkOffsets[7] + 1];
        }
        if ((n7 & 9) != 0) {
            int n10 = this.getStringWidth(cArray, n2, n3);
            n4 = (n7 & 8) != 0 ? (n4 -= n10) : (n4 -= n10 >> 1);
        }
        if ((n7 & 0x20) == 0) {
            n5 += n9;
        }
        while (n3 > 0) {
            if (cArray[n2] == '\u0015') {
                sDKGraphics.setClip(n4, n5 + 1, 4, 1);
                sDKGraphics.fillRect(n4, n5 + 1, 4, 1);
                n4 += 4;
            } else {
                int n11 = this.fontGetCharFrame(cArray[n2]);
                if (n11 >= 0) {
                    this.drawFrame(sDKGraphics, n4, n5, n11, n6, 20, 0);
                    if (n3 > 1 && cArray[n2 + 1] == '\u0014') {
                        sDKGraphics.setClip(n4, n5, this.getFrameWidth(n11), 2);
                        sDKGraphics.fillRect(n4, n5 + 1, this.getFrameWidth(n11), 1);
                    }
                    n4 += this.getFrameWidth(n11) + by;
                } else {
                    n4 += n8;
                }
            }
            ++n2;
            --n3;
        }
    }

    private int fontGetCharFrame(int n2) {
        int n3 = -1;
        if (n2 > 32 && n2 < 128) {
            n3 = this.m_chunkOffsets[8] + (n2 - 32) * 2;
        } else {
            int n4 = this.m_chunkOffsets[9];
            int n5 = this.m_spriteData[this.m_chunkOffsets[7] + 2 + 0] & 0xFF | (this.m_spriteData[this.m_chunkOffsets[7] + 2 + 1] & 0xFF) << 8;
            while (n5 > 0) {
                if ((this.m_spriteData[n4 + 0] & 0xFF | (this.m_spriteData[n4 + 1] & 0xFF) << 8) == n2) {
                    n3 = n4 + 2;
                    break;
                }
                --n5;
                n4 += 4;
            }
        }
        if (n3 > 0) {
            n3 = this.m_spriteData[n3 + 0] & 0xFF | (this.m_spriteData[n3 + 1] & 0xFF) << 8;
        }
        return n3;
    }

    private static int findChunk(byte[] byArray, char c2, char c3) {
        for (int i2 = 4; i2 < byArray.length; i2 += (byArray[i2 + 2] & 0xFF | (byArray[i2 + 3] & 0xFF) << 8) + 4) {
            if (byArray[i2] != (byte)c2 || byArray[i2 + 1] != (byte)c3) continue;
            return i2 + 4;
        }
        return -1;
    }

    private static int getShort(DDImage dDImage, int n2) {
        return DDFile.retrieveShort(dDImage.m_spriteData, n2, true);
    }

    private static boolean loadSpriteData(String string, DDImage dDImage, byte[] byArray, int n2, int n3, int n4, int n5, boolean bl) {
        boolean bl2 = false;
        if (string.endsWith("font.png")) {
            m_filename.setLength(0);
            m_filename.append(string);
            m_filename.setLength(string.length() - 4);
            m_filename.append(".rff");
            dDImage.m_spriteData = DDFile.loadFileBytes(m_filename.toString());
            dDImage.m_eaFont = SDKUtils.loadFont(null, dDImage.m_spriteData);
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            bl2 = true;
        } else if (string.endsWith(".spr")) {
            if (DDImage.loadSpriteChunkData(string, dDImage)) {
                DDImage.calculateFrameOffsets(dDImage);
                bl2 = true;
            }
        } else {
            dDImage.m_numImages = 1;
            dDImage.m_numFrames = 1;
            bl2 = true;
        }
        dDImage.m_numPalettes = 1;
        if (byArray != null) {
            dDImage.m_numPalettes = n5;
        }
        if (bl2) {
            bl2 = DDImage.loadSpriteImages(string, dDImage, null, byArray, n2, n3, n4, bl);
        }
        return bl2;
    }

    public static int pngFindPLTE(byte[] byArray, int n2) {
        for (int i2 = 8; i2 < n2; i2 += ((byArray[i2 + 0] & 0xFF) << 24 | (byArray[i2 + 1] & 0xFF) << 16 | (byArray[i2 + 2] & 0xFF) << 8 | (byArray[i2 + 3] & 0xFF) << 0) + 8 + 4) {
            if (byArray[i2 + 4] != 80 || byArray[i2 + 5] != 76 || byArray[i2 + 6] != 84 || byArray[i2 + 7] != 69) continue;
            return i2 + 8;
        }
        return -1;
    }

    public static void pngCalcCRC(byte[] byArray, int n2) {
        int n3 = ((byArray[(n2 -= 4) - 4] & 0xFF) << 24 | (byArray[n2 - 3] & 0xFF) << 16 | (byArray[n2 - 2] & 0xFF) << 8 | (byArray[n2 - 1] & 0xFF) << 0) + 4;
        int n4 = -1;
        for (int i2 = 0; i2 < n3; ++i2) {
            int n5 = (n4 ^ (byte)(byArray[i2 + n2] & 0xFF)) & 0xFF;
            for (int i3 = 0; i3 < 8; ++i3) {
                if ((n5 & 1) != 0) {
                    n5 = 0xEDB88320 ^ n5 >>> 1;
                    continue;
                }
                n5 >>>= 1;
            }
            n4 = n5 ^ n4 >>> 8;
        }
        byArray[n2 + n3 + 0] = (byte)((n4 ^= 0xFFFFFFFF) >> 24 & 0xFF);
        byArray[n2 + n3 + 1] = (byte)(n4 >> 16 & 0xFF);
        byArray[n2 + n3 + 2] = (byte)(n4 >> 8 & 0xFF);
        byArray[n2 + n3 + 3] = (byte)(n4 >> 0 & 0xFF);
    }

    private static boolean loadSpriteImages(String string, DDImage dDImage, byte[] byArray, byte[] byArray2, int n2, int n3, int n4, boolean bl) {
        int n5 = 0;
        boolean bl2 = true;
        if (byArray == null) {
            m_filename.setLength(0);
            m_filename.append(string);
            m_filename.setLength(string.length() - 4);
            if (dDImage.m_numImages > 1) {
                m_filename.append("_0");
                n5 = m_filename.length() - 1;
            }
            m_filename.append(".png");
        } else {
            m_filename.setLength(0);
            m_filename.append(string);
        }
        dDImage.m_images = new SDKImage[dDImage.m_numPalettes][dDImage.m_numImages];
        try {
            for (int i2 = 0; i2 < dDImage.m_numImages; ++i2) {
                if (dDImage.m_numImages > 1 && byArray == null) {
                    m_filename.setCharAt(n5, (char)(48 + i2));
                }
                if (byArray2 == null && byArray == null) {
                    dDImage.m_images[0][i2] = DDFile.loadImage(m_filename.toString());
                    continue;
                }
                if (byArray != null && byArray2 == null) {
                    dDImage.m_images[0][i2] = SDKUtils.createImage(byArray, 0, DDFile.getFileLength(string));
                    continue;
                }
                int n6 = DDFile.getFileLength(m_filename.toString());
                byte[] byArray3 = i2 > 0 || byArray == null ? DDFile.loadFileBytes(m_filename.toString()) : byArray;
                if (byArray3 == null) continue;
                int n7 = DDImage.pngFindPLTE(byArray3, n6);
                int n8 = !bl ? n3 * 3 : byArray2[4] & 0xFF | (byArray2[5] & 0xFF) << 8;
                int n9 = 0;
                int n10 = n2;
                while (n9 < dDImage.m_numPalettes) {
                    if ((n4 & 1 << n9) != 0) {
                        if (n7 > 0) {
                            if (!bl) {
                                for (int i3 = 0; i3 < n3 * 3; ++i3) {
                                    byArray3[n7 + i3] = byArray2[n10 + i3];
                                }
                                DDImage.pngCalcCRC(byArray3, n7);
                            } else {
                                System.arraycopy(byArray2, n10, byArray3, n7, n8);
                            }
                        }
                        dDImage.m_images[n9][i2] = SDKUtils.createImage(byArray3, 0, n6);
                        dDImage.m_images[n9][i2].getWidth();
                    }
                    ++n9;
                    n10 += n8;
                }
                byArray3 = null;
            }
        }
        catch (Exception exception) {
            bl2 = false;
        }
        return bl2;
    }

    private static boolean loadSpriteChunkData(String string, DDImage dDImage) {
        boolean bl = false;
        dDImage.m_spriteData = DDFile.loadFileBytes(string);
        if (dDImage.m_spriteData != null) {
            dDImage.m_chunkOffsets = new int[10];
            dDImage.m_chunkDataSize = new byte[10];
            for (int i2 = 0; i2 < 10; ++i2) {
                dDImage.m_chunkOffsets[i2] = (short)DDImage.findChunk(dDImage.m_spriteData, m_chunkIDs[i2][0], m_chunkIDs[i2][1]);
                dDImage.m_chunkDataSize[i2] = 2;
                if (m_chunkIDs[i2][1] != 'b' || dDImage.m_chunkOffsets[i2] != -1) continue;
                dDImage.m_chunkOffsets[i2] = (short)DDImage.findChunk(dDImage.m_spriteData, m_chunkIDs[i2][0], 's');
                dDImage.m_chunkDataSize[i2] = 4;
            }
            bl = true;
            if (dDImage.m_chunkOffsets[0] > 0) {
                dDImage.m_numImages = dDImage.m_spriteData[dDImage.m_chunkOffsets[0] + 4] & 0xFF;
            }
        }
        return bl;
    }

    private static void calculateFrameOffsets(DDImage dDImage) {
        int n2 = DDImage.getShort(dDImage, dDImage.m_chunkOffsets[0] + 0);
        int n3 = DDImage.getShort(dDImage, dDImage.m_chunkOffsets[0] + 2);
        dDImage.m_numFrames = n2;
        dDImage.m_frameOffsets = new short[n2];
        int n4 = 0;
        int n5 = 0;
        int n6 = dDImage.m_chunkOffsets[1];
        int n7 = dDImage.m_chunkOffsets[2];
        while (n4 < n2) {
            if (n3 > 0 && DDImage.getShort(dDImage, n7 + 0) == n4) {
                n7 += 4;
            } else {
                dDImage.m_frameOffsets[n4] = (short)n5;
                n5 += dDImage.m_spriteData[n6 + 0] & 0x1F;
            }
            ++n4;
            ++n6;
        }
        n4 = 0;
        n7 = dDImage.m_chunkOffsets[2];
        while (n4 < n3) {
            dDImage.m_frameOffsets[DDImage.getShort((DDImage)dDImage, (int)(n7 + 0))] = dDImage.m_frameOffsets[DDImage.getShort(dDImage, n7 + 2)];
            ++n4;
            n7 += 4;
        }
        if (dDImage.m_chunkOffsets[7] > 0) {
            short[] sArray = new short[n2];
            for (n4 = 0; n4 < n2; ++n4) {
                sArray[n4] = (short)dDImage.getFrameWidth(n4);
            }
            dDImage.m_frameWidths = sArray;
        }
    }

    private static void debugCheckChunkData(DDImage dDImage) {
    }
}

