/*
 * Decompiled with CFR 0.152.
 */
package com.ea.game;

import com.ea.game.DDFile;

public class DDMath {
    public static int[] m_sinTable;
    public static short[] m_atanTable;
    public static long m_randomSeed;

    public DDMath() {
        m_sinTable = null;
        m_atanTable = null;
    }

    public static void init() {
        DDMath.initRandom();
        m_sinTable = DDMath.unpackSinTableFile(DDFile.loadFileBytes("/sin.bin"));
        m_atanTable = DDMath.unpackAtanTableFile(DDFile.loadFileShorts("/atan.bin"));
    }

    public static int[] unpackSinTableFile(byte[] byArray) {
        int[] nArray = new int[256];
        if (byArray != null) {
            int n2 = 0;
            for (int i2 = 0; i2 < 2; ++i2) {
                int n3 = 2;
                int n4 = 0;
                int n5 = 0;
                while (n4 < 128) {
                    int n6;
                    if (n4 == 64) {
                        n6 = 65536;
                        n3 = -n3;
                    } else {
                        n6 = byArray[n5 + 0] & 0xFF | (byArray[n5 + 1] & 0xFF) << 8;
                    }
                    if (i2 == 1) {
                        n6 = -n6;
                    }
                    nArray[n2] = n6;
                    ++n2;
                    ++n4;
                    n5 += n3;
                }
            }
            byArray = null;
            System.gc();
        }
        return nArray;
    }

    public static int sin(int n2) {
        return m_sinTable[n2 & 0xFF];
    }

    public static int interSin(int n2) {
        if ((n2 & 1) == 0) {
            return m_sinTable[n2 >> 1 & 0xFF];
        }
        int n3 = m_sinTable[n2 >> 1 & 0xFF];
        int n4 = m_sinTable[n2 + 1 >> 1 & 0xFF];
        return (n4 - n3) / 2 + n3;
    }

    public static int cos(int n2) {
        return DDMath.sin(n2 + 64);
    }

    public static int interCos(int n2) {
        return DDMath.interSin(n2 + 128);
    }

    public static short[] unpackAtanTableFile(short[] sArray) {
        short[] sArray2 = new short[1032];
        System.arraycopy(sArray, 24, sArray2, 1024, 8);
        int n2 = 0;
        int n3 = 0;
        while (n2 < 16) {
            DDMath.buildAtanTab(sArray2, sArray, sArray[n2], n3, sArray[n2 + 1]);
            n2 += 2;
            n3 += 128;
        }
        sArray = null;
        System.gc();
        return sArray2;
    }

    private static void buildAtanTab(short[] sArray, short[] sArray2, int n2, int n3, int n4) {
        int n5 = n2;
        int n6 = 16;
        int n7 = 15;
        for (int i2 = 0; i2 < 128; ++i2) {
            sArray[i2 + n3] = (short)(n5 & 0x1FF);
            if ((sArray2[n6] & 1 << n7) != 0) {
                n5 += n4;
            }
            if (--n7 >= 0) continue;
            n7 = 15;
            ++n6;
        }
    }

    public static int atanLow(int n2, int n3) {
        return DDMath.atan(n2, n3) >> 1;
    }

    public static int atan(int n2, int n3) {
        short s;
        int n4 = 0;
        if (n2 < 0) {
            n4 |= 0x200;
            n2 = -n2;
        }
        if (n3 < 0) {
            n4 |= 0x100;
            n3 = -n3;
        }
        if (n2 == n3) {
            s = m_atanTable[1024 + (n4 >> 7)];
        } else {
            if (n3 < n2) {
                n4 |= 0x80;
                int n5 = n2;
                n2 = n3;
                n3 = n5;
            }
            s = n3 == 0 ? m_atanTable[n4] : m_atanTable[(n2 << 7) / n3 + n4];
        }
        return s;
    }

    public static void initRandom() {
        m_randomSeed = -739132197L;
        for (int i2 = (int)System.currentTimeMillis() & 0xFFFF; i2 > 0; --i2) {
            DDMath.getRandom();
        }
    }

    public static int getRandom() {
        m_randomSeed = 1103515245L * m_randomSeed + 12345L;
        return (int)(m_randomSeed >> 16);
    }

    public static void setRandomSeed(long l2) {
        m_randomSeed = l2;
    }

    public static int sqrt(int n2) {
        int n3;
        if (n2 <= 0) {
            return 1;
        }
        int n4 = n2;
        while ((n4 = (n3 = n4) + n2 / n3 >> 1) < n3 && n4 > 0) {
        }
        return n4;
    }

    public static int max(int n2, int n3) {
        if (n2 >= n3) {
            return n2;
        }
        return n3;
    }

    public static int min(int n2, int n3) {
        if (n2 <= n3) {
            return n2;
        }
        return n3;
    }

    public static int CalcModDifference(int n2, int n3) {
        int n4 = n2 - n3;
        if (n4 < 0) {
            n4 = -n4;
        }
        if (n4 > 128) {
            n4 = 255 - n4;
        }
        return n4;
    }

    public static int nextHighestPowerofTwo(int n2) {
        if (n2 != 0) {
            for (int i2 = 0; i2 < 32; ++i2) {
                if (1 << i2 < n2) continue;
                return i2 + 1;
            }
        }
        return 0;
    }

    public static int nextHighestPowerofTwo2(int n2) {
        int n3 = 0;
        if (n2 == 0) {
            return 0;
        }
        while ((n2 >>= 1) > 0) {
            ++n3;
        }
        return n3 + 1;
    }

    public static int abs(int n2) {
        return Math.abs(n2);
    }

    public static int countSetBits(int n2) {
        int n3 = 0;
        while (n2 != 0) {
            n2 &= n2 - 1;
            ++n3;
        }
        return n3;
    }
}

