/*
 * Decompiled with CFR 0.152.
 */
package com.distinctive;

import com.distinctive.DDFile;

public class DDMath {
    private static final int TRIG_DATA_BYTES_PER_ENTRY = 2;
    public static final int BITSHIFT_TRIG = 16;
    public static final int ANGLE_360 = 512;
    public static final int ANGLE_180 = 256;
    public static final int ANGLE_90 = 128;
    public static final int ANGLE_270 = 384;
    public static final int ANGLE_MASK = 511;
    public static final int BITSHIFT_TRANSITIONS = 8;
    private static int[] m_sinTable;
    private static byte[] m_atanTable;
    private static long m_randomSeed;

    public DDMath() {
        m_sinTable = null;
        m_atanTable = null;
    }

    public static void init() {
        byte[] byArray = DDFile.loadFileBytes("/sintab.bin");
        m_sinTable = DDMath.unpackSinTableFile(byArray);
        m_atanTable = DDMath.unpackAtanTableFile(DDFile.loadFileBytes("/atan.bin"));
        DDMath.initRandom();
    }

    public static int[] unpackSinTableFile(byte[] byArray) {
        int[] nArray = null;
        if (byArray != null) {
            nArray = new int[512];
            int n = 0;
            int n2 = 0;
            for (int i = 0; i < 2; ++i) {
                int n3 = 2;
                int n4 = 0;
                int n5 = 0;
                while (n4 < 256) {
                    if (n4 == 128) {
                        n2 = 65536;
                        n3 = -n3;
                    } else {
                        n2 = 0;
                        for (int j = 0; j < 2; ++j) {
                            n2 |= (byArray[n5 + j] & 0xFF) << (2 - j - 1) * 8;
                        }
                    }
                    if (i == 1) {
                        n2 = -n2;
                    }
                    nArray[n++] = n2;
                    ++n4;
                    n5 += n3;
                }
            }
        }
        return nArray;
    }

    public static byte[] unpackAtanTableFile(byte[] byArray) {
        byte[] byArray2 = new byte[520];
        System.arraycopy(byArray, 24, byArray2, 512, 8);
        int n = 0;
        int n2 = 0;
        while (n < 16) {
            DDMath.buildAtanTab(byArray2, byArray, byArray[n], n2, byArray[n + 1]);
            n += 2;
            n2 += 64;
        }
        return byArray2;
    }

    private static void buildAtanTab(byte[] byArray, byte[] byArray2, int n, int n2, int n3) {
        int n4 = n;
        int n5 = 16;
        int n6 = 7;
        for (int i = 0; i < 64; ++i) {
            byArray[i + n2] = (byte)n4;
            if ((byArray2[n5] & 1 << n6) != 0) {
                n4 += n3;
            }
            if (--n6 >= 0) continue;
            n6 = 7;
            ++n5;
        }
    }

    public static int atan(int n, int n2) {
        int n3 = 0;
        try {
            int n4 = 0;
            if (n < 0) {
                n4 |= 0x100;
                n = -n;
            }
            if (n2 < 0) {
                n4 |= 0x80;
                n2 = -n2;
            }
            if (n == n2) {
                n3 = m_atanTable[512 + (n4 >> 6)] & 0x1FF;
            } else {
                if (n2 < n) {
                    n4 |= 0x40;
                    int n5 = n;
                    n = n2;
                    n2 = n5;
                }
                n3 = n2 == 0 ? m_atanTable[n4] & 0x1FF : m_atanTable[(n << 6) / n2 + n4] & 0x1FF;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return n3 << 1;
    }

    public static int sin(int n) {
        return m_sinTable[n & 0x1FF];
    }

    public static int asin(int n) {
        if ((n &= 0x8000FFFF) >= 0) {
            for (int i = 0; i < 128; ++i) {
                if (m_sinTable[i + 1] <= n) continue;
                if (DDMath.abs(m_sinTable[i] - n) < DDMath.abs(m_sinTable[i + 1] - n)) {
                    return i;
                }
                return i + 1;
            }
        } else {
            for (int i = 384; i < 512; ++i) {
                if (m_sinTable[i + 1] >= n) continue;
                if (DDMath.abs(m_sinTable[i] - n) < DDMath.abs(m_sinTable[i + 1] - n)) {
                    return i;
                }
                return i + 1;
            }
        }
        return -1;
    }

    public static int cos(int n) {
        return m_sinTable[n + 128 & 0x1FF];
    }

    public static int calcTurnAngle(int n, int n2) {
        int n3 = (n2 & 0x1FF) - (n & 0x1FF);
        if (n3 >= 0) {
            if (n3 > 256) {
                n3 -= 512;
            }
        } else if (n3 < -256) {
            n3 += 512;
        }
        return n3;
    }

    public static int reflect(int n, int n2) {
        int n3 = DDMath.calcTurnAngle(n + 256, n2);
        return n2 + n3 & 0x1FF;
    }

    public static void initRandom() {
        m_randomSeed = -739132197L;
        for (int i = (int)System.currentTimeMillis() & 0xFFFF; i > 0; --i) {
            DDMath.getRandom();
        }
    }

    public static int getRandom() {
        m_randomSeed = 1103515245L * m_randomSeed + 12345L;
        return (int)(m_randomSeed >> 16);
    }

    public static int getRandom(int n) {
        return DDMath.abs(DDMath.getRandom()) % n;
    }

    public static int getRandom(int n, int n2) {
        if (n == n2) {
            return n;
        }
        return n + DDMath.abs(DDMath.getRandom()) % (n2 - n);
    }

    public static void setRandomSeed(long l) {
        m_randomSeed = l;
    }

    public static int sqrtRout(int n) {
        int n2;
        if (n <= 0) {
            return 1;
        }
        int n3 = n;
        while ((n3 = (n2 = n3) + n / n2 >> 1) < n2 && n3 > 0) {
        }
        return n3;
    }

    public static int max(int n, int n2) {
        if (n >= n2) {
            return n;
        }
        return n2;
    }

    public static int min(int n, int n2) {
        if (n <= n2) {
            return n;
        }
        return n2;
    }

    public static int abs(int n) {
        return n >= 0 ? n : -n;
    }

    public static int CalcModDifference(int n, int n2) {
        int n3 = n - n2;
        if (n3 < 0) {
            n3 = -n3;
        }
        if (n3 > 128) {
            n3 = 512 - n3 - 1;
        }
        return n3;
    }

    public static int nextHighestPowerofTwo(int n) {
        if (n != 0) {
            for (int i = 0; i < 32; ++i) {
                if (1 << i < n) continue;
                return i + 1;
            }
        }
        return 0;
    }

    public static int nextHighestPowerofTwo2(int n) {
        int n2 = 0;
        if (n == 0) {
            return 0;
        }
        while ((n >>= 1) > 0) {
            ++n2;
        }
        return n2 + 1;
    }

    public static int countSetBits(int n) {
        int n2 = 0;
        while (n != 0) {
            n &= n - 1;
            ++n2;
        }
        return n2;
    }

    public static boolean isPointInsideRectangle(int n, int n2, int n3, int n4, int n5, int n6) {
        return n >= n3 && n <= n3 + n5 && n2 >= n4 && n2 <= n4 + n6;
    }

    public static boolean isPointInsideCircle(int n, int n2, int n3, int n4, int n5) {
        int n6 = n - n3;
        int n7 = n2 - n4;
        return n6 * n6 + n7 * n7 <= n5 * n5;
    }

    public static boolean isPointInsideTriangle(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8) {
        int n9;
        int n10;
        int n11 = DDMath.abs(n3 * n8 - n3 * n6 + n5 * n4 - n5 * n8 + n7 * n6 - n7 * n4);
        int n12 = DDMath.abs(n * n6 - n * n4 + n3 * n2 - n3 * n6 + n5 * n4 - n5 * n2);
        return n12 + (n10 = DDMath.abs(n * n8 - n * n4 + n3 * n2 - n3 * n8 + n7 * n4 - n7 * n2)) + (n9 = DDMath.abs(n * n8 - n * n6 + n5 * n2 - n5 * n8 + n7 * n6 - n7 * n2)) <= n11;
    }

    public static int smoothStep(int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 - n4;
        int n7 = (n - n2 << 8) / (n3 - n2);
        n7 = DDMath.min(DDMath.max(n7, 0), 256);
        int n8 = n7 * n7 * (768 - (n7 << 1)) >> 16;
        return n4 + n8 * n6 / 256;
    }

    public static int linearStep(int n, int n2, int n3, int n4, int n5) {
        int n6 = n5 - n4;
        int n7 = (n - n2 << 8) / (n3 - n2);
        n7 = DDMath.min(DDMath.max(n7, 0), 256);
        return n4 + n7 * n6 / 256;
    }

    public static void updateSprings(int[] nArray, int[] nArray2, int[] nArray3, int n, int n2) {
        for (int i = 0; i < nArray.length; ++i) {
            int n3 = i;
            nArray3[n3] = nArray3[n3] + (nArray2[i] - nArray[i]) * n;
            int n4 = i;
            nArray[n4] = nArray[n4] + (nArray3[i] >> 8);
            nArray3[i] = nArray3[i] * n2 >> 8;
        }
    }
}

