/*
 * Decompiled with CFR 0.152.
 */
import java.io.InputStream;
import javax.microedition.media.Manager;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class GVL2_soundPlayer
implements PlayerListener,
Runnable {
    private static Player clipSound;
    public static StringBuffer strBuffer;
    private static Thread soundThread;
    private static boolean isPreloading;
    private static boolean isPlaying;
    private static int loopSoundIndex;
    private static int playingIndex;
    private static boolean playingLoop;
    private static int preLoadStep;
    private static Player[] soundData;
    private static boolean[] isOncePlay;
    private static int soundDataCnt;

    public GVL2_soundPlayer(int soundCnt, int _preLoadStep) {
        strBuffer = new StringBuffer();
        isPlaying = false;
        isPreloading = false;
        this.setLoopSoundIndex(-1);
        playingIndex = -1;
        playingLoop = false;
        preLoadStep = _preLoadStep;
        soundDataCnt = soundCnt;
        soundData = new Player[soundDataCnt];
        isOncePlay = new boolean[soundDataCnt];
        soundThread = new Thread(this);
        soundThread.start();
    }

    public void playerUpdate(Player player, String event, Object eventData) {
        isPlaying = event == "started";
        if ((event == "endOfMedia" || event == "stopped") && this.getLoopSoundIndex() >= 0) {
            this.Play(this.getLoopSoundIndex(), true);
        }
    }

    public int getLoopSoundIndex() {
        return loopSoundIndex;
    }

    public void Play(int fileIndex, boolean loop) {
        if (!isPreloading) {
            return;
        }
        playingIndex = -1;
        if (isPlaying) {
            this.Stop();
            playingIndex = fileIndex;
            playingLoop = loop;
            return;
        }
        if (loop) {
            this.setLoopSoundIndex(fileIndex);
        }
        if (preLoadStep == 0) {
            this.prefetchedTOrealized(clipSound);
            if (clipSound != null && clipSound.getState() == 300) {
                playingIndex = fileIndex;
                playingLoop = loop;
                return;
            }
        }
        clipSound = null;
        clipSound = soundData[fileIndex];
        ObsClass.saveSoundIndex = fileIndex;
        this.realizedTOprefetched(clipSound);
        if (clipSound.getState() != 300) {
            playingIndex = fileIndex;
            playingLoop = loop;
            return;
        }
        if (!this.prefetchedTOstarted(clipSound)) {
            playingIndex = fileIndex;
            playingLoop = loop;
            return;
        }
    }

    public void Stop() {
        try {
            this.setLoopSoundIndex(-1);
            this.onceSoundStop();
        }
        catch (Exception e) {
            System.out.println("-------GVL2_AmMidirPlayer.java Stop() error" + e);
        }
    }

    public void StopX() {
        try {
            this.onceSoundStop();
        }
        catch (Exception e) {
            System.out.println("-------GVL2_AmMidirPlayer.java Stop() error" + e);
        }
    }

    private synchronized void onceSoundStop() {
        try {
            if (clipSound != null) {
                playingIndex = -1;
                if (clipSound.getState() == 400) {
                    clipSound.deallocate();
                }
                if (clipSound.getState() == 300) {
                    clipSound.deallocate();
                }
                if (clipSound.getState() == 200) {
                    clipSound.deallocate();
                }
                clipSound.stop();
            }
        }
        catch (Exception e) {
            System.out.println("-------GVL2_AmMidirPlayer.java onceSoundStop() error re" + e);
        }
    }

    public void setLoopSoundIndex(int idx) {
        loopSoundIndex = idx;
    }

    private Player loadSoundData(String fileName, String type) {
        try {
            InputStream is = fileName.getClass().getResourceAsStream(fileName);
            Player rtnSound = Manager.createPlayer((InputStream)is, (String)type);
            rtnSound.addPlayerListener((PlayerListener)this);
            rtnSound.realize();
            if (preLoadStep == 1) {
                rtnSound.prefetch();
            }
            return rtnSound;
        }
        catch (Exception e) {
            System.out.println("-------GVL2_AmMidirPlayer.java loadSoundData() error : " + fileName + ":" + type + "   : " + e);
            return null;
        }
    }

    public int preLoading(String strName, int number, String type) {
        isPreloading = true;
        try {
            if (soundData[number] == null) {
                GVL2_soundPlayer.soundData[number] = this.loadSoundData(strName, type);
                GVL2_soundPlayer.isOncePlay[number] = false;
            }
        }
        catch (Exception e) {
            System.out.println("-------GVL2_AmMidirPlayer.java preLoading() error:" + e);
            return 0;
        }
        return number;
    }

    public boolean realizedTOprefetched(Player player) {
        if (player == null) {
            return false;
        }
        if (player.getState() == 200) {
            try {
                player.prefetch();
            }
            catch (Exception e) {
                System.out.println("-------realizedTOprefetched error : " + e);
                return false;
            }
        }
        return true;
    }

    public boolean prefetchedTOstarted(Player player) {
        if (player == null) {
            return false;
        }
        if (player.getState() == 300) {
            try {
                player.start();
            }
            catch (Exception e) {
                System.out.println("-------prefetchedTOstarted error : " + e);
                return false;
            }
        }
        return true;
    }

    public void prefetchedTOrealized(Player player) {
        if (player == null) {
            return;
        }
        if (player.getState() == 300) {
            player.deallocate();
        }
    }

    public void process() {
        if (playingIndex >= 0) {
            int tmp_index = playingIndex;
            boolean tmp_loop = playingLoop;
            playingIndex = -1;
            this.Play(tmp_index, tmp_loop);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        while (true) {
            GVL2_soundPlayer gVL2_soundPlayer = this;
            synchronized (gVL2_soundPlayer) {
                try {
                    soundThread.yield();
                    this.process();
                    soundThread.yield();
                    Thread.sleep(50L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
        }
    }

    public void close() {
        clipSound.close();
    }
}

