/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Button;
import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.List;
import com.sun.lwuit.TabbedPane;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.animations.Transition;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.geom.Rectangle;
import com.sun.lwuit.list.ListCellRenderer;
import com.sun.lwuit.plaf.Style;

public abstract class LookAndFeel {
    private Component verticalScroll;
    private Component horizontalScroll;
    private Component verticalScrollThumb;
    private Component horizontalScrollThumb;
    private boolean rtl;
    private long tickerSpeed = 50L;
    private int defaultFormTintColor = 0x77000000;
    private int disableColor = 0xCCCCCC;
    private Transition defaultFormTransitionIn;
    private Transition defaultFormTransitionOut;
    private Transition defaultMenuTransitionIn;
    private Transition defaultMenuTransitionOut;
    private Transition defaultDialogTransitionIn;
    private Transition defaultDialogTransitionOut;
    private boolean defaultSmoothScrolling = true;
    private boolean focusScrolling;
    private int defaultSmoothScrollingSpeed = 150;
    private boolean reverseSoftButtons;
    private ListCellRenderer menuRenderer;
    private Image[] menuIcons = new Image[3];
    private boolean touchMenus;
    private int tactileTouchDuration = 0;
    private boolean defaultEndsWith3Points = true;
    private boolean defaultTensileDrag = true;

    public void bind(Component cmp) {
    }

    public void uninstall() {
    }

    public abstract void drawButton(Graphics var1, Button var2);

    public abstract void drawCheckBox(Graphics var1, Button var2);

    public abstract void drawComboBox(Graphics var1, List var2);

    public abstract void drawLabel(Graphics var1, Label var2);

    public abstract void drawList(Graphics var1, List var2);

    public abstract void drawRadioButton(Graphics var1, Button var2);

    public abstract void drawTextArea(Graphics var1, TextArea var2);

    public abstract void drawTextField(Graphics var1, TextArea var2);

    public abstract void drawTextFieldCursor(Graphics var1, TextArea var2);

    public abstract void drawTabbedPane(Graphics var1, TabbedPane var2);

    public abstract Dimension getButtonPreferredSize(Button var1);

    public abstract Dimension getCheckBoxPreferredSize(Button var1);

    public abstract Dimension getLabelPreferredSize(Label var1);

    public abstract Dimension getListPreferredSize(List var1);

    public abstract Dimension getRadioButtonPreferredSize(Button var1);

    public abstract Dimension getTextAreaSize(TextArea var1, boolean var2);

    public abstract Dimension getTextFieldPreferredSize(TextArea var1);

    public abstract Dimension getComboBoxPreferredSize(List var1);

    public void drawVerticalScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio) {
        if (this.verticalScroll == null) {
            this.initScroll();
        }
        int borderW = 0;
        if (c.getStyle().getBorder() != null) {
            borderW = c.getStyle().getBorder().getThickness();
        }
        int x = c.getX();
        x = !c.isRTL() ? (x += c.getWidth() - this.getVerticalScrollWidth() - borderW) : (x += borderW);
        int y = c.getY();
        int height = c.getHeight();
        int width = this.getVerticalScrollWidth();
        this.drawScroll(g, c, offsetRatio, blockSizeRatio, true, x, y, width, height, this.verticalScroll, this.verticalScrollThumb);
    }

    public void drawHorizontalScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio) {
        if (this.horizontalScroll == null) {
            this.initScroll();
        }
        int borderH = 0;
        if (c.getStyle().getBorder() != null) {
            borderH = c.getStyle().getBorder().getThickness();
        }
        int x = c.getX();
        int y = c.getY() + c.getHeight() - this.getHorizontalScrollHeight() - borderH;
        int width = c.getWidth();
        int height = this.getHorizontalScrollHeight();
        this.drawScroll(g, c, offsetRatio, blockSizeRatio, false, x, y, width, height, this.horizontalScroll, this.horizontalScrollThumb);
    }

    private void drawScroll(Graphics g, Component c, float offsetRatio, float blockSizeRatio, boolean isVertical, int x, int y, int width, int height, Component scroll, Component scrollThumb) {
        int offset;
        int blockSize;
        Style scrollStyle = scroll.getUnselectedStyle();
        Style scrollThumbStyle = scrollThumb.getUnselectedStyle();
        int marginLeft = scrollStyle.getMargin(c.isRTL(), 1);
        int marginTop = scrollStyle.getMargin(false, 0);
        scroll.setX(x += marginLeft);
        scroll.setY(y += marginTop);
        scroll.setWidth(width -= marginLeft + scrollStyle.getMargin(c.isRTL(), 3));
        scroll.setHeight(height -= marginTop + scrollStyle.getMargin(false, 2));
        int cx = g.getClipX();
        int cy = g.getClipY();
        int cw = g.getClipWidth();
        int ch = g.getClipHeight();
        scroll.paintComponent(g);
        marginLeft = scrollThumbStyle.getMargin(c.isRTL(), 1);
        marginTop = scrollThumbStyle.getMargin(false, 0);
        x += marginLeft;
        width -= marginLeft + scrollThumbStyle.getMargin(c.isRTL(), 3);
        y += marginTop;
        height -= marginTop + scrollThumbStyle.getMargin(false, 2);
        if (isVertical) {
            blockSize = (int)((float)c.getHeight() * blockSizeRatio) + 2;
            offset = (int)((float)c.getHeight() * offsetRatio);
        } else {
            blockSize = (int)((float)c.getWidth() * blockSizeRatio) + 2;
            offset = (int)((float)c.getWidth() * offsetRatio);
        }
        if (isVertical) {
            scrollThumb.setX(x);
            scrollThumb.setY(y + offset);
            scrollThumb.setWidth(width);
            scrollThumb.setHeight(blockSize);
        } else {
            scrollThumb.setX(x + offset);
            scrollThumb.setY(y);
            scrollThumb.setWidth(blockSize);
            scrollThumb.setHeight(height);
        }
        g.setClip(cx, cy, cw, ch);
        scrollThumb.paintComponent(g);
        g.setClip(cx, cy, cw, ch);
    }

    public void setFG(Graphics g, Component c) {
        Style s = c.getStyle();
        g.setFont(s.getFont());
        if (c.isEnabled()) {
            g.setColor(s.getFgColor());
        } else {
            g.setColor(this.disableColor);
        }
    }

    public int getVerticalScrollWidth() {
        if (this.verticalScroll == null) {
            this.initScroll();
        }
        Style scrollStyle = this.verticalScroll.getStyle();
        return scrollStyle.getMargin(false, 1) + scrollStyle.getMargin(false, 3) + scrollStyle.getPadding(false, 1) + scrollStyle.getPadding(false, 3);
    }

    public int getHorizontalScrollHeight() {
        if (this.horizontalScroll == null) {
            this.initScroll();
        }
        Style scrollStyle = this.horizontalScroll.getStyle();
        return scrollStyle.getMargin(false, 0) + scrollStyle.getMargin(false, 2) + scrollStyle.getPadding(false, 0) + scrollStyle.getPadding(false, 2);
    }

    void drawBorder(Graphics g, Component c, int color, int borderWidth) {
        this.drawBorder(g, c, color, color, borderWidth);
    }

    void drawBorder(Graphics g, Component c, int topAndRightColor, int bottomAndLeftColor, int borderWidth) {
        g.setColor(topAndRightColor);
        g.fillRect(c.getX(), c.getY(), c.getWidth(), borderWidth);
        g.fillRect(c.getX(), c.getY(), borderWidth, c.getHeight());
        g.setColor(bottomAndLeftColor);
        g.fillRect(c.getX(), c.getY() + c.getHeight() - borderWidth, c.getWidth(), borderWidth);
        g.fillRect(c.getX() + c.getWidth() - borderWidth, c.getY(), borderWidth, c.getHeight());
    }

    public abstract Component getTabbedPaneCell(TabbedPane var1, String var2, Image var3, boolean var4, boolean var5, Style var6, Style var7, Style var8, int var9, int var10, Dimension var11, Dimension var12);

    public abstract void drawTabbedPaneContentPane(TabbedPane var1, Graphics var2, Rectangle var3, Dimension var4, int var5, int var6, Dimension var7, int var8, int var9);

    public Transition getDefaultFormTransitionIn() {
        return this.defaultFormTransitionIn;
    }

    public void setDefaultFormTransitionIn(Transition defaultFormTransitionIn) {
        this.defaultFormTransitionIn = defaultFormTransitionIn;
    }

    public Transition getDefaultFormTransitionOut() {
        return this.defaultFormTransitionOut;
    }

    public void setDefaultFormTransitionOut(Transition defaultFormTransitionOut) {
        this.defaultFormTransitionOut = defaultFormTransitionOut;
    }

    public Transition getDefaultMenuTransitionIn() {
        return this.defaultMenuTransitionIn;
    }

    public void setDefaultMenuTransitionIn(Transition defaultMenuTransitionIn) {
        this.defaultMenuTransitionIn = defaultMenuTransitionIn;
    }

    public Transition getDefaultMenuTransitionOut() {
        return this.defaultMenuTransitionOut;
    }

    public void setDefaultMenuTransitionOut(Transition defaultMenuTransitionOut) {
        this.defaultMenuTransitionOut = defaultMenuTransitionOut;
    }

    public Transition getDefaultDialogTransitionIn() {
        return this.defaultDialogTransitionIn;
    }

    public void setDefaultDialogTransitionIn(Transition defaultDialogTransitionIn) {
        this.defaultDialogTransitionIn = defaultDialogTransitionIn;
    }

    public Transition getDefaultDialogTransitionOut() {
        return this.defaultDialogTransitionOut;
    }

    public void setDefaultDialogTransitionOut(Transition defaultDialogTransitionOut) {
        this.defaultDialogTransitionOut = defaultDialogTransitionOut;
    }

    public int getDefaultFormTintColor() {
        return this.defaultFormTintColor;
    }

    public void setDefaultFormTintColor(int defaultFormTintColor) {
        this.defaultFormTintColor = defaultFormTintColor;
    }

    public int getDisableColor() {
        return this.disableColor;
    }

    public void setDisableColor(int disableColor) {
        this.disableColor = disableColor;
    }

    public boolean isDefaultSmoothScrolling() {
        return this.defaultSmoothScrolling;
    }

    public void setDefaultSmoothScrolling(boolean defaultSmoothScrolling) {
        this.defaultSmoothScrolling = defaultSmoothScrolling;
    }

    public int getDefaultSmoothScrollingSpeed() {
        return this.defaultSmoothScrollingSpeed;
    }

    public void setDefaultSmoothScrollingSpeed(int defaultSmoothScrollingSpeed) {
        this.defaultSmoothScrollingSpeed = defaultSmoothScrollingSpeed;
    }

    public boolean isReverseSoftButtons() {
        return this.reverseSoftButtons;
    }

    public void setReverseSoftButtons(boolean reverseSoftButtons) {
        this.reverseSoftButtons = reverseSoftButtons;
    }

    public ListCellRenderer getMenuRenderer() {
        return this.menuRenderer;
    }

    public void setMenuRenderer(ListCellRenderer menuRenderer) {
        this.menuRenderer = menuRenderer;
    }

    public void setMenuIcons(Image select, Image cancel, Image menu) {
        this.menuIcons[0] = select;
        this.menuIcons[1] = cancel;
        this.menuIcons[2] = menu;
    }

    public Image[] getMenuIcons() {
        return this.menuIcons;
    }

    public long getTickerSpeed() {
        return this.tickerSpeed;
    }

    public void setTickerSpeed(long tickerSpeed) {
        this.tickerSpeed = tickerSpeed;
    }

    private void initScroll() {
        this.verticalScroll = new Label();
        this.verticalScroll.setUIID("Scroll");
        this.horizontalScroll = new Label();
        this.horizontalScroll.setUIID("HorizontalScroll");
        this.verticalScrollThumb = new Label();
        this.verticalScrollThumb.setUIID("ScrollThumb");
        this.horizontalScrollThumb = new Label();
        this.horizontalScrollThumb.setUIID("HorizontalScrollThumb");
    }

    public void refreshTheme() {
        this.initScroll();
        if (this.menuRenderer != null && this.menuRenderer instanceof Component) {
            ((Component)((Object)this.menuRenderer)).refreshTheme();
        }
    }

    public boolean isTouchMenus() {
        return this.touchMenus;
    }

    public void setTouchMenus(boolean touchMenus) {
        this.touchMenus = touchMenus;
    }

    public void setRTL(boolean rtl) {
        this.rtl = rtl;
        if (rtl) {
            Display.getInstance().setBidiAlgorithm(true);
        }
    }

    public boolean isRTL() {
        return this.rtl;
    }

    public int getTactileTouchDuration() {
        return this.tactileTouchDuration;
    }

    public void setTactileTouchDuration(int tactileTouchDuration) {
        this.tactileTouchDuration = tactileTouchDuration;
    }

    public boolean isDefaultEndsWith3Points() {
        return this.defaultEndsWith3Points;
    }

    public void setDefaultEndsWith3Points(boolean defaultEndsWith3Points) {
        this.defaultEndsWith3Points = defaultEndsWith3Points;
    }

    public boolean isDefaultTensileDrag() {
        return this.defaultTensileDrag;
    }

    public void setDefaultTensileDrag(boolean defaultTensileDrag) {
        this.defaultTensileDrag = defaultTensileDrag;
    }

    public boolean isFocusScrolling() {
        return this.focusScrolling;
    }

    public void setFocusScrolling(boolean focusScrolling) {
        this.focusScrolling = focusScrolling;
    }
}

