/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Button;
import com.sun.lwuit.Command;
import com.sun.lwuit.Container;
import com.sun.lwuit.Dialog;
import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Form;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.TextArea;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.DataChangedListener;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.layouts.GridLayout;
import com.sun.lwuit.plaf.UIManager;
import com.sun.lwuit.util.EventDispatcher;
import java.util.Hashtable;
import java.util.Vector;

public class TextField
extends TextArea {
    private static boolean replaceMenuDefault = true;
    private long cursorBlinkTime = System.currentTimeMillis();
    private boolean drawCursor = true;
    private int cursorCharPosition = -1;
    private boolean pressedAndNotReleased;
    private long pressTime;
    private boolean useSoftkeys = true;
    private long releaseTime;
    private String previousText;
    private int commitTimeout = 1000;
    private boolean pendingCommit;
    private int pressCount = 0;
    private int lastKeyCode;
    private int pressedKeyCode;
    private static String clearText = "Clear";
    private static String t9Text = "T9";
    private boolean longClick;
    private Command originalClearCommand;
    private static Hashtable inputModes;
    private static String[] defaultInputModeOrder;
    private String inputMode = defaultInputModeOrder[0];
    private String[] inputModeOrder = defaultInputModeOrder;
    private static Vector firstUppercaseInputMode;
    private int blinkOnTime = 800;
    private int blinkOffTime = 200;
    private static boolean qwertyAutoDetect;
    private boolean qwertyInitialized;
    private static boolean qwertyDevice;
    private boolean qwerty = qwertyDevice;
    private boolean replaceMenu = replaceMenuDefault;
    private Command[] originalCommands;
    private EventDispatcher listeners = new EventDispatcher();
    private boolean overwriteMode;
    private boolean enableInputScroll = true;
    private int keyFwd = 5;
    private int keyBack = 2;
    private boolean leftAndRightEditingTrigger = true;
    private static int defaultChangeInputModeKey;
    private static int defaultSymbolDialogKey;
    private Command selectCommand;
    private Command DELETE_COMMAND = new CommandHandler(clearText, 1);
    private Command T9_COMMAND = new CommandHandler(t9Text, 2);
    private static final char[] DEFAULT_SYMBOL_TABLE;
    private static char[] symbolTable;
    private static final String[] DEFAULT_KEY_CODES;

    public static void setClearText(String text) {
        clearText = text;
    }

    public static void setT9Text(String text) {
        t9Text = text;
    }

    public boolean isEnableInputScroll() {
        return this.enableInputScroll;
    }

    public void setEnableInputScroll(boolean enableInputScroll) {
        this.enableInputScroll = enableInputScroll;
    }

    public TextField() {
        super(1, 20);
        this.setUIID("TextField");
    }

    public TextField(int columns) {
        super(1, columns);
        this.setUIID("TextField");
    }

    public TextField(String text) {
        super(text, 1, 20);
        this.setUIID("TextField");
    }

    public void deleteChar() {
        String text = this.getText();
        if (text.length() > 0 && this.cursorCharPosition > 0) {
            --this.cursorCharPosition;
            if (!this.overwriteMode) {
                text = text.substring(0, this.cursorCharPosition) + text.substring(this.cursorCharPosition + 1, text.length());
                super.setText(text);
                this.commitChange();
                this.fireDataChanged(0, this.cursorCharPosition);
            }
        }
    }

    public TextField(String text, int columns) {
        super(text, 1, columns);
    }

    public static TextArea create(String text, int columns) {
        if (Display.getInstance().getImplementation().isNativeInputSupported()) {
            return new TextArea(text, 1, columns);
        }
        return new TextField(text, columns);
    }

    public static TextArea create() {
        return TextField.create(20);
    }

    public static TextArea create(int columns) {
        return TextField.create("", columns);
    }

    public static TextArea create(String text) {
        return TextField.create(text, 20);
    }

    protected void commitChange() {
        this.pendingCommit = false;
        this.previousText = null;
        this.pressCount = 0;
    }

    public boolean isPendingCommit() {
        return this.pendingCommit;
    }

    public void setCommitTimeout(int commitTimeout) {
        this.commitTimeout = commitTimeout;
    }

    public int getCommitTimeout() {
        return this.commitTimeout;
    }

    public void setInputMode(String inputMode) {
        this.inputMode = inputMode;
        this.repaint();
    }

    public String getInputMode() {
        return this.inputMode;
    }

    protected boolean isChangeInputMode(int keyCode) {
        return keyCode == defaultChangeInputModeKey;
    }

    private static void initInputModes() {
        if (inputModes == null) {
            firstUppercaseInputMode.addElement("Abc");
            inputModes = new Hashtable();
            Hashtable<Integer, String> upcase = new Hashtable<Integer, String>();
            for (int iter = 0; iter < DEFAULT_KEY_CODES.length; ++iter) {
                upcase.put(new Integer(48 + iter), DEFAULT_KEY_CODES[iter]);
            }
            inputModes.put("ABC", upcase);
            Hashtable<Integer, String> lowcase = new Hashtable<Integer, String>();
            for (int iter = 0; iter < DEFAULT_KEY_CODES.length; ++iter) {
                lowcase.put(new Integer(48 + iter), DEFAULT_KEY_CODES[iter].toLowerCase());
            }
            inputModes.put("abc", lowcase);
            Hashtable<Integer, String> numbers = new Hashtable<Integer, String>();
            for (int iter = 0; iter < 10; ++iter) {
                numbers.put(new Integer(48 + iter), "" + iter);
            }
            inputModes.put("123", numbers);
        }
    }

    public static void addInputMode(String name, Hashtable values, boolean firstUpcase) {
        TextField.initInputModes();
        inputModes.put(name, values);
        if (firstUpcase) {
            firstUppercaseInputMode.addElement(name);
        }
    }

    public String[] getInputModeOrder() {
        return this.inputModeOrder;
    }

    public void setInputModeOrder(String[] order) {
        this.inputModeOrder = order;
        this.inputMode = order[0];
    }

    public static String[] getDefaultInputModeOrder() {
        return defaultInputModeOrder;
    }

    public static void setDefaultInputModeOrder(String[] order) {
        defaultInputModeOrder = order;
    }

    private String pickLowerOrUpper(String inputMode) {
        String text;
        int pos = this.cursorCharPosition - 1;
        if (this.pendingCommit) {
            --pos;
        }
        if (pos >= (text = this.getText()).length()) {
            pos = text.length() - 1;
        }
        while (pos > -1) {
            if (text.charAt(pos) == '.') {
                return inputMode.toUpperCase();
            }
            if (text.charAt(pos) != ' ') {
                return inputMode.toLowerCase();
            }
            --pos;
        }
        return inputMode.toUpperCase();
    }

    protected String getLongClickInputMode() {
        return "123";
    }

    protected char getCharPerKeyCode(int pressCount, int keyCode, boolean longClick) {
        TextField.initInputModes();
        String input = this.inputMode;
        if (longClick) {
            input = this.getLongClickInputMode();
        } else if (firstUppercaseInputMode.contains(input)) {
            input = this.pickLowerOrUpper(input);
        }
        Hashtable mode = (Hashtable)inputModes.get(input);
        String s = (String)mode.get(new Integer(keyCode));
        if (s != null) {
            return s.charAt(pressCount %= s.length());
        }
        return '\u0000';
    }

    void onClick() {
    }

    public void setCursorPosition(int pos) {
        if (pos < -1 || pos > this.getText().length()) {
            throw new IllegalArgumentException("Illegal cursor position: " + pos);
        }
        this.cursorCharPosition = pos;
    }

    public int getCursorPosition() {
        if (this.getText() == null) {
            return 0;
        }
        return Math.min(this.getText().length(), this.cursorCharPosition);
    }

    public void setText(String text) {
        super.setText(text);
        this.fireDataChanged(2, -1);
        if (this.cursorCharPosition < 0) {
            this.cursorCharPosition = text.length();
        } else if (this.cursorCharPosition > text.length()) {
            this.cursorCharPosition = text.length();
        }
    }

    public void clear() {
        this.setText("");
        this.commitChange();
    }

    private void longClick(int keyCode) {
        this.longClick = true;
        this.keyReleaseOrLongClick(keyCode, true);
    }

    protected boolean isClearKey(int keyCode) {
        return keyCode == Form.clearSK || keyCode == Form.backspaceSK;
    }

    protected void longKeyPress(int keyCode) {
        if (this.isClearKey(keyCode)) {
            this.setText("");
        }
    }

    public boolean isQwertyInput() {
        if (!this.qwertyInitialized) {
            this.qwertyInitialized = true;
            int type = Display.getInstance().getKeyboardType();
            if (type == 0) {
                this.qwerty = qwertyDevice;
            } else {
                boolean bl = this.qwerty = type == 2 || type == 3;
                if (!qwertyDevice) {
                    qwertyDevice = this.qwerty;
                }
            }
        }
        return this.qwerty;
    }

    public void setQwertyInput(boolean qwerty) {
        this.qwerty = qwerty;
    }

    protected boolean isImmediateInputMode(String mode) {
        return "123".equals(mode);
    }

    private boolean keyReleaseOrLongClick(int keyCode, boolean longClick) {
        int game;
        if (this.lastKeyCode != keyCode && this.pendingCommit) {
            this.commitChange();
        }
        this.lastKeyCode = keyCode;
        boolean isClearKey = this.isClearKey(keyCode);
        if (this.isQwertyInput() && !isClearKey) {
            if (keyCode > 0) {
                if (this.previousText == null) {
                    this.previousText = this.getText();
                }
                if (this.cursorCharPosition < 0) {
                    this.cursorCharPosition = 0;
                }
                this.insertChars("" + (char)keyCode);
                this.commitChange();
                this.fireDataChanged(1, this.cursorCharPosition);
                return true;
            }
        } else {
            char c = this.getCharPerKeyCode(this.pressCount, keyCode, longClick);
            this.cursorCharPosition = Math.max(this.cursorCharPosition, 0);
            if (c != '\u0000') {
                if (this.previousText == null) {
                    this.previousText = this.getText();
                }
                if (!this.pendingCommit) {
                    this.insertChars("" + c);
                    this.pendingCommit = true;
                    ++this.pressCount;
                } else if (this.overwriteMode) {
                    --this.cursorCharPosition;
                    this.insertChars("" + c);
                    ++this.pressCount;
                } else if (this.cursorCharPosition > 0 && this.cursorCharPosition < this.getMaxSize() && this.validChar("" + c)) {
                    String text = this.previousText.substring(0, this.cursorCharPosition - 1) + c + this.previousText.substring(this.cursorCharPosition - 1, this.previousText.length());
                    this.pendingCommit = true;
                    ++this.pressCount;
                    super.setText(text);
                }
                if (this.isImmediateInputMode(this.inputMode)) {
                    this.commitChange();
                    this.fireDataChanged(1, this.cursorCharPosition);
                } else if (this.pressCount == 1) {
                    this.fireDataChanged(1, this.cursorCharPosition);
                } else {
                    this.fireDataChanged(2, this.cursorCharPosition);
                }
                return true;
            }
        }
        if ((game = Display.getInstance().getGameAction(keyCode)) == this.keyFwd) {
            ++this.cursorCharPosition;
            if (this.cursorCharPosition > this.getText().length()) {
                this.cursorCharPosition = this.isCursorPositionCycle() ? 0 : this.getText().length();
            }
            this.repaint();
            return true;
        }
        if (game == this.keyBack) {
            --this.cursorCharPosition;
            if (this.cursorCharPosition < 0) {
                this.cursorCharPosition = this.isCursorPositionCycle() ? this.getText().length() : 0;
            }
            this.repaint();
            return true;
        }
        if (this.isChangeInputMode(keyCode)) {
            for (int iter = 0; iter < this.inputModeOrder.length; ++iter) {
                if (!this.inputModeOrder[iter].equals(this.inputMode)) continue;
                if (++iter < this.inputModeOrder.length) {
                    this.setInputMode(this.inputModeOrder[iter]);
                } else {
                    this.setInputMode(this.inputModeOrder[0]);
                }
                return true;
            }
            return true;
        }
        if (isClearKey) {
            if (longClick) {
                this.setText("");
                this.commitChange();
            } else {
                this.deleteChar();
            }
            return true;
        }
        if (this.isSymbolDialogKey(keyCode)) {
            this.showSymbolDialog();
            return true;
        }
        return false;
    }

    public void insertChars(String c) {
        String currentText = this.getText();
        if (!this.validChar(c)) {
            return;
        }
        ++this.cursorCharPosition;
        if (this.overwriteMode && this.cursorCharPosition <= currentText.length()) {
            this.setText(currentText.substring(0, this.cursorCharPosition - 1) + c + currentText.substring(this.cursorCharPosition, currentText.length()));
        } else {
            if (currentText.length() + c.length() > this.getMaxSize()) {
                --this.cursorCharPosition;
                return;
            }
            this.setText(currentText.substring(0, this.cursorCharPosition - 1) + c + currentText.substring(this.cursorCharPosition - 1, currentText.length()));
        }
        if (c.length() > 1) {
            this.cursorCharPosition += c.length() - 1;
        }
    }

    protected boolean validChar(String c) {
        return !(this.getConstraint() == 2 ? c.charAt(0) < '0' || c.charAt(0) > '9' : (this.getConstraint() == 3 ? (c.charAt(0) < '0' || c.charAt(0) > '9') && c.charAt(0) != '+' : this.getConstraint() == 5 && (c.charAt(0) < '0' || c.charAt(0) > '9') && c.charAt(0) != '+' && c.charAt(0) != '-' && c.charAt(0) != '.'));
    }

    protected void showSymbolDialog() {
        Command cancel = new Command("Cancel");
        Command r = Dialog.show(null, this.createSymbolTable(), new Command[]{cancel});
        if (r != null && r != cancel) {
            this.insertChars(r.getCommandName());
        }
    }

    protected Container createSymbolTable() {
        char[] symbolArray = TextField.getSymbolTable();
        Container symbols = new Container(new GridLayout(symbolArray.length / 5, 5));
        for (int iter = 0; iter < symbolArray.length; ++iter) {
            Button button = new Button(new Command("" + symbolArray[iter]));
            button.setAlignment(4);
            symbols.addComponent(button);
        }
        return symbols;
    }

    public void keyReleased(int keyCode) {
        if (!this.isEditable()) {
            return;
        }
        this.pressedAndNotReleased = false;
        this.releaseTime = System.currentTimeMillis();
        if (!this.longClick && this.keyReleaseOrLongClick(keyCode, false)) {
            return;
        }
        this.longClick = false;
        super.keyReleased(keyCode);
    }

    protected int getLongClickDuration() {
        return 800;
    }

    public static char[] getSymbolTable() {
        return symbolTable;
    }

    public static void setSymbolTable(char[] table) {
        symbolTable = table;
    }

    protected boolean isCursorPositionCycle() {
        return true;
    }

    protected boolean isSymbolDialogKey(int keyCode) {
        return keyCode == defaultSymbolDialogKey;
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterAnimated(this);
        if (this.handlesInput()) {
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                if (f != null) {
                    f.setClearCommand(this.originalClearCommand);
                }
                this.originalClearCommand = null;
            }
            this.pressedAndNotReleased = false;
            this.setHandlesInput(false);
        }
    }

    public void setEditable(boolean b) {
        super.setEditable(b);
        if (!b && this.handlesInput()) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                f.setClearCommand(this.originalClearCommand);
                this.originalClearCommand = null;
            }
            this.pressedAndNotReleased = false;
        }
    }

    public void keyRepeated(int keyCode) {
        if (this.isQwertyInput()) {
            super.keyRepeated(keyCode);
        }
    }

    public void keyPressed(int keyCode) {
        if (!this.isEditable()) {
            return;
        }
        this.pressedAndNotReleased = true;
        this.pressedKeyCode = keyCode;
        this.pressTime = System.currentTimeMillis();
        if (qwertyAutoDetect && !this.qwerty && (keyCode >= 97 && keyCode <= 122 || keyCode >= 65 && keyCode <= 90)) {
            qwertyDevice = true;
            this.qwerty = true;
        }
        if (!this.handlesInput() && this.isEditingTrigger(keyCode)) {
            this.setHandlesInput(true);
            if (this.useSoftkeys) {
                this.T9_COMMAND.setDisposesDialog(false);
                this.DELETE_COMMAND.setDisposesDialog(false);
                this.originalClearCommand = this.installCommands(this.DELETE_COMMAND, this.T9_COMMAND);
            } else {
                Form f = this.getComponentForm();
                if (f != null) {
                    this.originalClearCommand = f.getClearCommand();
                    f.setClearCommand(this.DELETE_COMMAND);
                }
            }
            return;
        }
        if (this.handlesInput() && this.isEditingEndTrigger(keyCode)) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                if (f != null) {
                    f.setClearCommand(this.originalClearCommand);
                    this.originalClearCommand = null;
                }
            }
            this.fireActionEvent();
            return;
        }
        if (this.handlesInput()) {
            return;
        }
        super.keyPressed(keyCode);
    }

    protected Command installCommands(Command clear, Command t9) {
        Form f = this.getComponentForm();
        if (f != null) {
            Command original = f.getClearCommand();
            if (original instanceof CommandHandler) {
                original = this.originalClearCommand;
            }
            if (this.replaceMenu && this.originalCommands == null) {
                this.originalCommands = new Command[f.getCommandCount()];
                for (int iter = 0; iter < this.originalCommands.length; ++iter) {
                    this.originalCommands[iter] = f.getCommand(iter);
                }
                f.removeAllCommands();
                if (Display.getInstance().isThirdSoftButton()) {
                    this.getComponentForm().addSelectCommand(this.getSelectCommandText());
                    this.selectCommand = this.getComponentForm().getCommand(0);
                }
            }
            f.addCommand(clear, 0);
            f.addCommand(t9, 0);
            f.setClearCommand(clear);
            return original;
        }
        return null;
    }

    protected boolean isSelectableInteraction() {
        return true;
    }

    protected void fireClicked() {
        if (!this.handlesInput()) {
            this.setHandlesInput(true);
            if (this.useSoftkeys) {
                this.T9_COMMAND.setDisposesDialog(false);
                this.DELETE_COMMAND.setDisposesDialog(false);
                this.originalClearCommand = this.installCommands(this.DELETE_COMMAND, this.T9_COMMAND);
            } else {
                Form f = this.getComponentForm();
                this.originalClearCommand = f.getClearCommand();
                f.setClearCommand(this.DELETE_COMMAND);
            }
            return;
        }
        if (this.handlesInput()) {
            this.setHandlesInput(false);
            if (this.useSoftkeys) {
                this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
            } else {
                Form f = this.getComponentForm();
                f.setClearCommand(this.originalClearCommand);
                this.originalClearCommand = null;
            }
            this.fireActionEvent();
            return;
        }
        if (this.handlesInput()) {
            return;
        }
    }

    protected void removeCommands(Command clear, Command t9, Command originalClear) {
        Form f = this.getComponentForm();
        if (f != null) {
            f.removeCommand(clear);
            f.removeCommand(t9);
            if (this.selectCommand != null) {
                f.removeCommand(this.selectCommand);
            }
            f.setClearCommand(this.originalClearCommand);
            if (this.replaceMenu && this.originalCommands != null) {
                for (int iter = this.originalCommands.length - 1; iter >= 0; --iter) {
                    f.addCommand(this.originalCommands[iter]);
                }
                this.originalCommands = null;
            }
        }
    }

    void focusLostInternal() {
        if (this.handlesInput() || this.pressedAndNotReleased || this.pendingCommit) {
            this.setHandlesInput(false);
            Form f = this.getComponentForm();
            if (f != null) {
                if (this.useSoftkeys) {
                    this.removeCommands(this.DELETE_COMMAND, this.T9_COMMAND, this.originalClearCommand);
                } else {
                    f.setClearCommand(this.originalClearCommand);
                }
            }
            this.releaseTime = System.currentTimeMillis();
            this.commitChange();
            this.pressedAndNotReleased = false;
            this.longClick = false;
        }
        if (Display.getInstance().isVirtualKeyboardShowingSupported()) {
            Display.getInstance().setShowVirtualKeyboard(false);
        }
    }

    void focusGainedInternal() {
        this.releaseTime = System.currentTimeMillis();
        this.pressedAndNotReleased = false;
        this.longClick = false;
    }

    protected boolean isEditingTrigger(int keyCode) {
        if (!this.isEditable()) {
            return false;
        }
        int gk = Display.getInstance().getGameAction(keyCode);
        if (this.isQwertyInput()) {
            return keyCode > 0 || gk == 8 || this.isClearKey(keyCode) || this.isEnterKey(keyCode) || this.leftAndRightEditingTrigger && (gk == 2 || gk == 5);
        }
        return keyCode >= 48 && keyCode <= 57 || this.isClearKey(keyCode) || gk == 8 || this.leftAndRightEditingTrigger && (gk == 2 || gk == 5);
    }

    protected boolean isEditingEndTrigger(int keyCode) {
        int k = Display.getInstance().getGameAction(keyCode);
        if (this.isQwertyInput()) {
            return keyCode < 0 && (k == 8 || k == 1 || k == 6 || this.isEnterKey(keyCode));
        }
        return k == 8 || k == 1 || k == 6;
    }

    public void paint(Graphics g) {
        UIManager.getInstance().getLookAndFeel().drawTextField(g, this);
        if (this.drawCursor && this.hasFocus() && this.isEditable()) {
            UIManager.getInstance().getLookAndFeel().drawTextFieldCursor(g, this);
        }
    }

    protected Dimension calcPreferredSize() {
        return UIManager.getInstance().getLookAndFeel().getTextFieldPreferredSize(this);
    }

    protected void initComponent() {
        boolean rtl = this.isRTL();
        this.keyFwd = rtl ? 2 : 5;
        this.keyBack = rtl ? 5 : 2;
        this.getComponentForm().registerAnimated(this);
    }

    public void setCursorBlinkTimeOn(int time) {
        this.blinkOnTime = time;
    }

    public void setCursorBlinkTimeOff(int time) {
        this.blinkOffTime = time;
    }

    public int getCursorBlinkTimeOn() {
        return this.blinkOnTime;
    }

    public int getCursorBlinkTimeOff() {
        return this.blinkOffTime;
    }

    public boolean animate() {
        boolean ani = super.animate();
        if (this.hasFocus()) {
            long currentTime = System.currentTimeMillis();
            if (this.drawCursor) {
                if (currentTime - this.cursorBlinkTime > (long)this.blinkOnTime) {
                    this.cursorBlinkTime = currentTime;
                    this.drawCursor = false;
                    return true;
                }
            } else if (currentTime - this.cursorBlinkTime > (long)this.blinkOffTime) {
                this.cursorBlinkTime = currentTime;
                this.drawCursor = true;
                return true;
            }
            if (this.pressedAndNotReleased) {
                if (currentTime - this.pressTime >= (long)this.getLongClickDuration()) {
                    this.longClick(this.pressedKeyCode);
                }
            } else if (this.pendingCommit && currentTime - this.releaseTime > (long)this.commitTimeout) {
                this.commitChange();
            }
        } else {
            this.drawCursor = false;
        }
        return ani;
    }

    public void pointerReleased(int x, int y) {
        int width;
        String text = this.getText();
        int textLength = text.length();
        int position = 0;
        Font f = this.getStyle().getFont();
        x -= this.getAbsoluteX();
        int iter = 0;
        while (iter < textLength && x > (width = f.substringWidth(text, 0, iter))) {
            position = iter++;
        }
        if (position == textLength - 1 && f.stringWidth(text) < x) {
            position = textLength;
        }
        this.setCursorPosition(position);
        if (!this.isEditable()) {
            return;
        }
        if (Display.getInstance().isVirtualKeyboardShowingSupported()) {
            Display.getInstance().setShowVirtualKeyboard(!Display.getInstance().isVirtualKeyboardShowing());
        } else if (!this.handlesInput()) {
            this.fireClicked();
        } else {
            this.repaint();
        }
    }

    public boolean isUseSoftkeys() {
        return this.useSoftkeys;
    }

    public void setUseSoftkeys(boolean useSoftkeys) {
        this.useSoftkeys = useSoftkeys;
    }

    public void addDataChangeListener(DataChangedListener d) {
        this.listeners.addListener(d);
    }

    public void removeDataChangeListener(DataChangedListener d) {
        this.listeners.removeListener(d);
    }

    private void fireDataChanged(int type, int index) {
        if (this.listeners != null) {
            this.listeners.fireDataChangeEvent(index, type);
        }
    }

    void onEditComplete(String text) {
        super.onEditComplete(text);
        this.setCursorPosition(text.length());
    }

    public boolean isReplaceMenu() {
        return this.replaceMenu;
    }

    public void setReplaceMenu(boolean replaceMenu) {
        this.replaceMenu = replaceMenu;
    }

    public static boolean isReplaceMenuDefault() {
        return replaceMenuDefault;
    }

    public static void setReplaceMenuDefault(boolean replaceMenu) {
        replaceMenuDefault = replaceMenu;
    }

    public static void setQwertyAutoDetect(boolean v) {
        qwertyAutoDetect = v;
    }

    public static void setQwertyDevice(boolean v) {
        qwertyDevice = v;
    }

    public static boolean isQwertyAutoDetect() {
        return qwertyAutoDetect;
    }

    public static boolean isQwertyDevice() {
        return qwertyDevice;
    }

    public static void setDefaultChangeInputModeKey(int k) {
        defaultChangeInputModeKey = k;
    }

    public static int getDefaultChangeInputModeKey() {
        return defaultChangeInputModeKey;
    }

    public static void setDefaultSymbolDialogKey(int d) {
        defaultSymbolDialogKey = d;
    }

    public static int getDefaultSymbolDialogKey() {
        return defaultSymbolDialogKey;
    }

    public void setOverwriteMode(boolean overwriteMode) {
        this.overwriteMode = overwriteMode;
    }

    public boolean isOverwriteMode() {
        return this.overwriteMode;
    }

    public void setLeftAndRightEditingTrigger(boolean leftAndRightEditingTrigger) {
        this.leftAndRightEditingTrigger = leftAndRightEditingTrigger;
    }

    public boolean isLeftAndRightEditingTrigger() {
        return this.leftAndRightEditingTrigger;
    }

    public boolean isSingleLineTextArea() {
        return true;
    }

    public void setAlignment(int align) {
        if (align == 4) {
            throw new IllegalArgumentException("CENTER alignment is not supported in TextField.");
        }
        super.setAlignment(align);
    }

    static {
        defaultInputModeOrder = new String[]{"Abc", "ABC", "abc", "123"};
        firstUppercaseInputMode = new Vector();
        qwertyAutoDetect = true;
        defaultChangeInputModeKey = 35;
        defaultSymbolDialogKey = 42;
        DEFAULT_SYMBOL_TABLE = new char[]{'.', ',', '?', '!', '$', '@', '\'', '-', '_', ')', '(', ':', ';', '&', '/', '~', '\\', '%', '*', '#', '+', '>', '=', '<', '\"'};
        symbolTable = DEFAULT_SYMBOL_TABLE;
        DEFAULT_KEY_CODES = new String[]{" 0", ".,?!'\"1-()@/:_", "ABC2", "DEF3", "GHI4", "JKL5", "MNO6", "PQRS7", "TUV8", "WXYZ9"};
    }

    class CommandHandler
    extends Command {
        CommandHandler(String title, int id) {
            super(title, id);
        }

        public void actionPerformed(ActionEvent ev) {
            ev.consume();
            switch (this.getId()) {
                case 1: {
                    TextField.this.releaseTime = System.currentTimeMillis();
                    TextField.this.pressedAndNotReleased = false;
                    TextField.this.longClick = false;
                    TextField.this.deleteChar();
                    break;
                }
                case 2: {
                    ev.consume();
                    TextField.this.editString();
                }
            }
        }
    }
}

