/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.html.Element;
import com.sun.lwuit.html.HTMLCallback;
import java.io.IOException;
import java.io.InputStreamReader;
import java.util.Hashtable;

class Parser {
    static Parser instance;
    static String[] EMPTY_TAGS;
    private static final String[] CHAR_ENTITY_STRINGS;
    private static Hashtable USER_DEFINED_CHAR_ENTITIES;

    Parser() {
    }

    static Parser getInstance() {
        if (instance == null) {
            instance = new Parser();
        }
        return instance;
    }

    static void addCharEntity(String symbol, int code) {
        if (USER_DEFINED_CHAR_ENTITIES == null) {
            USER_DEFINED_CHAR_ENTITIES = new Hashtable();
        }
        USER_DEFINED_CHAR_ENTITIES.put(Parser.trimCharEntity(symbol), new Integer(code));
    }

    static void addCharEntitiesRange(String[] symbols, int startcode) {
        if (USER_DEFINED_CHAR_ENTITIES == null) {
            USER_DEFINED_CHAR_ENTITIES = new Hashtable();
        }
        for (int i = 0; i < symbols.length; ++i) {
            if (symbols[i] == null) continue;
            USER_DEFINED_CHAR_ENTITIES.put(Parser.trimCharEntity(symbols[i]), new Integer(startcode + i));
        }
    }

    private static String trimCharEntity(String symbol) {
        if (symbol.startsWith("&")) {
            symbol = symbol.substring(1);
        }
        if (symbol.endsWith(";")) {
            symbol = symbol.substring(0, symbol.length() - 1);
        }
        return symbol;
    }

    private static int getCharEntityCode(String symbol) {
        Object charObj;
        if (symbol.equals("nbsp")) {
            return 160;
        }
        if (symbol.equals("lt")) {
            return 60;
        }
        if (symbol.equals("gt")) {
            return 62;
        }
        if (symbol.equals("amp")) {
            return 38;
        }
        if (symbol.equals("quot")) {
            return 34;
        }
        if (symbol.equals("apos")) {
            return 39;
        }
        if (symbol.equals("bull")) {
            return 8226;
        }
        if (symbol.equals("euro")) {
            return 8364;
        }
        for (int i = 0; i < CHAR_ENTITY_STRINGS.length; ++i) {
            if (!symbol.equals(CHAR_ENTITY_STRINGS[i])) continue;
            return i + 161;
        }
        if (USER_DEFINED_CHAR_ENTITIES != null && (charObj = USER_DEFINED_CHAR_ENTITIES.get(symbol)) != null) {
            return (Integer)charObj;
        }
        return -1;
    }

    private String convertCharEntity(String charEntity, HTMLCallback callback) {
        int charCode = -1;
        if (charEntity.startsWith("#")) {
            if (charEntity.startsWith("#x")) {
                try {
                    charCode = Integer.parseInt(charEntity.substring(2), 16);
                }
                catch (NumberFormatException nfe) {}
            } else {
                try {
                    charCode = Integer.parseInt(charEntity.substring(1));
                }
                catch (NumberFormatException nfe) {}
            }
        } else {
            charCode = Parser.getCharEntityCode(charEntity);
        }
        if (charCode != -1) {
            return "" + (char)charCode;
        }
        Parser.notifyError(callback, 4, null, null, null, "Unrecognized char entity: " + charEntity);
        return "&" + charEntity + ";";
    }

    Element parse(InputStreamReader is, HTMLCallback callback) {
        Element rootElement = new Element("ROOT");
        try {
            this.parseTagContent(rootElement, is, callback);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
        return rootElement;
    }

    private void parseTagContent(Element element, InputStreamReader is, HTMLCallback callback) throws IOException {
        String text = null;
        boolean leadingSpace = false;
        char c = (char)is.read();
        String charEntity = null;
        while ((byte)c != -1) {
            if (c == '<') {
                Element childElement;
                if (text != null) {
                    if (charEntity != null) {
                        text = text + "&" + charEntity;
                        charEntity = null;
                    }
                    if (leadingSpace) {
                        text = " " + text;
                    }
                    Element textElement = new Element("text");
                    textElement.addAttribute("title", text);
                    element.addChild(textElement);
                    text = null;
                    leadingSpace = false;
                }
                if ((childElement = this.parseTag(is, callback)) == null) {
                    String closingTag = "";
                    c = (char)is.read();
                    while (c != '>') {
                        closingTag = closingTag + c;
                        c = (char)is.read();
                    }
                    if (closingTag.equalsIgnoreCase(element.getName())) {
                        return;
                    }
                    if (!this.isEmptyTag(closingTag)) {
                        Parser.notifyError(callback, 3, element.getName(), null, null, "Malformed HTML - no appropriate closing tag for " + element.getName());
                        return;
                    }
                } else if (childElement.getId() != -1) {
                    element.addChild(childElement);
                }
            } else if (text != null) {
                if (charEntity != null) {
                    if (c == ';') {
                        text = text + this.convertCharEntity(charEntity, callback);
                        charEntity = null;
                    } else {
                        charEntity = charEntity + c;
                    }
                } else if (c == '&') {
                    charEntity = "";
                } else {
                    text = text + c;
                }
            } else if (!Parser.isWhiteSpace(c)) {
                if (c == '&') {
                    charEntity = "";
                    text = "";
                } else {
                    text = "" + c;
                }
            } else if (c == ' ') {
                leadingSpace = true;
            }
            c = (char)is.read();
        }
    }

    static boolean isWhiteSpace(char ch) {
        return ch == ' ' || ch == '\n' || ch == '\t' || ch == '\n' || ch == '\r';
    }

    private Element parseTag(InputStreamReader is, HTMLCallback callback) throws IOException {
        String tagName = "";
        String curAttribute = "";
        String curValue = "";
        char c = (char)is.read();
        if (c == '/') {
            return null;
        }
        if (c == '!') {
            c = (char)is.read();
            char c2 = (char)is.read();
            if (c == '-' && c2 == '-') {
                return this.parseCommentOrXMLDeclaration(is, "-->");
            }
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        if (c == '?') {
            return this.parseCommentOrXMLDeclaration(is, ">");
        }
        while (Parser.isWhiteSpace(c)) {
            c = (char)is.read();
        }
        while (!Parser.isWhiteSpace(c) && c != '>' && c != '/') {
            tagName = tagName + c;
            c = (char)is.read();
        }
        while (Parser.isWhiteSpace(c)) {
            c = (char)is.read();
        }
        Element element = new Element(tagName = tagName.toLowerCase());
        if (element.getId() == -1) {
            Parser.notifyError(callback, 0, tagName, null, null, "The tag '" + tagName + "' is not supported in XHTML-MP 1.0");
            String endTag = "</" + tagName + ">";
            int index = 0;
            while (index < endTag.length()) {
                c = (char)is.read();
                if (c >= 'A' && c <= 'Z') {
                    c = (char)(c - 65 + 97);
                }
                if (c == endTag.charAt(index)) {
                    ++index;
                    continue;
                }
                index = 0;
            }
            return element;
        }
        if (c == '>') {
            if (!this.isEmptyTag(tagName)) {
                this.parseTagContent(element, is, callback);
            }
            return element;
        }
        if (c == '/') {
            c = (char)is.read();
            if (c == '>') {
                return element;
            }
            Parser.notifyError(callback, 6, tagName, null, null, "HTML malformed - no > after /");
        }
        while (true) {
            int error;
            curAttribute = "" + c;
            c = (char)is.read();
            while (!Parser.isWhiteSpace(c) && c != '=' && c != '>') {
                curAttribute = curAttribute + c;
                c = (char)is.read();
            }
            if (c == '>') {
                Parser.notifyError(callback, 5, tagName, curAttribute, null, "Unexpected tag closing in tag " + tagName + ", attribute=" + curAttribute);
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is, callback);
                }
                return element;
            }
            while (Parser.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            if (c != '=') {
                Parser.notifyError(callback, 6, tagName, curAttribute, null, "Unexpected character " + c + ", expected '=' after attribute " + curAttribute + " in tag " + tagName);
                if (c != '>') continue;
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is, callback);
                }
                return element;
            }
            c = (char)is.read();
            while (Parser.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            char quote = ' ';
            if (c == '\"' || c == '\'') {
                quote = c;
            } else {
                curValue = curValue + c;
            }
            String charEntity = null;
            boolean ended = false;
            while (!ended) {
                c = (char)is.read();
                if (c == quote) {
                    ended = true;
                    c = (char)is.read();
                    continue;
                }
                if (quote == ' ' && (c == '/' || c == '>' || Parser.isWhiteSpace(c))) {
                    ended = true;
                    continue;
                }
                if (c == '&') {
                    if (charEntity != null) {
                        curValue = curValue + "&" + charEntity;
                    }
                    charEntity = "";
                    continue;
                }
                if (charEntity != null) {
                    if (c == ';') {
                        curValue = curValue + this.convertCharEntity(charEntity, callback);
                        charEntity = null;
                        continue;
                    }
                    charEntity = charEntity + c;
                    continue;
                }
                curValue = curValue + c;
            }
            if (charEntity != null) {
                curValue = curValue + "&" + charEntity;
                charEntity = null;
            }
            if ((error = element.addAttribute(curAttribute = curAttribute.toLowerCase(), curValue)) == 1) {
                Parser.notifyError(callback, error, tagName, curAttribute, curValue, "Attribute '" + curAttribute + "' is not supported for tag '" + tagName + "'. Supported attributes: " + element.getSupportedAttributesList());
            } else if (error == 2) {
                Parser.notifyError(callback, error, tagName, curAttribute, curValue, "Attribute '" + curAttribute + "' in tag '" + tagName + "' has an invalid value (" + curValue + ")");
            }
            while (Parser.isWhiteSpace(c)) {
                c = (char)is.read();
            }
            if (c == '>') {
                if (!this.isEmptyTag(tagName)) {
                    this.parseTagContent(element, is, callback);
                }
                return element;
            }
            if (c == '/') {
                c = (char)is.read();
                if (c == '>') {
                    return element;
                }
                Parser.notifyError(callback, 6, tagName, curAttribute, curValue, "HTML malformed - no > after /");
            }
            curAttribute = "";
            curValue = "";
        }
    }

    private Element parseCommentOrXMLDeclaration(InputStreamReader is, String endTag) throws IOException {
        int endTagPos = 0;
        String text = "";
        boolean ended = false;
        while (!ended) {
            char c = (char)is.read();
            if (c == endTag.charAt(endTagPos)) {
                if (++endTagPos != endTag.length()) continue;
                ended = true;
                continue;
            }
            if (endTagPos != 0) {
                text = text + endTag.substring(0, endTagPos);
                endTagPos = 0;
            }
            text = text + c;
        }
        String elementName = null;
        if (endTag.equals("-->")) {
            elementName = "comment";
        } else if (endTag.equals(">")) {
            elementName = "XML declaration";
        }
        Element comment = new Element(elementName);
        comment.addAttribute("content", text);
        return comment;
    }

    private boolean isEmptyTag(String tagName) {
        boolean found = false;
        for (int i = 0; i < EMPTY_TAGS.length && !found; ++i) {
            if (!tagName.equals(EMPTY_TAGS[i])) continue;
            found = true;
        }
        return found;
    }

    private static void notifyError(HTMLCallback callback, int errorId, String tag, String attribute, String value, String description) {
        boolean cont;
        if (callback != null && !(cont = callback.parsingError(errorId, tag, attribute, value, description))) {
            throw new IllegalArgumentException(description);
        }
    }

    static {
        EMPTY_TAGS = new String[]{"br", "link", "meta", "base", "area", "basefont", "col", "frame", "hr", "img", "input", "isindex", "param"};
        CHAR_ENTITY_STRINGS = new String[]{"iexcl", "cent", "pound", "curren", "yen", "brvbar", "sect", "uml", "copy", "ordf", "laquo", "not", "shy", "reg", "macr", "deg", "plusmn", "sup2", "sup3", "acute", "micro", "para", "middot", "cedil", "sup1", "ordm", "raquo", "frac14", "frac12", "frac34", "iquest", "Agrave", "Aacute", "Acirc", "Atilde", "Auml", "Aring", "AElig", "Ccedil", "Egrave", "Eacute", "Ecirc", "Euml", "Igrave", "Iacute", "Icirc", "Iuml", "ETH", "Ntilde", "Ograve", "Oacute", "Ocirc", "Otilde", "Ouml", "times", "Oslash", "Ugrave", "Uacute", "Ucirc", "Uuml", "Yacute", "THORN", "szlig", "agrave", "aacute", "acirc", "atilde", "auml", "aring", "aelig", "ccedil", "egrave", "eacute", "ecirc", "euml", "igrave", "iacute", "icirc", "iuml", "eth", "ntilde", "ograve", "oacute", "ocirc", "otilde", "ouml", "divide", "oslash", "ugrave", "uacute", "ucirc", "uuml", "yacute", "thorn", "yuml"};
    }
}

