/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.plaf;

import com.sun.lwuit.Display;
import com.sun.lwuit.Font;
import com.sun.lwuit.Image;
import com.sun.lwuit.events.ActionEvent;
import com.sun.lwuit.events.ActionListener;
import com.sun.lwuit.plaf.Border;
import com.sun.lwuit.plaf.DefaultLookAndFeel;
import com.sun.lwuit.plaf.LookAndFeel;
import com.sun.lwuit.plaf.Style;
import com.sun.lwuit.util.EventDispatcher;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Hashtable;

public class UIManager {
    private LookAndFeel current = new DefaultLookAndFeel();
    private Hashtable styles = new Hashtable();
    private Hashtable selectedStyles = new Hashtable();
    private Hashtable themeProps;
    private static UIManager instance = new UIManager();
    private Style defaultStyle = new Style();
    private Style defaultSelectedStyle = new Style();
    static boolean accessible = true;
    private Hashtable imageCache = new Hashtable();
    private Hashtable resourceBundle;
    private EventDispatcher themelisteners;

    private UIManager() {
        this.resetThemeProps();
    }

    public static UIManager getInstance() {
        return instance;
    }

    public LookAndFeel getLookAndFeel() {
        return this.current;
    }

    public void setLookAndFeel(LookAndFeel plaf) {
        this.current.uninstall();
        this.current = plaf;
    }

    public void setComponentStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.styles.put(id, style);
    }

    public void setComponentSelectedStyle(String id, Style style) {
        id = id == null || id.length() == 0 ? "" : id + ".";
        this.selectedStyles.put(id, style);
    }

    public Style getComponentStyle(String id) {
        return this.getComponentStyleImpl(id, false, "");
    }

    public Style getComponentSelectedStyle(String id) {
        return this.getComponentStyleImpl(id, true, "sel#");
    }

    public Style getComponentCustomStyle(String id, String type) {
        return this.getComponentStyleImpl(id, false, type + "#");
    }

    private Style getComponentStyleImpl(String id, boolean selected, String prefix) {
        Style style = null;
        id = id == null || id.length() == 0 ? "" : id + ".";
        if (selected) {
            style = (Style)this.selectedStyles.get(id);
            if (style == null) {
                style = this.createStyle(id, prefix, true);
                this.selectedStyles.put(id, style);
            }
        } else if (prefix.length() == 0) {
            style = (Style)this.styles.get(id);
            if (style == null) {
                style = this.createStyle(id, prefix, false);
                this.styles.put(id, style);
            }
        } else {
            return this.createStyle(id, prefix, false);
        }
        return new Style(style);
    }

    public String getThemeName() {
        if (this.themeProps != null) {
            return (String)this.themeProps.get("name");
        }
        return null;
    }

    private void resetThemeProps() {
        this.themeProps = new Hashtable();
        this.themeProps.put("Button.border", Border.getDefaultBorder());
        this.themeProps.put("TouchCommand.border", Border.getDefaultBorder());
        this.themeProps.put("Button.press#border", Border.getDefaultBorder().createPressedVersion());
        this.themeProps.put("Button.press#padding", "4,4,4,4");
        this.themeProps.put("TouchCommand.press#border", Border.getDefaultBorder().createPressedVersion());
        this.themeProps.put("TouchCommand.press#padding", "10,10,10,10");
        this.themeProps.put("Spinner.border", Border.getDefaultBorder());
        this.themeProps.put("TextArea.border", Border.getDefaultBorder());
        this.themeProps.put("TextField.border", Border.getDefaultBorder());
        this.themeProps.put("ComboBox.border", Border.getDefaultBorder());
        this.themeProps.put("ComboBoxPopup.border", Border.getDefaultBorder());
        this.themeProps.put("Title.margin", "0,0,0,0");
        this.themeProps.put("CommandList.margin", "0,0,0,0");
        this.themeProps.put("CommandList.padding", "0,0,0,0");
        this.themeProps.put("CommandList.transparency", "0");
        this.themeProps.put("ComboBoxList.margin", "0,0,0,0");
        this.themeProps.put("ComboBoxList.padding", "0,0,0,0");
        this.themeProps.put("ComboBoxList.transparency", "0");
        this.themeProps.put("TableCell.transparency", "0");
        this.themeProps.put("TableHeader.transparency", "0");
        this.themeProps.put("Table.border", Border.getDefaultBorder());
        this.themeProps.put("Menu.padding", "0,0,0,0");
        this.themeProps.put("Command.margin", "0,0,0,0");
        this.themeProps.put("ComboBoxItem.margin", "0,0,0,0");
        this.themeProps.put("Container.transparency", "0");
        this.themeProps.put("ContentPane.transparency", "0");
        this.themeProps.put("List.transparency", "0");
        this.themeProps.put("List.margin", "0,0,0,0");
        this.themeProps.put("SoftButton.transparency", "255");
        this.themeProps.put("SoftButton.margin", "0,0,0,0");
        this.themeProps.put("SoftButton.padding", "2,2,2,2");
        this.themeProps.put("Button.padding", "4,4,4,4");
        this.themeProps.put("TouchCommand.padding", "10,10,10,10");
        this.themeProps.put("TouchCommand.margin", "0,0,0,0");
        this.themeProps.put("Container.margin", "0,0,0,0");
        this.themeProps.put("Container.padding", "0,0,0,0");
        this.themeProps.put("ContentPane.margin", "0,0,0,0");
        this.themeProps.put("ContentPane.padding", "0,0,0,0");
        this.themeProps.put("Title.transparency", "255");
        this.themeProps.put("TabbedPane.margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.padding", "0,0,0,0");
        this.themeProps.put("TabbedPane.transparency", "0");
        this.themeProps.put("ScrollThumb.padding", "0,0,0,0");
        this.themeProps.put("ScrollThumb.margin", "0,0,0,0");
        this.themeProps.put("ScrollThumb.bgColor", "0");
        this.themeProps.put("Scroll.margin", "0,0,0,0");
        this.themeProps.put("Scroll.padding", "1,1,1,1");
        this.themeProps.put("HorizontalScrollThumb.padding", "0,0,0,0");
        this.themeProps.put("HorizontalScrollThumb.bgColor", "0");
        this.themeProps.put("HorizontalScrollThumb.margin", "0,0,0,0");
        this.themeProps.put("HorizontalScroll.margin", "0,0,0,0");
        this.themeProps.put("HorizontalScroll.padding", "1,1,1,1");
        this.themeProps.put("Form.padding", "0,0,0,0");
        this.themeProps.put("Form.margin", "0,0,0,0");
        this.themeProps.put("ListRenderer.transparency", "0");
        this.themeProps.put("Command.transparency", "0");
        this.themeProps.put("ComboBoxItem.transparency", "0");
        this.themeProps.put("CalendarSelectedDay.border", Border.getDefaultBorder());
        this.themeProps.put("Command.sel#transparency", "0");
        this.themeProps.put("ComboBoxItem.sel#transparency", "0");
        this.themeProps.put("ListRenderer.sel#transparency", "100");
        this.themeProps.put("Button.sel#border", Border.getDefaultBorder());
        this.themeProps.put("TouchCommand.sel#border", Border.getDefaultBorder());
        this.themeProps.put("TextArea.sel#border", Border.getDefaultBorder());
        this.themeProps.put("TextField.sel#border", Border.getDefaultBorder());
        this.themeProps.put("Spinner.sel#border", Border.getDefaultBorder());
        this.themeProps.put("ComboBox.sel#border", Border.getDefaultBorder());
        this.themeProps.put("ComboBoxPopup.sel#border", Border.getDefaultBorder());
        this.themeProps.put("Table.sel#border", Border.getDefaultBorder());
        this.themeProps.put("Title.sel#margin", "0,0,0,0");
        this.themeProps.put("CommandList.sel#margin", "0,0,0,0");
        this.themeProps.put("CommandList.sel#padding", "0,0,0,0");
        this.themeProps.put("CommandList.sel#transparency", "0");
        this.themeProps.put("Menu.sel#padding", "0,0,0,0");
        this.themeProps.put("Command.sel#margin", "0,0,0,0");
        this.themeProps.put("ComboBoxItem.sel#margin", "0,0,0,0");
        this.themeProps.put("Container.sel#transparency", "0");
        this.themeProps.put("ContentPane.sel#transparency", "0");
        this.themeProps.put("List.sel#transparency", "0");
        this.themeProps.put("SoftButton.sel#transparency", "255");
        this.themeProps.put("List.sel#margin", "0,0,0,0");
        this.themeProps.put("SoftButton.sel#margin", "0,0,0,0");
        this.themeProps.put("SoftButton.sel#padding", "2,2,2,2");
        this.themeProps.put("Button.sel#padding", "4,4,4,4");
        this.themeProps.put("TouchCommand.sel#padding", "10,10,10,10");
        this.themeProps.put("TouchCommand.sel#margin", "0,0,0,0");
        this.themeProps.put("Container.sel#margin", "0,0,0,0");
        this.themeProps.put("Container.sel#padding", "0,0,0,0");
        this.themeProps.put("ContentPane.sel#margin", "0,0,0,0");
        this.themeProps.put("ContentPane.sel#padding", "0,0,0,0");
        this.themeProps.put("Title.sel#transparency", "255");
        this.themeProps.put("TabbedPane.sel#margin", "0,0,0,0");
        this.themeProps.put("TabbedPane.sel#padding", "0,0,0,0");
        this.themeProps.put("Form.sel#padding", "0,0,0,0");
        this.themeProps.put("Form.sel#margin", "0,0,0,0");
        this.themeProps.put("sel#transparency", "255");
        this.themeProps.put("TableCell.sel#transparency", "0");
        this.themeProps.put("TableHeader.sel#transparency", "0");
    }

    public void setThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.setThemePropsImpl(themeProps);
        }
    }

    public void addThemeProps(Hashtable themeProps) {
        if (accessible) {
            this.buildTheme(themeProps);
        }
    }

    void setThemePropsImpl(Hashtable themeProps) {
        this.resetThemeProps();
        this.styles.clear();
        this.selectedStyles.clear();
        this.imageCache.clear();
        if (this.themelisteners != null) {
            this.themelisteners.fireActionEvent(new ActionEvent(themeProps));
        }
        this.buildTheme(themeProps);
        this.current.refreshTheme();
    }

    private void buildTheme(Hashtable themeProps) {
        Enumeration e = themeProps.keys();
        while (e.hasMoreElements()) {
            Object key = e.nextElement();
            this.themeProps.put(key, themeProps.get(key));
        }
        this.defaultStyle = new Style();
        this.defaultStyle = this.createStyle("", "", false);
        this.defaultSelectedStyle = new Style(this.defaultStyle);
        this.defaultSelectedStyle = this.createStyle("", "sel#", true);
    }

    private Style createStyle(String id, String prefix, boolean selected) {
        String originalId = id;
        Style style = selected ? new Style(this.defaultSelectedStyle) : new Style(this.defaultStyle);
        if (prefix != null && prefix.length() > 0) {
            id = id + prefix;
        }
        if (this.themeProps != null) {
            String bgColor = (String)this.themeProps.get(id + "bgColor");
            String fgColor = (String)this.themeProps.get(id + "fgColor");
            Object border = this.themeProps.get(id + "border");
            Object bgImage = this.themeProps.get(id + "bgImage");
            String transperency = (String)this.themeProps.get(id + "transparency");
            String margin = (String)this.themeProps.get(id + "margin");
            String padding = (String)this.themeProps.get(id + "padding");
            Object font = this.themeProps.get(id + "font");
            Byte backgroundType = (Byte)this.themeProps.get(id + "bgType");
            Byte backgroundAlignment = (Byte)this.themeProps.get(id + "bgAlign");
            Object[] backgroundGradient = (Object[])this.themeProps.get(id + "bgGradient");
            if (bgColor != null) {
                style.setBgColor(Integer.valueOf(bgColor, 16));
            }
            if (fgColor != null) {
                style.setFgColor(Integer.valueOf(fgColor, 16));
            }
            if (transperency != null) {
                style.setBgTransparency(Integer.valueOf(transperency));
            } else if (selected && (transperency = (String)this.themeProps.get(originalId + "transparency")) != null) {
                style.setBgTransparency(Integer.valueOf(transperency));
            }
            if (margin != null) {
                int[] marginArr = this.toIntArray(margin.trim());
                style.setMargin(marginArr[0], marginArr[1], marginArr[2], marginArr[3]);
            }
            if (padding != null) {
                int[] paddingArr = this.toIntArray(padding.trim());
                style.setPadding(paddingArr[0], paddingArr[1], paddingArr[2], paddingArr[3]);
            }
            if (backgroundType != null) {
                style.setBackgroundType(backgroundType);
            }
            if (backgroundAlignment != null) {
                style.setBackgroundAlignment(backgroundAlignment);
            }
            if (backgroundGradient != null) {
                if (backgroundGradient.length < 5) {
                    Object[] a = new Object[5];
                    System.arraycopy(backgroundGradient, 0, a, 0, backgroundGradient.length);
                    backgroundGradient = a;
                    backgroundGradient[4] = new Float(1.0f);
                }
                style.setBackgroundGradient(backgroundGradient);
            }
            if (bgImage != null) {
                Image im = null;
                if (bgImage instanceof String) {
                    try {
                        String bgImageStr = (String)bgImage;
                        if (this.imageCache.contains(bgImageStr)) {
                            im = (Image)this.imageCache.get(bgImageStr);
                        } else {
                            im = bgImageStr.startsWith("/") ? Image.createImage(bgImageStr) : UIManager.parseImage((String)bgImage);
                            this.imageCache.put(bgImageStr, im);
                        }
                        this.themeProps.put(id + "bgImage", im);
                    }
                    catch (IOException ex) {
                        System.out.println("failed to parse image for id = " + id + "bgImage");
                    }
                } else {
                    im = (Image)bgImage;
                }
                if (id.indexOf("Form") > -1 && (im.getWidth() != Display.getInstance().getDisplayWidth() || im.getHeight() != Display.getInstance().getDisplayHeight()) && style.getBackgroundType() == 1 && accessible) {
                    im.scale(Display.getInstance().getDisplayWidth(), Display.getInstance().getDisplayHeight());
                }
                style.setBgImage(im);
            }
            if (font != null) {
                if (font instanceof String) {
                    style.setFont(UIManager.parseFont((String)font));
                } else {
                    style.setFont((Font)font);
                }
            }
            style.setBorder((Border)border);
            style.resetModifiedFlag();
        }
        return style;
    }

    private int[] toIntArray(String str) {
        int[] retVal = new int[4];
        str = str + ",";
        for (int i = 0; i < retVal.length; ++i) {
            retVal[i] = Integer.parseInt(str.substring(0, str.indexOf(",")));
            str = str.substring(str.indexOf(",") + 1, str.length());
        }
        return retVal;
    }

    private static Image parseImage(String value) throws IOException {
        byte[] imageData = new byte[value.length() / 2];
        for (int index = 0; index < value.length(); index += 2) {
            String byteStr = value.substring(index, index + 2);
            imageData[index / 2] = Integer.valueOf(byteStr, 16).byteValue();
        }
        ByteArrayInputStream in = new ByteArrayInputStream(imageData);
        Image image = Image.createImage(in);
        in.close();
        return image;
    }

    private static Font parseFont(String fontStr) {
        if (fontStr.startsWith("System")) {
            int face = 0;
            int style = 0;
            int size = 0;
            String sysFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
            String faceStr = sysFont.substring(0, sysFont.indexOf(";"));
            sysFont = sysFont.substring(sysFont.indexOf(";") + 1, sysFont.length());
            String styleStr = sysFont.substring(0, sysFont.indexOf(";"));
            String sizeStr = sysFont.substring(sysFont.indexOf(";") + 1, sysFont.length());
            if (faceStr.indexOf("FACE_SYSTEM") > -1) {
                face = 0;
            } else if (faceStr.indexOf("FACE_MONOSPACE") > -1) {
                face = 32;
            } else if (faceStr.indexOf("FACE_PROPORTIONAL") > -1) {
                face = 64;
            }
            if (styleStr.indexOf("STYLE_PLAIN") > -1) {
                style = 0;
            } else {
                if (styleStr.indexOf("STYLE_BOLD") > -1) {
                    style = 1;
                }
                if (styleStr.indexOf("STYLE_ITALIC") > -1) {
                    style |= 2;
                }
                if (styleStr.indexOf("STYLE_UNDERLINED") > -1) {
                    style |= 4;
                }
            }
            if (sizeStr.indexOf("SIZE_SMALL") > -1) {
                size = 8;
            } else if (sizeStr.indexOf("SIZE_MEDIUM") > -1) {
                size = 0;
            } else if (sizeStr.indexOf("SIZE_LARGE") > -1) {
                size = 16;
            }
            return Font.createSystemFont(face, style, size);
        }
        if (fontStr.toLowerCase().startsWith("bitmap")) {
            try {
                String bitmapFont = fontStr.substring(fontStr.indexOf("{") + 1, fontStr.indexOf("}"));
                String nameStr = bitmapFont.substring(0, bitmapFont.length());
                if (nameStr.toLowerCase().startsWith("highcontrast")) {
                    nameStr = nameStr.substring(nameStr.indexOf(";") + 1, nameStr.length());
                    Font f = Font.getBitmapFont(nameStr);
                    f.addContrast((byte)30);
                    return f;
                }
                return Font.getBitmapFont(nameStr);
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        return null;
    }

    public Hashtable getResourceBundle() {
        return this.resourceBundle;
    }

    public void setResourceBundle(Hashtable resourceBundle) {
        this.resourceBundle = resourceBundle;
    }

    public String localize(String key, String defaultValue) {
        Object o;
        if (this.resourceBundle != null && (o = this.resourceBundle.get(key)) != null) {
            return (String)o;
        }
        return defaultValue;
    }

    public void addThemeRefreshListener(ActionListener l) {
        if (this.themelisteners == null) {
            this.themelisteners = new EventDispatcher();
        }
        this.themelisteners.addListener(l);
    }

    public void removeThemeRefreshListener(ActionListener l) {
        if (this.themelisteners == null) {
            return;
        }
        this.themelisteners.removeListener(l);
    }
}

