/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.html;

import com.sun.lwuit.Display;
import com.sun.lwuit.Image;
import com.sun.lwuit.Label;
import com.sun.lwuit.html.DocumentInfo;
import com.sun.lwuit.html.DocumentRequestHandler;
import com.sun.lwuit.html.HTMLComponent;
import com.sun.lwuit.html.ImageThreadQueue;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Vector;

class ImageThread
implements Runnable {
    Label imgLabel;
    Vector labels;
    String imageUrl;
    DocumentRequestHandler handler;
    ImageThreadQueue threadQueue;
    boolean cancelled;
    HTMLComponent htmlC;
    Image img;

    ImageThread(String imageUrl, Label imgLabel, HTMLComponent htmlC, ImageThreadQueue threadQueue) {
        this.imageUrl = imageUrl;
        this.imgLabel = imgLabel;
        this.handler = htmlC.getRequestHandler();
        this.threadQueue = threadQueue;
        this.htmlC = htmlC;
    }

    void cancel() {
        this.cancelled = true;
    }

    void addLabel(Label label) {
        if (this.labels == null) {
            this.labels = new Vector();
        }
        this.labels.addElement(label);
    }

    public void run() {
        block8: {
            try {
                InputStream is = this.handler.resourceRequested(new DocumentInfo(this.imageUrl, DocumentInfo.TYPE_IMAGE));
                if (is == null) {
                    if (this.htmlC.getHTMLCallback() != null) {
                        this.htmlC.getHTMLCallback().parsingError(7, null, null, null, "Image not found at " + this.imageUrl);
                    }
                } else {
                    this.img = Image.createImage(is);
                    if (this.img == null && this.htmlC.getHTMLCallback() != null) {
                        this.htmlC.getHTMLCallback().parsingError(8, null, null, null, "Image could not be created from " + this.imageUrl);
                    }
                }
                if (this.img == null) {
                    this.threadQueue.threadFinished(this, false);
                    return;
                }
                if (!this.cancelled) {
                    Display.getInstance().callSerially(new Runnable(){

                        public void run() {
                            ImageThread.this.handleImage(ImageThread.this.img, ImageThread.this.imgLabel);
                            if (ImageThread.this.labels != null) {
                                Enumeration e = ImageThread.this.labels.elements();
                                while (e.hasMoreElements()) {
                                    Label label = (Label)e.nextElement();
                                    ImageThread.this.handleImage(ImageThread.this.img, label);
                                }
                            }
                        }
                    });
                    this.threadQueue.threadFinished(this, true);
                }
            }
            catch (IOException ioe) {
                this.htmlC.getHTMLCallback().parsingError(8, null, null, null, "Image could not be created from " + this.imageUrl + ": " + ioe.getMessage());
                if (this.cancelled) break block8;
                this.threadQueue.threadFinished(this, false);
            }
        }
    }

    private void handleImage(Image img, Label label) {
        int width = label.getPreferredW();
        int height = label.getPreferredH();
        if (width == 0) {
            width = img.getWidth();
            label.setPreferredW(width);
            label.setWidth(width);
            this.htmlC.revalidate();
        }
        if (height == 0) {
            height = img.getHeight();
            label.setPreferredH(height);
            label.setHeight(height);
            if (label.getParent().getPreferredH() < height) {
                label.getParent().setPreferredH(height);
            }
            this.htmlC.revalidate();
        }
        label.setIcon(img.scaled(width, height));
        label.getUnselectedStyle().setBorder(null);
    }
}

