/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit.spinner;

import com.sun.lwuit.Component;
import com.sun.lwuit.List;
import com.sun.lwuit.list.DefaultListCellRenderer;
import java.util.Calendar;
import java.util.Date;

class DateTimeRenderer
extends DefaultListCellRenderer {
    private boolean date;
    private int type;
    private char separatorChar;
    private boolean twentyFourHours;
    private boolean showSeconds;

    private DateTimeRenderer() {
        super(false);
    }

    boolean isShowSeconds() {
        return this.showSeconds;
    }

    public static DateTimeRenderer createTimeRenderer(boolean twentyFourHours, boolean showSeconds) {
        DateTimeRenderer d = new DateTimeRenderer();
        d.twentyFourHours = twentyFourHours;
        d.showSeconds = showSeconds;
        return d;
    }

    public static DateTimeRenderer createDateRenderer(char separatorChar, int format) {
        DateTimeRenderer d = new DateTimeRenderer();
        d.date = true;
        d.separatorChar = separatorChar;
        d.type = format;
        return d;
    }

    private String twoDigits(int i) {
        if (i < 10) {
            return "0" + i;
        }
        return "" + i;
    }

    public Component getListCellRendererComponent(List list, Object value, int index, boolean isSelected) {
        if (this.date) {
            Calendar c = Calendar.getInstance();
            c.setTime((Date)value);
            int day = c.get(5);
            int month = c.get(2) + 1;
            int year = c.get(1);
            switch (this.type) {
                case 1: {
                    value = this.twoDigits(day) + this.separatorChar + this.twoDigits(month) + this.separatorChar + year;
                    break;
                }
                case 2: {
                    value = this.twoDigits(month) + this.separatorChar + this.twoDigits(day) + this.separatorChar + year;
                    break;
                }
                case 11: {
                    value = this.twoDigits(day) + this.separatorChar + this.twoDigits(month) + this.separatorChar + year % 100;
                    break;
                }
                case 12: {
                    value = this.twoDigits(month) + this.separatorChar + this.twoDigits(day) + this.separatorChar + year % 100;
                }
            }
        } else {
            int v = (Integer)value;
            int seconds = v % 60;
            int minutes = (v /= 60) % 60;
            int hours = this.twentyFourHours ? v % 24 : (v /= 60) % 12;
            value = this.showSeconds ? this.twoDigits(hours) + ":" + this.twoDigits(minutes) + ":" + this.twoDigits(seconds) : this.twoDigits(hours) + ":" + this.twoDigits(minutes);
        }
        return super.getListCellRendererComponent(list, value, index, isSelected);
    }

    public boolean isTwentyFourHours() {
        return this.twentyFourHours;
    }
}

