/*
 * Decompiled with CFR 0.152.
 */
package com.sun.lwuit;

import com.sun.lwuit.Component;
import com.sun.lwuit.Display;
import com.sun.lwuit.Graphics;
import com.sun.lwuit.geom.Dimension;
import com.sun.lwuit.impl.LWUITImplementation;

public class MediaComponent
extends Component {
    private Object player;
    private Object vidc;
    private boolean fullscreen = false;

    public MediaComponent(Object player) {
        this.player = player;
        this.setFocusable(false);
        this.vidc = Display.getInstance().getImplementation().createVideoComponent(player);
    }

    protected void initComponent() {
        this.getComponentForm().registerMediaComponent(this);
    }

    protected void deinitialize() {
        this.getComponentForm().deregisterMediaComponent(this);
    }

    public void paint(Graphics g) {
        if (this.isVisible()) {
            Display.getInstance().getImplementation().paintVideo(this, this.fullscreen, g.getGraphics(), this.vidc, this.player);
        }
    }

    protected void paintBackground(Graphics g) {
    }

    public void paintBackgrounds(Graphics g) {
    }

    protected Dimension calcPreferredSize() {
        LWUITImplementation impl = Display.getInstance().getImplementation();
        return new Dimension(impl.getVideoWidth(this.vidc), impl.getVideoHeight(this.vidc));
    }

    public void setVisible(boolean visible) {
        super.setVisible(visible);
        if (this.vidc != null) {
            Display.getInstance().getImplementation().setVideoVisible(this.vidc, visible);
        }
    }

    public void start() {
        Display.getInstance().getImplementation().startVideo(this.player, this.vidc);
    }

    public void stop() {
        Display.getInstance().getImplementation().stopVideo(this.player, this.vidc);
    }

    public void setLoopCount(int count) {
        Display.getInstance().getImplementation().setVideoLoopCount(this.player, count);
    }

    public long getMediaTime() {
        return Display.getInstance().getImplementation().getMediaTime(this.player);
    }

    public long setMediaTime(long now) {
        return Display.getInstance().getImplementation().setMediaTime(this.player, now);
    }

    public void setFullScreen(boolean fullscreen) {
        this.fullscreen = fullscreen;
        this.repaint();
    }

    public boolean isFullScreen() {
        return this.fullscreen;
    }

    public Object getVideoControl() {
        return this.vidc;
    }
}

