/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.Cube;
import com.ximad.braincube2.components.Hint;

public class Camera {
    private static Camera _instance;
    public int x;
    public int y;
    public int xAdd = 0;
    public int yAdd = 0;
    private int animationCounter;
    public boolean isAnimationInProgress = false;
    private int nextX;
    private int nextY;
    private int lastX;
    private int lastY;
    public boolean isScrollingMode;

    public static Camera getInstance() {
        if (_instance == null) {
            _instance = new Camera();
        }
        return _instance;
    }

    public void centerCube(Cube cube) {
        this.x = 320 - cube.xR + cube.camX + this.xAdd;
        this.y = 180 - cube.yR + cube.camY + this.yAdd;
    }

    public void smoothCenterCube(Cube cube) {
        this.makeSmoothMove(320 - cube.nextXR + cube.camX + this.xAdd, 180 - cube.nextYR + cube.camY + this.yAdd);
    }

    public void smoothCenterHint(Hint hint) {
        this.makeSmoothMove(320 - hint.xR + hint.camX + this.xAdd, 180 - hint.yR + hint.camY + this.yAdd);
    }

    public void saveCurrentCamPos() {
        this.lastX = this.x;
        this.lastY = this.y;
    }

    public void smoothRestoreCamPos() {
        this.makeSmoothMove(this.lastX, this.lastY);
    }

    public void makeSmoothMove(int toX, int toY) {
        this.nextX = (toX - this.x) / 4;
        this.nextY = (toY - this.y) / 4;
        this.isAnimationInProgress = true;
        this.animationCounter = 0;
    }

    public void makeSmoothAnimation() {
        if (this.isAnimationInProgress) {
            ++this.animationCounter;
            if (this.animationCounter > 4) {
                this.animationCounter = 0;
                this.isAnimationInProgress = false;
                this.nextX = 0;
                this.nextY = 0;
            }
        }
        if (this.x > 320) {
            return;
        }
        int xFut = this.x + this.nextX;
        int yFut = this.y + this.nextY;
        if ((xFut > 320 || xFut < Constants.SCROLLING_ADS[0] - (Constants.cBc[0][0] * Board.getInstance().dimX + Constants.cBc[0][1] * Board.getInstance().dimY) || yFut > 180 - Constants.cBc[1][0] * Board.getInstance().dimX - Constants.SCROLLING_ADS[1] || yFut < Constants.SCROLLING_ADS[2] - (Constants.cBc[1][1] * Board.getInstance().dimY - 90)) && this.isScrollingMode) {
            return;
        }
        this.x = xFut;
        this.y = yFut;
    }

    public void makeSmoothScrolling(int dx, int dy) {
        if (dx > 0) {
            this.nextX = -20;
            this.nextY = 0;
        } else if (dx < 0) {
            this.nextX = 20;
            this.nextY = 0;
        } else if (dy > 0) {
            this.nextY = -20;
            this.nextX = 0;
        } else if (dy < 0) {
            this.nextY = 20;
            this.nextX = 0;
        }
        this.isAnimationInProgress = true;
        this.animationCounter = 0;
    }

    public void makeSmoothScrollingTouch(int dx, int dy) {
        int xFut = this.x + dx;
        int yFut = this.y + dy;
        if ((xFut > 320 || xFut < Constants.SCROLLING_ADS[0] - (Constants.cBc[0][0] * Board.getInstance().dimX + Constants.cBc[0][1] * Board.getInstance().dimY) || yFut > 180 - Constants.cBc[1][0] * Board.getInstance().dimX - Constants.SCROLLING_ADS[1] || yFut < Constants.SCROLLING_ADS[2] - (Constants.cBc[1][1] * Board.getInstance().dimY - 90)) && this.isScrollingMode) {
            return;
        }
        this.x = xFut;
        this.y = yFut;
    }

    public void setShifts(int dx, int dy) {
        this.xAdd = dx;
        this.yAdd = dy;
    }

    public void clear() {
        this.xAdd = 0;
        this.yAdd = 0;
        this.x = 0;
        this.y = 0;
        this.nextX = 0;
        this.nextY = 0;
        this.lastX = 0;
        this.lastY = 0;
    }

    public void setScrollingMode(boolean isScrolling) {
        this.isScrollingMode = isScrolling;
    }
}

