/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.component.CustomItemBox;
import com.ximad.braincube2.components.AchievementItem;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.MenuScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class AchievementsScreen
extends UiScreen {
    private static AchievementsScreen instance;
    private CustomItemBox verticalManger;
    private CustomManager layoutManager;
    private Font titleFont;
    private Font descriptionFont;
    private AchievementItem[] buttonsStack;

    private AchievementsScreen() {
        ImagesResources.initAchievementsScreen();
        ImagesResources.initWorldSelector();
        this.titleFont = Utils.getFont(64, 1, Constants.achievementItemProps[4][0]);
        this.descriptionFont = Utils.getFont(0, 0, 8);
        this.buttonsStack = new AchievementItem[Achievements.ACHIEVENTS_NUMBER - 1];
        this.verticalManger = new CustomItemBox(Constants.achievementItemProps[8][0], Constants.achievementItemProps[8][2]);
        for (int i = 0; i < Achievements.ACHIEVENTS_NUMBER - 1; ++i) {
            this.buttonsStack[i] = new AchievementItem(i, DataManager.achievements[i], this.titleFont, this.descriptionFont);
            this.verticalManger.add(this.buttonsStack[i]);
        }
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics g) {
                ImagesResources.achievementBackground.draw(g, 0, 0);
                ImagesResources.achievementTitle.draw(g, Constants.achievementsScreen[0][0], Constants.achievementsScreen[0][1]);
                super.onPaint(g);
            }
        };
        this.layoutManager.add(this.verticalManger, Constants.achievementsScreen[1][0], Constants.achievementsScreen[1][1]);
        CustomButton backButton = new CustomButton(ImagesResources.backButtonInactive, ImagesResources.backButtonActive, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.setScreen(MenuScreen.getInstance(true));
            }
        };
        this.layoutManager.add(backButton, 0, 283);
    }

    protected boolean onMenu() {
        return false;
    }

    protected void applyTheme() {
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public static AchievementsScreen getInstance() {
        if (instance == null) {
            instance = new AchievementsScreen();
        } else {
            instance.reinitialize();
        }
        return instance;
    }

    private void reinitialize() {
        ImagesResources.initAchievementsScreen();
        ImagesResources.initWorldSelector();
        for (int i = 0; i < Achievements.ACHIEVENTS_NUMBER - 1; ++i) {
            this.buttonsStack[i].setState(DataManager.achievements[i]);
        }
    }
}

