/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.Screen;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.AboutScreen;
import com.ximad.braincube2.screens.AchievementsScreen;
import com.ximad.braincube2.screens.HelpScreen;
import com.ximad.braincube2.screens.WorldSelectorScreen;
import javax.microedition.lcdui.Graphics;

public class MenuScreen
extends UiScreen {
    private static MenuScreen instance;
    private CustomButton playButton;
    private CustomButton soundButton;
    private CustomButton musicButton;
    private CustomButton helpButton;
    private CustomButton aboutButton;
    private CustomButton youtubeButton;
    private CustomButton soundtrackButton;
    private CustomButton achievementsButton;
    private CustomButton exitButton;
    public Application.XRunnable closeRunnable;
    private boolean isAnimationInProgress;
    private int animationFrame;
    private int repeatCount;
    CustomManager layoutManager;
    public boolean isPlayAllowed;
    private Application.XRunnable delayRunnable;
    private long initTime = System.currentTimeMillis();

    private MenuScreen(boolean isNeedToPlayMusic) {
        ImagesResources.initMenuScreen();
        this.playButton = new CustomButton(ImagesResources.menuScreenButtons[0][0], ImagesResources.menuScreenButtons[0][1], null, null){

            protected void touchAction() {
                if (MenuScreen.this.isPlayAllowed) {
                    MenuScreen.this.isPlayAllowed = false;
                    Application.invokeLater(MenuScreen.this.closeRunnable);
                    SoundSystem.play(19);
                }
            }
        };
        this.soundButton = new CustomButton(ImagesResources.menuScreenButtons[1][2], ImagesResources.menuScreenButtons[1][3], null, null){

            protected void touchAction() {
                DataManager.saveSoundEffectsState(!DataManager.isSoundEffectsEnabled);
                if (DataManager.isSoundEffectsEnabled) {
                    SoundSystem.playButtonSound();
                    MenuScreen.this.soundButton.setOnImage(ImagesResources.menuScreenButtons[1][3]);
                    MenuScreen.this.soundButton.setOffImage(ImagesResources.menuScreenButtons[1][2]);
                } else {
                    MenuScreen.this.soundButton.setOnImage(ImagesResources.menuScreenButtons[1][1]);
                    MenuScreen.this.soundButton.setOffImage(ImagesResources.menuScreenButtons[1][0]);
                }
            }
        };
        if (!DataManager.isSoundEffectsEnabled) {
            this.soundButton.setOnImage(ImagesResources.menuScreenButtons[1][1]);
            this.soundButton.setOffImage(ImagesResources.menuScreenButtons[1][0]);
        }
        this.musicButton = new CustomButton(ImagesResources.menuScreenButtons[2][2], ImagesResources.menuScreenButtons[2][3], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                DataManager.saveSoundMusicState(!DataManager.isSoundMusicEnabled);
                if (DataManager.isSoundMusicEnabled) {
                    MenuScreen.this.musicButton.setOnImage(ImagesResources.menuScreenButtons[2][3]);
                    MenuScreen.this.musicButton.setOffImage(ImagesResources.menuScreenButtons[2][2]);
                    SoundSystem.playBackgroundMusic();
                } else {
                    MenuScreen.this.musicButton.setOnImage(ImagesResources.menuScreenButtons[2][1]);
                    MenuScreen.this.musicButton.setOffImage(ImagesResources.menuScreenButtons[2][0]);
                    SoundSystem.stopBackgroundMusic();
                }
            }
        };
        if (!DataManager.isSoundMusicEnabled) {
            this.musicButton.setOnImage(ImagesResources.menuScreenButtons[2][1]);
            this.musicButton.setOffImage(ImagesResources.menuScreenButtons[2][0]);
        }
        this.helpButton = new CustomButton(ImagesResources.menuScreenButtons[3][0], ImagesResources.menuScreenButtons[3][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.setScreen(HelpScreen.getInstance(MenuScreen.this, 0, true));
            }
        };
        this.aboutButton = new CustomButton(ImagesResources.menuScreenButtons[4][0], ImagesResources.menuScreenButtons[4][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.setScreen(AboutScreen.getInstance());
            }
        };
        this.youtubeButton = new CustomButton(ImagesResources.menuScreenButtons[5][0], ImagesResources.menuScreenButtons[5][1], null, null){

            protected void touchAction() {
                MenuScreen.this.youtubeClick();
            }
        };
        this.soundtrackButton = new CustomButton(ImagesResources.menuScreenButtons[6][0], ImagesResources.menuScreenButtons[6][1], null, null){

            protected void touchAction() {
                MenuScreen.this.soundTrackClick();
            }
        };
        this.achievementsButton = new CustomButton(ImagesResources.menuScreenButtons[7][0], ImagesResources.menuScreenButtons[7][1], null, null){

            protected void touchAction() {
                MenuScreen.this.achievementClick();
            }
        };
        this.exitButton = new CustomButton(ImagesResources.menuScreenButtons[8][0], ImagesResources.menuScreenButtons[8][1], null, null){

            protected void touchAction() {
                MenuScreen.this.exitClick();
            }
        };
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics graphics) {
                ImagesResources.menuScreenBackground.draw(graphics, 0, 0);
                super.onPaint(graphics);
            }

            public void execute(int code) {
                switch (code) {
                    case 0: {
                        this.showPlayButtons();
                    }
                }
            }

            public void showPlayButtons() {
                MenuScreen.this.playButton.setPosition(Constants.MENU_BUTTONS_COORDS[0][0], Constants.MENU_BUTTONS_COORDS[0][1]);
                MenuScreen.this.soundButton.setPosition(Constants.MENU_BUTTONS_COORDS[1][0], Constants.MENU_BUTTONS_COORDS[1][1]);
                MenuScreen.this.musicButton.setPosition(Constants.MENU_BUTTONS_COORDS[2][0], Constants.MENU_BUTTONS_COORDS[2][1]);
                MenuScreen.this.helpButton.setPosition(Constants.MENU_BUTTONS_COORDS[3][0], Constants.MENU_BUTTONS_COORDS[3][1]);
                MenuScreen.this.aboutButton.setPosition(Constants.MENU_BUTTONS_COORDS[4][0], Constants.MENU_BUTTONS_COORDS[4][1]);
                MenuScreen.this.youtubeButton.setPosition(Constants.MENU_BUTTONS_COORDS[5][0], Constants.MENU_BUTTONS_COORDS[5][1]);
                MenuScreen.this.soundtrackButton.setPosition(Constants.MENU_BUTTONS_COORDS[6][0], Constants.MENU_BUTTONS_COORDS[6][1]);
                MenuScreen.this.achievementsButton.setPosition(Constants.MENU_BUTTONS_COORDS[7][0], Constants.MENU_BUTTONS_COORDS[7][1]);
            }
        };
        this.layoutManager.add(this.playButton, Constants.MENU_BUTTONS_COORDS[0][0], Constants.MENU_BUTTONS_COORDS[0][1]);
        this.layoutManager.add(this.soundButton, Constants.MENU_BUTTONS_COORDS[1][0], Constants.MENU_BUTTONS_COORDS[1][1]);
        this.layoutManager.add(this.musicButton, Constants.MENU_BUTTONS_COORDS[2][0], Constants.MENU_BUTTONS_COORDS[2][1]);
        this.layoutManager.add(this.helpButton, Constants.MENU_BUTTONS_COORDS[3][0], Constants.MENU_BUTTONS_COORDS[3][1]);
        this.layoutManager.add(this.aboutButton, Constants.MENU_BUTTONS_COORDS[4][0], Constants.MENU_BUTTONS_COORDS[4][1]);
        this.layoutManager.add(this.youtubeButton, Constants.MENU_BUTTONS_COORDS[5][0], Constants.MENU_BUTTONS_COORDS[5][1]);
        this.layoutManager.add(this.soundtrackButton, Constants.MENU_BUTTONS_COORDS[6][0], Constants.MENU_BUTTONS_COORDS[6][1]);
        this.layoutManager.add(this.achievementsButton, Constants.MENU_BUTTONS_COORDS[7][0], Constants.MENU_BUTTONS_COORDS[7][1]);
        this.layoutManager.add(this.exitButton, Constants.MENU_BUTTONS_COORDS[8][0], Constants.MENU_BUTTONS_COORDS[8][1]);
        if (isNeedToPlayMusic && DataManager.isSoundMusicEnabled) {
            SoundSystem.playBackgroundMusic();
        }
        this.closeRunnable = new Application.XRunnable(){

            public void run() {
                MenuScreen.this.animationFrame = 1;
                MenuScreen.this.repeatCount = 0;
                MenuScreen.this.isAnimationInProgress = true;
                while (MenuScreen.this.isAnimationInProgress) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        // empty catch block
                    }
                    MenuScreen.this.animationFrame++;
                    if (MenuScreen.this.animationFrame == 4 && MenuScreen.this.repeatCount == 0) {
                        MenuScreen.this.animationFrame = 1;
                        MenuScreen.this.repeatCount = 1;
                    }
                    if (MenuScreen.this.animationFrame == 6) {
                        MenuScreen.this.isAnimationInProgress = false;
                        MenuScreen.this.animationFrame = 5;
                        try {
                            Thread.sleep(500L);
                        }
                        catch (InterruptedException e) {
                            e.printStackTrace();
                        }
                        Application.setScreen(WorldSelectorScreen.getInstance());
                        MenuScreen.this.closeScreen();
                    }
                    MenuScreen.this.playButton.setOnImage(ImagesResources.menuScreenButtons[0][MenuScreen.this.animationFrame]);
                    MenuScreen.this.playButton.setOffImage(ImagesResources.menuScreenButtons[0][MenuScreen.this.animationFrame]);
                    Screen.repaint();
                }
            }
        };
        this.isPlayAllowed = false;
        this.delayRunnable = new Application.XRunnable(){

            public void run() {
                MenuScreen.this.isPlayAllowed = true;
            }
        };
        Application.invokeLater(this.delayRunnable, 1100L, false);
    }

    private void youtubeClick() {
        if (this.isPlayAllowed) {
            SoundSystem.playButtonSound();
            try {
                Application.getInstance().platformRequest("http://www.youtube.com/watch?v=42lovuPivCM");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void achievementClick() {
        SoundSystem.playButtonSound();
        Application.setScreen(AchievementsScreen.getInstance());
    }

    private void exitClick() {
        SoundSystem.playButtonSound();
        if (DataManager.isSoundMusicEnabled) {
            SoundSystem.stopBackgroundMusic();
        }
        if (DataManager.isSoundMusicEnabled || DataManager.isSoundEffectsEnabled) {
            SoundSystem.cleanup();
        }
        Application.quit();
    }

    private void soundTrackClick() {
        if (this.isPlayAllowed) {
            SoundSystem.playButtonSound();
            try {
                Application.getInstance().platformRequest("http://www.youtube.com/watch?v=BRvLfcnQFA8");
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public boolean navigationClick(int status, int time) {
        return true;
    }

    private boolean isMoveAllowed() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.initTime > 500L) {
            this.initTime = currTime;
            return true;
        }
        return false;
    }

    public void closeScreen() {
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public static MenuScreen getInstance(boolean isNeedToPlayMusic) {
        if (instance == null) {
            instance = new MenuScreen(isNeedToPlayMusic);
        } else {
            instance.reinitialize(isNeedToPlayMusic);
        }
        return instance;
    }

    private void reinitialize(boolean isNeedToPlayMusic) {
        this.playButton.setOffImage(ImagesResources.menuScreenButtons[0][0]);
        this.playButton.setOnImage(ImagesResources.menuScreenButtons[0][1]);
        ImagesResources.initMenuScreen();
        if (!DataManager.isSoundEffectsEnabled) {
            this.soundButton.setOnImage(ImagesResources.menuScreenButtons[1][1]);
            this.soundButton.setOffImage(ImagesResources.menuScreenButtons[1][0]);
        } else {
            this.soundButton.setOnImage(ImagesResources.menuScreenButtons[1][3]);
            this.soundButton.setOffImage(ImagesResources.menuScreenButtons[1][2]);
        }
        if (!DataManager.isSoundMusicEnabled) {
            this.musicButton.setOnImage(ImagesResources.menuScreenButtons[2][1]);
            this.musicButton.setOffImage(ImagesResources.menuScreenButtons[2][0]);
        } else {
            this.musicButton.setOnImage(ImagesResources.menuScreenButtons[2][3]);
            this.musicButton.setOffImage(ImagesResources.menuScreenButtons[2][2]);
        }
        if (isNeedToPlayMusic && DataManager.isSoundMusicEnabled) {
            SoundSystem.playBackgroundMusic();
        }
        this.isPlayAllowed = false;
        Application.invokeLater(this.delayRunnable, 1100L, false);
    }
}

