/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.audio;

import com.ximad.braincube2.utils.Utils;
import javax.microedition.media.Player;
import javax.microedition.media.PlayerListener;

public class WatchdogListener
implements PlayerListener {
    private String soundPath;
    private static int playedCount;
    private static int playedCountMax;

    public WatchdogListener(String soundPath) {
        this.soundPath = soundPath;
    }

    public void playerUpdate(Player player, String event, Object data) {
        if (event.equals("bufferingStarted")) {
            this.msg("BUFFERING_STARTED");
        } else if (event.equals("bufferingStopped")) {
            this.msg("BUFFERING_STOPPED");
        } else if (event.equals("started")) {
            if (playedCountMax < ++playedCount) {
                playedCountMax = playedCount;
            }
            this.msg("STARTED " + playedCount + "  " + playedCountMax);
        } else if (event.equals("stopped")) {
            this.msg("STOPPED " + --playedCount);
        } else if (event.equals("error")) {
            this.msg("ERROR " + data);
        } else if (event.equals("endOfMedia")) {
            this.msg("END_OF_MEDIA " + --playedCount);
        } else {
            this.msg(event + " : " + data);
        }
    }

    private void msg(String msg) {
        String s = "SOUND WD [" + this.soundPath + "]: " + msg;
        Utils.log(s);
    }
}

