/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.components;

import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.engine.Bitmap;
import javax.microedition.lcdui.Graphics;

public class CustomButtonRes
extends Field {
    private Bitmap currentImage = null;
    private Bitmap offImage = null;
    private Bitmap onImage = null;
    private Bitmap focusImage = null;
    private Bitmap checkImage = null;
    private int width;
    private int height;
    private boolean isFocusImageNeeded;
    private boolean isCheckImageNeeded;
    private boolean isFocused = false;
    private boolean checkState;

    public CustomButtonRes(Bitmap _offImage, Bitmap _onImage, Bitmap _focusImage, Bitmap _checkImage) {
        if (_offImage != null) {
            this.offImage = _offImage;
            this.width = this.offImage.getWidth();
            this.height = this.offImage.getHeight();
            this.currentImage = this.offImage;
        }
        if (_onImage != null) {
            this.onImage = _onImage;
        }
        if (this.offImage == null || this.onImage == null) {
            // empty if block
        }
        if (_focusImage == null) {
            this.isFocusImageNeeded = false;
        } else {
            this.focusImage = _focusImage;
            this.isFocusImageNeeded = true;
            this.width = this.focusImage.getWidth();
            this.height = this.focusImage.getHeight();
        }
        if (_checkImage == null) {
            this.isCheckImageNeeded = false;
        } else {
            this.checkImage = _checkImage;
            this.isCheckImageNeeded = true;
        }
        this.checkState = false;
    }

    public boolean getFocusState() {
        return this.isFocused;
    }

    public void setOffImage(Bitmap _offImage) {
        this.offImage = _offImage;
        if (!this.getFocusState()) {
            this.currentImage = this.offImage;
        }
        this.repaint();
    }

    public void setOnImage(Bitmap _onImage) {
        this.onImage = _onImage;
        if (this.getFocusState()) {
            this.currentImage = this.onImage;
        }
        this.repaint();
    }

    public void setFocusImage(Bitmap _focusImage) {
        if (this.focusImage == null) {
            this.isFocusImageNeeded = false;
        } else {
            this.isFocusImageNeeded = true;
            this.focusImage = _focusImage;
        }
        this.repaint();
    }

    public void setCheckState(boolean state) {
        this.checkState = state;
        this.repaint();
    }

    public void setSize(int _width, int _height) {
        this.width = _width;
        this.height = _height;
    }

    public boolean getCheckState() {
        return this.checkState;
    }

    public void onPaint(Graphics g) {
        this.isFocused = false;
        if (this.currentImage != null) {
            this.currentImage.draw(g, 0, 0);
        }
        if (this.isCheckImageNeeded && this.checkState) {
            this.checkImage.draw(g, 0, 0);
        }
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.currentImage = this.onImage;
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1) {
                    this.touchAction();
                    this.currentImage = this.offImage;
                    this.status = 0;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.currentImage = this.offImage;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    protected void touchAction() {
    }
}

