/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.engine;

import com.ximad.braincube2.component.Field;
import com.ximad.braincube2.engine.Bitmap;
import javax.microedition.lcdui.Graphics;

public class CustomButton
extends Field {
    private Bitmap imgPressed;
    private Bitmap imgDefault;
    private Bitmap imgFocused;
    private Bitmap image;
    private int normalIndex;
    private int pressedIndex;
    private boolean isEnabled = true;
    private boolean isVisible = true;

    public CustomButton(Bitmap offImage, Bitmap onImage, Bitmap focusImage) {
        if (offImage != null) {
            this.imgDefault = offImage;
            this.width = this.imgDefault.getWidth();
            this.height = this.imgDefault.getHeight();
            this.status = 0;
        }
        this.imgPressed = onImage;
        this.imgFocused = focusImage;
    }

    public CustomButton(Bitmap offImage, Bitmap onImage, Bitmap focusImage, Bitmap checkImage) {
        this(offImage, onImage, focusImage);
    }

    public CustomButton(Bitmap image, int normalIndex, int pressedIndex) {
        this.image = image;
        this.width = image.getTileWidth();
        this.height = image.getTileHeight();
        this.normalIndex = normalIndex;
        this.pressedIndex = pressedIndex;
    }

    public CustomButton(int width, int height) {
        this(null, null, null);
        this.width = width > 0 ? width : 1;
        this.height = height > 0 ? height : 1;
    }

    public void setOffImage(Bitmap offImagePath) {
        this.imgDefault = offImagePath;
    }

    public void setOnImage(Bitmap onImagePath) {
        this.imgPressed = onImagePath;
    }

    public void setOffImage(int index) {
        this.normalIndex = index;
        this.status = 0;
    }

    public void setOnImage(int index) {
        this.pressedIndex = index;
        this.status = 1;
    }

    public void onPaint(Graphics g) {
        if (this.isVisible) {
            switch (this.status) {
                case 0: {
                    if (this.image != null) {
                        this.image.drawSprite(g, this.left, this.top, this.normalIndex);
                        break;
                    }
                    if (this.imgDefault == null) break;
                    this.imgDefault.draw(g, this.left, this.top);
                    break;
                }
                case 1: {
                    if (this.image != null) {
                        this.image.drawSprite(g, this.left, this.top, this.pressedIndex);
                        break;
                    }
                    if (this.imgPressed == null) break;
                    this.imgPressed.draw(g, this.left, this.top);
                }
            }
            if (this.show_coords) {
                g.drawString("left: " + this.left + " / top: " + this.top, this.left, this.top, 0);
            }
        }
    }

    public boolean touchEvent(int touchEventType, int eventX, int eventY) {
        if (!(this.isVisible && this.isEnabled || touchEventType == 1)) {
            return false;
        }
        boolean out = false;
        if (eventX < this.left || eventX > this.left + this.width || eventY < this.top || eventY > this.top + this.height) {
            out = true;
        }
        switch (touchEventType) {
            case 2: {
                if (out) {
                    return false;
                }
                this.status = 1;
                this.repaint();
                break;
            }
            case 1: {
                if (!out && this.status == 1) {
                    this.touchAction();
                    this.status = 0;
                    this.repaint();
                    break;
                }
                if (this.status == 1) {
                    this.status = 0;
                    this.repaint();
                    break;
                }
                this.status = 0;
            }
        }
        return !out;
    }

    protected void touchAction() {
    }

    public void setEnabled(boolean isEnabled) {
        this.isEnabled = isEnabled;
    }

    public int getLeft() {
        return this.left;
    }

    public int getTop() {
        return this.top;
    }

    public void setVisible(boolean isVisible) {
        this.isVisible = isVisible;
    }
}

