/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.Achievements;
import com.ximad.braincube2.components.AchievementsButton;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.components.ScoresManager;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.Screen;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.GameScreen;
import com.ximad.braincube2.utils.Utils;
import java.util.EmptyStackException;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class EndGameScreen
extends UiScreen {
    private static EndGameScreen instance;
    private GameScreen parentScreen;
    CustomManager layoutManager;
    private CustomButton nextButton;
    private CustomButton soundButton;
    private CustomButton exitButton;
    private CustomButton restartButton;
    private AchievementsButton achievementsButton;
    private Font currentFont;
    private Font bestFont;
    private Font totalFont;
    public int animationFrame;
    public int flaskFrame;
    public int flaskMaxFrame;
    public boolean isAnimationInProgress;
    public boolean isFillingAnimationInProgress;
    public Application.XRunnable counterRunnable;
    private int counterRunnableID = -1;
    public Application.XRunnable closeRunnable;
    private int closeRunnableID = -1;
    public Application.XRunnable achievementsRunnable;
    private int achievementsRunnableID = -1;
    private Application.XRunnable startRunnable;
    private int startRunnableID;
    public int score;
    public float scoreStep;
    public int scoreBest;
    public float scoreBestStep;
    public int scoreTotal;
    public float scoreTotalStep;
    private boolean isBestTotalAnimationNeeded;
    private float bestStepTemp;
    private float totalStepTemp;
    public int flaskAnimationFrame;
    private long initTime = System.currentTimeMillis();
    private int achievementsNumber;
    private boolean isAchievementDisplayed;

    private EndGameScreen(GameScreen parent) {
        this.parentScreen = parent;
        SoundSystem.play(6);
        ImagesResources.initEndGame();
        ImagesResources.initAchievementsScreen();
        this.currentFont = Utils.getFont(64, 2, 0);
        this.bestFont = Utils.getFont(64, 2, 8);
        this.totalFont = Utils.getFont(64, 2, 0);
        this.isBestTotalAnimationNeeded = ScoresManager.getInstance().isBestTotalAnimationNeeded;
        this.nextButton = new CustomButton(ImagesResources.endGameImages[0][0], ImagesResources.endGameImages[0][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                EndGameScreen.this.isAnimationInProgress = true;
                EndGameScreen.this.layoutManager.execute(1);
                EndGameScreen.this.update();
                EndGameScreen.this.closeRunnableID = Application.invokeLater(EndGameScreen.this.closeRunnable, 80L, true);
                if (((EndGameScreen)EndGameScreen.this).parentScreen.level == 24) {
                    EndGameScreen.this.parentScreen.openWorldSelector();
                } else {
                    EndGameScreen.this.parentScreen.loadNextLevel();
                }
            }
        };
        this.soundButton = new CustomButton(ImagesResources.endGameImages[2][0], ImagesResources.endGameImages[2][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                DataManager.saveSoundEffectsState(!DataManager.isSoundEffectsEnabled);
                if (DataManager.isSoundEffectsEnabled) {
                    EndGameScreen.this.soundButton.setOnImage(ImagesResources.endGameImages[2][1]);
                    EndGameScreen.this.soundButton.setOffImage(ImagesResources.endGameImages[2][0]);
                } else {
                    EndGameScreen.this.soundButton.setOnImage(ImagesResources.endGameImages[2][3]);
                    EndGameScreen.this.soundButton.setOffImage(ImagesResources.endGameImages[2][2]);
                }
                EndGameScreen.this.update();
            }
        };
        if (!DataManager.isSoundEffectsEnabled) {
            this.soundButton.setOffImage(ImagesResources.endGameImages[2][2]);
            this.soundButton.setOnImage(ImagesResources.endGameImages[2][3]);
        }
        this.exitButton = new CustomButton(ImagesResources.endGameImages[3][0], ImagesResources.endGameImages[3][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                EndGameScreen.this.isAnimationInProgress = true;
                EndGameScreen.this.layoutManager.execute(1);
                EndGameScreen.this.update();
                EndGameScreen.this.closeRunnableID = Application.invokeLater(EndGameScreen.this.closeRunnable, 80L, true);
                EndGameScreen.this.parentScreen.exitLevel();
            }
        };
        this.restartButton = new CustomButton(ImagesResources.endGameImages[4][0], ImagesResources.endGameImages[4][1], null, null){

            public void touchAction() {
                SoundSystem.playButtonSound();
                EndGameScreen.this.isAnimationInProgress = true;
                EndGameScreen.this.layoutManager.execute(1);
                EndGameScreen.this.update();
                EndGameScreen.this.closeRunnableID = Application.invokeLater(EndGameScreen.this.closeRunnable, 80L, true);
                EndGameScreen.this.parentScreen.reloadLevel();
            }
        };
        this.achievementsNumber = Achievements.openedAchievements.size();
        if (this.achievementsNumber != 0) {
            int type = (Integer)Achievements.openedAchievements.pop();
            this.achievementsButton = new AchievementsButton(type);
            this.isAchievementDisplayed = false;
        }
        this.animationFrame = 0;
        this.isAnimationInProgress = true;
        this.isFillingAnimationInProgress = false;
        this.score = 0;
        this.scoreStep = 0.0f;
        this.flaskMaxFrame = this.getIndicatorHeight();
        if (this.isBestTotalAnimationNeeded) {
            this.scoreBest = ScoresManager.getInstance().bestScorePrev;
            this.scoreBestStep = (float)(ScoresManager.getInstance().getBestScore() - this.scoreBest) / (float)this.flaskMaxFrame;
            this.scoreTotal = ScoresManager.getInstance().totalScorePrev;
            this.scoreTotalStep = (float)(ScoresManager.getInstance().getTotalScore() - this.scoreTotal) / (float)this.flaskMaxFrame;
        } else {
            this.scoreBest = ScoresManager.getInstance().getBestScore();
            this.scoreTotal = ScoresManager.getInstance().getTotalScore();
        }
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics graphics) {
                if (((EndGameScreen)EndGameScreen.this).parentScreen.bg != null) {
                    ((EndGameScreen)EndGameScreen.this).parentScreen.bg.draw(graphics, 0, 0);
                }
                ImagesResources.popupBackgroundImage.draw(graphics, 0, 0);
                if (EndGameScreen.this.isAnimationInProgress) {
                    ImagesResources.popupEffectImages[EndGameScreen.this.animationFrame].draw(graphics, 80, 0);
                } else {
                    ImagesResources.endGameCompleteImage.draw(graphics, 80, 0);
                    graphics.setColor(10682112);
                    graphics.setFont(EndGameScreen.this.currentFont);
                    graphics.drawString(String.valueOf(EndGameScreen.this.score), Constants.END_GAME_COORDS[11][0], Constants.END_GAME_COORDS[11][1], 20);
                    graphics.setColor(0xE6E6E6);
                    graphics.setFont(EndGameScreen.this.bestFont);
                    graphics.drawString(String.valueOf(EndGameScreen.this.scoreBest), Constants.END_GAME_COORDS[12][0], Constants.END_GAME_COORDS[12][1], 20);
                    graphics.setColor(52214);
                    graphics.setFont(EndGameScreen.this.totalFont);
                    graphics.drawString(String.valueOf(EndGameScreen.this.scoreTotal), Constants.END_GAME_COORDS[13][0], Constants.END_GAME_COORDS[13][1], 20);
                    int batCount = Board.getInstance().batteryStackCount;
                    int currBat = ScoresManager.getInstance().getCurrentBatteries();
                    switch (batCount) {
                        case 1: {
                            if (currBat == 0) {
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[5][0], Constants.END_GAME_COORDS[5][1]);
                                break;
                            }
                            if (currBat != 1) break;
                            ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[5][0], Constants.END_GAME_COORDS[5][1]);
                            break;
                        }
                        case 2: {
                            if (currBat == 0) {
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[6][0], Constants.END_GAME_COORDS[6][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[7][0], Constants.END_GAME_COORDS[7][1]);
                                break;
                            }
                            if (currBat == 1) {
                                ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[6][0], Constants.END_GAME_COORDS[6][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[7][0], Constants.END_GAME_COORDS[7][1]);
                                break;
                            }
                            if (currBat != 2) break;
                            ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[6][0], Constants.END_GAME_COORDS[6][1]);
                            ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[7][0], Constants.END_GAME_COORDS[7][1]);
                            break;
                        }
                        case 3: {
                            if (currBat == 0) {
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[8][0], Constants.END_GAME_COORDS[8][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[9][0], Constants.END_GAME_COORDS[9][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[10][0], Constants.END_GAME_COORDS[10][1]);
                                break;
                            }
                            if (currBat == 1) {
                                ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[8][0], Constants.END_GAME_COORDS[8][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[9][0], Constants.END_GAME_COORDS[9][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[10][0], Constants.END_GAME_COORDS[10][1]);
                                break;
                            }
                            if (currBat == 2) {
                                ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[8][0], Constants.END_GAME_COORDS[8][1]);
                                ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[9][0], Constants.END_GAME_COORDS[9][1]);
                                ImagesResources.batterySymbolImages[0].draw(graphics, Constants.END_GAME_COORDS[10][0], Constants.END_GAME_COORDS[10][1]);
                                break;
                            }
                            if (currBat != 3) break;
                            ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[8][0], Constants.END_GAME_COORDS[8][1]);
                            ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[9][0], Constants.END_GAME_COORDS[9][1]);
                            ImagesResources.batterySymbolImages[1].draw(graphics, Constants.END_GAME_COORDS[10][0], Constants.END_GAME_COORDS[10][1]);
                        }
                    }
                }
                this.drawFlask(graphics);
                if (!EndGameScreen.this.isAnimationInProgress) {
                    super.onPaint(graphics);
                }
            }

            public void execute(int code) {
                switch (code) {
                    case 0: {
                        EndGameScreen.this.nextButton.setVisible(true);
                        EndGameScreen.this.soundButton.setVisible(true);
                        EndGameScreen.this.exitButton.setVisible(true);
                        EndGameScreen.this.restartButton.setVisible(true);
                        break;
                    }
                    case 1: {
                        EndGameScreen.this.nextButton.setVisible(false);
                        EndGameScreen.this.restartButton.setVisible(false);
                        EndGameScreen.this.exitButton.setVisible(false);
                        EndGameScreen.this.soundButton.setVisible(false);
                        if (EndGameScreen.this.achievementsButton == null) break;
                        EndGameScreen.this.achievementsButton.setVisible(false);
                    }
                }
            }

            public void drawFlask(Graphics g) {
                int height = ImagesResources.flaskIndicatorImages[EndGameScreen.this.flaskAnimationFrame].getHeight();
                int width = ImagesResources.flaskIndicatorImages[EndGameScreen.this.flaskAnimationFrame].getWidth();
                for (int i = 0; i < EndGameScreen.this.flaskFrame; ++i) {
                    ImagesResources.flaskIndicatorImages[EndGameScreen.this.flaskAnimationFrame].draw(g, Constants.FLASK_COORDS[0][0], Constants.FLASK_COORDS[0][1] - height * i);
                }
                ImagesResources.flaskIndicatorImages[EndGameScreen.this.flaskAnimationFrame + 2].draw(g, Constants.FLASK_COORDS[1][0], Constants.FLASK_COORDS[1][1] - height * EndGameScreen.this.flaskFrame);
                ImagesResources.flaskImage.draw(g, Constants.FLASK_COORDS[2][0], Constants.FLASK_COORDS[2][1]);
            }
        };
        this.layoutManager.add(this.nextButton, Constants.END_GAME_COORDS[0][0], Constants.END_GAME_COORDS[0][1]);
        this.layoutManager.add(this.soundButton, Constants.END_GAME_COORDS[2][0], Constants.END_GAME_COORDS[2][1]);
        this.layoutManager.add(this.exitButton, Constants.END_GAME_COORDS[3][0], Constants.END_GAME_COORDS[3][1]);
        this.layoutManager.add(this.restartButton, Constants.END_GAME_COORDS[4][0], Constants.END_GAME_COORDS[4][1]);
        if (this.achievementsButton != null) {
            this.layoutManager.add(this.achievementsButton, (640 - ImagesResources.endGameImages[5][0].getWidth()) / 2, 360 - ImagesResources.endGameImages[5][0].getHeight());
        }
        this.layoutManager.execute(0);
        this.startRunnable = new Application.XRunnable(){

            public void run() {
                ++EndGameScreen.this.animationFrame;
                if (EndGameScreen.this.animationFrame == 3) {
                    EndGameScreen.this.isAnimationInProgress = false;
                    EndGameScreen.this.animationFrame = 2;
                    EndGameScreen.this.update();
                    EndGameScreen.this.isFillingAnimationInProgress = true;
                    EndGameScreen.this.scoreStep = ScoresManager.getInstance().getCurrentScore() / EndGameScreen.this.flaskMaxFrame;
                    EndGameScreen.this.flaskAnimationFrame = 1;
                    EndGameScreen.this.counterRunnableID = Application.invokeLater(EndGameScreen.this.counterRunnable, 50L, true);
                    if (EndGameScreen.this.achievementsNumber != 0) {
                        EndGameScreen.this.isAchievementDisplayed = true;
                        EndGameScreen.this.achievementsRunnableID = Application.invokeLater(EndGameScreen.this.achievementsRunnable, 3000L, true);
                    }
                    Application.cancelInvokeLater(EndGameScreen.this.startRunnableID);
                    EndGameScreen.this.startRunnableID = -1;
                }
                Screen.repaint();
            }
        };
        this.counterRunnable = new Application.XRunnable(){

            public void run() {
                EndGameScreen.this.flaskFrame += 5;
                EndGameScreen.this.score = (int)((float)EndGameScreen.this.score + EndGameScreen.this.scoreStep * 5.0f);
                if (EndGameScreen.this.isBestTotalAnimationNeeded) {
                    EndGameScreen.this.bestStepTemp += EndGameScreen.this.scoreBestStep * 5.0f;
                    EndGameScreen.this.totalStepTemp += EndGameScreen.this.scoreTotalStep * 5.0f;
                    if ((double)EndGameScreen.this.bestStepTemp >= 1.0) {
                        EndGameScreen.this.scoreBest = (int)((float)EndGameScreen.this.scoreBest + EndGameScreen.this.bestStepTemp);
                        EndGameScreen.this.bestStepTemp = 0.0f;
                    }
                    if ((double)EndGameScreen.this.totalStepTemp >= 1.0) {
                        EndGameScreen.this.scoreTotal = (int)((float)EndGameScreen.this.scoreTotal + EndGameScreen.this.totalStepTemp);
                        EndGameScreen.this.totalStepTemp = 0.0f;
                    }
                }
                if (EndGameScreen.this.flaskFrame >= EndGameScreen.this.flaskMaxFrame) {
                    EndGameScreen.this.flaskFrame = EndGameScreen.this.flaskMaxFrame;
                    EndGameScreen.this.score = ScoresManager.getInstance().getCurrentScore();
                    if (EndGameScreen.this.isBestTotalAnimationNeeded) {
                        EndGameScreen.this.scoreBest = ScoresManager.getInstance().getBestScore();
                        EndGameScreen.this.scoreTotal = ScoresManager.getInstance().getTotalScore();
                    }
                    EndGameScreen.this.isFillingAnimationInProgress = false;
                    EndGameScreen.this.flaskAnimationFrame = 1;
                    EndGameScreen.this.update();
                    Application.cancelInvokeLater(EndGameScreen.this.counterRunnableID);
                    EndGameScreen.this.counterRunnableID = -1;
                }
                Screen.repaint();
            }
        };
        this.closeRunnable = new Application.XRunnable(){

            public void run() {
                ++EndGameScreen.this.animationFrame;
                if (EndGameScreen.this.animationFrame == 3) {
                    EndGameScreen.this.isAnimationInProgress = false;
                    EndGameScreen.this.animationFrame = 2;
                    EndGameScreen.this.closeScreen();
                    Application.cancelInvokeLater(EndGameScreen.this.closeRunnableID);
                    EndGameScreen.this.closeRunnableID = -1;
                }
                Screen.repaint();
            }
        };
        this.achievementsRunnable = new Application.XRunnable(){

            public void run() {
                try {
                    int type = (Integer)Achievements.openedAchievements.pop();
                    EndGameScreen.this.achievementsButton.setType(type);
                }
                catch (EmptyStackException e) {
                    EndGameScreen.this.achievementsNumber = 0;
                    EndGameScreen.this.isAchievementDisplayed = false;
                    EndGameScreen.this.achievementsButton.setVisible(false);
                    Application.cancelInvokeLater(EndGameScreen.this.achievementsRunnableID);
                    EndGameScreen.this.achievementsRunnableID = -1;
                }
                Screen.repaint();
            }
        };
        this.startRunnableID = Application.invokeLater(this.startRunnable, 80L, true);
    }

    public void update() {
        EndGameScreen.repaint();
    }

    private int getIndicatorHeight() {
        int height = 0;
        int maxScore = ScoresManager.getInstance().getCurrentScore();
        height = 166 * maxScore / 1000;
        return height;
    }

    public void closeScreen() {
    }

    public boolean onClose() {
        this.isAnimationInProgress = true;
        this.layoutManager.execute(1);
        this.update();
        this.closeRunnableID = Application.invokeLater(this.closeRunnable, 80L, true);
        if (this.achievementsButton != null) {
            try {
                Application.cancelInvokeLater(this.achievementsRunnableID);
            }
            catch (Exception exception) {
                // empty catch block
            }
            Achievements.reset();
        }
        this.parentScreen.exitLevel();
        return true;
    }

    private boolean isMoveAllowed() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.initTime > 500L) {
            this.initTime = currTime;
            return true;
        }
        return false;
    }

    public void onPaint(Graphics g) {
        this.parentScreen.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public static EndGameScreen getInstance(GameScreen parent) {
        if (instance == null) {
            instance = new EndGameScreen(parent);
        } else {
            instance.reinitialize(parent);
        }
        return instance;
    }

    private void reinitialize(GameScreen parent) {
        this.parentScreen = parent;
        this.flaskFrame = 0;
        SoundSystem.play(6);
        ImagesResources.initEndGame();
        ImagesResources.initAchievementsScreen();
        this.isBestTotalAnimationNeeded = ScoresManager.getInstance().isBestTotalAnimationNeeded;
        if (!DataManager.isSoundEffectsEnabled) {
            this.soundButton.setOffImage(ImagesResources.endGameImages[2][2]);
            this.soundButton.setOnImage(ImagesResources.endGameImages[2][3]);
        } else {
            this.soundButton.setOffImage(ImagesResources.endGameImages[2][0]);
            this.soundButton.setOnImage(ImagesResources.endGameImages[2][1]);
        }
        this.achievementsNumber = Achievements.openedAchievements.size();
        if (this.achievementsNumber != 0) {
            int type = (Integer)Achievements.openedAchievements.pop();
            if (this.achievementsButton == null) {
                this.achievementsButton = new AchievementsButton(type);
                this.layoutManager.add(this.achievementsButton, (640 - ImagesResources.endGameImages[5][0].getWidth()) / 2, 360 - ImagesResources.endGameImages[5][0].getHeight());
            } else {
                this.achievementsButton.setVisible(true);
                this.achievementsButton.setType(type);
            }
            this.isAchievementDisplayed = false;
        }
        this.animationFrame = 0;
        this.isAnimationInProgress = true;
        this.isFillingAnimationInProgress = false;
        this.score = 0;
        this.scoreStep = 0.0f;
        this.flaskMaxFrame = this.getIndicatorHeight();
        if (this.isBestTotalAnimationNeeded) {
            this.scoreBest = ScoresManager.getInstance().bestScorePrev;
            this.scoreBestStep = (float)(ScoresManager.getInstance().getBestScore() - this.scoreBest) / (float)this.flaskMaxFrame;
            this.scoreTotal = ScoresManager.getInstance().totalScorePrev;
            this.scoreTotalStep = (float)(ScoresManager.getInstance().getTotalScore() - this.scoreTotal) / (float)this.flaskMaxFrame;
        } else {
            this.scoreBest = ScoresManager.getInstance().getBestScore();
            this.scoreTotal = ScoresManager.getInstance().getTotalScore();
        }
        this.layoutManager.execute(0);
        this.startRunnableID = Application.invokeLater(this.startRunnable, 80L, true);
    }
}

