/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.Board;
import com.ximad.braincube2.components.Help;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.Screen;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.GameScreen;
import com.ximad.braincube2.screens.HelpScreen;
import com.ximad.braincube2.screens.TurboGameScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class PauseScreen
extends UiScreen {
    private static PauseScreen instance;
    private boolean toMainMenu = false;
    private GameScreen parentScreen;
    public boolean isEnabled;
    private int timeToPass;
    public String time;
    public String worldLevel;
    CustomManager layoutManager;
    public CustomButton resumeButton;
    public CustomButton helpButton;
    public CustomButton restartButton;
    public CustomButton exitButton;
    public CustomButton soundButton;
    public CustomButton hintButton;
    private Font levelFont;
    private Font timerFont;
    public int animationFrame;
    public boolean isAnimationInProgress;
    public Application.XRunnable closeRunnable;
    private int closeRunnableID;
    private Application.XRunnable startRunnable;
    private int startRunnableID;
    private int bossHint;
    private long initTime = System.currentTimeMillis();
    public int world;
    public int level;
    private int worldLevelX;

    private PauseScreen(GameScreen parent) {
        this.parentScreen = parent;
        this.world = this.parentScreen.world;
        this.level = this.parentScreen.level;
        ImagesResources.initPauseMenu();
        this.levelFont = Utils.getFont(64, 0, 8);
        this.timerFont = Utils.getFont(64, 0, 8);
        if (this.parentScreen.level == 24) {
            this.bossHint = this.parentScreen.world + 5;
        } else {
            this.bossHint = -1;
            this.isEnabled = false;
        }
        this.resumeButton = new CustomButton(ImagesResources.gameMenuImages[0][0], ImagesResources.gameMenuImages[0][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                PauseScreen.this.isAnimationInProgress = true;
                PauseScreen.this.layoutManager.execute(1);
                PauseScreen.this.update();
                PauseScreen.this.closeRunnableID = Application.invokeLater(PauseScreen.this.closeRunnable, 80L, true);
                GameScreen.gameStatus = 0;
            }
        };
        this.helpButton = new CustomButton(ImagesResources.gameMenuImages[1][0], ImagesResources.gameMenuImages[1][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                if (Help.HELP_MATRIX[PauseScreen.this.world][PauseScreen.this.level] != -1) {
                    Application.setScreen(HelpScreen.getInstance(PauseScreen.this, Help.HELP_MATRIX[PauseScreen.this.world][PauseScreen.this.level], true));
                } else {
                    Application.setScreen(HelpScreen.getInstance(PauseScreen.this, 0, true));
                }
            }
        };
        this.restartButton = new CustomButton(ImagesResources.gameMenuImages[3][0], ImagesResources.gameMenuImages[3][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                PauseScreen.this.isAnimationInProgress = true;
                PauseScreen.this.layoutManager.execute(1);
                PauseScreen.this.update();
                PauseScreen.this.closeRunnableID = Application.invokeLater(PauseScreen.this.closeRunnable, 80L, true);
                PauseScreen.this.parentScreen.reloadLevel();
            }
        };
        this.exitButton = new CustomButton(ImagesResources.gameMenuImages[4][0], ImagesResources.gameMenuImages[4][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                PauseScreen.this.toMainMenu = true;
                PauseScreen.this.isAnimationInProgress = true;
                PauseScreen.this.layoutManager.execute(1);
                PauseScreen.this.update();
                PauseScreen.this.closeRunnableID = Application.invokeLater(PauseScreen.this.closeRunnable, 80L, true);
            }
        };
        this.soundButton = new CustomButton(ImagesResources.gameMenuImages[5][0], ImagesResources.gameMenuImages[5][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                DataManager.saveSoundEffectsState(!DataManager.isSoundEffectsEnabled);
                if (DataManager.isSoundEffectsEnabled) {
                    PauseScreen.this.soundButton.setOnImage(ImagesResources.gameMenuImages[5][1]);
                    PauseScreen.this.soundButton.setOffImage(ImagesResources.gameMenuImages[5][0]);
                    if (PauseScreen.this.parentScreen instanceof TurboGameScreen) {
                        SoundSystem.startTurbo();
                    }
                } else {
                    PauseScreen.this.soundButton.setOnImage(ImagesResources.gameMenuImages[5][3]);
                    PauseScreen.this.soundButton.setOffImage(ImagesResources.gameMenuImages[5][2]);
                    if (PauseScreen.this.parentScreen instanceof TurboGameScreen) {
                        SoundSystem.stopTurbo();
                    }
                }
                PauseScreen.this.update();
            }
        };
        if (!DataManager.isSoundEffectsEnabled) {
            this.soundButton.setOnImage(ImagesResources.gameMenuImages[5][3]);
            this.soundButton.setOffImage(ImagesResources.gameMenuImages[5][2]);
        }
        this.timeToPass = (int)((long)Board.getInstance().hintTime - this.parentScreen.timeFromBeg);
        this.hintButton = new CustomButton(ImagesResources.gameMenuImages[6][3], ImagesResources.gameMenuImages[6][4], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                if (PauseScreen.this.bossHint == -1) {
                    PauseScreen.this.isAnimationInProgress = true;
                    PauseScreen.this.layoutManager.execute(1);
                    GameScreen.gameStatus = 0;
                    PauseScreen.this.update();
                    PauseScreen.this.closeRunnableID = Application.invokeLater(PauseScreen.this.closeRunnable, 80L, true);
                    if (Board.getInstance().hints.isActive) {
                        Board.getInstance().hideHint();
                    } else {
                        Board.getInstance().showHint();
                    }
                }
            }
        };
        if (this.bossHint == -1) {
            if (this.timeToPass <= 0) {
                this.isEnabled = true;
                if (!Board.getInstance().hints.isActive) {
                    this.hintButton.setOffImage(ImagesResources.gameMenuImages[6][1]);
                    this.hintButton.setOnImage(ImagesResources.gameMenuImages[6][2]);
                }
            } else {
                this.isEnabled = false;
                this.hintButton.setOffImage(ImagesResources.gameMenuImages[6][0]);
                this.hintButton.setOnImage(ImagesResources.gameMenuImages[6][0]);
                this.hintButton.setEnabled(false);
                this.time = this.convertMsToTime(this.timeToPass);
            }
        }
        this.worldLevel = this.parentScreen.world + 1 + "-" + (this.parentScreen.level + 1);
        this.worldLevelX = Constants.IN_GAME_MENU_COORDS[9][0] + (Constants.IN_GAME_MENU_COORDS[9][2] - this.levelFont.stringWidth(this.worldLevel)) / 2;
        this.animationFrame = 0;
        this.isAnimationInProgress = true;
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics graphics) {
                ((PauseScreen)PauseScreen.this).parentScreen.bg.draw(graphics, 0, 0);
                ImagesResources.popupBackgroundImage.draw(graphics, 0, 0);
                if (PauseScreen.this.bossHint != -1) {
                    ImagesResources.gameMenuImages[6][PauseScreen.this.bossHint].draw(graphics, Constants.IN_GAME_MENU_COORDS[6][0], Constants.IN_GAME_MENU_COORDS[6][1]);
                }
                if (PauseScreen.this.isAnimationInProgress) {
                    ImagesResources.popupEffectImages[PauseScreen.this.animationFrame].draw(graphics, 80, 0);
                } else {
                    ImagesResources.gameMenuLevelImage.draw(graphics, Constants.IN_GAME_MENU_COORDS[8][0], Constants.IN_GAME_MENU_COORDS[8][1]);
                    graphics.setColor(10682112);
                    graphics.setFont(PauseScreen.this.levelFont);
                    graphics.drawString(PauseScreen.this.worldLevel, PauseScreen.this.worldLevelX, Constants.IN_GAME_MENU_COORDS[9][1], 0);
                    if (!PauseScreen.this.isEnabled) {
                        graphics.setColor(0xB4B4B4);
                        graphics.setFont(PauseScreen.this.timerFont);
                        graphics.drawString(PauseScreen.this.time, Constants.IN_GAME_MENU_COORDS[7][0], Constants.IN_GAME_MENU_COORDS[7][1], 0);
                    }
                }
                this.drawFlask(graphics);
                if (!PauseScreen.this.isAnimationInProgress) {
                    super.onPaint(graphics);
                }
            }

            public void execute(int code) {
                switch (code) {
                    case 0: {
                        PauseScreen.this.resumeButton.setVisible(true);
                        PauseScreen.this.helpButton.setVisible(true);
                        PauseScreen.this.restartButton.setVisible(true);
                        PauseScreen.this.exitButton.setVisible(true);
                        PauseScreen.this.soundButton.setVisible(true);
                        if (PauseScreen.this.bossHint != -1) break;
                        PauseScreen.this.hintButton.setVisible(true);
                        break;
                    }
                    case 1: {
                        PauseScreen.this.resumeButton.setVisible(false);
                        PauseScreen.this.helpButton.setVisible(false);
                        PauseScreen.this.restartButton.setVisible(false);
                        PauseScreen.this.exitButton.setVisible(false);
                        PauseScreen.this.soundButton.setVisible(false);
                        if (PauseScreen.this.bossHint != -1) break;
                        PauseScreen.this.hintButton.setVisible(false);
                    }
                }
            }

            public void drawFlask(Graphics g) {
                int height = ImagesResources.flaskIndicatorImages[0].getHeight();
                int width = ImagesResources.flaskIndicatorImages[0].getWidth();
                int heightFlask = this.getIndicatorHeight();
                for (int i = 0; i < heightFlask; ++i) {
                    ImagesResources.flaskIndicatorImages[0].draw(g, Constants.FLASK_COORDS[0][0], Constants.FLASK_COORDS[0][1] - height * i);
                }
                ImagesResources.flaskIndicatorImages[2].draw(g, Constants.FLASK_COORDS[1][0], Constants.FLASK_COORDS[1][1] - height * heightFlask);
                ImagesResources.flaskImage.draw(g, Constants.FLASK_COORDS[2][0], Constants.FLASK_COORDS[2][1]);
            }

            private int getIndicatorHeight() {
                int height = 0;
                int maxScore = DataManager.getLevelScore(((PauseScreen)PauseScreen.this).parentScreen.world, ((PauseScreen)PauseScreen.this).parentScreen.level)[0];
                height = 166 * maxScore / 1000;
                return height;
            }
        };
        this.layoutManager.add(this.resumeButton, Constants.IN_GAME_MENU_COORDS[0][0], Constants.IN_GAME_MENU_COORDS[0][1]);
        this.layoutManager.add(this.helpButton, Constants.IN_GAME_MENU_COORDS[1][0], Constants.IN_GAME_MENU_COORDS[1][1]);
        this.layoutManager.add(this.restartButton, Constants.IN_GAME_MENU_COORDS[3][0], Constants.IN_GAME_MENU_COORDS[3][1]);
        this.layoutManager.add(this.exitButton, Constants.IN_GAME_MENU_COORDS[4][0], Constants.IN_GAME_MENU_COORDS[4][1]);
        this.layoutManager.add(this.soundButton, Constants.IN_GAME_MENU_COORDS[5][0], Constants.IN_GAME_MENU_COORDS[5][1]);
        this.layoutManager.add(this.hintButton, Constants.IN_GAME_MENU_COORDS[6][0], Constants.IN_GAME_MENU_COORDS[6][1]);
        if (this.bossHint != -1) {
            this.hintButton.setVisible(false);
        }
        this.layoutManager.execute(0);
        this.startRunnable = new Application.XRunnable(){

            public void run() {
                ++PauseScreen.this.animationFrame;
                if (PauseScreen.this.animationFrame == 3) {
                    PauseScreen.this.isAnimationInProgress = false;
                    PauseScreen.this.animationFrame = 2;
                    PauseScreen.this.update();
                    Application.cancelInvokeLater(PauseScreen.this.startRunnableID);
                }
                Screen.repaint();
            }
        };
        this.closeRunnable = new Application.XRunnable(){

            public void run() {
                ++PauseScreen.this.animationFrame;
                if (PauseScreen.this.animationFrame == 3) {
                    PauseScreen.this.isAnimationInProgress = false;
                    PauseScreen.this.animationFrame = 2;
                    if (!PauseScreen.this.toMainMenu) {
                        Application.setScreen(PauseScreen.this.parentScreen);
                        PauseScreen.this.closeScreen();
                    } else {
                        PauseScreen.this.toMainMenu = false;
                        GameScreen.getInstance().exitLevel();
                    }
                    Application.cancelInvokeLater(PauseScreen.this.closeRunnableID);
                    PauseScreen.this.closeRunnableID = -1;
                }
                Screen.repaint();
            }
        };
        this.startRunnableID = Application.invokeLater(this.startRunnable, 80L, true);
    }

    public void update() {
        PauseScreen.repaint();
    }

    public void closeScreen() {
    }

    public boolean onClose() {
        this.closeScreen();
        GameScreen.gameStatus = 0;
        return true;
    }

    private String convertMsToTime(int ms) {
        int min;
        String time = "0:00";
        int sec = ms / 1000;
        time = (sec -= (min = sec / 60) * 60) < 10 ? min + ":0" + sec : min + ":" + sec;
        return time;
    }

    private boolean isMoveAllowed() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.initTime > 500L) {
            this.initTime = currTime;
            return true;
        }
        return false;
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public static PauseScreen getInstance(GameScreen parent) {
        if (instance == null) {
            instance = new PauseScreen(parent);
        } else {
            instance.reinitialize(parent);
        }
        return instance;
    }

    private void reinitialize(GameScreen parent) {
        this.parentScreen = parent;
        this.world = this.parentScreen.world;
        this.level = this.parentScreen.level;
        ImagesResources.initPauseMenu();
        if (this.parentScreen.level == 24) {
            this.bossHint = this.parentScreen.world + 5;
        } else {
            this.bossHint = -1;
            this.isEnabled = false;
        }
        if (!DataManager.isSoundEffectsEnabled) {
            this.soundButton.setOnImage(ImagesResources.gameMenuImages[5][3]);
            this.soundButton.setOffImage(ImagesResources.gameMenuImages[5][2]);
        } else {
            this.soundButton.setOnImage(ImagesResources.gameMenuImages[5][1]);
            this.soundButton.setOffImage(ImagesResources.gameMenuImages[5][0]);
        }
        this.timeToPass = (int)((long)Board.getInstance().hintTime - this.parentScreen.timeFromBeg);
        this.hintButton.setOffImage(ImagesResources.gameMenuImages[6][3]);
        this.hintButton.setOnImage(ImagesResources.gameMenuImages[6][4]);
        this.hintButton.setEnabled(true);
        if (this.bossHint == -1) {
            if (this.timeToPass <= 0) {
                this.isEnabled = true;
                if (!Board.getInstance().hints.isActive) {
                    this.hintButton.setOffImage(ImagesResources.gameMenuImages[6][1]);
                    this.hintButton.setOnImage(ImagesResources.gameMenuImages[6][2]);
                }
            } else {
                this.isEnabled = false;
                this.hintButton.setOffImage(ImagesResources.gameMenuImages[6][0]);
                this.hintButton.setOnImage(ImagesResources.gameMenuImages[6][0]);
                this.hintButton.setEnabled(false);
                this.time = this.convertMsToTime(this.timeToPass);
            }
        }
        this.worldLevel = this.parentScreen.world + 1 + "-" + (this.parentScreen.level + 1);
        this.worldLevelX = Constants.IN_GAME_MENU_COORDS[9][0] + (Constants.IN_GAME_MENU_COORDS[9][2] - this.levelFont.stringWidth(this.worldLevel)) / 2;
        this.animationFrame = 0;
        this.isAnimationInProgress = true;
        if (this.bossHint == -1) {
            this.hintButton.setVisible(true);
        } else {
            this.hintButton.setVisible(false);
        }
        this.layoutManager.execute(0);
        this.startRunnableID = Application.invokeLater(this.startRunnable, 80L, true);
    }
}

