/*
 * Decompiled with CFR 0.152.
 */
package com.ximad.braincube2.screens;

import com.ximad.braincube2.Constants;
import com.ximad.braincube2.audio.SoundSystem;
import com.ximad.braincube2.components.ImagesResources;
import com.ximad.braincube2.engine.Application;
import com.ximad.braincube2.engine.CustomButton;
import com.ximad.braincube2.engine.CustomManager;
import com.ximad.braincube2.engine.DataManager;
import com.ximad.braincube2.engine.UiScreen;
import com.ximad.braincube2.screens.LevelSelectorScreen;
import com.ximad.braincube2.screens.MenuScreen;
import com.ximad.braincube2.utils.Utils;
import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;

public class WorldSelectorScreen
extends UiScreen {
    private static WorldSelectorScreen instance;
    CustomManager layoutManager;
    private CustomButton episode_0;
    private CustomButton episode_1;
    private CustomButton episode_2;
    private Font totalScoreFont;
    private int totalScoreX;
    private String totalScore;
    private Font battariesFont;
    private String battariesToOpenEpisode_1;
    private long initTime = System.currentTimeMillis();

    private WorldSelectorScreen() {
        ImagesResources.initWorldSelector();
        this.episode_0 = new CustomButton(ImagesResources.worldSelectorButtonsImages[1][0], ImagesResources.worldSelectorButtonsImages[1][1], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                WorldSelectorScreen.this.closeScreen();
                Application.setScreen(LevelSelectorScreen.getInstance(0, -1));
            }
        };
        this.episode_1 = new CustomButton(ImagesResources.worldSelectorButtonsImages[2][2], ImagesResources.worldSelectorButtonsImages[2][3], null, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                WorldSelectorScreen.this.closeScreen();
                Application.setScreen(LevelSelectorScreen.getInstance(1, -1));
            }
        };
        if (!DataManager.episode2Enable) {
            this.episode_1.setOffImage(ImagesResources.worldSelectorButtonsImages[2][0]);
            this.episode_1.setOnImage(ImagesResources.worldSelectorButtonsImages[2][1]);
            this.battariesToOpenEpisode_1 = DataManager.getTotalBatteries() + "/" + Constants.MIN_BATTARIES[0];
        }
        this.episode_2 = new CustomButton(ImagesResources.worldSelectorButtonsImages[3][0], ImagesResources.worldSelectorButtonsImages[3][0], null, null){

            protected void touchAction() {
            }
        };
        this.totalScoreFont = Utils.getFont(64, 0, 22);
        this.totalScore = "Total score: " + DataManager.getTotalScore();
        this.battariesFont = Utils.getFont(64, 0, 20);
        this.layoutManager = new CustomManager(){

            public void onPaint(Graphics g) {
                ImagesResources.worldLevelSelectorBackground.draw(g, 0, 0);
                ImagesResources.worldSelectorSelectWorld.draw(g, Constants.WORLD_SELECTOR_COORDS[2][0], Constants.WORLD_SELECTOR_COORDS[2][1]);
                g.setColor(52214);
                g.setFont(WorldSelectorScreen.this.totalScoreFont);
                g.drawString(WorldSelectorScreen.this.totalScore, Constants.WORLD_SELECTOR_COORDS[1][0], Constants.WORLD_SELECTOR_COORDS[1][1], 17);
                super.onPaint(g);
            }

            public void execute(int code) {
                WorldSelectorScreen.this.episode_0.setPosition(Constants.WORLD_SELECTOR_COORDS[4][0], Constants.WORLD_SELECTOR_COORDS[4][1]);
                WorldSelectorScreen.this.episode_2.setPosition(Constants.WORLD_SELECTOR_COORDS[6][0], Constants.WORLD_SELECTOR_COORDS[6][1]);
            }
        };
        this.layoutManager.add(this.episode_0, Constants.WORLD_SELECTOR_COORDS[4][0], Constants.WORLD_SELECTOR_COORDS[4][1]);
        this.layoutManager.add(this.episode_2, Constants.WORLD_SELECTOR_COORDS[6][0], Constants.WORLD_SELECTOR_COORDS[6][1]);
        CustomButton backButton = new CustomButton(ImagesResources.backButtonInactive, ImagesResources.backButtonActive, null){

            protected void touchAction() {
                SoundSystem.playButtonSound();
                Application.setScreen(MenuScreen.getInstance(true));
            }
        };
        this.layoutManager.add(backButton, 20, 283);
        this.layoutManager.execute(0);
    }

    private void closeScreen() {
    }

    public boolean onClose() {
        this.closeScreen();
        Application.setScreen(MenuScreen.getInstance(false));
        return true;
    }

    private boolean isMoveAllowed() {
        long currTime = System.currentTimeMillis();
        if (currTime - this.initTime > 500L) {
            this.initTime = currTime;
            return true;
        }
        return false;
    }

    public void unlockEpisode_1() {
        this.episode_1.setOffImage(ImagesResources.worldSelectorButtonsImages[2][2]);
        this.episode_1.setOnImage(ImagesResources.worldSelectorButtonsImages[2][3]);
        WorldSelectorScreen.repaint();
    }

    public void touchEvent(int touchEventType, int eventX, int eventY) {
        this.layoutManager.touchEvent(touchEventType, eventX, eventY);
    }

    public void onPaint(Graphics g) {
        super.onPaint(g);
        this.layoutManager.onPaint(g);
    }

    public static WorldSelectorScreen getInstance() {
        if (instance == null) {
            instance = new WorldSelectorScreen();
        } else {
            instance.reinitialize();
        }
        return instance;
    }

    private void reinitialize() {
        ImagesResources.initWorldSelector();
        if (!DataManager.episode2Enable) {
            this.episode_1.setOffImage(ImagesResources.worldSelectorButtonsImages[2][0]);
            this.episode_1.setOnImage(ImagesResources.worldSelectorButtonsImages[2][1]);
            this.battariesToOpenEpisode_1 = DataManager.getTotalBatteries() + "/" + Constants.MIN_BATTARIES[0];
        } else {
            this.episode_1.setOffImage(ImagesResources.worldSelectorButtonsImages[2][2]);
            this.episode_1.setOnImage(ImagesResources.worldSelectorButtonsImages[2][3]);
            this.battariesToOpenEpisode_1 = "";
        }
        this.totalScore = "Total score: " + DataManager.getTotalScore();
        this.layoutManager.execute(0);
    }
}

