/*
 * Decompiled with CFR 0.152.
 */
package com.twist.promotion;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.rms.RecordStore;
import javax.microedition.rms.RecordStoreException;
import javax.microedition.rms.RecordStoreNotFoundException;

public class ImageStore {
    Image image = null;
    public RecordStore rs = null;
    public RecordStore rs1 = null;
    static final String REC_STORE = "ReadWriteImage";
    static final String REC_STORE_RS1 = "ReadWriteData";
    InputStream is = null;
    Image defaultImg;
    RecordStore rStore;

    public boolean saveRMSImage(String record, Image img) {
        try {
            this.rStore = RecordStore.openRecordStore((String)record, (boolean)true);
            int width = img.getWidth();
            int height = img.getHeight();
            if (img == null || width < 0 || height < 0) {
                throw new IllegalArgumentException("Check arguments");
            }
            int[] imgRgbData = new int[width * height];
            try {
                img.getRGB(imgRgbData, 0, width, 0, 0, width, height);
            }
            catch (Exception e) {
                return false;
            }
            try {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                DataOutputStream dos = new DataOutputStream(baos);
                dos.writeUTF(record);
                for (int i = 0; i < imgRgbData.length; ++i) {
                    dos.writeInt(imgRgbData[i]);
                }
                if (this.rStore.getNumRecords() == 0) {
                    this.rStore.addRecord(baos.toByteArray(), 0, baos.toByteArray().length);
                } else {
                    this.rStore.setRecord(1, baos.toByteArray(), 0, baos.toByteArray().length);
                }
            }
            catch (RecordStoreNotFoundException rsnfe) {
                return false;
            }
            catch (RecordStoreException rse) {
                return false;
            }
            catch (IOException ioe) {
                return false;
            }
            this.rStore.closeRecordStore();
            return true;
        }
        catch (RecordStoreException recordstoreexception) {
            recordstoreexception.printStackTrace();
            return false;
        }
    }

    public Image loadRMSImage(String record, int width, int height) {
        try {
            RecordStore rStore = RecordStore.openRecordStore((String)record, (boolean)true);
            byte[] b = null;
            String imagename = null;
            Image image = null;
            try {
                int i = rStore.getNumRecords();
                for (int j = 1; j < i + 1; ++j) {
                    if (rStore.getRecord(j) == null) continue;
                    b = rStore.getRecord(j);
                    ByteArrayInputStream bin = new ByteArrayInputStream(b);
                    DataInputStream din = new DataInputStream(bin);
                    imagename = din.readUTF();
                    int remaining = (b.length - imagename.getBytes().length - 2) / 4;
                    int[] rawdata = new int[remaining];
                    for (int k = 0; k < rawdata.length; ++k) {
                        rawdata[k] = din.readInt();
                    }
                    image = Image.createRGBImage((int[])rawdata, (int)width, (int)height, (boolean)true);
                    bin.reset();
                    din.close();
                    din = null;
                    return image;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                return this.defaultImg;
            }
            catch (RecordStoreException recordstoreexception) {
                recordstoreexception.printStackTrace();
                return this.defaultImg;
            }
        }
        catch (RecordStoreException recordstoreexception) {
            recordstoreexception.printStackTrace();
            return this.defaultImg;
        }
        return this.defaultImg;
    }

    private Image rescaleImage(Image image, int width, int height) {
        int sourceWidth = image.getWidth();
        int sourceHeight = image.getHeight();
        Image newImage = Image.createImage((int)width, (int)height);
        Graphics g = newImage.getGraphics();
        for (int y = 0; y < height; ++y) {
            for (int x = 0; x < width; ++x) {
                g.setClip(x, y, 1, 1);
                int dx = x * sourceWidth / width;
                int dy = y * sourceHeight / height;
                g.drawImage(image, x - dx, y - dy, 20);
            }
        }
        return Image.createImage((Image)newImage);
    }

    public void stringStore(String data, String record) {
        try {
            this.rs1 = RecordStore.openRecordStore((String)record, (boolean)true);
            byte[] bytes = data.getBytes();
            if (this.rs1.getNumRecords() == 0) {
                this.rs1.addRecord(bytes, 0, bytes.length);
            } else {
                this.rs1.setRecord(1, bytes, 0, bytes.length);
            }
            this.rs1.closeRecordStore();
        }
        catch (RecordStoreException ex) {
            ex.printStackTrace();
        }
    }

    public String getRecord(String record, int i) {
        System.out.println("open" + record);
        String str = "";
        try {
            this.rs1 = RecordStore.openRecordStore((String)record, (boolean)true);
            if (this.rs1.getNumRecords() == 0) {
                return null;
            }
            byte[] b = this.rs1.getRecord(1);
            str = new String(b, 0, b.length);
        }
        catch (RecordStoreException ex) {
            System.out.println((Object)((Object)ex) + "problem" + record);
            ex.printStackTrace();
        }
        return str;
    }
}

