/*
 * Decompiled with CFR 0.152.
 */
package net.phys2d.raw.shapes;

import net.phys2d.math.ROVector2f;
import net.phys2d.math.Vector2f;
import net.phys2d.raw.shapes.AABox;
import net.phys2d.raw.shapes.AbstractShape;
import net.phys2d.raw.shapes.DynamicShape;

public class Polygon
extends AbstractShape
implements DynamicShape {
    protected Vector2f[] vertices;
    protected float area;
    protected Vector2f centroid;

    public Polygon(Vector2f[] vertices) {
        if (vertices.length < 3) {
            throw new IllegalArgumentException("A polygon can not have fewer than 3 edges!");
        }
        this.vertices = new Vector2f[vertices.length];
        for (int i = 0; i < vertices.length; ++i) {
            this.vertices[i] = new Vector2f(vertices[i]);
        }
        float r = this.computeBoundingCircleRadius();
        this.bounds = new AABox(r * 2.0f, r * 2.0f);
        this.area = this.computeArea();
        this.centroid = this.computeCentroid();
    }

    protected Polygon() {
    }

    protected float computeArea() {
        this.area = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f v1 = this.vertices[i];
            Vector2f v2 = this.vertices[(i + 1) % this.vertices.length];
            this.area += v1.x * v2.y;
            this.area -= v2.x * v1.y;
        }
        return Math.abs(this.area / 2.0f);
    }

    protected Vector2f computeCentroid() {
        float x = 0.0f;
        float y = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f v1 = this.vertices[i];
            Vector2f v2 = this.vertices[(i + 1) % this.vertices.length];
            x += (v1.x + v2.x) * (v1.x * v2.y - v2.x * v1.y);
            y += (v1.y + v2.y) * (v1.x * v2.y - v2.x * v1.y);
        }
        return new Vector2f(x / (6.0f * this.area), y / (6.0f * this.area));
    }

    protected float computeBoundingCircleRadius() {
        float r = 0.0f;
        for (int i = 0; i < this.vertices.length; ++i) {
            float l = this.vertices[i].x * this.vertices[i].x + this.vertices[i].y * this.vertices[i].y;
            r = l > r ? l : r;
        }
        return (float)Math.sqrt(r);
    }

    public float getArea() {
        return this.area;
    }

    public Vector2f getCentroid() {
        return this.centroid;
    }

    public Vector2f[] getVertices() {
        Vector2f[] roVertices = new Vector2f[this.vertices.length];
        for (int i = 0; i < this.vertices.length; ++i) {
            roVertices[i] = this.vertices[i];
        }
        return roVertices;
    }

    public boolean isConvex() {
        int l = this.vertices.length;
        for (int i = 0; i < this.vertices.length; ++i) {
            Vector2f x = this.vertices[i];
            Vector2f y = this.vertices[(i + 1) % l];
            Vector2f z = this.vertices[(i + 2) % l];
            if (!((z.x - x.x) * (y.y - x.y) - (y.x - x.x) * (z.y - x.y) >= 0.0f)) continue;
            return false;
        }
        return true;
    }

    public Vector2f[] getVertices(ROVector2f displacement, float rotation) {
        Vector2f[] retVertices = new Vector2f[this.vertices.length];
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        for (int i = 0; i < this.vertices.length; ++i) {
            float x = this.vertices[i].x * cos - this.vertices[i].y * sin;
            float y = this.vertices[i].y * cos + this.vertices[i].x * sin;
            retVertices[i] = new Vector2f(x += displacement.getX(), y += displacement.getY());
        }
        return retVertices;
    }

    public Vector2f getCentroid(ROVector2f displacement, float rotation) {
        float cos = (float)Math.cos(rotation);
        float sin = (float)Math.sin(rotation);
        return new Vector2f(this.centroid.x * cos - this.centroid.y * sin + displacement.getX(), this.centroid.y * cos + this.centroid.x * sin + displacement.getY());
    }

    public boolean contains(Vector2f p) {
        return false;
    }

    public ROVector2f getNearestPoint(ROVector2f p) {
        return null;
    }

    public float getSurfaceFactor() {
        return this.getArea();
    }
}

