/*
 * Decompiled with CFR 0.152.
 */
package json.me.util;

import java.util.Hashtable;
import json.me.JSONTokener;
import json.me.util.XML;

public class XMLTokener
extends JSONTokener {
    public static final Hashtable entity = new Hashtable<String, Character>(8);

    public XMLTokener(String string) {
        super(string);
    }

    public String nextCDATA() {
        int n;
        StringBuffer stringBuffer = new StringBuffer();
        do {
            if ((n = this.next()) == 0) {
                throw this.syntaxError("Unclosed CDATA.");
            }
            stringBuffer.append((char)n);
        } while ((n = stringBuffer.length() - 3) < 0 || stringBuffer.charAt(n) != ']' || stringBuffer.charAt(n + 1) != ']' || stringBuffer.charAt(n + 2) != '>');
        stringBuffer.setLength(n);
        return stringBuffer.toString();
    }

    public Object nextContent() {
        char c;
        while (XMLTokener.a(c = this.next())) {
        }
        if (c == '\u0000') {
            return null;
        }
        if (c == '<') {
            return XML.LT;
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            if (c == '<' || c == '\u0000') {
                this.back();
                return stringBuffer.toString().trim();
            }
            if (c == '&') {
                stringBuffer.append(this.nextEntity(c));
            } else {
                stringBuffer.append(c);
            }
            c = this.next();
        }
    }

    public Object nextEntity(char c) {
        char c2;
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            boolean bl;
            char c3 = c2 = this.next();
            switch (c2) {
                case '0': 
                case '1': 
                case '2': 
                case '3': 
                case '4': 
                case '5': 
                case '6': 
                case '7': 
                case '8': 
                case '9': 
                case 'A': 
                case 'B': 
                case 'C': 
                case 'D': 
                case 'E': 
                case 'F': 
                case 'G': 
                case 'H': 
                case 'I': 
                case 'J': 
                case 'K': 
                case 'L': 
                case 'M': 
                case 'N': 
                case 'O': 
                case 'P': 
                case 'Q': 
                case 'R': 
                case 'S': 
                case 'T': 
                case 'U': 
                case 'V': 
                case 'W': 
                case 'X': 
                case 'Y': 
                case 'Z': 
                case 'a': 
                case 'b': 
                case 'c': 
                case 'd': 
                case 'e': 
                case 'f': 
                case 'g': 
                case 'h': 
                case 'i': 
                case 'j': 
                case 'k': 
                case 'l': 
                case 'm': 
                case 'n': 
                case 'o': 
                case 'p': 
                case 'q': 
                case 'r': 
                case 's': 
                case 't': 
                case 'u': 
                case 'v': 
                case 'w': 
                case 'x': 
                case 'y': 
                case 'z': {
                    bl = true;
                    break;
                }
                default: {
                    bl = false;
                }
            }
            if (!bl && c2 != '#') break;
            stringBuffer.append(Character.toLowerCase(c2));
        }
        if (c2 != ';') {
            throw this.syntaxError("Missing ';' in XML entity: &" + stringBuffer);
        }
        String string = stringBuffer.toString();
        if ((stringBuffer = entity.get(string)) != null) {
            return stringBuffer;
        }
        return c + string + ";";
    }

    public Object nextMeta() {
        char c;
        while (XMLTokener.a(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped meta tag.");
            }
            case '<': {
                return XML.LT;
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                do {
                    if ((c = this.next()) != '\u0000') continue;
                    throw this.syntaxError("Unterminated string.");
                } while (c != c2);
                return Boolean.TRUE;
            }
        }
        while (!XMLTokener.a(c = this.next())) {
            switch (c) {
                case '\u0000': 
                case '!': 
                case '\"': 
                case '\'': 
                case '/': 
                case '<': 
                case '=': 
                case '>': 
                case '?': {
                    this.back();
                    return Boolean.TRUE;
                }
            }
        }
        return Boolean.TRUE;
    }

    public Object nextToken() {
        char c;
        while (XMLTokener.a(c = this.next())) {
        }
        switch (c) {
            case '\u0000': {
                throw this.syntaxError("Misshaped element.");
            }
            case '<': {
                throw this.syntaxError("Misplaced '<'.");
            }
            case '>': {
                return XML.GT;
            }
            case '/': {
                return XML.SLASH;
            }
            case '=': {
                return XML.EQ;
            }
            case '!': {
                return XML.BANG;
            }
            case '?': {
                return XML.QUEST;
            }
            case '\"': 
            case '\'': {
                char c2 = c;
                StringBuffer stringBuffer = new StringBuffer();
                while (true) {
                    if ((c = this.next()) == '\u0000') {
                        throw this.syntaxError("Unterminated string.");
                    }
                    if (c == c2) {
                        return stringBuffer.toString();
                    }
                    if (c == '&') {
                        stringBuffer.append(this.nextEntity(c));
                        continue;
                    }
                    stringBuffer.append(c);
                }
            }
        }
        StringBuffer stringBuffer = new StringBuffer();
        while (true) {
            stringBuffer.append(c);
            c = this.next();
            if (XMLTokener.a(c)) {
                return stringBuffer.toString();
            }
            switch (c) {
                case '\u0000': 
                case '!': 
                case '/': 
                case '=': 
                case '>': 
                case '?': 
                case '[': 
                case ']': {
                    this.back();
                    return stringBuffer.toString();
                }
                case '\"': 
                case '\'': 
                case '<': {
                    throw this.syntaxError("Bad character in a name.");
                }
            }
        }
    }

    private static boolean a(char c) {
        switch (c) {
            case '\t': 
            case '\n': 
            case '\r': 
            case ' ': {
                return true;
            }
        }
        return false;
    }

    static {
        entity.put("amp", XML.AMP);
        entity.put("apos", XML.APOS);
        entity.put("gt", XML.GT);
        entity.put("lt", XML.LT);
        entity.put("quot", XML.QUOT);
    }
}

