/*
 * Decompiled with CFR 0.152.
 */
package com.sensiblemobiles.game;

import at.emini.physics2D.World;
import com.sensiblemobiles.Templet.GameMidlet;
import com.sensiblemobiles.Templet.LoadLavel;
import com.sensiblemobiles.Templet.MenuCanvas;
import com.sensiblemobiles.game.DrawShapes;
import com.sensiblemobiles.game.WorldInfo;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class GraphicsWorld
extends World {
    public static int radius;
    public static int transformId;
    public static int menuId;
    private Image[] menu;
    private Image slected;
    private Image unselected;
    public static int translateX;
    public static int translateY;
    private DrawShapes c = new DrawShapes();

    public GraphicsWorld(World loadWorld) {
        super(loadWorld);
        this.menu = new Image[5];
        if (GameMidlet.is_501) {
            this.menu = new Image[4];
        }
        this.loadImage();
    }

    private void loadImage() {
        try {
            for (int i = 0; i < this.menu.length; ++i) {
                this.menu[i] = Image.createImage((String)("/res/menu/M" + i + ".png"));
            }
            this.slected = Image.createImage((String)"/res/menu/select.png");
            this.unselected = Image.createImage((String)"/res/menu/unselect.png");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void draw(Graphics g) {
        int bodyCount = WorldInfo.BodyCount;
        if (LoadLavel.IsDisplayed()) {
            for (int i = 0; i < bodyCount; ++i) {
                byte j = (byte)WorldInfo.body[i].shape().getId();
                if (j <= 3 || j == 6 || j == 15 || j == 18) {
                    this.c.draw(g, WorldInfo.body[i]);
                    continue;
                }
                if (j >= 4 && j <= 5 || j >= 7 && j <= 14 || j == 16 || j == 17) {
                    this.c.DrawRectangel(g, WorldInfo.body[i]);
                    continue;
                }
                if (j != 19) continue;
                transformId = WorldInfo.body[i].getId();
            }
            this.drawLandScape(g);
        }
        if (!LoadLavel.IsDisplayed()) {
            translateX = -WorldInfo.world.findBodyById(menuId).positionFX().xAsInt() + g.getClipWidth() / 2;
            translateY = -WorldInfo.world.findBodyById(menuId).positionFX().yAsInt() + g.getClipHeight() / 2;
            g.translate(translateX, translateY);
            this.drawMenu(g);
            g.translate(translateX * -1, translateY * -1);
        }
    }

    public void drawLandScape(Graphics g) {
        for (int j = 0; j < WorldInfo.land.segmentCount(); ++j) {
            g.drawLine(WorldInfo.land.startPoint(j).xAsInt(), WorldInfo.land.startPoint(j).yAsInt(), WorldInfo.land.endPoint(j).xAsInt(), WorldInfo.land.endPoint(j).yAsInt());
        }
    }

    private void drawMenu(Graphics g) {
        int bodyCount = WorldInfo.BodyCount;
        for (int i = 0; i < bodyCount; ++i) {
            if (LoadLavel.IsDisplayed()) continue;
            radius = WorldInfo.body[i].shape().getBoundingRadiusSquare();
            double radius1 = Math.sqrt(radius);
            radius = (int)radius1;
            if (WorldInfo.body[i].shape().getId() == MenuCanvas.slectionIndex) {
                g.setColor(255, 0, 255);
                g.drawImage(this.slected, WorldInfo.body[i].positionFX().xAsInt(), WorldInfo.body[i].positionFX().yAsInt(), 3);
                g.drawImage(this.menu[MenuCanvas.slectionIndex], WorldInfo.body[i].positionFX().xAsInt(), WorldInfo.body[i].positionFX().yAsInt(), 3);
                continue;
            }
            if (WorldInfo.body[i].shape().getId() < this.menu.length) {
                g.setColor(0);
                g.drawImage(this.unselected, WorldInfo.body[i].positionFX().xAsInt(), WorldInfo.body[i].positionFX().yAsInt(), 3);
                g.drawImage(this.menu[WorldInfo.body[i].shape().getId()], WorldInfo.body[i].positionFX().xAsInt(), WorldInfo.body[i].positionFX().yAsInt(), 3);
                continue;
            }
            if (WorldInfo.body[i].shape().getId() != 6) continue;
            menuId = WorldInfo.body[i].getId();
        }
    }
}

