/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame;

import com.pipogame.Input;
import com.pipogame.ScreenManager;
import com.pipogame.Store;
import com.pipogame.util.Drawer;
import com.pipogame.util.PFont;
import java.io.IOException;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GameScreen {
    public ScreenManager screenManager;
    boolean exiting;
    protected boolean initialized;
    protected boolean loaded;
    protected int transitionOnTime;
    protected int transitionOffTime;
    protected float transitionPos = 1.0f;
    protected float tranPos2;
    protected int screenState = 1;
    private int timeCancelCount;
    private int timeCancelInput = 300;
    protected static int _width;
    protected static int _height;
    protected int translateX;
    protected int translateY;
    protected Store asset;

    public void loadContent() throws Exception {
        this.loaded = true;
    }

    public void initialize() throws Exception {
        this.initialized = true;
    }

    public abstract void handleInput(Input var1, int var2);

    /*
     * Enabled aggressive block sorting
     */
    boolean preHandleInput(Input input, int frameTime) {
        if (!input.isSameKeyState() && !input.isSameKeyCode()) {
            this.timeCancelCount = 0;
            return true;
        }
        this.timeCancelCount += frameTime;
        if (this.timeCancelCount >= this.timeCancelInput) {
            this.timeCancelCount = 0;
            return true;
        }
        input.resetKey();
        return false;
    }

    public abstract void update(int var1, boolean var2);

    boolean preUpdate(int frameTime, boolean covered) {
        if (this.exiting) {
            this.screenState = 4;
            if (!this.updateTransition(frameTime, this.transitionOffTime, 1)) {
                this.onScreenExiting();
                this.screenManager.removeCurrentScreen();
                this.onScreenExited();
                PFont.free();
                return false;
            }
        } else {
            this.screenState = covered ? (this.updateTransition(frameTime, this.transitionOffTime, 1) ? 4 : 3) : (this.updateTransition(frameTime, this.transitionOnTime, -1) ? 1 : 2);
        }
        return true;
    }

    public abstract void draw(Graphics var1, int var2);

    public void finalize() {
        this.loaded = false;
    }

    private boolean updateTransition(int frameTime, int time, int direction) {
        float transDelta = time == 0 ? 1.0f : (float)frameTime / (float)time;
        this.transitionPos += transDelta * (float)direction;
        this.tranPos2 = this.transitionPos * this.transitionPos;
        if (direction < 0 && this.transitionPos < 0.0f || direction > 0 && this.transitionPos > 1.0f) {
            if (this.transitionPos < 0.0f) {
                this.transitionPos = 0.0f;
                this.tranPos2 = 0.0f;
            } else {
                this.transitionPos = 1.0f;
                this.tranPos2 = 1.0f;
            }
            return false;
        }
        return true;
    }

    public final Image loadImage(int key) throws IOException {
        return Image.createImage((String)this.asset.getString(key));
    }

    public final void exitScreen() {
        if (this.transitionOffTime == 0) {
            this.onScreenExiting();
            this.screenManager.removeCurrentScreen();
            this.onScreenExited();
        } else {
            this.exiting = true;
        }
    }

    public void onExitGame() {
    }

    protected void onScreenExited() {
    }

    protected void onScreenExiting() {
    }

    public void setTimeCancelInput(int time) {
        this.timeCancelInput = time;
    }

    public boolean isExiting() {
        return this.exiting;
    }

    public static int width() {
        return _width;
    }

    public static int height() {
        return _height;
    }

    public ScreenManager getScreenManager() {
        return this.screenManager;
    }

    protected final void drawFade(Graphics g, int color) {
        Drawer.drawBg(g, 0, 0, _width, _height, (int)(this.transitionPos * 256.0f) << 24 | color & 0xFFFFFF);
    }

    protected final void drawFade(Graphics g, int color, float transparent) {
        Drawer.drawBg(g, 0, 0, _width, _height, (int)(transparent * 256.0f) << 24 | color & 0xFFFFFF);
    }

    public static void fillScreen(Graphics g, int color) {
        g.setColor(color);
        g.fillRect(0, 0, _width, _height);
    }

    public static class ScreenState {
        public static final int TRANSITION_ON = 1;
        public static final int ACTIVE = 2;
        public static final int HIDDEN = 3;
        public static final int TRANSITION_OFF = 4;
    }
}

