/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.components.Point;
import com.pipogame.components.SortedList;
import com.pipogame.fad.BagScreen;
import com.pipogame.fad.Item;
import com.pipogame.fad.ScoreFly;
import com.pipogame.fad.SubMenu;
import com.pipogame.fad.SumUpScreen;
import com.pipogame.fad.scen.NormalDayScreen;
import com.pipogame.fad.strings;
import com.pipogame.util.BlinkingText;
import com.pipogame.util.Drawer;
import com.pipogame.util.ImageTool;
import com.pipogame.util.MathExt;
import com.pipogame.util.PFont;
import com.pipogame.util.Util;
import java.util.Random;
import java.util.Vector;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public abstract class GameplayScreen
extends GameScreen {
    protected Item[][] tableOfItems;
    protected Point pointerPos;
    protected Point selectedPos;
    protected Point copyOfSelectedItemPos;
    protected Point copyOfPointerPos;
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    protected Image[] itemImages;
    protected Image gridImage;
    protected Image frameImage;
    protected Image shopBtnImage;
    protected Image menuBtnImage;
    protected Image timeBarImage;
    protected Image timeoutImage;
    protected Image axeImage;
    protected Image axeTrayImage;
    protected Image itemNoneImage = Image.createRGBImage((int[])new int[]{0}, (int)1, (int)1, (boolean)true);
    protected Image bgrImage;
    protected Image starImage;
    protected SubMenu subMenu;
    protected GameSprite pointerSprite;
    protected GameSprite chosenSprite;
    protected GameSprite thunderboltSprite;
    protected GameSprite boomSprite;
    protected GameSprite hourGlassSprite;
    protected GameSprite coinsSprite;
    protected BagScreen bagScreen;
    protected GameSprite[] itemEffectSprites;
    private ScoreFly scoreFly;
    private BlinkingText noMoveBlinkingText;
    protected Vector eatenItemsOnSpecial = new Vector(20);
    protected SortedList eatingItemsList = new SortedList(10, 3);
    protected Vector slidingItemsList = new Vector(30, 5);
    protected int tbl_corner_x = 12;
    protected int tbl_corner_y = 47;
    protected boolean isSelected;
    protected boolean isXchanging2Items;
    protected boolean isReXchanging2Items;
    protected boolean isItemXchanged;
    protected boolean isSlidingDown;
    protected boolean isEatingItems;
    protected boolean isHerbFlyReversed;
    private boolean isScoring;
    protected boolean noMove;
    protected boolean hasHerb;
    protected boolean isAxeFull;
    protected byte specialItemUsed;
    public static final byte BOOM_USED = 1;
    public static final byte THUNDERBOLT_USED = 2;
    public static final byte AXE_USED = 3;
    public static final byte EXCHANGE_USED = 4;
    private int exchangeSelected;
    public static final Point[] BOOM_THUNDERBOLT_DELTA = new Point[]{null, new Point(4, 4), new Point(10, 41)};
    protected boolean isSpecialItemTriggered;
    private int dir1;
    private int dir2;
    private int dir3;
    private int dir4;
    private int dir5;
    private int dir6;
    private int dir7;
    private int dir8;
    protected int gameState = 2;
    protected int timePlayed;
    protected int MAX_TIME_PLAY = 120000;
    protected int combos;
    protected int scores;
    protected int animScore;
    protected int turnScore;
    protected boolean isLevelUp;
    protected int MAX_SCORE = 10000;
    protected final int[] numEatenItems = new int[7];
    protected final int[] turnCounter = new int[7];
    protected final int[] basicScores = new int[7];
    protected int eatFourOrFive;
    protected final Point[] effectDelta = new Point[17];
    protected static Point[] EFFECT_DELTA = new Point[]{new Point(18, 69), new Point(0, 0), new Point(9, 35), new Point(12, 19), new Point(17, 0), new Point(17, 0), new Point(19, 26), new Point(18, 69), new Point(12, 19), new Point(19, 26), new Point(12, 17), new Point(12, 17), new Point(9, 32), new Point(12, 19)};
    protected int seventhItem;
    protected byte NUM_OF_ITEMS = (byte)7;
    protected Image[] obstacleImages;
    protected boolean hasRock = true;
    public static final byte MAX_RC = 8;
    public static final byte ITEM_SIZE = 27;
    public static final byte MAX_NUM_OF_ITEMS = 7;
    public static final byte ITEM_NONE = 7;
    protected static byte ITEM_HERB = 1;
    public static final byte ITEM_ROCK = 8;
    public static final byte ITEM_BOOM = 9;
    public static final byte ITEM_LIFE = 10;
    public static final byte ITEM_EXCHG = 11;
    public static final byte ITEM_TIME = 12;
    public static final byte ITEM_CITIZEN = 13;
    public static final byte ITEM_THUNDERBOLT = 14;
    public static final byte ITEM_PIPO = 15;
    public static final byte ITEM_MOBSTER = 16;
    public static final byte MAX_ITEMS = 17;
    public static final byte OBST_NONE = -1;
    public static final byte OBST_ICE = 0;
    public static final byte OBST_ICE2 = 1;
    public static final byte OBST_LOCK = 2;
    public static final byte OBST_LOCK2 = 3;
    public static final byte EFFECT_DRUG = 0;
    public static final byte EFFECT_HERB = 1;
    public static final byte EFFECT_SILK = 2;
    public static final byte EFFECT_GEM = 3;
    public static final byte EFFECT_GOLD = 4;
    public static final byte EFFECT_SILV = 5;
    public static final byte EFFECT_AQUA = 6;
    public static final byte EFFECT_GREEN = 7;
    public static final byte EFFECT_GREEN2 = 8;
    public static final byte EFFECT_PINK = 9;
    public static final byte EFFECT_PINK2 = 10;
    public static final byte EFFECT_TURQ = 11;
    public static final byte EFFECT_WHITE = 12;
    public static final byte EFFECT_YELLOW = 13;
    public static final short[] PREMULTIPLY = new short[9];
    private boolean isUnkownLand;
    String tempString = "";
    public static int land_x = 23;
    public static int land_y = 8;
    public static int window_x = 0;
    public static int window_y = 35;
    public static int menuBtn_x = 9;
    public static int button_y = 294;
    public static int shopBtn_x = 167;
    protected int maxSliding;
    private Vector emptyItemsUnderIce = new Vector(10);
    private int timeSlided;
    private int timeExchange = 250;
    protected static final float TIME_EXCHANGE = 250.0f;
    private int timeStopEating;
    private static final int TIME_STOP_EATING = 200;
    public static int timeBarX = 0;
    public static int timeout_x = 228;
    public static int timeout_y = 4;
    public static int score_y = 22;
    public static int bar_w = 209;
    private int hglassX = -5;
    private int hglassY = -2;
    private int coinX = 0;
    private int coinY = 20;
    private int countHourglass = 5000;
    private static final int COUNT_TIME = 10000;
    private int axeHeight;
    private int axePart;
    private int axeX = 103;
    private int axeY = 278;
    private int axeTrayX = 90;
    private int axeTrayY = 266;
    private static final int AXE_PART = 8;
    private int starringTimeCounter;
    private static final int STARRING_TIME = 1000;
    private static int paperX = 0;
    private static int paperY = 0;

    public void initialize() throws Exception {
        this.bagScreen = new BagScreen(this);
        this.bagScreen.screenManager = this.screenManager;
        this.bagScreen.initialize();
        this.initParams(this.screenManager.screenType);
        ITEM_HERB = 1;
        for (int i = 0; i < PREMULTIPLY.length; i = (int)((byte)(i + 1))) {
            GameplayScreen.PREMULTIPLY[i] = (short)(i * 27);
        }
        this.transitionOnTime = 1000;
        this.transitionOffTime = 600;
        this.setTimeCancelInput(500);
        this.tableOfItems = new Item[8][8];
        Random ran = Util.RANDOM;
        Store store = this.screenManager.store;
        if (store.getBoolean(strings.SAVED)) {
            this.seventhItem = store.getInt(strings.SEVENTH_ITEM);
            int[][] items = store.get2DArray(strings.STATUS);
            int[][] obsts = store.get2DArray(strings.OBSTACLES);
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    this.tableOfItems[i][j] = new Item(i, j, items[i][j]);
                    this.tableOfItems[i][j].obstacle = (byte)obsts[i][j];
                }
            }
            this.scores = this.animScore = store.getInt(strings.SCORES);
            this.timePlayed = store.getInt(strings.TIME_PLAYED);
            this.noMove = !this.checkHasMove();
            this.deleteLastSavedData();
        } else {
            this.seventhItem = ran.nextInt(3);
            this.generateTable(ran);
            this.eatFourOrFive = 0;
        }
        this.pointerPos = new Point();
        this.selectedPos = new Point();
        this.copyOfSelectedItemPos = new Point();
        this.copyOfPointerPos = new Point();
        super.initialize();
    }

    private void generateTable(Random ran) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.tableOfItems[i][j] = new Item(i, j, PREMULTIPLY[j] + this.tbl_corner_x, PREMULTIPLY[i] + this.tbl_corner_y, ran.nextInt(this.NUM_OF_ITEMS));
            }
        }
        Vector list = new Vector(20);
        this.checkAllRowAndColumn(list);
        int c = 0;
        do {
            for (int i = 0; i < list.size(); ++i) {
                ((Point)list.elementAt(i)).setStatus(ran.nextInt(this.NUM_OF_ITEMS));
            }
            this.fixSpecialItems(this.tableOfItems);
            this.checkAllRowAndColumn(list);
        } while (c <= 10 && (!list.isEmpty() || !this.checkHasMove()));
    }

    public void loadContent() throws Exception {
        if (this.screenManager.handleSoftkeyByTouch && this.screenManager.screenType == 2) {
            this.screenManager.drawSoftkeyPlace = true;
        }
        this.setBasicScores(this.basicScores);
        this.MAX_SCORE = this.getMaxScore();
        this.generateTransitionParams(Util.RANDOM);
        this.asset = Store.loadJar(strings.SHARE_FILE);
        this.scoreFly = new ScoreFly(this.tbl_corner_x, this.tbl_corner_y, this.loadImage(58));
        this.paperTopImage = this.loadImage(0);
        this.paperBotImage = this.loadImage(1);
        this.paperMidImage = this.loadImage(2);
        this.chosenSprite = new GameSprite(this.loadImage(3), 8, 1);
        this.gridImage = ImageTool.changeImageOpacity(this.loadImage(4), 0.8f);
        this.frameImage = this.loadImage(5);
        this.shopBtnImage = this.loadImage(6);
        this.menuBtnImage = this.loadImage(7);
        this.timeBarImage = this.loadImage(18);
        this.timeoutImage = ImageTool.changeImageOpacity(this.loadImage(19), 0.8f);
        this.axeImage = this.loadImage(20);
        this.axeTrayImage = this.loadImage(21);
        this.axeHeight = this.axeImage.getHeight();
        this.starImage = this.loadImage(22);
        this.obstacleImages = this.getObstacleImages();
        this.pointerSprite = new GameSprite(this.loadImage(8), 12, 1);
        this.subMenu = new SubMenu(this);
        this.subMenu.load(this.asset);
        this.thunderboltSprite = new GameSprite(this.loadImage(23), 10, 1);
        this.boomSprite = new GameSprite(this.loadImage(24), 13, 1);
        this.coinsSprite = new GameSprite(this.loadImage(61), 3, 1);
        this.hourGlassSprite = new GameSprite(this.loadImage(62), 4, 1);
        this.coinsSprite.setTimeSequence(200);
        this.coinsSprite.setFrameSequence(new int[]{0, 1, 2, 1});
        this.hourGlassSprite.setTimeSequence(150);
        this.noMoveBlinkingText = new BlinkingText(PFont.toBytesIndex(this.asset.getString(69), null), 400);
        this.asset = new Store(strings.ITEMS_FILE, 2);
        Image landImage = this.loadLandImage();
        this.bgrImage = ImageTool.createImage(_width, _height);
        Graphics g = this.bgrImage.getGraphics();
        g.setColor(0);
        g.fillRect(0, 0, _width, _height);
        g.drawImage(landImage, land_x, land_y, 0);
        if (this.screenManager.screenType == 1) {
            g.fillRect(280, 0, 40, _height);
        }
        this.drawPaperImage(g);
        this.drawWindow(g, window_x, window_y);
        this.drawGrid(g);
        this.itemImages = new Image[17];
        this.setItemImages(this.itemImages);
        this.itemImages[7] = this.itemNoneImage;
        this.pointerSprite.setPosition(this.tbl_corner_x + PREMULTIPLY[this.pointerPos.getY()], this.tbl_corner_y + PREMULTIPLY[this.pointerPos.getX()]);
        this.pointerSprite.setTimeSequence(70);
        this.chosenSprite.setTimeSequence(30);
        this.chosenSprite.setPosition(this.tbl_corner_x, this.tbl_corner_y);
        this.itemEffectSprites = new GameSprite[7];
        this.setItemEffectSprites(this.itemEffectSprites);
        this.setDeltaEffect(this.effectDelta);
        this.asset = null;
    }

    public void handleInput(Input input, int frameTime) {
        if (this.screenState == 2) {
            switch (this.gameState) {
                case 64: {
                    this.subMenu.handleInput(input);
                    break;
                }
                case 2: {
                    if (input.getKeyState() == 0 && !input.touchSupported) {
                        switch (input.getKeyCode()) {
                            case 52: {
                                this.bagScreen.useItem(1);
                                break;
                            }
                            case 53: {
                                this.bagScreen.useItem(2);
                                break;
                            }
                            case 54: {
                                this.bagScreen.useItem(3);
                                break;
                            }
                            case 55: {
                                this.bagScreen.useItem(4);
                                break;
                            }
                            case 56: {
                                this.bagScreen.useItem(5);
                            }
                        }
                    }
                    if (this.isXchanging2Items || this.isReXchanging2Items || this.isItemXchanged || this.isSlidingDown || this.isEatingItems || this.isSpecialItemTriggered) break;
                    short i = this.pointerPos.getX();
                    short j = this.pointerPos.getY();
                    if (input.isUpPrd()) {
                        this.movePointer(i, j, -1, 0);
                    } else if (input.isDownPrd()) {
                        this.movePointer(i, j, 1, 0);
                    } else if (input.isRightPrd()) {
                        this.movePointer(i, j, 0, 1);
                    } else if (input.isLeftPrd()) {
                        this.movePointer(i, j, 0, -1);
                    } else if (input.isFirePrd()) {
                        if (this.specialItemUsed == 4) {
                            ++this.exchangeSelected;
                            if (this.exchangeSelected == 2) {
                                Item p1 = this.tableOfItems[this.pointerPos.getX()][this.pointerPos.getY()];
                                Item p2 = this.tableOfItems[this.selectedPos.getX()][this.selectedPos.getY()];
                                byte stt = p1.getStatus();
                                p1.setStatus(p2.getStatus());
                                p2.setStatus(stt);
                                stt = p1.obstacle;
                                p1.obstacle = p2.obstacle;
                                p2.obstacle = stt;
                                this.exchangeSelected = 0;
                                this.specialItemUsed = 0;
                                this.bagScreen.useDone();
                                Vector tempList = new Vector(10, 10);
                                this.checkRowAndColumn(this.pointerPos, this.eatingItemsList, tempList);
                                this.checkRowAndColumn(this.selectedPos, this.eatingItemsList, tempList);
                                boolean bl = this.isHerbFlyReversed = this.hasHerb && GameplayScreen.checkHerbFlyDirection(this.eatingItemsList);
                                if (this.eatingItemsList.size() > 0) {
                                    this.isEatingItems = true;
                                    ++this.combos;
                                    this.turnScore = this.score(this.combos);
                                    this.findEmptyItems(this.pointerPos, this.emptyItemsUnderIce);
                                    this.findEmptyItems(this.selectedPos, this.emptyItemsUnderIce);
                                    this.scores += this.turnScore;
                                    this.isScoring = true;
                                    this.scoreFly.score = this.turnScore;
                                } else {
                                    this.emptyItemsUnderIce.removeAllElements();
                                    this.findEmptyItems(this.pointerPos, this.emptyItemsUnderIce);
                                    this.findEmptyItems(this.selectedPos, this.emptyItemsUnderIce);
                                    if (this.emptyItemsUnderIce.size() > 0) {
                                        this.replaceItems();
                                        this.isSlidingDown = true;
                                    } else {
                                        this.noMove = !this.checkHasMove();
                                    }
                                }
                            }
                        }
                        this.isSelected = !this.isSelected;
                        this.selectedPos.copy(this.pointerPos);
                        this.copyOfSelectedItemPos.copy(this.tableOfItems[i][j]);
                        this.chosenSprite.setPosition(this.copyOfSelectedItemPos.getX(), this.copyOfSelectedItemPos.getY());
                    } else if (input.isSoftLeftPrd()) {
                        this.isSelected = false;
                        this.soft1Pressed();
                    } else if (input.isSoftRightPrd()) {
                        this.isSelected = false;
                        this.soft2Pressed();
                    }
                    if (!input.isUpPrd() && !input.isDownPrd() && !input.isLeftPrd() && !input.isRightPrd()) break;
                    Item p = this.tableOfItems[this.pointerPos.getX()][this.pointerPos.getY()];
                    if (this.isSelected && this.specialItemUsed != 4) {
                        if (Math.abs(this.pointerPos.getX() - i) == 1 || Math.abs(this.pointerPos.getY() - j) == 1) {
                            this.isSelected = false;
                            this.isXchanging2Items = true;
                            this.copyOfPointerPos.copy(p);
                            this.chosenSprite.reset();
                            break;
                        }
                        this.pointerPos.setAllFields(i, j, 0);
                        break;
                    }
                    this.pointerSprite.setPosition(p.getX(), p.getY());
                }
            }
        }
    }

    private void findEmptyItems(Point itemPos, Vector emptyList) {
        Item itemDown;
        Item item = this.tableOfItems[itemPos.getX()][itemPos.getY()];
        for (int k = item.i + 1; k < 8 && (itemDown = this.tableOfItems[k][item.j]).getStatus() == 7; ++k) {
            GameplayScreen.addToList(this.emptyItemsUnderIce, itemDown);
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void update(int frameTime, boolean covered) {
        if (Math.abs(this.scores - this.animScore) >= 50) {
            this.animScore += 50 * MathExt.getSign(this.scores - this.animScore);
            if (this.animScore > this.scores) {
                this.animScore = this.scores;
            }
        } else if (this.scores != this.animScore) {
            this.animScore += 10 * MathExt.getSign(this.scores - this.animScore);
            if (Math.abs(this.animScore - this.scores) <= 10) {
                this.animScore = this.scores;
            }
        }
        block0 : switch (this.screenState) {
            case 1: {
                switch (this.gameState) {
                    case 2: {
                        this.updateTableByDir(320, this.tranPos2);
                        return;
                    }
                    case 64: {
                        this.subMenu.update(frameTime, this.tranPos2);
                    }
                }
                return;
            }
            case 4: {
                switch (this.gameState) {
                    case 32: {
                        for (int i = 0; i < 8; ++i) {
                            for (int j = 0; j < 8; ++j) {
                                this.tableOfItems[i][j].setX_Y(PREMULTIPLY[j] + this.tbl_corner_x + (int)((float)(Util.RANDOM.nextInt(12) - 6) * this.transitionPos), PREMULTIPLY[i] + this.tbl_corner_y + (int)((float)(Util.RANDOM.nextInt(12) - 6) * this.transitionPos));
                            }
                        }
                        return;
                    }
                    default: {
                        this.updateTableByDir(320, this.tranPos2);
                        return;
                    }
                }
            }
            case 2: {
                switch (this.gameState) {
                    case 64: {
                        this.subMenu.update(frameTime, 0.0f);
                        break block0;
                    }
                    case 2: {
                        this.timePlayed += frameTime;
                        this.isLevelUp = this.isLevelUp();
                        if (this.isSelected) {
                            this.chosenSprite.updateFrame(frameTime, true);
                            if (this.specialItemUsed == 3) {
                                this.eatingItemsList.removeAllElements();
                                Item onAxe = this.tableOfItems[this.selectedPos.getX()][this.selectedPos.getY()];
                                if (onAxe.obstacle > -1 | onAxe.getStatus() > 8) {
                                    this.eatingItemsList.addElement(onAxe);
                                    this.score(1);
                                    this.replaceItems();
                                    this.isSlidingDown = true;
                                    this.screenManager.cancelOneDraw();
                                } else {
                                    this.eatingItemsList.addElement(onAxe);
                                    this.isEatingItems = true;
                                }
                                this.isSelected = false;
                                this.specialItemUsed = 0;
                                this.bagScreen.useDone();
                            } else if (!this.isSpecialItemTriggered && this.specialItemUsed != 0 && this.specialItemUsed != 4) {
                                this.isSelected = false;
                                this.isSpecialItemTriggered = true;
                                short i = this.pointerPos.getX();
                                short j = this.pointerPos.getY();
                                this.eatenItemsOnSpecial.removeAllElements();
                                switch (this.specialItemUsed) {
                                    case 2: {
                                        this.eatOnThunderbolt(this.tableOfItems[i][j].getStatus(), this.eatenItemsOnSpecial);
                                        break;
                                    }
                                    case 1: {
                                        this.eatOnBoom(i, j, this.eatenItemsOnSpecial);
                                    }
                                }
                            }
                        } else if (this.isReXchanging2Items) {
                            this.isReXchanging2Items = this.exchange(this.selectedPos, this.pointerPos, frameTime);
                            if (!this.isReXchanging2Items) {
                                this.pointerPos.copy(this.selectedPos);
                            }
                        } else if (this.isXchanging2Items) {
                            this.isXchanging2Items = this.exchange(this.pointerPos, this.selectedPos, frameTime);
                            this.isItemXchanged = !this.isXchanging2Items;
                        } else if (this.isItemXchanged) {
                            Vector tempList = new Vector(10, 10);
                            this.checkRowAndColumn(this.pointerPos, this.eatingItemsList, tempList);
                            this.checkRowAndColumn(this.selectedPos, this.eatingItemsList, tempList);
                            boolean bl = this.isHerbFlyReversed = this.hasHerb && GameplayScreen.checkHerbFlyDirection(this.eatingItemsList);
                            if (this.eatingItemsList.size() > 0) {
                                this.isEatingItems = true;
                                ++this.combos;
                                this.turnScore = this.score(this.combos);
                                this.scores += this.turnScore;
                                this.isScoring = true;
                                this.scoreFly.score = this.turnScore;
                            } else {
                                this.isReXchanging2Items = true;
                            }
                            this.isItemXchanged = false;
                        } else if (this.isSlidingDown) {
                            this.isSlidingDown = this.slidingItemsDown(frameTime);
                            if (!this.isSlidingDown) {
                                this.slidingItemsList.removeAllElements();
                                this.eatingItemsList.removeAllElements();
                                this.checkAllRowAndColumn(this.eatingItemsList);
                                boolean bl = this.isHerbFlyReversed = this.hasHerb && GameplayScreen.checkHerbFlyDirection(this.eatingItemsList);
                                if (this.eatingItemsList.size() > 0) {
                                    this.isEatingItems = true;
                                    ++this.combos;
                                    this.turnScore = this.score(this.combos);
                                    this.scores += this.turnScore;
                                    this.isScoring = true;
                                    this.scoreFly.score = this.turnScore;
                                } else {
                                    this.combos = 0;
                                    this.noMove = !this.checkHasMove();
                                }
                            }
                        }
                        this.pointerSprite.updateFrame(frameTime, true);
                        if (this.isSlidingDown || this.isEatingItems || this.timePlayed <= this.MAX_TIME_PLAY) return;
                        if (this.isLevelUp) {
                            this.gameState = 4;
                            this.transitionOffTime = 1000;
                            this.screenManager.store.changeInt(strings.STAGE, 1);
                            this.screenManager.addScreen(new SumUpScreen(this));
                            if (this.isUnkownLand) {
                                this.screenManager.addScreen(new NormalDayScreen(13, 20));
                            }
                        } else {
                            this.gameState = 32;
                            this.transitionOffTime = 1500;
                            this.screenManager.store.changeInt(strings.LIFE, -1);
                            this.screenManager.addScreen(new SumUpScreen(this));
                        }
                        this.exitScreen();
                    }
                }
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, 0, 0, 0);
        block0 : switch (this.screenState) {
            case 1: 
            case 4: {
                switch (this.gameState) {
                    case 64: {
                        this.subMenu.paint(g);
                        this.drawFade(g, 0);
                        return;
                    }
                    case 2: 
                    case 4: 
                    case 32: {
                        int delta_y = (int)(this.tranPos2 * 100.0f);
                        this.drawBars(g, -delta_y);
                        this.drawHourglassAndCoins(g, frameTime, delta_y);
                        this.drawItems(g);
                        this.drawAxe(g, delta_y);
                        if (this.screenManager.screenType == 2) break;
                        g.drawImage(this.menuBtnImage, menuBtn_x, button_y + delta_y, 0);
                        g.drawImage(this.shopBtnImage, shopBtn_x, button_y + delta_y, 0);
                    }
                }
                return;
            }
            case 2: {
                switch (this.gameState) {
                    case 64: {
                        this.subMenu.paint(g);
                        break block0;
                    }
                    case 2: {
                        this.drawBars(g, 0);
                        this.drawHourglassAndCoins(g, frameTime, 0);
                        this.drawItems(g);
                        this.drawAxe(g, 0);
                        if (this.isAxeFull) {
                            this.isAxeFull = this.drawStarringAsAxeFull(g, frameTime);
                        }
                        if (!this.isSelected && !this.isEatingItems && !this.isSlidingDown || this.exchangeSelected == 1) {
                            this.pointerSprite.paint(g);
                        }
                        if (this.isSelected) {
                            this.chosenSprite.paint(g);
                        }
                        if (this.isEatingItems) {
                            this.isEatingItems = this.drawEatingItems(g, frameTime);
                            if (!this.isEatingItems) {
                                this.isSlidingDown = true;
                                this.replaceItems();
                            }
                        } else if (!this.isSlidingDown && this.isLevelUp) {
                            this.gameState = 4;
                            this.transitionOffTime = 1000;
                            this.screenManager.store.changeInt(strings.STAGE, 1);
                            this.screenManager.store.changeInt(strings.SILVER, this.scores + (int)Math.sqrt(Math.max(0, this.MAX_TIME_PLAY - this.timePlayed) / 1000) * 100);
                            this.screenManager.addScreen(new SumUpScreen(this));
                            if (this.isUnkownLand) {
                                this.screenManager.addScreen(new NormalDayScreen(13, 20));
                            }
                            this.exitScreen();
                        }
                        if (this.isSpecialItemTriggered) {
                            this.isSpecialItemTriggered = this.drawEatOnSpecialItems(g, frameTime);
                            if (!this.isSpecialItemTriggered) {
                                this.eatingItemsList.addAllElement(this.eatenItemsOnSpecial);
                                this.scores += this.score(1);
                                this.isSlidingDown = true;
                                this.replaceItems();
                                this.specialItemUsed = 0;
                                this.bagScreen.useDone();
                            }
                        }
                        if (this.isScoring) {
                            this.isScoring = this.scoreFly.paint(g, frameTime);
                        }
                        g.drawImage(this.menuBtnImage, menuBtn_x, button_y, 0);
                        g.drawImage(this.shopBtnImage, shopBtn_x, button_y, 0);
                        if (!this.noMove) return;
                        this.noMoveBlinkingText.draw(g, frameTime, 255, 0xFFFFFF);
                    }
                }
            }
        }
    }

    public void finalize() {
        this.itemImages = null;
        this.pointerSprite = null;
        this.chosenSprite = null;
        this.itemEffectSprites = null;
        this.menuBtnImage = null;
        this.shopBtnImage = null;
        this.obstacleImages = null;
        this.subMenu = null;
        this.coinsSprite = null;
        this.hourGlassSprite = null;
        this.boomSprite = null;
        this.thunderboltSprite = null;
        this.scoreFly = null;
        this.screenManager.drawSoftkeyPlace = false;
        super.finalize();
    }

    protected abstract void fixSpecialItems(Item[][] var1);

    protected void setDeltaEffect(Point[] deltaPoints) {
        System.arraycopy(EFFECT_DELTA, 0, deltaPoints, 0, 7);
    }

    protected abstract void setItemEffectSprites(GameSprite[] var1) throws Exception;

    protected abstract Image loadLandImage() throws Exception;

    protected abstract void setItemImages(Image[] var1) throws Exception;

    protected abstract void setBasicScores(int[] var1);

    public int getMaxScore() {
        return 10000;
    }

    protected final void randomlyNegative(int[] basicScores) {
        int[] arr = Util.makeRandomSubarray(7, 3);
        for (int i = 0; i < arr.length; ++i) {
            int n = arr[i];
            basicScores[n] = basicScores[n] * -1;
        }
    }

    public void makeTobeUnkownLand() {
        this.isUnkownLand = true;
    }

    private Image[] getObstacleImages() throws Exception {
        Image[] obImages = new Image[]{this.loadImage(14), this.loadImage(15), this.loadImage(16), this.loadImage(17)};
        return obImages;
    }

    protected GameSprite getEffectSprite(int spriteNumber) throws Exception {
        GameSprite sprite = null;
        switch (spriteNumber) {
            case 1: {
                sprite = new GameSprite(this.loadImage(11), 1, 9);
                break;
            }
            case 4: 
            case 5: 
            case 7: 
            case 8: 
            case 10: 
            case 11: 
            case 13: {
                sprite = new GameSprite(this.loadImage(10 + spriteNumber), 8, 1);
                break;
            }
            case 3: 
            case 6: 
            case 9: {
                sprite = new GameSprite(this.loadImage(10 + spriteNumber), 9, 1);
                break;
            }
            case 12: {
                sprite = new GameSprite(this.loadImage(22), 10, 1);
                break;
            }
            case 0: 
            case 2: {
                sprite = new GameSprite(this.loadImage(10 + spriteNumber), 11, 1);
            }
        }
        return sprite;
    }

    private boolean hasNoObstacle(int i, int j) {
        Item ip = this.tableOfItems[i][j];
        byte status = ip.getStatus();
        return ip.obstacle == -1 && (status < 7 || status > 8) || this.specialItemUsed > 0 && status != 7 && status < 15;
    }

    private void movePointer(int i, int j, int dir_i, int dir_j) {
        if (this.hasNoObstacle(i = (i + dir_i + 8) % 8, j = (j + dir_j + 8) % 8)) {
            this.pointerPos.setX_Y(i, j);
        } else {
            this.movePointer(i, j, dir_i, dir_j);
        }
    }

    public void resume() {
        this.transitionPos = 1.0f;
        this.screenState = 1;
        this.gameState = 2;
        this.screenManager.cancelOneDraw();
    }

    protected void soft1Pressed() {
        this.subMenu.gameState = this.gameState;
        this.gameState = 64;
        this.transitionPos = 1.0f;
        this.screenState = 1;
    }

    protected void soft2Pressed() {
        this.screenManager.addScreen(this.bagScreen);
        this.exitScreen();
    }

    private void checkAllRowAndColumn(Vector list) {
        list.removeAllElements();
        Vector tempList = new Vector(10, 3);
        for (int i = 0; i < 8; ++i) {
            byte stt;
            Item p;
            for (int j = 0; j < 8; ++j) {
                p = this.tableOfItems[i][j];
                stt = p.getStatus();
                if (stt >= 7) continue;
                this.checkRowAndColumn(stt, i, j, list, tempList);
            }
            p = this.tableOfItems[7][i];
            stt = p.getStatus();
            if (stt <= 8 || stt >= 15) continue;
            list.addElement(p);
        }
    }

    protected void checkRowAndColumn(Point p, Vector list, Vector tempList) {
        int j;
        int i;
        short y;
        short x = p.getX();
        byte stt = this.tableOfItems[x][y = p.getY()].getStatus();
        if (stt >= 7) {
            return;
        }
        tempList.removeAllElements();
        GameplayScreen.addToList(tempList, this.tableOfItems[x][y]);
        for (i = x - 1; i >= 0 && stt == this.tableOfItems[i][y].getStatus(); --i) {
            GameplayScreen.addToList(tempList, this.tableOfItems[i][y]);
        }
        for (i = x + 1; i < 8 && stt == this.tableOfItems[i][y].getStatus(); ++i) {
            GameplayScreen.addToList(tempList, this.tableOfItems[i][y]);
        }
        this.eatFourOrFive += GameplayScreen.colectEat4or5(tempList.size());
        GameplayScreen.colectEatableItems(tempList, list);
        tempList.addElement(this.tableOfItems[x][y]);
        for (j = y - 1; j >= 0 && stt == this.tableOfItems[x][j].getStatus(); --j) {
            GameplayScreen.addToList(tempList, this.tableOfItems[x][j]);
        }
        for (j = y + 1; j < 8 && stt == this.tableOfItems[x][j].getStatus(); ++j) {
            GameplayScreen.addToList(tempList, this.tableOfItems[x][j]);
        }
        this.eatFourOrFive += GameplayScreen.colectEat4or5(tempList.size());
        GameplayScreen.colectEatableItems(tempList, list);
    }

    protected void checkRowAndColumn(int stt, int x, int y, Vector list, Vector tempList) {
        tempList.removeAllElements();
        GameplayScreen.addToList(tempList, this.tableOfItems[x][y]);
        for (int i = x + 1; i < 8 && stt == this.tableOfItems[i][y].getStatus(); ++i) {
            GameplayScreen.addToList(tempList, this.tableOfItems[i][y]);
        }
        this.eatFourOrFive += GameplayScreen.colectEat4or5(tempList.size());
        GameplayScreen.colectEatableItems(tempList, list);
        tempList.addElement(this.tableOfItems[x][y]);
        for (int j = y + 1; j < 8 && stt == this.tableOfItems[x][j].getStatus(); ++j) {
            GameplayScreen.addToList(tempList, this.tableOfItems[x][j]);
        }
        this.eatFourOrFive += GameplayScreen.colectEat4or5(tempList.size());
        GameplayScreen.colectEatableItems(tempList, list);
    }

    protected boolean checkHasMove() {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Item item;
                byte stt = this.tableOfItems[i][j].getStatus();
                if (stt == 7) continue;
                if (j < 7 && this.tableOfItems[i][j + 1].getStatus() == stt) {
                    if (j > 1 && this.tableOfItems[i][j - 1].obstacle == -1 && (item = this.tableOfItems[i][j - 2]).getStatus() == stt && item.obstacle == -1) {
                        return true;
                    }
                    if (j < 5 && this.tableOfItems[i][j + 2].obstacle == -1 && (item = this.tableOfItems[i][j + 3]).getStatus() == stt && item.obstacle == -1) {
                        return true;
                    }
                    if (j > 0 && this.tableOfItems[i][j - 1].obstacle == -1) {
                        if (i > 0 && (item = this.tableOfItems[i - 1][j - 1]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                        if (i < 7 && (item = this.tableOfItems[i + 1][j - 1]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                    }
                    if (j < 6 && this.tableOfItems[i][j + 2].obstacle == -1) {
                        if (i > 0 && (item = this.tableOfItems[i - 1][j + 2]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                        if (i < 7 && (item = this.tableOfItems[i + 1][j + 2]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                    }
                }
                if (j < 6 && this.tableOfItems[i][j + 2].getStatus() == stt && this.tableOfItems[i][j + 1].obstacle == -1) {
                    if (i > 0 && (item = this.tableOfItems[i - 1][j + 1]).getStatus() == stt && item.obstacle == -1) {
                        return true;
                    }
                    if (i < 7 && (item = this.tableOfItems[i + 1][j + 1]).getStatus() == stt && item.obstacle == -1) {
                        return true;
                    }
                }
                if (i < 7 && this.tableOfItems[i + 1][j].getStatus() == stt) {
                    if (i > 1 && this.tableOfItems[i - 1][j].obstacle == -1 && (item = this.tableOfItems[i - 2][j]).getStatus() == stt && item.obstacle == -1) {
                        return true;
                    }
                    if (i < 5 && this.tableOfItems[i + 2][j].obstacle == -1 && (item = this.tableOfItems[i + 3][j]).getStatus() == stt && item.obstacle == -1) {
                        return true;
                    }
                    if (i > 0 && this.tableOfItems[i - 1][j].obstacle == -1) {
                        if (j > 0 && (item = this.tableOfItems[i - 1][j - 1]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                        if (j < 7 && (item = this.tableOfItems[i - 1][j + 1]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                    }
                    if (i < 6) {
                        if (j > 0 && (item = this.tableOfItems[i + 2][j - 1]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                        if (j < 7 && (item = this.tableOfItems[i + 2][j + 1]).getStatus() == stt && item.obstacle == -1) {
                            return true;
                        }
                    }
                }
                if (i >= 6 || this.tableOfItems[i + 2][j].getStatus() != stt || this.tableOfItems[i + 1][j].obstacle != -1) continue;
                if (j > 0 && (item = this.tableOfItems[i + 1][j - 1]).getStatus() == stt && item.obstacle == -1) {
                    return true;
                }
                if (j >= 7 || (item = this.tableOfItems[i + 1][j + 1]).getStatus() != stt || item.obstacle != -1) continue;
                return true;
            }
        }
        return false;
    }

    private static int colectEat4or5(int size) {
        if (size >= 4) {
            return size - 3;
        }
        return 0;
    }

    protected final void eatSpecialItem(int item) {
        Store store = this.screenManager.store;
        switch (item) {
            case 9: {
                store.changeInt(strings.BOOM, 1);
                break;
            }
            case 11: {
                store.changeInt(strings.EXCHANGE, 1);
                break;
            }
            case 10: {
                store.changeInt(strings.LIFE, 1);
                break;
            }
            case 14: {
                store.changeInt(strings.THUNDERBOLT, 1);
                break;
            }
            case 12: {
                store.changeInt(strings.TIME, 1);
            }
        }
    }

    protected void eatOnThunderbolt(int pieceStatus, Vector eatList) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                Item item = this.tableOfItems[i][j];
                if (item.getStatus() != pieceStatus) continue;
                eatList.addElement(item);
            }
        }
    }

    protected void eatOnAxe(int i, int j, Vector eatList) {
        eatList.addElement(this.tableOfItems[i][j]);
    }

    protected void eatOnBoom(int i, int j, Vector eatList) {
        for (int k = i - 1; k < i + 2; ++k) {
            if (k == -1 || k == 8) continue;
            for (int l = j - 1; l < j + 2; ++l) {
                Item p;
                if (l == -1 || l == 8 || (p = this.tableOfItems[k][l]).getStatus() >= 15 || p.getStatus() == 7) continue;
                eatList.addElement(p);
            }
        }
    }

    private static void colectEatableItems(Vector itemList, Vector listAllItem) {
        int length = itemList.size();
        if (length >= 3) {
            for (int i = 0; i < length; ++i) {
                GameplayScreen.addToList(listAllItem, (Point)itemList.elementAt(i));
            }
        }
        itemList.removeAllElements();
    }

    protected void replaceItems() {
        boolean broken = false;
        this.eatingItemsList.addAllElement(this.emptyItemsUnderIce);
        int eatSize = this.eatingItemsList.size();
        this.maxSliding = 0;
        for (int i = 0; i < eatSize; ++i) {
            Item itemUp;
            Item item = (Item)this.eatingItemsList.elementAt(i);
            int x = item.i;
            byte y = item.j;
            for (int j = x; j > 0; --j) {
                Item itemDown = this.tableOfItems[j][y];
                itemUp = this.tableOfItems[j - 1][y];
                if (itemUp.obstacle == 0 || itemUp.obstacle == 1) {
                    itemDown.setStatus(7);
                    broken = true;
                    this.maxSliding = Math.max(this.maxSliding, item.delta_i);
                    break;
                }
                if (itemUp.obstacle == 2 || itemUp.obstacle == 3) {
                    itemDown.obstacle = itemUp.obstacle;
                    itemUp.obstacle = (byte)-1;
                }
                itemDown.setStatus(itemUp.getStatus());
                itemDown.delta_i = (byte)(itemUp.delta_i + 1);
                GameplayScreen.addToList(this.slidingItemsList, itemDown);
            }
            if (!broken) {
                itemUp = this.tableOfItems[0][y];
                if (itemUp.obstacle != 0 && itemUp.obstacle != 1) {
                    itemUp.setStatus(Util.RANDOM.nextInt(this.NUM_OF_ITEMS));
                    itemUp.delta_i = (byte)(itemUp.delta_i + 1);
                    GameplayScreen.addToList(this.slidingItemsList, itemUp);
                }
                this.maxSliding = Math.max(itemUp.delta_i, this.maxSliding);
            }
            broken = false;
        }
        this.eatingItemsList.removeAllElements();
    }

    protected boolean slidingItemsDown(int frameTime) {
        int i;
        this.timeSlided += frameTime;
        int slideTime = 150 + this.maxSliding * 50;
        if (this.timeSlided > slideTime) {
            this.timeSlided = slideTime;
        }
        float delta = 27.0f * (1.0f - MathExt.sqr((float)this.timeSlided / (float)slideTime));
        for (i = 0; i < this.slidingItemsList.size(); ++i) {
            Item ip = (Item)this.slidingItemsList.elementAt(i);
            ip.setY(PREMULTIPLY[ip.i] + this.tbl_corner_y - (int)(delta * (float)ip.delta_i));
        }
        if (this.timeSlided < slideTime) {
            return true;
        }
        this.timeSlided = 0;
        for (i = this.slidingItemsList.size() - 1; i >= 0; --i) {
            ((Item)this.slidingItemsList.elementAt((int)i)).delta_i = 0;
        }
        return false;
    }

    public static void addToList(Vector list, Point o) {
        if (!list.contains(o)) {
            list.addElement(o);
        }
    }

    protected boolean exchange(Point pointer, Point selected, int frameTime) {
        Item atPointer = this.tableOfItems[pointer.getX()][pointer.getY()];
        Item atSelect = this.tableOfItems[selected.getX()][selected.getY()];
        this.timeExchange -= frameTime;
        if (this.timeExchange < 0) {
            atPointer.setX_Y(this.tbl_corner_x + PREMULTIPLY[atPointer.j], this.tbl_corner_y + PREMULTIPLY[atPointer.i]);
            atSelect.setX_Y(this.tbl_corner_x + PREMULTIPLY[atSelect.j], this.tbl_corner_y + PREMULTIPLY[atSelect.i]);
            GameplayScreen.exchange2Items(atSelect, atPointer);
            this.pointerSprite.setPosition(atPointer.getX(), atPointer.getY());
            this.timeExchange = 250;
            return false;
        }
        if (pointer.getX() == selected.getX()) {
            int delta = (int)((float)((pointer.getY() - selected.getY()) * 27 * this.timeExchange) / 250.0f);
            atPointer.setX(this.tbl_corner_x + PREMULTIPLY[atSelect.j] + delta);
            atSelect.setX(this.tbl_corner_x + PREMULTIPLY[atPointer.j] - delta);
        } else {
            int delta = (int)((float)((pointer.getX() - selected.getX()) * 27 * this.timeExchange) / 250.0f);
            atPointer.setY(this.tbl_corner_y + PREMULTIPLY[atSelect.i] + delta);
            atSelect.setY(this.tbl_corner_y + PREMULTIPLY[atPointer.i] - delta);
        }
        this.pointerSprite.setPosition(atSelect.getX(), atSelect.getY());
        return true;
    }

    public static void exchange2Items(Item ip1, Item ip2) {
        byte status = ip1.getStatus();
        ip1.setStatus(ip2.getStatus());
        ip2.setStatus(status);
    }

    protected int score(int combos) {
        int i;
        for (int i2 = 0; i2 < this.turnCounter.length; ++i2) {
            this.turnCounter[i2] = 0;
        }
        int score = 0;
        this.emptyItemsUnderIce.removeAllElements();
        int specialItem = 0;
        for (i = this.eatingItemsList.size() - 1; i >= 0; --i) {
            Item item = (Item)this.eatingItemsList.elementAt(i);
            byte status = item.getStatus();
            if (item.obstacle > -1) {
                switch (item.obstacle) {
                    case 1: {
                        item.obstacle = 0;
                        break;
                    }
                    case 3: {
                        item.obstacle = (byte)2;
                        break;
                    }
                    case 0: {
                        Item itemDown;
                        item.obstacle = (byte)-1;
                        for (int j = item.i + 1; j < 8 && (itemDown = this.tableOfItems[j][item.j]).getStatus() == 7; ++j) {
                            GameplayScreen.addToList(this.emptyItemsUnderIce, itemDown);
                        }
                        break;
                    }
                    case 2: {
                        item.obstacle = (byte)-1;
                    }
                }
                ++specialItem;
                this.eatingItemsList.removeElement(item);
                continue;
            }
            if (status < 7) {
                byte by = status;
                this.numEatenItems[by] = this.numEatenItems[by] + 1;
                byte by2 = status;
                this.turnCounter[by2] = this.turnCounter[by2] + 1;
                continue;
            }
            this.eatSpecialItem(status);
        }
        for (i = 0; i < this.NUM_OF_ITEMS; ++i) {
            if (this.turnCounter[i] <= 0) continue;
            score += (this.turnCounter[i] + combos) * this.basicScores[i];
        }
        return score + specialItem * 500;
    }

    public boolean isLevelUp() {
        return this.scores >= this.MAX_SCORE;
    }

    public final boolean checkTarget(int[] numEaten, int[] target) {
        for (int i = 0; i < numEaten.length; ++i) {
            if (numEaten[i] >= target[i]) continue;
            return false;
        }
        return true;
    }

    public final void useSpecialItem(byte specialItem) {
        switch (specialItem) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                this.specialItemUsed = specialItem;
                this.isSelected = false;
                break;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    public final boolean useTime() {
        this.timePlayed -= 30000;
        if (this.timePlayed < 0) {
            this.timePlayed += 30000;
            return false;
        }
        return true;
    }

    private static boolean checkHerbFlyDirection(Vector eatingList) {
        byte head = 8;
        byte tail = 0;
        for (int i = 0; i < eatingList.size(); ++i) {
            Item ip = (Item)eatingList.elementAt(i);
            if (ip.getStatus() != ITEM_HERB) continue;
            if (head > ip.j) {
                head = ip.j;
            }
            if (tail >= ip.j) continue;
            tail = ip.j;
        }
        return head + tail > 8;
    }

    protected void drawItems(Graphics g) {
        if (this.gameState != 64) {
            for (int i = 0; i < 8; ++i) {
                for (int j = 0; j < 8; ++j) {
                    Item p = this.tableOfItems[i][j];
                    if (!this.eatingItemsList.contains(p)) {
                        g.drawImage(this.itemImages[p.getStatus()], (int)p.getX(), (int)p.getY(), 0);
                    }
                    if (p.obstacle == -1) continue;
                    g.drawImage(this.obstacleImages[p.obstacle], (int)p.getX(), (int)p.getY(), 0);
                }
            }
        }
    }

    protected void drawGrid(Graphics g) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                g.drawRegion(this.gridImage, (i + j) % 2 * 27, 0, 27, 27, 0, PREMULTIPLY[j] + this.tbl_corner_x, PREMULTIPLY[i] + this.tbl_corner_y, 0);
            }
        }
        this.gridImage = null;
    }

    protected boolean drawEatingItems(Graphics g, int frameTime) {
        int i;
        boolean isAnimating = false;
        for (i = this.eatingItemsList.size() - 1; i >= 0; --i) {
            byte stt;
            Item item = (Item)this.eatingItemsList.elementAt(i);
            if (item.obstacle == 1 || item.obstacle == 3 || (stt = item.getStatus()) > 7) continue;
            GameSprite gs = this.itemEffectSprites[stt];
            if (this.isHerbFlyReversed && stt == ITEM_HERB) {
                gs.setTransform(2);
                gs.setPosition(item.getX() - gs.getWidth() + 27, item.getY());
            } else {
                gs.setTransform(0);
                gs.setPosition(item.getX() - this.effectDelta[stt].getX(), item.getY() - this.effectDelta[stt].getY());
            }
            gs.paint(g);
            isAnimating = isAnimating || !gs.isLastFrame();
        }
        for (i = 0; i < this.itemEffectSprites.length; ++i) {
            if (this.itemEffectSprites[i] == null) continue;
            this.itemEffectSprites[i].updateFrame(frameTime, false);
        }
        if (!isAnimating) {
            this.timeStopEating += frameTime;
            if (this.timeStopEating < 200) {
                isAnimating = true;
            } else {
                this.timeStopEating = 0;
            }
        }
        if (!isAnimating) {
            for (i = 0; i < this.itemEffectSprites.length; ++i) {
                if (this.itemEffectSprites[i] == null) continue;
                this.itemEffectSprites[i].reset();
            }
        }
        return isAnimating;
    }

    private boolean drawEatOnSpecialItems(Graphics g, int frameTime) {
        GameSprite sprite;
        Point delta;
        switch (this.specialItemUsed) {
            case 2: {
                delta = BOOM_THUNDERBOLT_DELTA[2];
                sprite = this.thunderboltSprite;
                break;
            }
            case 1: {
                delta = BOOM_THUNDERBOLT_DELTA[1];
                sprite = this.boomSprite;
                break;
            }
            default: {
                return false;
            }
        }
        int eatSize = this.eatenItemsOnSpecial.size();
        for (int i = 0; i < eatSize; ++i) {
            Item item = (Item)this.eatenItemsOnSpecial.elementAt(i);
            sprite.setPosition(item.getX() - delta.getX(), item.getY() - delta.getY());
            sprite.paint(g);
        }
        sprite.updateFrame(frameTime, false);
        if (sprite.isLastFrame()) {
            sprite.reset();
            return false;
        }
        return true;
    }

    protected void drawBars(Graphics g, int delta) {
        if (this.screenManager.screenType != 2) {
            g.drawImage(this.timeBarImage, timeBarX, delta, 0);
        } else {
            Drawer.drawTransform(g, this.timeBarImage, delta, 0, 6);
        }
        int imW = this.timeoutImage.getWidth();
        int imH = this.timeoutImage.getHeight();
        int width = this.timePlayed * bar_w / this.MAX_TIME_PLAY;
        this.drawBarCoverer(g, width, imW, imH, timeout_x + delta, timeout_y + delta);
        if (this.animScore > this.MAX_SCORE) {
            width = 0;
        } else {
            width = bar_w - this.animScore * bar_w / this.MAX_SCORE;
            if (width > bar_w) {
                width = bar_w;
            }
        }
        this.drawBarCoverer(g, width, imW, imH, timeout_x + 18 + delta, score_y + delta);
    }

    private void drawHourglassAndCoins(Graphics g, int frametime, int delta) {
        this.countHourglass += frametime;
        this.coinsSprite.updateFrame(frametime, true);
        if (this.screenManager.screenType != 2) {
            this.coinsSprite.setPosition(this.coinX, this.coinY - delta);
            this.hourGlassSprite.setPosition(this.hglassX, this.hglassY - delta);
        } else {
            this.coinsSprite.setPosition(this.coinX - delta, this.coinY);
            this.hourGlassSprite.setPosition(this.hglassX - delta, this.hglassY);
        }
        if (this.countHourglass > 10000) {
            this.hourGlassSprite.updateFrame(frametime, false);
            if (this.hourGlassSprite.isLastFrame()) {
                this.countHourglass = 0;
                this.hourGlassSprite.reset();
            }
        }
        this.hourGlassSprite.paint(g);
        this.coinsSprite.paint(g);
    }

    private void drawBarCoverer(Graphics g, int width, int imW, int imH, int x, int y) {
        int times = width / imW;
        for (int i = 0; i < times; ++i) {
            if (this.screenManager.screenType != 2) {
                g.drawImage(this.timeoutImage, timeout_x - (i + 1) * imW, y, 0);
                continue;
            }
            Drawer.drawTransform(g, this.timeoutImage, x, timeout_y + i * imW, 5);
        }
        int remain = width % imW;
        if (this.screenManager.screenType != 2) {
            g.drawRegion(this.timeoutImage, 0, 0, remain, imH, 0, timeout_x - width, y, 0);
        } else {
            g.drawRegion(this.timeoutImage, 0, 0, remain, imH, 5, x, timeout_y + width - remain, 0);
        }
    }

    private void drawWindow(Graphics g, int x, int y) {
        int w = this.frameImage.getWidth();
        int h = this.frameImage.getHeight();
        g.drawImage(this.frameImage, x, y + w, 0);
        g.drawRegion(this.frameImage, 0, 0, w, h, 5, x + w, y, 0);
        g.drawRegion(this.frameImage, 0, 0, w, h, 3, x + w + h, y + w, 0);
        g.drawRegion(this.frameImage, 0, 0, w, h, 6, x + w, y + w + h, 0);
        this.frameImage = null;
    }

    protected void drawAxe(Graphics g, int delta_y) {
        if (this.axePart < this.axeHeight * this.eatFourOrFive / 8) {
            ++this.axePart;
            if (this.axePart == this.axeHeight) {
                this.eatFourOrFive -= 8;
                this.isAxeFull = true;
                this.screenManager.store.changeInt(strings.AXE, 1);
            }
        }
        int dx = delta_y;
        if (this.screenManager.screenType != 2) {
            dx = 0;
        } else {
            delta_y = 0;
        }
        g.drawImage(this.axeTrayImage, this.axeTrayX + dx, this.axeTrayY + delta_y, 0);
        g.drawRegion(this.axeImage, 0, this.axeHeight - this.axePart, this.axeImage.getWidth(), this.axePart, 0, this.axeX + dx, this.axeY + this.axeHeight - this.axePart + delta_y, 0);
    }

    protected boolean drawStarringAsAxeFull(Graphics g, int frameTime) {
        this.starringTimeCounter += frameTime;
        boolean stillStarring = true;
        if (this.starringTimeCounter > 1000) {
            this.starringTimeCounter = 1000;
            stillStarring = false;
            this.axePart = 0;
        }
        int starringPart = this.axeHeight * this.starringTimeCounter / 1000;
        Random r = Util.RANDOM;
        int axeW = this.axeImage.getWidth();
        for (int i = 0; i < 5; ++i) {
            g.drawImage(this.starImage, this.axeX + r.nextInt(axeW), this.axeY + starringPart + r.nextInt(15), 0);
        }
        if (!stillStarring) {
            this.starringTimeCounter = 0;
        }
        return stillStarring;
    }

    private void drawPaperImage(Graphics g) {
        if (this.screenManager.screenType != 2) {
            g.drawImage(this.paperTopImage, paperX, paperY, 0);
            g.drawImage(this.paperMidImage, paperX, paperY + this.paperTopImage.getHeight(), 0);
            g.drawImage(this.paperBotImage, paperX, _height - this.paperBotImage.getHeight(), 0);
        } else {
            Drawer.drawTransform(g, this.paperBotImage, 0, 0, 5);
            Drawer.drawTransform(g, this.paperMidImage, 61, 0, 5);
            Drawer.drawTransform(g, this.paperBotImage, 257, 0, 4);
        }
        this.paperBotImage = null;
        this.paperMidImage = null;
        this.paperTopImage = null;
    }

    protected final void setTimeout(int second) {
        this.MAX_TIME_PLAY = second * 1000;
    }

    private void generateTransitionParams(Random ran) {
        while (this.dir1 == 0 && this.dir5 == 0) {
            this.dir1 = ran.nextInt(3) - 1;
            this.dir5 = ran.nextInt(3) - 1;
        }
        switch (ran.nextInt(57)) {
            case 0: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 1: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = 1;
                this.dir8 = -7;
                break;
            }
            case 2: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 3: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = -8;
                break;
            }
            case 4: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 0;
                break;
            }
            case 5: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 8;
                break;
            }
            case 6: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 7: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 8: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = -8;
                break;
            }
            case 9: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 10: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 11: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 1;
                this.dir7 = 1;
                this.dir8 = -7;
                break;
            }
            case 12: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 13: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = -8;
                break;
            }
            case 14: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 0;
                break;
            }
            case 15: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 8;
                break;
            }
            case 16: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 0;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 17: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 18: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = -8;
                break;
            }
            case 19: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 20: {
                this.dir2 = 1;
                this.dir3 = 1;
                this.dir4 = -7;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 21: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 22: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = -8;
                break;
            }
            case 23: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 0;
                break;
            }
            case 24: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 8;
                break;
            }
            case 25: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 26: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 27: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = -8;
                break;
            }
            case 28: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 29: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = -8;
                break;
            }
            case 30: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = -8;
                break;
            }
            case 31: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 0;
                break;
            }
            case 32: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 8;
                break;
            }
            case 33: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 0;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 34: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 35: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 36: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = -8;
                break;
            }
            case 37: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 38: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 0;
                break;
            }
            case 39: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = -1;
                this.dir7 = 1;
                this.dir8 = 8;
                break;
            }
            case 40: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = 0;
                this.dir7 = 0;
                this.dir8 = 1;
                break;
            }
            case 41: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 42: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = -8;
                break;
            }
            case 43: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 44: {
                this.dir2 = -1;
                this.dir3 = 1;
                this.dir4 = 0;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 45: {
                this.dir2 = 0;
                this.dir3 = 0;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 46: {
                this.dir2 = 0;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = 1;
                break;
            }
            case 47: {
                this.dir2 = 0;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = -8;
                break;
            }
            case 48: {
                this.dir2 = 0;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 49: {
                this.dir2 = 0;
                this.dir3 = 1;
                this.dir4 = 1;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 50: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 1;
                this.dir7 = 0;
                this.dir8 = -8;
                break;
            }
            case 51: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 52: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -8;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 53: {
                this.dir2 = 1;
                this.dir3 = -1;
                this.dir4 = 0;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 0;
                break;
            }
            case 54: {
                this.dir2 = 1;
                this.dir3 = -1;
                this.dir4 = 0;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            case 55: {
                this.dir2 = 1;
                this.dir3 = -1;
                this.dir4 = 8;
                this.dir6 = 1;
                this.dir7 = -1;
                this.dir8 = 8;
                break;
            }
            default: {
                this.dir2 = 1;
                this.dir3 = 0;
                this.dir4 = -3;
                this.dir6 = 0;
                this.dir7 = 1;
                this.dir8 = -3;
            }
        }
    }

    public void save() {
        if (!this.initialized) {
            return;
        }
        int[][] items = new int[8][8];
        int[][] obstacles = new int[8][8];
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                items[i][j] = this.tableOfItems[i][j].getStatus();
                obstacles[i][j] = this.tableOfItems[i][j].obstacle;
            }
        }
        Store store = this.screenManager.store;
        store.set(strings.SAVED, true);
        store.set(strings.STATUS, items);
        store.set(strings.OBSTACLES, obstacles);
        store.set(strings.TIME_PLAYED, this.timePlayed);
        store.set(strings.SCORES, this.scores);
        store.set(strings.SEVENTH_ITEM, this.seventhItem);
    }

    public void deleteLastSavedData() {
        Store store = this.screenManager.store;
        store.delete(strings.SAVED);
        store.delete(strings.TIME_PLAYED);
        store.delete(strings.SCORES);
        store.delete(strings.STATUS);
        store.delete(strings.OBSTACLES);
    }

    private void updateTableByDir(int delta, float tranPos) {
        for (int i = 0; i < 8; ++i) {
            for (int j = 0; j < 8; ++j) {
                this.tableOfItems[i][j].setX_Y(PREMULTIPLY[j] + this.tbl_corner_x - this.dir1 * (int)(tranPos * (float)(this.dir2 * i + this.dir3 * j + this.dir4) * (float)delta), PREMULTIPLY[i] + this.tbl_corner_y - this.dir5 * (int)(tranPos * (float)(this.dir6 * i + this.dir7 * j + this.dir8) * (float)delta));
            }
        }
    }

    public void replay() {
        this.timePlayed = 0;
        this.scores = 0;
        this.animScore = 0;
        this.noMove = false;
        this.isSelected = false;
        this.isXchanging2Items = false;
        this.isReXchanging2Items = false;
        this.isItemXchanged = false;
        this.isSlidingDown = false;
        this.isEatingItems = false;
        this.isHerbFlyReversed = false;
        this.isScoring = false;
        Util.resetArray(this.turnCounter);
        Util.resetArray(this.numEatenItems);
        this.generateTable(Util.RANDOM);
        this.screenManager.store.changeInt(strings.LIFE, -1);
    }

    public void onExitGame() {
        if (!this.isExiting()) {
            this.save();
        }
    }

    private void initParams(int screenType) {
        switch (screenType) {
            case 2: {
                this.tbl_corner_x = 49;
                this.tbl_corner_y = 12;
                land_x = 22;
                land_y = -54;
                this.axeX = 280;
                this.axeY = 101;
                this.axeTrayX = 267;
                this.axeTrayY = 89;
                window_x = 37;
                window_y = 0;
                menuBtn_x = 9;
                button_y = 294;
                shopBtn_x = 167;
                timeBarX = 0;
                timeout_x = 4;
                timeout_y = 12;
                this.hglassY = 217;
                this.coinX = 18;
                this.coinY = 220;
                break;
            }
            case 1: {
                this.tbl_corner_x = 52;
                land_x += 40;
                timeout_x += 40;
                paperX = 40;
                menuBtn_x += 40;
                shopBtn_x += 40;
                window_x += 40;
                this.axeX += 40;
                this.axeTrayX += 40;
                timeBarX = 40;
                this.coinX = 40;
                this.hglassX = 36;
            }
        }
    }
}

