/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import com.pipogame.util.Queue;
import java.util.Enumeration;
import java.util.NoSuchElementException;
import java.util.Vector;

public final class ArrayUtils {
    private static final byte[] BYTE = new byte[0];
    private static final boolean[] BOOL = new boolean[0];
    private static final long[] LONG = new long[0];
    private static final int[] INT = new int[0];
    private static final Object[] OBJ = new Object[0];
    private static final short[] SHORT = new short[0];

    private ArrayUtils() {
    }

    public static void addAll(Vector vector, Object[] copyFrom) {
        if (copyFrom == null) {
            return;
        }
        vector.ensureCapacity(vector.size() + copyFrom.length);
        for (int i = 0; i < copyFrom.length; ++i) {
            vector.addElement(copyFrom[i]);
        }
    }

    public static boolean equals(Enumeration enum1, Object[] enum2) {
        Object obj2;
        Object obj1;
        int i = 0;
        do {
            if (!enum1.hasMoreElements()) {
                return i >= enum2.length;
            }
            if (i >= enum2.length) {
                return false;
            }
            obj1 = enum1.nextElement();
            obj2 = enum2[i++];
        } while (obj1 != null ? obj1.equals(obj2) : obj2 == null);
        return false;
    }

    public static boolean equals(Object[] enum1, Object[] enum2) {
        if (enum1.length != enum2.length) {
            return false;
        }
        for (int i = 0; i < enum1.length; ++i) {
            if (enum1[i].equals(enum2[i])) continue;
            return false;
        }
        return true;
    }

    public static boolean equals(Object enum1, Object enum2) {
        return ArrayUtils.equals((Object)ArrayUtils.arrayToEnumeration(enum1), ArrayUtils.arrayToEnumeration(enum2));
    }

    public static int hashCode(Object object) {
        if (object == null) {
            return 0;
        }
        if (!object.getClass().isArray()) {
            return object.hashCode();
        }
        int result = 1;
        Enumeration e = ArrayUtils.arrayToEnumeration(object);
        while (e.hasMoreElements()) {
            Object o = e.nextElement();
            result = result * 1001 + ArrayUtils.hashCode(o);
        }
        return result;
    }

    public static Enumeration arrayToEnumeration(Object array) {
        ArrayUtils.checkIsArray(array, true);
        if (array instanceof Queue) {
            return ((Queue)array).getEnumeration();
        }
        if (array instanceof Vector) {
            return ((Vector)array).elements();
        }
        if (array instanceof Enumeration) {
            return (Enumeration)array;
        }
        return new ArrayEnumeration(array);
    }

    public static boolean isArray(Object array) {
        if (array == null) {
            return false;
        }
        if (array.getClass().isArray()) {
            return true;
        }
        return array instanceof Queue || array instanceof Vector || array instanceof Enumeration;
    }

    public static void checkIsArray(Object array, boolean allowEnumeration) {
        if ((allowEnumeration || !(array instanceof Enumeration)) && ArrayUtils.isArray(array)) {
            return;
        }
        throw new IllegalArgumentException("not an array: " + array == null ? "null" : array.getClass().toString());
    }

    public static int getLength(Object array) {
        ArrayUtils.checkIsArray(array, true);
        Class<?> c = array.getClass();
        if (c.isInstance(BYTE)) {
            return ((byte[])array).length;
        }
        if (c.isInstance(BOOL)) {
            return ((boolean[])array).length;
        }
        if (c.isInstance(LONG)) {
            return ((long[])array).length;
        }
        if (c.isInstance(INT)) {
            return ((int[])array).length;
        }
        if (c.isInstance(OBJ)) {
            return ((Object[])array).length;
        }
        if (c.isInstance(SHORT)) {
            return ((short[])array).length;
        }
        if (array instanceof Vector) {
            return ((Vector)array).size();
        }
        if (array instanceof Queue) {
            return ((Queue)array).occupiedSlots();
        }
        int i = 0;
        while (((Enumeration)array).hasMoreElements()) {
            ++i;
        }
        return i;
    }

    public static Object getElementAt(Object array, int index) {
        ArrayUtils.checkIsArray(array, false);
        Class<?> c = array.getClass();
        if (c.isInstance(BYTE)) {
            return new Byte(((byte[])array)[index]);
        }
        if (c.isInstance(BOOL)) {
            return new Boolean(((boolean[])array)[index]);
        }
        if (c.isInstance(LONG)) {
            return new Long(((long[])array)[index]);
        }
        if (c.isInstance(INT)) {
            return new Integer(((int[])array)[index]);
        }
        if (c.isInstance(OBJ)) {
            return ((Object[])array)[index];
        }
        if (c.isInstance(SHORT)) {
            return new Short(((short[])array)[index]);
        }
        if (array instanceof Vector) {
            return ((Vector)array).elementAt(index);
        }
        return ((Queue)array).peek(index);
    }

    public static Object clone(Object array, boolean deep) {
        if (array == null) {
            return null;
        }
        if (array instanceof Queue) {
            if (!deep) {
                return new Queue((Queue)array);
            }
            Queue q = (Queue)array;
            Queue result = new Queue(q.bufferSize);
            Enumeration e = q.getEnumeration();
            while (e.hasMoreElements()) {
                Object obj = e.nextElement();
                if (ArrayUtils.isArray(obj)) {
                    obj = ArrayUtils.clone(obj, true);
                }
                result.offer(obj);
            }
            return result;
        }
        Class<?> c = array.getClass();
        if (c.isInstance(BYTE)) {
            byte[] a = (byte[])array;
            byte[] result = new byte[a.length];
            System.arraycopy(a, 0, result, 0, a.length);
            return result;
        }
        if (c.isInstance(BOOL)) {
            boolean[] a = (boolean[])array;
            boolean[] result = new boolean[a.length];
            System.arraycopy(a, 0, result, 0, a.length);
            return result;
        }
        if (c.isInstance(LONG)) {
            long[] a = (long[])array;
            long[] result = new long[a.length];
            System.arraycopy(a, 0, result, 0, a.length);
            return result;
        }
        if (c.isInstance(INT)) {
            int[] a = (int[])array;
            int[] result = new int[a.length];
            System.arraycopy(a, 0, result, 0, a.length);
            return result;
        }
        if (c.isInstance(OBJ)) {
            Object[] a = (Object[])array;
            Object[] result = new Object[a.length];
            for (int i = 0; i < a.length; ++i) {
                Object obj = a[i];
                if (deep && ArrayUtils.isArray(obj)) {
                    obj = ArrayUtils.clone(obj, true);
                }
                result[i] = obj;
            }
            return result;
        }
        if (c.isInstance(SHORT)) {
            short[] a = (short[])array;
            short[] result = new short[a.length];
            System.arraycopy(a, 0, result, 0, a.length);
            return result;
        }
        if (array instanceof Vector) {
            Vector a = (Vector)array;
            Vector result = new Vector(a.size());
            for (int i = 0; i < a.size(); ++i) {
                Object obj = a.elementAt(i);
                if (deep && ArrayUtils.isArray(obj)) {
                    obj = ArrayUtils.clone(obj, true);
                }
                result.addElement(obj);
            }
            return result;
        }
        throw new IllegalArgumentException("Unsupported array class: " + c.getName());
    }

    public static String arrayToString(Object array) {
        if (array == null) {
            return "null";
        }
        ArrayUtils.checkIsArray(array, true);
        StringBuffer result = new StringBuffer("[");
        Enumeration e = ArrayUtils.arrayToEnumeration(array);
        while (e.hasMoreElements()) {
            Object obj = e.nextElement();
            if (ArrayUtils.isArray(obj)) {
                result.append(ArrayUtils.arrayToString(obj));
            } else if (obj == null) {
                result.append("null");
            } else {
                result.append(obj);
            }
            if (!e.hasMoreElements()) continue;
            result.append(", ");
        }
        result.append(']');
        return result.toString();
    }

    public static final class ArrayEnumeration
    implements Enumeration {
        private final Object array;
        private final int length;
        private int currentItem = 0;

        ArrayEnumeration(Object array) {
            this.array = array;
            this.length = ArrayUtils.getLength(array);
        }

        public boolean hasMoreElements() {
            return this.currentItem < this.length;
        }

        public Object nextElement() {
            if (!this.hasMoreElements()) {
                throw new NoSuchElementException();
            }
            return ArrayUtils.getElementAt(this.array, this.currentItem++);
        }
    }
}

