/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.util;

import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public final class ImageTool {
    public static final int TRANSPARENT_COLOR = ImageTool.getTransparentColor();
    public static final int RED = 0;
    public static final int GREEN = 1;
    public static final int BLUE = 2;

    private static int getTransparentColor() {
        Image image = ImageTool.createImage(2, 2);
        Graphics g = image.getGraphics();
        g.setColor(-65281);
        g.fillRect(0, 0, 2, 2);
        int[] data = ImageTool.getImageData(image, 0, 0, 2, 2);
        return data[0];
    }

    public static Image changeImageRGB(Image image, int red, int green, int blue) {
        int[] rgbData = new int[image.getWidth() * image.getHeight()];
        image.getRGB(rgbData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        return Image.createRGBImage((int[])ImageTool.changeRGB(rgbData, red, green, blue), (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    public static Image changeImageBrightness(Image image, int brightness) {
        int[] rgbData = new int[image.getWidth() * image.getHeight()];
        image.getRGB(rgbData, 0, image.getWidth(), 0, 0, image.getWidth(), image.getHeight());
        return Image.createRGBImage((int[])ImageTool.changeRGB(rgbData, brightness, brightness, brightness), (int)image.getWidth(), (int)image.getHeight(), (boolean)true);
    }

    private static int[] changeRGB(int[] rgbDat, int red, int green, int blue) {
        int deep = 256;
        for (int i = 0; i < rgbDat.length; ++i) {
            int opac = rgbDat[i] & 0xFF000000;
            int r = Math.max(((rgbDat[i] & 0xFF0000) >>> 16) + red, 0);
            r = r > 0 ? r : 0;
            int g = Math.max(((rgbDat[i] & 0xFF00) >>> 8) + green, 0);
            g = g > 0 ? g : 0;
            int b = Math.max((rgbDat[i] & 0xFF) + blue, 0);
            b = b > 0 ? b : 0;
            rgbDat[i] = opac | r << 16 | g << 8 | b;
        }
        return rgbDat;
    }

    public static Image getGrayScaleImage(Image image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int length = width * height;
        int[] rgbData = new int[length];
        image.getRGB(rgbData, 0, width, 0, 0, width, height);
        for (int x = 0; x < length; ++x) {
            int color = rgbData[x];
            int opac = color & 0xFF000000;
            if (opac == 0) continue;
            int red = (color & 0xFF0000) >>> 16;
            int green = (color & 0xFF00) >>> 8;
            int blue = color & 0xFF;
            int gray = (int)((float)red * 0.299f + (float)green * 0.587f + (float)blue * 0.114f);
            rgbData[x] = opac | gray << 16 | gray << 8 | gray;
        }
        Image grayImage = Image.createRGBImage((int[])rgbData, (int)width, (int)height, (boolean)true);
        return grayImage;
    }

    public static Image getImageRegion(Image image, int src_x, int src_y, int width, int height) {
        return Image.createRGBImage((int[])ImageTool.getImageData(image, src_x, src_y, width, height), (int)width, (int)height, (boolean)true);
    }

    private static int[] getImageData(Image image, int src_x, int src_y, int width, int height) {
        Image image_temp = ImageTool.createImage(width, height);
        Graphics g = image_temp.getGraphics();
        g.setColor(TRANSPARENT_COLOR);
        g.fillRect(0, 0, width, height);
        g.drawRegion(image, src_x, src_y, width, height, 0, 0, 0, 0);
        return ImageTool.getMutableImageData(image_temp);
    }

    public static Image createImage(int width, int height) {
        return Image.createImage((int)width, (int)height);
    }

    public static Image getImageRegion(Image image, short width, short height, int frame) {
        int framesInWidth = image.getWidth() / width;
        return ImageTool.getImageRegion(image, frame % framesInWidth * width, frame / framesInWidth * height, width, height);
    }

    public static Image getImageByFrame(Image image, int numHorz, int numVer, int frame) {
        int width = image.getWidth() / numHorz;
        int height = image.getHeight() / numVer;
        return ImageTool.getImageRegion(image, frame % numHorz * width, frame / numHorz * height, width, height);
    }

    public static int[] getMutableImageData(Image mutableImage) {
        int width = mutableImage.getWidth();
        int height = mutableImage.getHeight();
        int[] data = new int[width * height];
        mutableImage.getRGB(data, 0, width, 0, 0, width, height);
        for (int j = 0; j < data.length; ++j) {
            if (data[j] != TRANSPARENT_COLOR) continue;
            data[j] = 0;
        }
        return data;
    }

    public static int[] getImutableImageData(Image image) {
        int width = image.getWidth();
        int height = image.getHeight();
        int[] data = new int[width * height];
        image.getRGB(data, 0, width, 0, 0, width, height);
        return data;
    }

    public static int changeColor(int color, int component, int quantity) {
        int newComponent = color >>> (component *= 8) & 0xFF;
        newComponent = (newComponent + quantity + 256) % 256 << component;
        return (color &= ~(255 << component)) | newComponent;
    }

    public static int[] changeOpacity(int[] data, int imWidth, int imHeight, float transparency, int x, int y, int width, int height) {
        for (int i = x; i < x + width; ++i) {
            for (int j = y; j < y + height; ++j) {
                int location = i + j * imWidth;
                int pixel = data[location] >>> 24;
                pixel = (int)((float)pixel * transparency);
                data[location] = pixel << 24 | data[location] & 0xFFFFFF;
            }
        }
        return data;
    }

    public static Image changeImageOpacity(int[] data, int imWidth, int imHeight, float transparency, int x, int y, int width, int height) {
        data = ImageTool.changeOpacity(data, imWidth, imHeight, transparency, x, y, width, height);
        return Image.createRGBImage((int[])data, (int)imWidth, (int)imHeight, (boolean)true);
    }

    public static Image changeImageOpacity(int[] data, int imWidth, int imHeight, float transparency) {
        return ImageTool.changeImageOpacity(data, imWidth, imHeight, transparency, 0, 0, imWidth, imHeight);
    }

    public static Image changeImageOpacity(Image image, float transparency) {
        int w = image.getWidth();
        int h = image.getHeight();
        return Image.createRGBImage((int[])ImageTool.changeOpacity(ImageTool.getImutableImageData(image), w, h, transparency, 0, 0, w, h), (int)w, (int)h, (boolean)true);
    }

    public static Image makePsudoTransparentImageBuffer(int width, int height) {
        Image image = ImageTool.createImage(width, height);
        Graphics g = image.getGraphics();
        g.setColor(TRANSPARENT_COLOR);
        g.fillRect(0, 0, width, height);
        return image;
    }

    public static Image makePsudoTransparentImageBuffer(Image image) {
        Image buff = ImageTool.makePsudoTransparentImageBuffer(image.getWidth(), image.getHeight());
        Graphics g = buff.getGraphics();
        g.drawImage(image, 0, 0, 0);
        return buff;
    }
}

