/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.ScreenManager;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.components.Point;
import com.pipogame.fad.CollectionScreen;
import com.pipogame.fad.HelpScreen;
import com.pipogame.fad.SmsDecode;
import com.pipogame.fad.scen.ChooseCharacterScreen;
import com.pipogame.fad.scen.TravelScreen;
import com.pipogame.fad.strings;
import com.pipogame.util.BlinkingText;
import com.pipogame.util.MathExt;
import com.pipogame.util.MessageBox;
import com.pipogame.util.PFont;
import com.pipogame.util.SMSender;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class MenuScreen
extends GameScreen {
    private Image[] itemImages;
    private Image[] itemSelectedImages;
    private Image bgImage;
    private GameSprite camelSprite;
    private int selectedItem = 0;
    private int totalChoices;
    private MessageBox messageBox;
    private MessageBox buyLifeMessageBox;
    private boolean isMessagePopup;
    private boolean isBuyLifeMb;
    private boolean hasMoreLife;
    private BlinkingText moreLife = new BlinkingText(PFont.toBytesIndex("B\u1ea1n \u0111\u00e3 c\u00f3 th\u00eam 3 m\u1ea1ng ch\u01a1i.", null), 500);
    private Point[] itemPositions;
    private Point selectedPos;
    private boolean touched;
    private int timeCounter;
    private static final int TIME = 300;
    private int moreLifeCounter;

    public void initialize() throws Exception {
        super.initialize();
        this.setTimeCancelInput(300);
        if (!this.screenManager.store.contains(strings.COLLECTION)) {
            int[] collection = new int[48];
            for (int i = 0; i < collection.length; ++i) {
                collection[i] = -1;
            }
            this.screenManager.store.set(strings.COLLECTION, collection);
        }
        if (!this.screenManager.store.contains(strings.LIFE)) {
            this.screenManager.store.set(strings.LIFE, 1);
        }
        this.transitionOffTime = 350;
        this.transitionOnTime = 350;
    }

    public void loadContent() throws Exception {
        this.touched = false;
        this.asset = Store.loadJar(strings.SHARE_FILE);
        switch (this.screenManager.screenType) {
            case 2: {
                this.bgImage = this.loadImage(101);
                break;
            }
            case 3: {
                this.bgImage = this.loadImage(100);
            }
        }
        this.itemImages = this.getMenuItemImages();
        this.itemSelectedImages = this.getMenuItemClickedImages();
        this.camelSprite = new GameSprite(this.loadImage(103), 6, 1);
        this.camelSprite.setTimeSequence(150);
        this.messageBox = new MessageBox(this.asset, 66, 180);
        this.messageBox.setX((_width - 180) / 2);
        this.messageBox.setY((_height - this.messageBox.getHeight()) / 2);
        this.buyLifeMessageBox = new MessageBox(this.asset, 73, 180);
        this.buyLifeMessageBox.setX(this.messageBox.getX());
        this.buyLifeMessageBox.setY((_height - this.buyLifeMessageBox.getHeight()) / 2);
        this.screenManager.music.playMusic("m");
        this.totalChoices = this.itemImages.length;
        this.itemPositions = new Point[this.totalChoices];
        int centerx = _width / 2;
        if (this.screenManager.screenType == 2) {
            centerx = 191;
        }
        int centery = _height / 2 - 10;
        for (int i = 0; i < this.totalChoices; ++i) {
            this.itemPositions[i] = new Point(centerx - this.itemImages[i].getWidth() / 2, centery + (i - 2) * 20);
        }
        this.selectedPos = new Point(this.itemPositions[0]);
        super.loadContent();
    }

    public void handleInput(Input input, int frameTime) {
        this.touched = false;
        if (this.isMessagePopup) {
            switch (this.messageBox.handleInput(input)) {
                case 1: {
                    this.startNewGame(this.screenManager);
                }
            }
        } else if (this.isBuyLifeMb) {
            switch (this.buyLifeMessageBox.handleInput(input)) {
                case 1: {
                    try {
                        if (SmsDecode.getNummerMobile(0) > 0 && new SMSender().send(SmsDecode.getStringSms(0), SmsDecode.getNummerMobile(0))) {
                            this.screenManager.store.changeInt(strings.LIFE, 3);
                            this.hasMoreLife = true;
                        }
                        break;
                    }
                    catch (Exception ex) {
                        // empty catch block
                    }
                }
            }
        } else if (input.isSomeKeyPrd() || input.isTouchUp()) {
            if (input.isTouchUp()) {
                for (int i = 0; i < this.itemPositions.length; ++i) {
                    if (!input.touched(this.itemPositions[i].getX(), this.itemPositions[i].getY(), this.itemImages[i].getWidth(), 22)) continue;
                    this.touched = true;
                    this.selectedItem = i;
                    this.selectedPos.copy(this.itemPositions[i]);
                    break;
                }
            }
            if (input.isUpPrd()) {
                this.selectedItem = (this.selectedItem - 1 + this.totalChoices) % this.totalChoices;
                this.selectedPos.setY(this.itemPositions[this.selectedItem].getY() - 10);
                this.timeCounter = 300;
            } else if (input.isDownPrd()) {
                this.selectedItem = (this.selectedItem + 1) % this.totalChoices;
                this.selectedPos.setY(this.itemPositions[this.selectedItem].getY() - 10);
                this.timeCounter = 300;
            } else if (this.touched || input.isFirePrd()) {
                switch (this.selectedItem) {
                    case 0: {
                        if (this.screenManager.store.getBoolean(strings.PLAYING)) {
                            this.screenManager.addScreen(new TravelScreen());
                            this.exitScreen();
                            break;
                        }
                        this.startNewGame(this.screenManager);
                        break;
                    }
                    case 1: {
                        if (this.screenManager.store.getBoolean(strings.PLAYING)) {
                            this.isMessagePopup = true;
                            break;
                        }
                        this.startNewGame(this.screenManager);
                        break;
                    }
                    case 2: {
                        this.screenManager.addScreen(new HelpScreen());
                        this.exitScreen();
                        break;
                    }
                    case 3: {
                        this.screenManager.addScreen(new CollectionScreen());
                        this.exitScreen();
                        break;
                    }
                    default: {
                        this.screenManager.exitGame();
                    }
                }
            }
        }
    }

    public void startNewGame(ScreenManager sm) {
        if (sm.store.getInt(strings.LIFE) > 0) {
            sm.addScreen(new ChooseCharacterScreen());
            sm.store.changeInt(strings.LIFE, -1);
            MenuScreen.resetGame(sm.store);
            this.exitScreen();
        } else {
            this.isBuyLifeMb = true;
        }
    }

    public static void resetGame(Store store) {
        store.set(strings.PLAYING, true);
        store.set(strings.STAGE, 1);
        store.delete(strings.SAVED);
        store.delete(strings.STATUS);
        store.delete(strings.OBSTACLES);
        store.set(strings.LAST_CITY_RWD, 0);
    }

    public void update(int frameTime, boolean covered) {
        this.camelSprite.setPosition(this.selectedPos.getX() - this.camelSprite.getWidth(), this.selectedPos.getY());
        this.camelSprite.updateFrame(frameTime, true);
        this.timeCounter -= frameTime;
        if (this.timeCounter < 0) {
            this.timeCounter = 0;
        }
        this.selectedPos.setX_Y(this.itemPositions[this.selectedItem].getX(), this.itemPositions[this.selectedItem].getY() + (int)(10.0f * MathExt.sqr((float)this.timeCounter / 300.0f)));
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgImage, 0, 0, 0);
        for (int i = 0; i < this.totalChoices; ++i) {
            if (i == this.selectedItem) continue;
            Point p = this.itemPositions[i];
            g.drawImage(this.itemImages[i], (int)p.getX(), (int)p.getY(), 0);
        }
        g.drawImage(this.itemSelectedImages[this.selectedItem], (int)this.selectedPos.getX(), (int)this.selectedPos.getY(), 0);
        this.camelSprite.paint(g);
        if (this.isMessagePopup) {
            this.isMessagePopup = this.messageBox.draw(g, frameTime);
        } else if (this.isBuyLifeMb) {
            this.isBuyLifeMb = this.buyLifeMessageBox.draw(g, frameTime);
        }
        if (this.hasMoreLife) {
            this.moreLifeCounter += frameTime;
            if (this.moreLifeCounter > 5000) {
                this.moreLifeCounter = 0;
                this.hasMoreLife = false;
            }
            this.moreLife.draw(g, frameTime, 255, 0xFFFFFF);
        }
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.drawFade(g, 0);
            }
        }
    }

    public void finalize() {
        this.itemImages = null;
        this.itemSelectedImages = null;
        this.bgImage = null;
        this.itemPositions = null;
        this.camelSprite = null;
        super.finalize();
    }

    private Image[] getMenuItemImages() throws Exception {
        return new Image[]{this.loadImage(104), this.loadImage(105), this.loadImage(106), this.loadImage(107), this.loadImage(108)};
    }

    private Image[] getMenuItemClickedImages() throws Exception {
        return new Image[]{this.loadImage(109), this.loadImage(110), this.loadImage(111), this.loadImage(112), this.loadImage(113)};
    }
}

