/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class PillageScreen
extends GameScreen {
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    private Image bgrImage;
    protected Image robImage;
    GameSprite pipoSprite;
    Image pipoShad;
    int keyLand = 6;
    int poSpeed = 20;
    int bgr_x = 23;
    int bgr_y = 8;
    int road_y;
    int rob_x;
    int rob_y;
    int fadeCounter;
    int meetCounter;
    static final int FADE_TIME = 600;

    public PillageScreen(int keyLand) {
        this.keyLand = keyLand;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 500;
        this.transitionOnTime = 500;
        this.asset = Store.loadJar(strings.SHARE_FILE);
    }

    public void loadContent() throws Exception {
        super.loadContent();
        try {
            this.paperTopImage = this.loadImage(0);
            this.paperBotImage = this.loadImage(1);
            this.paperMidImage = this.loadImage(2);
            this.pipoShad = this.loadImage(51);
            this.bgrImage = Lands.getBgrImage(this.keyLand);
            this.road_y = this.bgr_y + this.bgrImage.getHeight() - 42;
            this.pipoSprite = this.screenManager.store.getInt(strings.CHAR_SLTD) == 2 ? new GameSprite(this.loadImage(47), 6, 1) : new GameSprite(this.loadImage(46), 6, 1);
            this.pipoSprite.setTimeSequence(150);
            this.pipoSprite.setPositionFoot(this.bgr_x, this.road_y);
            this.robImage = this.loadImage(57);
            this.rob_x = _width - this.robImage.getWidth() - 90;
            this.rob_y = this.road_y - this.robImage.getHeight() - 6;
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isFirePrd()) {
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, this.bgr_x, this.bgr_y, 0);
        if (this.pipoSprite.getX() > this.rob_x - this.pipoSprite.getWidth() - 10) {
            this.fadeCounter += frameTime;
            if (this.fadeCounter > 400) {
                this.fadeCounter = 400;
                this.meetCounter += frameTime;
                if (this.meetCounter > 2000 && !this.isExiting()) {
                    this.exitScreen();
                }
            }
            this.drawFade(g, 0, (float)this.fadeCounter / 600.0f);
            this.pipoSprite.setFrame(0);
        } else {
            this.pipoSprite.updateFrame(frameTime, true);
            this.pipoSprite.move(this.poSpeed, 0, frameTime);
        }
        this.drawPiPo(g);
        HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.drawFade(g, 0);
            }
        }
    }

    protected void drawPiPo(Graphics g) {
        g.drawImage(this.robImage, this.rob_x + 10, this.rob_y - 10, 0);
        g.drawImage(this.robImage, this.rob_x - 10, this.rob_y - 10, 0);
        g.drawImage(this.robImage, this.rob_x, this.rob_y, 0);
        this.pipoSprite.paint(g);
        g.drawImage(this.pipoShad, this.pipoSprite.getX(), this.pipoSprite.getFootY() - this.pipoShad.getHeight() / 2, 0);
    }
}

