/*
 * Decompiled with CFR 0.152.
 */
package com.pipogame.fad.scen;

import com.pipogame.GameScreen;
import com.pipogame.Input;
import com.pipogame.Store;
import com.pipogame.components.GameSprite;
import com.pipogame.fad.HelpDraw;
import com.pipogame.fad.stag.Lands;
import com.pipogame.fad.strings;
import com.pipogame.util.Drawer;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;

public class RainScreen
extends GameScreen {
    private Image paperTopImage;
    private Image paperMidImage;
    private Image paperBotImage;
    private Image bgrImage;
    protected GameSprite[] weatherSprite;
    GameSprite piSprite;
    GameSprite poSprite;
    Image pipoShad;
    int keyLand;
    int bgr_x = 23;
    int bgr_y = 8;

    public RainScreen(int keyLand) {
        this.keyLand = keyLand;
    }

    public void initialize() throws Exception {
        super.initialize();
        this.transitionOffTime = 500;
        this.transitionOnTime = 500;
        this.asset = Store.loadJar(strings.SHARE_FILE);
    }

    public void loadContent() throws Exception {
        super.loadContent();
        this.paperTopImage = this.loadImage(0);
        this.paperBotImage = this.loadImage(1);
        this.paperMidImage = this.loadImage(2);
        this.bgrImage = Lands.getBgrImage(this.keyLand);
        this.pipoShad = this.loadImage(51);
        int curChar = this.screenManager.store.getInt(strings.CHAR_SLTD);
        int curStage = this.screenManager.store.getInt(strings.STAGE);
        if (curChar == 1 || curStage <= 4 || curStage >= 17) {
            this.piSprite = new GameSprite(this.loadImage(46), 6, 1);
            this.piSprite.setTimeSequence(150);
            this.piSprite.setFrame(2);
            this.piSprite.setPositionFoot(this.bgr_x, this.bgr_y + this.bgrImage.getHeight() - 42);
        }
        if (curChar == 2 || curStage <= 4 || curStage >= 24) {
            this.poSprite = new GameSprite(this.loadImage(47), 6, 1);
            this.poSprite.setTimeSequence(150);
            this.poSprite.setPositionFoot(this.bgr_x - 23, this.bgr_y + this.bgrImage.getHeight() - 49);
        }
        Graphics g = this.bgrImage.getGraphics();
        Drawer.drawBg(g, 0, 0, this.bgrImage.getWidth(), this.bgrImage.getHeight(), 0x40000000);
        GameSprite sprite = new GameSprite(this.loadImage(45), 7, 1);
        sprite.setTimeSequence(30);
        int wid = (_width - this.bgr_x) / sprite.getWidth() + 1;
        int hei = (_height - this.bgr_y) / sprite.getHeight() + 1;
        this.weatherSprite = new GameSprite[wid * hei];
        for (int i = 0; i < this.weatherSprite.length; ++i) {
            this.weatherSprite[i] = new GameSprite(sprite);
            this.weatherSprite[i].setPosition(i % wid * sprite.getWidth() + this.bgr_x, i / wid * sprite.getHeight() + this.bgr_y);
        }
    }

    public void handleInput(Input input, int frameTime) {
        if (input.isFirePrd()) {
            this.exitScreen();
        }
    }

    public void update(int frameTime, boolean covered) {
        for (int i = 0; i < this.weatherSprite.length; ++i) {
            this.weatherSprite[i].updateFrame(frameTime, true);
        }
        if (this.piSprite != null) {
            this.piSprite.updateFrame(frameTime, true);
            this.piSprite.move(20, 0, frameTime);
            if (this.piSprite.getX() > _width) {
                this.exitScreen();
            }
        }
        if (this.poSprite != null) {
            this.poSprite.updateFrame(frameTime, true);
            this.poSprite.move(20, 0, frameTime);
            if (this.poSprite.getX() > _width) {
                this.exitScreen();
            }
        }
    }

    public void draw(Graphics g, int frameTime) {
        g.drawImage(this.bgrImage, this.bgr_x, this.bgr_y, 0);
        this.drawPiPo(g);
        for (int i = 0; i < this.weatherSprite.length; ++i) {
            this.weatherSprite[i].paint(g);
        }
        HelpDraw.drawPaper(g, this.paperTopImage, this.paperBotImage, this.paperMidImage, this.screenManager.screenType);
        switch (this.screenState) {
            case 1: 
            case 4: {
                this.drawFade(g, 0);
            }
        }
    }

    public void finalize() {
        super.finalize();
    }

    protected void drawPiPo(Graphics g) {
        if (this.poSprite != null) {
            this.poSprite.paint(g);
            g.drawImage(this.pipoShad, this.poSprite.getX(), this.poSprite.getFootY() - this.pipoShad.getHeight() / 2, 0);
        }
        if (this.piSprite != null) {
            this.piSprite.paint(g);
            g.drawImage(this.pipoShad, this.piSprite.getX(), this.piSprite.getFootY() - this.pipoShad.getHeight() / 2, 0);
        }
    }
}

