/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.ads;

import tv.ingames.j2dm.ads.IAdBanner;
import tv.ingames.j2dm.ads.J2DM_AdBanner;
import tv.ingames.j2dm.ads.J2DM_StateParametersGenericAPIAds;
import tv.ingames.j2dm.core.J2DM_AbstractState;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.display.ui.IButtonCallBack;
import tv.ingames.j2dm.display.ui.J2DM_GenericButton;
import tv.ingames.j2dm.display.ui.J2DM_GenericButtonWithText;
import tv.ingames.j2dm.display.ui.J2DM_SimpleMenu;
import tv.ingames.j2dm.ingames.J2DM_GameData;
import tv.ingames.j2dm.ingames.J2DM_Ingames;
import tv.ingames.j2dm.loader.J2DM_Loader;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoaderHttpImage;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.utils.J2DM_Point;

public class J2DM_StateGenericApiAds
extends J2DM_AbstractState
implements IButtonCallBack,
IAdBanner {
    public static final int STATE_NONE = 0;
    public static final int STATE_LOADING_XML = 1;
    public static final int STATE_LOADING_IMAGE = 2;
    public static final int STATE_SHOWING_BANNER = 3;
    public static final int STATE_BANNER_READY = 4;
    public static final int STATE_ERROR_PARSING = 5;
    public static final int STATE_INHOUSE_BANNER = 6;
    protected int _bgColorBackUp;
    protected int[] _itemsLoader;
    protected J2DM_TextField _textFieldLoadingAd;
    protected long _timeInit;
    protected int _timeToWait = 15000;
    protected int _timeShow;
    protected int _lastNumberShown = -100;
    protected int _state;
    protected int _idLoaderXML;
    protected int _idLoaderUrlImage;
    protected String _xmlUrlImage;
    protected String _xmlClick;
    protected String _xmlText;
    protected J2DM_AdBanner _adBanner;
    protected J2DM_SimpleMenu _menu;
    protected J2DM_TextField _textField;
    protected J2DM_GameData _inHouseGameData;

    public J2DM_StateGenericApiAds() {
    }

    public J2DM_StateGenericApiAds(J2DM_StateParametersGenericAPIAds params) {
        super(params);
    }

    public void create() {
        this.setState(0);
        this._bgColorBackUp = J2DM_Stage.getInstance().getBgColor();
        J2DM_Stage.getInstance().setBgColor(((J2DM_StateParametersGenericAPIAds)this._params).getBgColor());
        int[] itemsLoaderIds = new int[]{((J2DM_StateParametersGenericAPIAds)this._params).getIdLoaderButton()};
        this._itemsLoader = itemsLoaderIds;
        this.loadResources(this._itemsLoader, false);
    }

    protected void loadResourcesComplete() {
        boolean isComplete = J2DM_Loader.getInstance().checkCompleteStateByVector(this._itemsLoader);
        if (isComplete) {
            switch (this._state) {
                case 0: {
                    this.setState(1);
                    break;
                }
                case 1: {
                    this.onLoadingXML();
                    break;
                }
                case 2: {
                    this.onLoadingImage();
                    break;
                }
                case 6: {
                    this.showInHouseBanner();
                }
            }
        }
    }

    private void setState(int state) {
        this._state = state;
        switch (this._state) {
            case 0: {
                break;
            }
            case 1: {
                this.setStateLoadingXml();
                this.startCountDown();
                break;
            }
            case 2: {
                this.setStateLoadBanner();
                break;
            }
            case 3: {
                break;
            }
            case 4: {
                this.bannerReady();
                break;
            }
            case 5: {
                break;
            }
            case 6: {
                this.loadInHouseBanner();
            }
        }
    }

    public void update() {
        switch (this._state) {
            case 1: 
            case 2: {
                this.controlCountDown();
            }
        }
    }

    protected void setStateLoadingXml() {
        this._textFieldLoadingAd = new J2DM_TextField(((J2DM_StateParametersGenericAPIAds)this._params).getFontName(), ((J2DM_StateParametersGenericAPIAds)this._params).getTextLoadingAd());
        this._textFieldLoadingAd.setX(J2DM_Stage.getInstance().getWidth() / 2);
        this._textFieldLoadingAd.setY((int)((float)J2DM_Stage.getInstance().getHeight() * 0.5f));
        this._textFieldLoadingAd.setAnchorY(2);
        J2DM_Stage.getInstance().addElement(this._textFieldLoadingAd, 3);
    }

    protected void onLoadingXML() {
        boolean validData = this.parseXML(J2DM_Loader.getInstance().getTextById(this._idLoaderXML));
        if (validData) {
            this.setState(2);
        }
    }

    protected void startCountDown() {
        this._timeInit = System.currentTimeMillis();
    }

    protected boolean parseXML(String data) {
        return false;
    }

    protected void controlCountDown() {
        long timeNow = System.currentTimeMillis();
        long deltaTime = timeNow - this._timeInit;
        if (deltaTime < (long)this._timeToWait) {
            this._timeShow = this._timeToWait / 1000 - (int)(deltaTime / 1000L);
            if (this._lastNumberShown != this._timeShow) {
                this._lastNumberShown = this._timeShow;
                this._textFieldLoadingAd.setText(String.valueOf(((J2DM_StateParametersGenericAPIAds)this._params).getTextLoadingAd()) + "||" + this._timeShow);
            }
        } else {
            this.removeTextFieldLoadingAd();
            this.setState(6);
        }
    }

    private void removeTextFieldLoadingAd() {
        if (this._textFieldLoadingAd != null) {
            J2DM_Stage.getInstance().removeElement(this._textFieldLoadingAd, 3);
            this._textFieldLoadingAd.destroy();
            this._textFieldLoadingAd = null;
        }
    }

    protected void loadInHouseBanner() {
        this._inHouseGameData = J2DM_Ingames.getInstance().getRandomDataBanner();
        int[] itemsLoaderIds = new int[]{this._inHouseGameData.getIdBannerAdFileImage()};
        this._itemsLoader = itemsLoaderIds;
        this.loadResources(this._itemsLoader, false);
    }

    protected void showInHouseBanner() {
        J2DM_Image imageBanner = J2DM_Loader.getInstance().getImageById(this._inHouseGameData.getIdBannerAdFileImage());
        this._adBanner = new J2DM_AdBanner(imageBanner, this._inHouseGameData.getUrlFreeVersion(), this);
        this._adBanner.start();
    }

    protected void setStateLoadBanner() {
        this._state = 2;
        this._idLoaderUrlImage = J2DM_Loader.getInstance().addItem(new J2DM_ItemLoaderHttpImage(this._xmlUrlImage));
        this._itemsLoader = new int[1];
        this._itemsLoader[0] = this._idLoaderUrlImage;
        this.loadResources(this._itemsLoader, false);
    }

    protected void onLoadingImage() {
        this.removeTextFieldLoadingAd();
        J2DM_Image imageBanner = J2DM_Loader.getInstance().getImageById(this._idLoaderUrlImage);
        this._adBanner = new J2DM_AdBanner(imageBanner, this._xmlClick, this);
        this._adBanner.start();
        this.setState(3);
    }

    public void changeAdBannerState(int state) {
        switch (state) {
            case 2: {
                this.setState(4);
                break;
            }
            case 4: {
                this.onGoButton();
            }
        }
    }

    protected void bannerReady() {
        this._state = 4;
        J2DM_Image imageButton = J2DM_Loader.getInstance().getImageById(((J2DM_StateParametersGenericAPIAds)this._params).getIdLoaderButton());
        this._textField = new J2DM_TextField(((J2DM_StateParametersGenericAPIAds)this._params).getFontName(), ((J2DM_StateParametersGenericAPIAds)this._params).getTextSupportUs());
        this._textField.setX(((J2DM_StateParametersGenericAPIAds)this._params).getXTextSupportUs());
        this._textField.setAnchorX(4);
        this._textField.setAnchorY(2);
        this._textField.setY(((J2DM_StateParametersGenericAPIAds)this._params).getYTextSupportUs());
        J2DM_Stage.getInstance().addElement(this._textField, 3);
        J2DM_GenericButton[][] buttons = new J2DM_GenericButton[1][2];
        buttons[0][0] = new J2DM_GenericButtonWithText(imageButton, 17, ((J2DM_StateParametersGenericAPIAds)this._params).getFontName(), ((J2DM_StateParametersGenericAPIAds)this._params).getTextButtonSkip(), this);
        buttons[0][0].setX((int)((float)J2DM_Stage.getInstance().getWidth() * 0.25f));
        buttons[0][0].setY((int)((float)J2DM_Stage.getInstance().getHeight() * 0.9f));
        buttons[0][1] = new J2DM_GenericButtonWithText(imageButton, 16, ((J2DM_StateParametersGenericAPIAds)this._params).getFontName(), ((J2DM_StateParametersGenericAPIAds)this._params).getTextButtonGo(), this);
        buttons[0][1].setX((int)((float)J2DM_Stage.getInstance().getWidth() * 0.75f));
        buttons[0][1].setY((int)((float)J2DM_Stage.getInstance().getHeight() * 0.9f));
        this._menu = new J2DM_SimpleMenu(buttons, null, new J2DM_Point(0.0f, 1.0f));
        this._menu.show();
    }

    public void buttonEvent(int event, J2DM_GenericButton button) {
        if (event == 0) {
            switch (button.getTypeButton()) {
                case 17: {
                    this.onSkipButton();
                    break;
                }
                case 16: {
                    this.onGoButton();
                }
            }
        }
    }

    protected void onSkipButton() {
    }

    protected void onGoButton() {
        this._adBanner.openLink();
    }

    protected void onError(int idError) {
        if (this._state == 1 || this._state == 5 || this._state == 2) {
            this.removeTextFieldLoadingAd();
            this.setState(6);
        }
    }

    public void destroy() {
        super.destroy();
        J2DM_Loader.getInstance().unsuscribeElement(this);
        if (this._textField != null) {
            J2DM_Stage.getInstance().removeElement(this._textField, 3);
            this._textField.destroy();
            this._textField = null;
        }
        this.removeTextFieldLoadingAd();
        if (this._adBanner != null) {
            this._adBanner.destroy();
            this._adBanner = null;
        }
        if (this._menu != null) {
            this._menu.destroy();
            this._menu = null;
        }
        J2DM_Stage.getInstance().setBgColor(this._bgColorBackUp);
    }
}

