/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.keyboardTouch;

import javax.microedition.lcdui.Font;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.lcdui.game.Sprite;
import javax.microedition.lcdui.game.TiledLayer;
import tv.ingames.j2dm.keyboardTouch.Button;

public abstract class MatrixButton
extends Button {
    private int fontColor = 0;
    private Font font = Font.getFont((int)32, (int)1, (int)16);
    private int previewFontColor = 0;
    int yOffsetPixelsPreview = 4;
    private Sprite keyPreview;
    private char[][] currentKeys;
    private int keyWidth;
    private int keyHeight;
    private boolean paintPreview;
    private int selectedCell;
    private boolean selected;

    public MatrixButton(char[][] currentKeys, int keyWidth, int keyHeight, Image img, Sprite keyPreview) {
        this.currentKeys = currentKeys;
        this.keyWidth = keyWidth;
        this.keyHeight = keyHeight;
        this.keyPreview = keyPreview;
        keyPreview.setFrame(2);
        this.layer = new TiledLayer(currentKeys[0].length, currentKeys.length, img, keyWidth, keyHeight);
        int column = 0;
        while (column < ((TiledLayer)this.layer).getColumns()) {
            int row = 0;
            while (row < ((TiledLayer)this.layer).getRows()) {
                ((TiledLayer)this.layer).setCell(column, row, 1);
                ++row;
            }
            ++column;
        }
    }

    public boolean isSelected(int posX, int posY) {
        this.selected = false;
        Sprite singlePoint = new Sprite(Image.createImage((int)1, (int)1));
        singlePoint.setPosition(posX, posY);
        this.selected = singlePoint.collidesWith((TiledLayer)this.layer, false);
        if (this.selected) {
            this.detectSelectedCell(posX, posY);
        }
        return this.selected;
    }

    private void detectSelectedCell(int posX, int posY) {
        if (this.selected) {
            int column = (posX + this.keyWidth - this.getX()) / this.keyWidth;
            int row = (posY + this.keyHeight - this.getY()) / this.keyHeight;
            this.selectedCell = this.getCellNumber(--column, --row);
        }
    }

    public void press() {
        int[] xy = this.getCoordinates(this.selectedCell);
        if (this.currentKeys[xy[1]][xy[0]] != '\u0000') {
            ((TiledLayer)this.layer).setCell(xy[0], xy[1], 2);
            this.paintPreview = true;
        }
    }

    public void release() {
        this.unSelect();
        this.execute();
        this.selectedCell = -1;
        this.selected = false;
    }

    public abstract void execute();

    public int hashCode() {
        return this.selectedCell;
    }

    public void unSelect() {
        this.paintPreview = false;
        int[] xy = this.getCoordinates(this.selectedCell);
        ((TiledLayer)this.layer).setCell(xy[0], xy[1], 1);
    }

    public void unSelect(int cellNumber) {
        this.paintPreview = false;
        int[] xy = this.getCoordinates(cellNumber);
        ((TiledLayer)this.layer).setCell(xy[0], xy[1], 1);
    }

    public char[][] getCurrentKeys() {
        return this.currentKeys;
    }

    public void setCurrentKeys(char[][] currentKeys) {
        this.currentKeys = currentKeys;
    }

    public int getCellNumber(int x, int y) {
        int response = -1;
        response = y * ((TiledLayer)this.layer).getColumns() + x;
        return response;
    }

    public int[] getCoordinates(int cellNumber) {
        int numColumnas = ((TiledLayer)this.layer).getColumns();
        int y = cellNumber / numColumnas;
        int x = cellNumber - numColumnas * y;
        return new int[]{x, y};
    }

    public void paint(Graphics g) {
        this.layer.paint(g);
        this.drawCharacters(g);
        if (this.paintPreview) {
            this.paintPreview(g);
        }
    }

    private void drawCharacters(Graphics graphics) {
        graphics.setFont(this.font);
        graphics.setColor(this.fontColor);
        int posx = ((TiledLayer)this.layer).getX() + this.keyWidth / 2;
        int posy = ((TiledLayer)this.layer).getY() + this.keyHeight / 2;
        int i = 0;
        while (i < this.currentKeys.length) {
            int j = 0;
            while (j < this.currentKeys[i].length) {
                if (this.currentKeys[i][j] != '\u0000') {
                    graphics.drawChar(this.currentKeys[i][j], posx, posy + this.font.getHeight() / 2, 65);
                }
                posx += this.keyWidth;
                ++j;
            }
            posx = ((TiledLayer)this.layer).getX() + this.keyWidth / 2;
            posy += this.keyHeight;
            ++i;
        }
    }

    private void paintPreview(Graphics graphics) {
        int[] xy = this.getCoordinates(this.selectedCell);
        int posx = this.layer.getX() + xy[0] * this.keyWidth;
        int posy = this.layer.getY() + (xy[1] - 1) * this.keyHeight - this.yOffsetPixelsPreview;
        this.keyPreview.setPosition(posx, posy);
        this.keyPreview.paint(graphics);
        graphics.setFont(this.font);
        graphics.setColor(this.previewFontColor);
        graphics.drawChar(this.currentKeys[xy[1]][xy[0]], posx + this.keyWidth / 2, posy + this.keyHeight / 2 + this.font.getHeight() / 2, 65);
    }

    public char getSelectedChar() {
        int[] xy = this.getCoordinates(this.selectedCell);
        return this.currentKeys[xy[1]][xy[0]];
    }

    public void setFontColor(int fontColor) {
        this.fontColor = fontColor;
    }

    public void setFont(Font font) {
        this.font = font;
    }

    public void setPreviewFontColor(int previewFontColor) {
        this.previewFontColor = previewFontColor;
    }
}

