/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.platform;

import javax.microedition.lcdui.Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.stage.J2DM_Stage;

public class J2DM_Graphics {
    public static final int HCENTER = 1;
    public static final int VCENTER = 2;
    public static final int LEFT = 4;
    public static final int RIGHT = 8;
    public static final int TOP = 16;
    public static final int BOTTOM = 32;
    private Graphics _graphics;
    private int _alpha;
    private int _widthScreen;
    private int _heigthScreen;

    public J2DM_Graphics() {
        this._alpha = 255;
        this._widthScreen = J2DM_Stage.getInstance().getWidth();
        this._heigthScreen = J2DM_Stage.getInstance().getHeight();
    }

    public J2DM_Graphics(J2DM_Image image) {
        this._graphics = image.getImage().getGraphics();
        this._alpha = 255;
        this._widthScreen = J2DM_Stage.getInstance().getWidth();
        this._heigthScreen = J2DM_Stage.getInstance().getHeight();
    }

    public void drawImage(int x, int y, int width, int height, J2DM_Image image, int regx, int regy) {
        this._graphics.setClip(x, y, width, height);
        this._graphics.drawImage(image.getImage(), x - regx, y - regy, 20);
    }

    public void drawImage(int x, int y, int width, int height, J2DM_Image image, int regPoint) {
        this._graphics.setClip(0, 0, this._widthScreen, this._heigthScreen);
        this._graphics.drawImage(image.getImage(), x, y, regPoint);
    }

    public void drawString(String text, int x, int y) {
        this._graphics.setClip(0, 0, this._widthScreen, this._heigthScreen);
        this._graphics.drawString(text, x, y, 20);
    }

    public void setColor(int RGB) {
        this._graphics.setColor(RGB);
    }

    public void drawRect(int x, int y, int width, int height) {
        this._graphics.setClip(x, y, width + 1, height + 1);
        this._graphics.drawRect(x, y, width, height);
    }

    public void fillRect(int x, int y, int width, int height) {
        this._graphics.setClip(x, y, width + 1, height + 1);
        if (this._alpha != 255 && width != 0 && height != 0) {
            int[] mRGB = new int[width * height];
            int color = this._alpha << 24 | this._graphics.getRedComponent() << 16 | this._graphics.getGreenComponent() << 8 | this._graphics.getBlueComponent();
            int i = 0;
            while (i < mRGB.length) {
                mRGB[i] = color;
                ++i;
            }
            this._graphics.drawRGB(mRGB, 0, 0, x, y, width, height, true);
        } else {
            this._graphics.fillRect(x, y, width, height);
        }
    }

    public void drawLine(int x1, int y1, int x2, int y2) {
        this._graphics.setClip(x1, y1, x2, y2);
        this._graphics.drawLine(x1, y1, x2, y2);
    }

    public void setClip(int x1, int y1, int width, int height) {
        this._graphics.setClip(x1, y1, width, height);
    }

    public void setGlobalAlpha(int alpha) {
        this._alpha = alpha * 255 / 100;
        if (this._alpha < 0) {
            this._alpha = 0;
        }
        if (this._alpha > 255) {
            this._alpha = 255;
        }
    }

    public void resetAlpha() {
        this._alpha = 255;
    }

    public Graphics getGraphics() {
        return this._graphics;
    }

    public void setGraphics(Graphics graphics) {
        this._graphics = graphics;
    }

    public void destroy() {
        this._graphics = null;
    }
}

