/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.persistentData;

import tv.ingames.j2dm.ingames.J2DM_Ingames;
import tv.ingames.j2dm.persistentData.J2DM_RMSException;
import tv.ingames.j2dm.persistentData.J2DM_RecordManager;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_StringTools;

public class J2DM_HighScoreTable {
    private static J2DM_HighScoreTable _instance;
    private static String RMS_HIGH_SCORES;
    public static char SEPARATOR;
    private J2DM_RecordManager _rc = J2DM_RecordManager.getInstance();
    private int _cantGameModes;
    private int _cantScores;
    private int[][] _tableScores;
    private String[][] _tableNames;

    static {
        RMS_HIGH_SCORES = "rmsHighScore";
        SEPARATOR = (char)124;
    }

    private J2DM_HighScoreTable() {
        RMS_HIGH_SCORES = "rmsHighScore_" + J2DM_Ingames.getInstance().getMyGameData().getGameId();
    }

    public static J2DM_HighScoreTable getInstance() {
        if (_instance == null) {
            _instance = new J2DM_HighScoreTable();
        }
        return _instance;
    }

    public void init(int cantScores, int cantGameModes) {
        this._cantScores = cantScores;
        this._cantGameModes = cantGameModes;
        this._tableScores = new int[this._cantGameModes][this._cantScores];
        this._tableNames = new String[this._cantGameModes][this._cantScores];
        int i = 0;
        while (i < this._cantGameModes) {
            this.readTables(i);
            this.printTable(i);
            ++i;
        }
    }

    public int getCantScores() {
        return this._cantScores;
    }

    public int getCantGameModes() {
        return this._cantGameModes;
    }

    public int getScoreAtIndex(int gameMode, int ind) {
        return this._tableScores[gameMode][ind];
    }

    public String getNameAtIndex(int gameMode, int ind) {
        return this._tableNames[gameMode][ind];
    }

    public String[] getNameTable(int gameMode) {
        return this._tableNames[gameMode];
    }

    public int[] getScoreTable(int gameMode) {
        return this._tableScores[gameMode];
    }

    public String[] getStringScoreTable(int gameMode) {
        String[] _table = new String[this._cantScores];
        int i = 0;
        while (i < this._cantScores) {
            _table[i] = String.valueOf(this._tableScores[gameMode][i]);
            ++i;
        }
        return _table;
    }

    public boolean canAddScore(int gameMode, int newScore) {
        return newScore > this._tableScores[gameMode][this._cantScores - 1];
    }

    public void addNewScore(int gameMode, int newScore, String name) {
        if (!this.canAddScore(gameMode, newScore)) {
            return;
        }
        int ind = 0;
        int i = 0;
        while (i < this._cantScores) {
            if (newScore > this._tableScores[gameMode][i]) {
                ind = i;
                break;
            }
            ++i;
        }
        i = this._cantScores - 1;
        while (i > ind) {
            this._tableScores[gameMode][i] = this._tableScores[gameMode][i - 1];
            this._tableNames[gameMode][i] = this._tableNames[gameMode][i - 1];
            --i;
        }
        this._tableScores[gameMode][ind] = newScore;
        this._tableNames[gameMode][ind] = name;
        this.saveTable(gameMode);
    }

    private void saveTable(int gameMode) {
        String dataTableScores = "";
        int i = 0;
        while (i < this._cantScores) {
            dataTableScores = String.valueOf(dataTableScores) + this._tableScores[gameMode][i] + SEPARATOR + this._tableNames[gameMode][i] + SEPARATOR;
            ++i;
        }
        try {
            this._rc.saveData(String.valueOf(RMS_HIGH_SCORES) + gameMode, dataTableScores);
        }
        catch (J2DM_RMSException e) {
            J2DM_Console.getInstance().addLog("J2DM_HighScoreTable::saveTable", "Error saving HighScore Table", J2DM_ConsoleMessageTypes.ERROR);
        }
    }

    public void deleteTable(int gameMode) {
        try {
            this._rc.deleteRegisterZone(String.valueOf(RMS_HIGH_SCORES) + gameMode);
        }
        catch (J2DM_RMSException e) {
            J2DM_Console.getInstance().addLog("J2DM_HighScoreTable::deleteTable", "Error deleting HighScore Table", J2DM_ConsoleMessageTypes.ERROR);
        }
    }

    public void printTable(int gameMode) {
        J2DM_Console.getInstance().addLog("J2DM_HighScoreTable::printTable", "----Table HighScores----", J2DM_ConsoleMessageTypes.LOG);
        int i = 0;
        while (i < this._cantScores) {
            J2DM_Console.getInstance().addLog("J2DM_HighScoreTable::printTable", String.valueOf(this._tableNames[gameMode][i]) + " " + this._tableScores[gameMode][i], J2DM_ConsoleMessageTypes.LOG);
            ++i;
        }
    }

    /*
     * Unable to fully structure code
     */
    private void readTables(int modeGame) {
        block7: {
            try {
                tableScoresData = this._rc.readData(String.valueOf(J2DM_HighScoreTable.RMS_HIGH_SCORES) + modeGame);
                arrayDataTableScores = J2DM_StringTools.split(tableScoresData, String.valueOf(J2DM_HighScoreTable.SEPARATOR));
                if (arrayDataTableScores.length == this._cantScores * 2) {
                    i = 0;
                    while (i < this._cantScores) {
                        this._tableScores[modeGame][i] = Integer.parseInt(arrayDataTableScores[i * 2]);
                        this._tableNames[modeGame][i] = arrayDataTableScores[1 + i * 2];
                        ++i;
                    }
                } else {
                    i = 0;
                    while (i < this._cantScores) {
                        this._tableScores[modeGame][i] = 0;
                        this._tableNames[modeGame][i] = "...";
                        ++i;
                    }
                }
                break block7;
            }
            catch (J2DM_RMSException e) {
                i = 0;
                ** while (i < this._cantScores)
            }
lbl-1000:
            // 1 sources

            {
                this._tableScores[modeGame][i] = 0;
                this._tableNames[modeGame][i] = "...";
                ++i;
                continue;
            }
        }
    }
}

