/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.system.fonts;

import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Rect;

public class J2DM_Font {
    private String _name;
    private String _abc;
    private J2DM_Image _image;
    private int[][] _structData;
    private int _size;
    private J2DM_Rect[] _rect;
    private int _interline;

    public J2DM_Font(String name, String abc, J2DM_Image image, int[][] structData, int size, int interline) {
        this._name = name;
        this._abc = abc;
        this._image = image;
        this._structData = structData;
        this._size = size;
        this._interline = interline;
        this.init();
    }

    private void init() {
        if (this._abc == null || this.getCantLettersFromStructData(this._structData) != this._abc.length()) {
            J2DM_Console.getInstance().addLog("J2DM_Font::init", "inconsistent in Cant Letters", J2DM_ConsoleMessageTypes.ERROR);
            return;
        }
        if (this._image == null) {
            J2DM_Console.getInstance().addLog("J2DM_Font::init", "image = null", J2DM_ConsoleMessageTypes.ERROR);
            return;
        }
        int cantLetters = this._abc.length();
        int cantRows = this._structData.length;
        this._rect = new J2DM_Rect[cantLetters];
        int ind = 0;
        int i = 0;
        while (i < cantRows) {
            int y = this._size * i;
            int cantLettersInRows = this._structData[i].length;
            int accumX = 0;
            int j = 0;
            while (j < cantLettersInRows) {
                this._rect[ind] = new J2DM_Rect(accumX, y, this._structData[i][j], this._size);
                ++ind;
                accumX += this._structData[i][j];
                ++j;
            }
            ++i;
        }
    }

    public boolean hasCharacter(char character) {
        int indCharacter = this._abc.indexOf(character);
        return indCharacter != -1;
    }

    public int getCharWidth(char character) {
        int indCharacter = this._abc.indexOf(character);
        if (indCharacter < 0) {
            return -1;
        }
        return this._rect[indCharacter]._width;
    }

    public boolean isReady() {
        return this._rect != null;
    }

    private int getCantLettersFromStructData(int[][] structData) {
        if (structData == null) {
            J2DM_Console.getInstance().addLog("J2DM_Font::getCantLettersFromStructData", "Null _structData", J2DM_ConsoleMessageTypes.ERROR);
            return -1;
        }
        int cantRows = this._structData.length;
        int cantLetters = 0;
        int i = 0;
        while (i < cantRows) {
            if (this._structData[i] != null) {
                cantLetters += this._structData[i].length;
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Font::getCantLettersFromStructData", "Null _structData", J2DM_ConsoleMessageTypes.ERROR);
                return -1;
            }
            ++i;
        }
        return cantLetters;
    }

    public String getName() {
        return this._name;
    }

    public String getAbc() {
        return this._abc;
    }

    public J2DM_Image getImage() {
        return this._image;
    }

    public int getSize() {
        return this._size;
    }

    public int getInterline() {
        return this._interline;
    }

    public void setInterline(int interline) {
        this._interline = interline;
    }

    public J2DM_Rect[] getRect() {
        return this._rect;
    }
}

