/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.cubeMatch.states;

import tv.ingames.cubeMatch.application.ScreenParametersApplication;
import tv.ingames.cubeMatch.core.TextKeys;
import tv.ingames.cubeMatch.loaders.ExternalFiles;
import tv.ingames.j2dm.core.J2DM_AbstractState;
import tv.ingames.j2dm.core.J2DM_AbstractStateParameters;
import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.display.textfield.J2DM_TextField;
import tv.ingames.j2dm.display.ui.IButtonCallBack;
import tv.ingames.j2dm.display.ui.J2DM_GenericButton;
import tv.ingames.j2dm.display.ui.J2DM_GenericButtonWithText;
import tv.ingames.j2dm.display.ui.J2DM_SimpleMenu;
import tv.ingames.j2dm.gameplay.J2DM_GamePlayParameters;
import tv.ingames.j2dm.loader.J2DM_Loader;
import tv.ingames.j2dm.media.languaje.J2DM_Language;
import tv.ingames.j2dm.persistentData.J2DM_HighScoreTable;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.platform.J2DM_WebtrendsManager;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.utils.J2DM_Point;

public class StateHighScoresTable
extends J2DM_AbstractState
implements IButtonCallBack {
    private int _cantGameModes;
    private static int _indGameModes = 0;
    private J2DM_SimpleMenu _menu;
    private J2DM_TextField _nameText;
    private J2DM_TextField _scoreText;
    private J2DM_TextField _textFieldModeGame;
    static /* synthetic */ Class class$0;

    public StateHighScoresTable() {
    }

    public StateHighScoresTable(J2DM_AbstractStateParameters params) {
        super(params);
    }

    public static int getIndGamesMode() {
        return _indGameModes;
    }

    public static void setIndGamesMode(int value) {
        _indGameModes = value;
    }

    public void create() {
        J2DM_WebtrendsManager.getInstance().sendData(2, "/mainscreen/HighScoreState", "High Score State", "High_Score", null);
        this._cantGameModes = J2DM_GamePlayParameters.getInstance().getCantGameModes();
        int[] itemsLoaderIds = new int[]{ExternalFiles.BUTTON_MENU, ExternalFiles.BACKGROUND_MENU, ExternalFiles.POP_UP_WINDOW, ExternalFiles.DOTS};
        this.loadResources(itemsLoaderIds, false);
    }

    protected void loadResourcesComplete() {
        J2DM_Image imageBackGround = J2DM_Loader.getInstance().getImageById(ExternalFiles.BACKGROUND_MENU);
        J2DM_Image imagePopUp = J2DM_Loader.getInstance().getImageById(ExternalFiles.POP_UP_WINDOW);
        J2DM_Image imageDots = J2DM_Loader.getInstance().getImageById(ExternalFiles.DOTS);
        J2DM_Image newImage = new J2DM_Image(J2DM_Image.getDefaultType(), J2DM_Stage.getInstance().getWidth(), J2DM_Stage.getInstance().getHeight());
        J2DM_Graphics newGraphics = new J2DM_Graphics(newImage);
        newGraphics.drawImage(0, 0, J2DM_Stage.getInstance().getWidth(), J2DM_Stage.getInstance().getHeight(), imageBackGround, 20);
        newGraphics.drawImage(ScreenParametersApplication.POP_UP_WINDOWS_X, ScreenParametersApplication.POP_UP_WINDOWS_Y, imagePopUp.getWidth(), imagePopUp.getHeight(), imagePopUp, 3);
        newGraphics.drawImage(ScreenParametersApplication.POP_UP_WINDOWS_X - imagePopUp.getWidth() / 2, ScreenParametersApplication.HIGH_SCORES_TITLE_MODE_Y + 6, imageDots.getWidth(), imageDots.getHeight(), imageDots, 6);
        newGraphics.drawImage(ScreenParametersApplication.POP_UP_WINDOWS_X + imagePopUp.getWidth() / 2, ScreenParametersApplication.HIGH_SCORES_TITLE_MODE_Y + 6, imageDots.getWidth(), imageDots.getHeight(), imageDots, 10);
        J2DM_GenericButton[][] buttons = this._cantGameModes > 1 ? this.getButtonModeGames() : this.getButtonOneModeGame();
        J2DM_Point indSelected = this._cantGameModes > 1 ? new J2DM_Point(0.0f, 1.0f) : new J2DM_Point(0.0f, 0.0f);
        this._menu = new J2DM_SimpleMenu(buttons, new J2DM_Sprite(newImage, new J2DM_Point(0.0f, 0.0f)), indSelected);
        this._menu.show();
        String[] nameTable = J2DM_HighScoreTable.getInstance().getNameTable(_indGameModes);
        this._nameText = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, nameTable);
        this._nameText.setX(ScreenParametersApplication.HIGH_SCORES_TEXTFIELD_NAMES_X);
        this._nameText.setY(ScreenParametersApplication.HIGH_SCORES_TEXTFIELD_NAMES_Y);
        this._nameText.setAnchorX(4);
        J2DM_Stage.getInstance().addElement(this._nameText, 3);
        String[] scoreTable = J2DM_HighScoreTable.getInstance().getStringScoreTable(_indGameModes);
        this._scoreText = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, scoreTable);
        this._scoreText.setX(ScreenParametersApplication.HIGH_SCORES_TEXTFIELD_SCORES_X);
        this._scoreText.setY(ScreenParametersApplication.HIGH_SCORES_TEXTFIELD_SCORES_Y);
        J2DM_Stage.getInstance().addElement(this._scoreText, 3);
        this._textFieldModeGame = new J2DM_TextField(ScreenParametersApplication.FONT_GAME, String.valueOf(J2DM_Language.getInstance().getTextByKey(15)) + " - " + J2DM_Language.getInstance().getTextByKey(TextKeys.MODES_GAME[_indGameModes]));
        J2DM_Stage.getInstance().addElement(this._textFieldModeGame, 3);
        this._textFieldModeGame.setX(ScreenParametersApplication.HIGH_SCORES_TITLE_MODE_X);
        this._textFieldModeGame.setY(ScreenParametersApplication.HIGH_SCORES_TITLE_MODE_Y);
    }

    private void refreshTextFields() {
        this._nameText.setText(J2DM_HighScoreTable.getInstance().getNameTable(_indGameModes));
        this._scoreText.setText(J2DM_HighScoreTable.getInstance().getStringScoreTable(_indGameModes));
        this._textFieldModeGame.setText(String.valueOf(J2DM_Language.getInstance().getTextByKey(15)) + " - " + J2DM_Language.getInstance().getTextByKey(TextKeys.MODES_GAME[_indGameModes]));
    }

    private J2DM_GenericButton[][] getButtonOneModeGame() {
        J2DM_Image imageButton = J2DM_Loader.getInstance().getImageById(ExternalFiles.BUTTON_MENU);
        J2DM_GenericButton[][] buttons = new J2DM_GenericButton[1][1];
        buttons[0][0] = new J2DM_GenericButtonWithText(imageButton, 5, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(7), this);
        buttons[0][0].setX(ScreenParametersApplication.HIGH_SCORES_BTN_MENU_X);
        buttons[0][0].setY(ScreenParametersApplication.HIGH_SCORES_BTNS_Y);
        return buttons;
    }

    private J2DM_GenericButton[][] getButtonModeGames() {
        J2DM_Image imageButton = J2DM_Loader.getInstance().getImageById(ExternalFiles.BUTTON_MENU);
        J2DM_GenericButton[][] buttons = new J2DM_GenericButton[1][3];
        buttons[0][0] = new J2DM_GenericButtonWithText(imageButton, 9, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(48), this);
        buttons[0][0].setX(ScreenParametersApplication.HIGH_SCORES_BTN_BACK_X);
        buttons[0][0].setY(ScreenParametersApplication.HIGH_SCORES_BTNS_Y);
        buttons[0][1] = new J2DM_GenericButtonWithText(imageButton, 5, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(7), this);
        buttons[0][1].setX(ScreenParametersApplication.HIGH_SCORES_BTN_MENU_X);
        buttons[0][1].setY(ScreenParametersApplication.HIGH_SCORES_BTNS_Y);
        buttons[0][2] = new J2DM_GenericButtonWithText(imageButton, 11, ScreenParametersApplication.FONT_GAME, J2DM_Language.getInstance().getTextByKey(49), this);
        buttons[0][2].setX(ScreenParametersApplication.HIGH_SCORES_BTN_NEXT_X);
        buttons[0][2].setY(ScreenParametersApplication.HIGH_SCORES_BTNS_Y);
        return buttons;
    }

    public void buttonEvent(int event, J2DM_GenericButton button) {
        block8: {
            if (event != 0) break block8;
            switch (button.getTypeButton()) {
                case 5: {
                    Class<?> clazz = class$0;
                    if (clazz == null) {
                        try {
                            clazz = class$0 = Class.forName("tv.ingames.cubeMatch.states.StatePrincipalMenu");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    this._gameLoop.changeState(clazz);
                    break;
                }
                case 11: {
                    if (_indGameModes + 1 >= this._cantGameModes) break;
                    ++_indGameModes;
                    this.refreshTextFields();
                    break;
                }
                case 9: {
                    if (_indGameModes - 1 < 0) break;
                    --_indGameModes;
                    this.refreshTextFields();
                }
            }
        }
    }

    public void specialKeyPressed(int keyCode) {
        switch (keyCode) {
            case 5: {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("tv.ingames.cubeMatch.states.StatePrincipalMenu");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                this._gameLoop.changeState(clazz);
            }
        }
    }

    public void destroy() {
        super.destroy();
        if (this._menu != null) {
            this._menu.destroy();
            this._menu = null;
        }
        if (this._scoreText != null) {
            J2DM_Stage.getInstance().removeElement(this._scoreText, 3);
            this._scoreText.destroy();
            this._scoreText = null;
        }
        if (this._nameText != null) {
            J2DM_Stage.getInstance().removeElement(this._nameText, 3);
            this._nameText.destroy();
            this._nameText = null;
        }
        if (this._textFieldModeGame != null) {
            J2DM_Stage.getInstance().removeElement(this._textFieldModeGame, 3);
            this._textFieldModeGame.destroy();
            this._textFieldModeGame = null;
        }
        J2DM_Loader.getInstance().deleteItemContentById(ExternalFiles.BUTTON_MENU);
        J2DM_Loader.getInstance().deleteItemContentById(ExternalFiles.BACKGROUND_MENU);
        J2DM_Loader.getInstance().deleteItemContentById(ExternalFiles.POP_UP_WINDOW);
        J2DM_Loader.getInstance().deleteItemContentById(ExternalFiles.DOTS);
    }
}

