/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.loader;

import java.util.Vector;
import tv.ingames.j2dm.loader.ILoader;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoader;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoaderHttpImage;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoaderHttpText;
import tv.ingames.j2dm.loader.items.J2DM_ItemLoaderImage;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;

public class J2DM_Loader
implements ILoader {
    private static J2DM_Loader _instance;
    private int _maxSimultaneousLoaders = 5;
    private Vector _waitingQueue;
    private Vector _itemsLoader = new Vector();
    private int _dynamicCounter = 0;
    private Vector _suscribeElements;

    private J2DM_Loader() {
        this._waitingQueue = new Vector();
        this._suscribeElements = new Vector();
    }

    public static J2DM_Loader getInstance() {
        if (_instance == null) {
            _instance = new J2DM_Loader();
        }
        return _instance;
    }

    public int addItem(J2DM_ItemLoader item) {
        if (item == null) {
            J2DM_Console.getInstance().addLog("J2DM_Loader::addItem", "The item is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return -1;
        }
        this._itemsLoader.addElement(item);
        item.setId(this._itemsLoader.size() - 1);
        return item.getId();
    }

    public void setMaxSimultaneousLoaders(int value) {
        if (value > this._maxSimultaneousLoaders && this._waitingQueue.size() > 0) {
            while (this._waitingQueue.size() > 0 && this._dynamicCounter < value) {
                J2DM_ItemLoader newItem = (J2DM_ItemLoader)this._waitingQueue.elementAt(0);
                newItem.load(this);
                this._waitingQueue.removeElementAt(0);
                ++this._dynamicCounter;
            }
        }
        this._maxSimultaneousLoaders = value;
    }

    public void loadResources(int[] itemLoaderIds) {
        int i = 0;
        while (i < itemLoaderIds.length) {
            int idItemLoader = itemLoaderIds[i];
            if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
                if (this._dynamicCounter < this._maxSimultaneousLoaders) {
                    ((J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader)).load(this);
                    ++this._dynamicCounter;
                } else {
                    this._waitingQueue.addElement(this._itemsLoader.elementAt(idItemLoader));
                }
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Loader::loadResources", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            }
            ++i;
        }
    }

    public int getStatusById(int idItemLoader) {
        if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            return ((J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader)).getStatus();
        }
        J2DM_Console.getInstance().addLog("J2DM_Loader::getStatusById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return -1;
    }

    public J2DM_Image getImageById(int idItemLoader) {
        if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
            if (item.getStatus() == 2) {
                if (item instanceof J2DM_ItemLoaderImage || item instanceof J2DM_ItemLoaderHttpImage) {
                    return (J2DM_Image)item.getContent();
                }
                J2DM_Console.getInstance().addLog("J2DM_Loader::getImageById", "Item ID " + idItemLoader + " is not an Image Item Loader", J2DM_ConsoleMessageTypes.WARNING);
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Loader::getImageById", "Item ID " + idItemLoader + " is not fully loaded", J2DM_ConsoleMessageTypes.WARNING);
            }
        } else {
            J2DM_Console.getInstance().addLog("J2DM_Loader::getImageById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        }
        return null;
    }

    public String getTextById(int idItemLoader) {
        if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
            if (item.getStatus() == 2) {
                if (item instanceof J2DM_ItemLoaderHttpText) {
                    return (String)item.getContent();
                }
                J2DM_Console.getInstance().addLog("J2DM_Loader::getTextById", "Item ID " + idItemLoader + " is not a Text Item Loader", J2DM_ConsoleMessageTypes.WARNING);
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Loader::getTextById", "Item ID " + idItemLoader + " is not fully loaded", J2DM_ConsoleMessageTypes.WARNING);
            }
        } else {
            J2DM_Console.getInstance().addLog("J2DM_Loader::getTextById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        }
        return null;
    }

    public String getPathById(int idItemLoader) {
        if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
            return item.getPath();
        }
        J2DM_Console.getInstance().addLog("J2DM_Loader::getPathById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return null;
    }

    public int getBytesTotalById(int idItemLoader) {
        if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
            return item.getBytesTotal();
        }
        J2DM_Console.getInstance().addLog("J2DM_Loader::getBytesTotalById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return -1;
    }

    public int getBytesLoadedById(int idItemLoader) {
        if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
            return item.getBytesLoaded();
        }
        J2DM_Console.getInstance().addLog("J2DM_Loader::getBytesLoadedById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return -1;
    }

    public float getPercentByVector(int[] itemLoaderIds) {
        float acumulator = 0.0f;
        int validLength = 0;
        int i = 0;
        while (i < itemLoaderIds.length) {
            int idItemLoader = itemLoaderIds[i];
            if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
                J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
                if (item.getBytesTotal() != 0) {
                    acumulator += (float)(item.getBytesLoaded() * 100 / item.getBytesTotal());
                }
                ++validLength;
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Loader::getPercentByVector", "Item loader ID " + itemLoaderIds[i] + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            }
            ++i;
        }
        if (validLength == 0) {
            return 0.0f;
        }
        return acumulator / (float)validLength;
    }

    public void deleteItemContentByVector(int[] itemLoaderIds) {
        int i = 0;
        while (i < itemLoaderIds.length) {
            int idItemLoader = itemLoaderIds[i];
            if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
                J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
                item.deleteContent();
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Loader::deleteItemContentByVector", "Item loader ID " + itemLoaderIds[i] + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            }
            ++i;
        }
    }

    public void deleteItemContentById(int idItemLoader) {
        if (this._itemsLoader != null && idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
            J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
            item.deleteContent();
        } else {
            J2DM_Console.getInstance().addLog("J2DM_Loader::deleteItemContentById", "Item loader ID " + idItemLoader + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        }
    }

    public boolean checkCompleteStateByVector(int[] itemLoaderIds) {
        int i = 0;
        while (i < itemLoaderIds.length) {
            int idItemLoader = itemLoaderIds[i];
            if (idItemLoader >= 0 && idItemLoader < this._itemsLoader.size()) {
                J2DM_ItemLoader item = (J2DM_ItemLoader)this._itemsLoader.elementAt(idItemLoader);
                if (item.getStatus() != 2) {
                    return false;
                }
            } else {
                J2DM_Console.getInstance().addLog("J2DM_Loader::checkCompleteStateByVector", "Item loader ID " + itemLoaderIds[i] + " is out of range", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return false;
            }
            ++i;
        }
        return true;
    }

    public void onItemLoaderFinish(J2DM_ItemLoader item) {
        switch (item.getStatus()) {
            case 3: {
                J2DM_Console.getInstance().addLog("J2DM_Loader::onItemLoaderFinish", "Error loading item ID " + item.getId(), J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            }
            case 2: {
                if (this._waitingQueue.size() > 0 && this._dynamicCounter <= this._maxSimultaneousLoaders) {
                    J2DM_ItemLoader newItem = (J2DM_ItemLoader)this._waitingQueue.elementAt(0);
                    newItem.load(this);
                    this._waitingQueue.removeElementAt(0);
                } else {
                    --this._dynamicCounter;
                }
                this.dispatchSuscribeElements(item);
            }
        }
    }

    public boolean suscribeElement(ILoader element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_Loader::suscribeElement", "The Element is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = this._suscribeElements.size();
        int i = 0;
        while (i < cant) {
            if (element == (ILoader)this._suscribeElements.elementAt(i)) {
                J2DM_Console.getInstance().addLog("J2DM_Loader::suscribeElement", "The Element already exists", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return false;
            }
            ++i;
        }
        this._suscribeElements.addElement(element);
        return true;
    }

    public boolean unsuscribeElement(ILoader element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_Loader::unsuscribeElement", "Null Element", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = this._suscribeElements.size();
        int i = 0;
        while (i < cant) {
            if ((ILoader)this._suscribeElements.elementAt(i) == element) {
                this._suscribeElements.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    private void dispatchSuscribeElements(J2DM_ItemLoader item) {
        int cant = this._suscribeElements.size();
        Object[] array = new Object[cant];
        this._suscribeElements.copyInto(array);
        int i = 0;
        while (i < cant) {
            if (array[i] instanceof ILoader) {
                ((ILoader)array[i]).onItemLoaderFinish(item);
            }
            ++i;
        }
    }
}

