/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.platform;

import com.nokia.mid.ui.CustomKeyboardControl;
import com.nokia.mid.ui.VirtualKeyboard;
import com.nokia.mid.ui.orientation.Orientation;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.game.GameCanvas;
import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_KeyCodes;
import tv.ingames.j2dm.stage.J2DM_Stage;

public class J2DM_CanvasScreen
extends GameCanvas {
    private J2DM_Graphics _graphics;
    private J2DM_Stage _stage;
    private boolean _supportTouch;

    public J2DM_CanvasScreen() {
        super(false);
        this.setFullScreenMode(true);
        this._graphics = new J2DM_Graphics();
        this._stage = J2DM_Stage.getInstance();
        this._supportTouch = false;
    }

    public boolean onCloseVserv() {
        return false;
    }

    public boolean isReady() {
        return true;
    }

    public void paint(Graphics g) {
        this._graphics.setGraphics(g);
        this._stage.paint(this._graphics);
    }

    public void refreshScreen(int offsetX, int offsetY, int widthScale, int heightScale) {
        this.repaint();
    }

    public int getCurrentWidth() {
        return this.getWidth();
    }

    public int getCurrentHeight() {
        return this.getHeight();
    }

    public void setSupportTouch(boolean value) {
        this._supportTouch = value;
    }

    public boolean supportTouch() {
        return this.hasPointerEvents() && this.hasPointerMotionEvents();
    }

    public void pointerPressed(int x, int y) {
        this._stage.onMouseDown(x, y);
    }

    public void pointerReleased(int x, int y) {
        this._stage.onMouseUp(x, y);
    }

    public void pointerDragged(int x, int y) {
        this._stage.onMouseMove(x, y);
    }

    public void keyPressed(int keyCode) {
        if (keyCode >= -7) {
            int actionKey = this.getGameAction(keyCode);
            switch (actionKey) {
                case 8: {
                    this._stage.specialKeyPressed(4);
                    if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
                        this._stage.keyPressed(keyCode);
                    }
                    return;
                }
                case 1: {
                    this._stage.specialKeyPressed(0);
                    if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
                        this._stage.keyPressed(keyCode);
                    }
                    return;
                }
                case 6: {
                    if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
                        this._stage.keyPressed(keyCode);
                    }
                    this._stage.specialKeyPressed(1);
                    return;
                }
                case 5: {
                    if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
                        this._stage.keyPressed(keyCode);
                    }
                    this._stage.specialKeyPressed(3);
                    return;
                }
                case 2: {
                    if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
                        this._stage.keyPressed(keyCode);
                    }
                    this._stage.specialKeyPressed(2);
                    return;
                }
            }
        }
        if (keyCode == 8) {
            this._stage.specialKeyPressed(8);
            return;
        }
        if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
            this._stage.keyPressed(keyCode);
        } else {
            this._stage.specialKeyPressed(keyCode);
        }
    }

    public void keyReleased(int keyCode) {
        int actionKey = this.getGameAction(keyCode);
        switch (actionKey) {
            case 8: {
                this._stage.specialKeyReleased(4);
                return;
            }
            case 1: {
                this._stage.specialKeyReleased(0);
                return;
            }
            case 6: {
                this._stage.specialKeyReleased(1);
                return;
            }
            case 5: {
                this._stage.specialKeyReleased(3);
                return;
            }
            case 2: {
                this._stage.specialKeyReleased(2);
                return;
            }
        }
        if (keyCode == 8) {
            this._stage.specialKeyReleased(8);
            return;
        }
        if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
            this._stage.keyReleased(keyCode);
        } else {
            this._stage.specialKeyReleased(keyCode);
        }
    }

    public void keyRepeated(int keyCode) {
        int actionKey = this.getGameAction(keyCode);
        switch (actionKey) {
            case 8: {
                this._stage.specialKeyRepeated(4);
                return;
            }
            case 1: {
                this._stage.specialKeyRepeated(0);
                return;
            }
            case 6: {
                this._stage.specialKeyRepeated(1);
                return;
            }
            case 5: {
                this._stage.specialKeyRepeated(3);
                return;
            }
            case 2: {
                this._stage.specialKeyRepeated(2);
                return;
            }
        }
        if (keyCode == 8) {
            this._stage.specialKeyRepeated(8);
            return;
        }
        if (J2DM_KeyCodes.getInstance().getCharFromKeyCode(keyCode) != '|') {
            this._stage.keyRepeated(keyCode);
        } else {
            this._stage.specialKeyRepeated(keyCode);
        }
    }

    public void pauseApp() {
        J2DM_AbstractGameLoop.setPauseOn();
    }

    public void showNotify() {
        J2DM_AbstractGameLoop.setPauseOn();
    }

    public void showNotifys60() {
        J2DM_AbstractGameLoop.setPauseOn();
    }

    public void hideNotify() {
        J2DM_AbstractGameLoop.setPauseOn();
    }

    public void activateTouchKeyboard() {
        try {
            CustomKeyboardControl vkbControl = VirtualKeyboard.getCustomKeyboardControl();
            vkbControl.launch(1, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void deactivateTouchKeyboard() {
        try {
            CustomKeyboardControl vkbControl = VirtualKeyboard.getCustomKeyboardControl();
            vkbControl.dismiss();
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public void setOrientationScreen(int orientation) {
        switch (orientation) {
            case 0: {
                Orientation.setAppOrientation((int)1);
                break;
            }
            case 1: {
                Orientation.setAppOrientation((int)2);
            }
        }
    }
}

