/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.ads;

import tv.ingames.j2dm.ads.IAdBanner;
import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.display.J2DM_Sprite;
import tv.ingames.j2dm.platform.J2DM_Image;
import tv.ingames.j2dm.platform.J2DM_Utilities;
import tv.ingames.j2dm.stage.J2DM_Stage;

public class J2DM_AdBanner
extends J2DM_Sprite {
    public static final int STATE_NONE = 0;
    public static final int STATE_ENTER = 1;
    public static final int STATE_READY = 2;
    public static final int STATE_LEAVE = 3;
    public static final int STATE_CLICKED = 4;
    private String _clickUrl;
    private int _state;
    private float _actualX;
    private float _enterFactor;
    private IAdBanner _callbackChangeState;

    public J2DM_AdBanner(J2DM_Image image, String clickUrl, IAdBanner callbackChangeState) {
        super(image, 1, 2);
        J2DM_AbstractGameLoop.suscribeElement(this);
        J2DM_Stage.getInstance().suscribeMouseElement(this);
        this._clickUrl = clickUrl;
        this._state = 0;
        this._enterFactor = 0.2f;
        this._callbackChangeState = callbackChangeState;
    }

    public float getEnterFactor() {
        return this._enterFactor;
    }

    public void setEnterFactor(float value) {
        this._enterFactor = value;
    }

    public int getState() {
        return this._state;
    }

    public void hide() {
        J2DM_Stage.getInstance().removeElement(this, 3);
    }

    public void start() {
        J2DM_Stage.getInstance().addElement(this, 3);
        this.setState(1);
    }

    protected void setState(int state) {
        if (this._callbackChangeState != null) {
            this._callbackChangeState.changeAdBannerState(state);
        }
        this._state = state;
        switch (this._state) {
            case 1: {
                this.setStateEnter();
                break;
            }
            case 2: {
                this.setStateReady();
                break;
            }
        }
    }

    public void update() {
        super.update();
        switch (this._state) {
            case 1: {
                this.updateEnter();
                break;
            }
            case 2: {
                break;
            }
        }
    }

    protected void setStateEnter() {
        this._state = 1;
        this.setX(-this.getWidth() / 2);
        this.setY(J2DM_Stage.getInstance().getHeight() / 2);
        this._actualX = this.getX();
    }

    protected void updateEnter() {
        this._actualX += ((float)(J2DM_Stage.getInstance().getWidth() / 2) - this._actualX) * this._enterFactor;
        this.setX((int)this._actualX);
        if (Math.abs((float)(J2DM_Stage.getInstance().getWidth() / 2) - this._actualX) < 0.5f) {
            this.setState(2);
        }
    }

    protected void setStateReady() {
        this.setX(J2DM_Stage.getInstance().getWidth() / 2);
        this._state = 2;
    }

    public void destroy() {
        super.destroy();
        J2DM_Stage.getInstance().unsuscribeMouseElement(this);
        J2DM_AbstractGameLoop.unsuscribeElement(this);
        this.hide();
    }

    public void openLink() {
        J2DM_Utilities.openBrowser(this._clickUrl);
        this._state = 4;
    }

    public void onMouseDown(int x, int y) {
        this.setState(4);
    }
}

