/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.core;

import java.util.Vector;
import tv.ingames.j2dm.core.ICommonBehavior;
import tv.ingames.j2dm.core.IPaused;
import tv.ingames.j2dm.core.J2DM_AbstractState;
import tv.ingames.j2dm.core.J2DM_AbstractStateParameters;
import tv.ingames.j2dm.core.J2DM_DefaultState;
import tv.ingames.j2dm.ingames.J2DM_Releases;
import tv.ingames.j2dm.platform.J2DM_CanvasScreen;
import tv.ingames.j2dm.platform.J2DM_Main;
import tv.ingames.j2dm.stage.J2DM_Stage;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.system.input.IListenKeyboard;

public class J2DM_AbstractGameLoop
implements Runnable,
ICommonBehavior,
IListenKeyboard {
    private static int _frameRate;
    private static int _frameRateMilliseconds;
    private static long _initTime;
    private static long _finalTime;
    private static long _deltaTime;
    private static long _lastInitTime;
    private static long _timeSleep;
    private J2DM_AbstractState _currentState;
    private J2DM_AbstractStateParameters _defaultStateParameters;
    private Class _newState;
    private J2DM_AbstractStateParameters _newParams;
    private static Vector _suscribeElements;
    private static Vector _suscribePauseElements;
    private static int _game;
    private static int _release;
    public static boolean _pause;
    private static int _device;
    private int _cantSuscribeGameloop;
    private Object[] _arrayObjectsSuscribeGameloop;

    public J2DM_AbstractGameLoop(Object canvas, int width, int height, int frameRate, boolean useDoubleBuffer, int game, int release, int device) {
        _game = game;
        _release = release;
        _device = device;
        _pause = false;
        _suscribeElements = new Vector();
        _suscribePauseElements = new Vector();
        J2DM_Stage.getInstance().init(this, width, height, (J2DM_CanvasScreen)((Object)canvas), useDoubleBuffer);
        this._defaultStateParameters = new J2DM_AbstractStateParameters(this);
        this._currentState = new J2DM_DefaultState(this._defaultStateParameters);
        J2DM_AbstractGameLoop.setFrameRate(frameRate);
        new Thread(this).start();
        this.create();
    }

    public static int getCurrentKeyboard() {
        if (_device == 5 || _device == 4 || _device == 3 || _device == 16 || _device == 17 || _device == 19) {
            return 1;
        }
        return 0;
    }

    public static int getCurrentPlatform() {
        return J2DM_Releases.getCurrentPlatformFromRelease(J2DM_AbstractGameLoop.getCurrentRelease());
    }

    public static int getCurrentGameId() {
        return _game;
    }

    public static int getCurrentRelease() {
        return _release;
    }

    public static int getCurrentDevice() {
        return _device;
    }

    public static long getDeltaTimeFrame() {
        return _initTime - _lastInitTime;
    }

    public void run() {
        while (true) {
            _lastInitTime = _initTime;
            _initTime = System.currentTimeMillis();
            this.internalUpdate();
            _finalTime = System.currentTimeMillis();
            _deltaTime = _finalTime - _initTime;
            if (_deltaTime >= (long)_frameRateMilliseconds) continue;
            _timeSleep = (long)_frameRateMilliseconds - _deltaTime;
            if (_timeSleep > 5L && _timeSleep <= 10L) {
                try {
                    Thread.sleep(10L);
                }
                catch (InterruptedException e) {
                    J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::run", e.toString(), J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                }
                continue;
            }
            try {
                Thread.sleep(_timeSleep);
                continue;
            }
            catch (InterruptedException e) {
                J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::run", e.toString(), J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                continue;
            }
            break;
        }
    }

    protected void create() {
    }

    public void destroy() {
        this.deleteSuscribeElements();
    }

    public static int getFrameRate() {
        return _frameRate;
    }

    public static void setFrameRate(int value) {
        _frameRate = value;
        _frameRateMilliseconds = 1000 / _frameRate;
    }

    private synchronized void internalUpdate() {
        if (this._newState != null) {
            this.internalChangeState();
        }
        if (this._currentState != null) {
            this._currentState.update();
        }
        this._cantSuscribeGameloop = _suscribeElements.size();
        this._arrayObjectsSuscribeGameloop = new Object[this._cantSuscribeGameloop];
        _suscribeElements.copyInto(this._arrayObjectsSuscribeGameloop);
        int i = 0;
        while (i < this._cantSuscribeGameloop) {
            if (this._arrayObjectsSuscribeGameloop[i] instanceof ICommonBehavior) {
                ((ICommonBehavior)this._arrayObjectsSuscribeGameloop[i]).update();
            }
            ++i;
        }
        if (J2DM_Main.getInstance().getPauseFromRuntimeStore()) {
            J2DM_AbstractGameLoop.setPauseOn();
        }
        this.update();
    }

    public void update() {
    }

    public void changeState(Class className) {
        this.changeState(className, this._defaultStateParameters);
    }

    public void changeState(Class className, J2DM_AbstractStateParameters params) {
        this._newState = className;
        this._newParams = params;
    }

    public J2DM_AbstractState getState() {
        return this._currentState;
    }

    public void internalChangeState() {
        block4: {
            this._currentState.destroy();
            try {
                Class auxNewState = this._newState;
                Object state = this._newState.newInstance();
                if (state instanceof J2DM_AbstractState) {
                    this._currentState = (J2DM_AbstractState)state;
                    this._currentState.setParameters(this._newParams);
                    this._currentState.create();
                    if (auxNewState == this._newState) {
                        this._newState = null;
                    }
                    break block4;
                }
                J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::changeState", "The className is not J2DM_AbstractState", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return;
            }
            catch (Exception e) {
                J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::changeState", e.toString(), J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return;
            }
        }
    }

    public static boolean suscribeElement(ICommonBehavior element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::suscribeElement", "The Element is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = _suscribeElements.size();
        int i = 0;
        while (i < cant) {
            if (element == (ICommonBehavior)_suscribeElements.elementAt(i)) {
                J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::suscribeElement", "The Element already exists", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return false;
            }
            ++i;
        }
        _suscribeElements.addElement(element);
        return true;
    }

    public static boolean unsuscribeElement(ICommonBehavior element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::unsuscribeElement", "Null Element", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = _suscribeElements.size();
        int i = 0;
        while (i < cant) {
            if ((ICommonBehavior)_suscribeElements.elementAt(i) == element) {
                _suscribeElements.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean suscribePauseElement(IPaused element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::suscribeToPauseGame", "The Element is null", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = _suscribePauseElements.size();
        int i = 0;
        while (i < cant) {
            if (element == (IPaused)_suscribePauseElements.elementAt(i)) {
                J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::suscribeToPauseGame", "The Element already exists", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
                return false;
            }
            ++i;
        }
        _suscribePauseElements.addElement(element);
        return true;
    }

    public static boolean unsuscribePauseElement(IPaused element) {
        if (element == null) {
            J2DM_Console.getInstance().addLog("J2DM_AbstractGameLoop::unsuscribePauseElement", "Null Element", J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
            return false;
        }
        int cant = _suscribePauseElements.size();
        int i = 0;
        while (i < cant) {
            if ((IPaused)_suscribePauseElements.elementAt(i) == element) {
                _suscribePauseElements.removeElementAt(i);
                return true;
            }
            ++i;
        }
        return false;
    }

    public static boolean getPause() {
        return _pause;
    }

    public static void setPauseOn() {
        if (!_pause) {
            _pause = true;
            int cant = _suscribePauseElements.size();
            int i = 0;
            while (i < cant) {
                ((IPaused)_suscribePauseElements.elementAt(i)).pauseOn();
                ++i;
            }
        }
    }

    public static void setPauseOff() {
        if (_pause) {
            J2DM_Main.getInstance().setPauseToRuntimeStore(false);
            _pause = false;
            int cant = _suscribePauseElements.size();
            int i = 0;
            while (i < cant) {
                ((IPaused)_suscribePauseElements.elementAt(i)).pauseOff();
                ++i;
            }
        }
    }

    private void deleteSuscribeElements() {
        _suscribeElements.removeAllElements();
    }

    public void keyPressed(char key) {
        if (this._currentState != null) {
            this._currentState.keyPressed(key);
        }
    }

    public void keyReleased(char key) {
        if (this._currentState != null) {
            this._currentState.keyReleased(key);
        }
    }

    public void keyRepeated(char key) {
        if (this._currentState != null) {
            this._currentState.keyRepeated(key);
        }
    }

    public void specialKeyPressed(int keyCode) {
        if (this._currentState != null) {
            this._currentState.specialKeyPressed(keyCode);
        }
    }

    public void specialKeyReleased(int keyCode) {
        if (this._currentState != null) {
            this._currentState.specialKeyReleased(keyCode);
        }
    }

    public void specialKeyRepeated(int keyCode) {
        if (this._currentState != null) {
            this._currentState.specialKeyRepeated(keyCode);
        }
    }
}

