/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.display.textfield;

import tv.ingames.j2dm.display.textfield.J2DM_InputText;
import tv.ingames.j2dm.platform.J2DM_Graphics;
import tv.ingames.j2dm.platform.J2DM_KeyCodes;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;

public class J2DM_InputTextSpecial
extends J2DM_InputText {
    private static final int INSERT = 0;
    private static final int REPLACE = 1;
    private String[] _letterXnum = new String[]{"0", ".,:;$!?()=&1", "abc2", "def3", "ghi4", "jkl5", "mn\u00f1o6", "pqrs7", "tuv8", "wxyz9"};
    private int _stateInsertKey;
    private int _lastKeyPressed;
    private int _indiceSubNumero;
    private long _timeInsert;
    private int _replaceTime;

    public J2DM_InputTextSpecial(String fontName, int maxCharacters, String name) {
        super(fontName, maxCharacters, name);
        this.init();
    }

    public J2DM_InputTextSpecial(String fontName, int maxCharacters) {
        super(fontName, maxCharacters);
        this.init();
    }

    public int getReplaceTime() {
        return this._replaceTime;
    }

    public void setReplaceTime(int value) {
        this._replaceTime = value;
    }

    public String[] getLetterXNum() {
        return this._letterXnum;
    }

    public void setLetterXNum(String[] value) {
        this._letterXnum = value;
    }

    private void init() {
        this._stateInsertKey = 0;
        this._replaceTime = 1000;
        this._lastKeyPressed = -1;
    }

    public void keyPressed(char key) {
        int keyCode = J2DM_KeyCodes.getInstance().getKeyCodeFromChar(key);
        if (keyCode == -1) {
            return;
        }
        if (keyCode == 35 || keyCode == 42) {
            this.deleteKey();
        }
        if (keyCode < 48 || keyCode > 57) {
            return;
        }
        int number = keyCode - 48;
        if (this._lastKeyPressed != keyCode) {
            this._stateInsertKey = 0;
        }
        if (this._text[0].length() >= this._maxCharacters && this._stateInsertKey == 0) {
            return;
        }
        if (this._stateInsertKey == 0) {
            this._indiceSubNumero = 0;
            char charNumber = this._letterXnum[number].charAt(this._indiceSubNumero);
            char newKey = this.checkLowerUpperCase(charNumber);
            if (!this._font.hasCharacter(newKey)) {
                J2DM_Console.getInstance().addLog("J2DM_InputTextSpecial::specialKeyPressed", "The keyCode " + keyCode + " does not exist in Font", J2DM_ConsoleMessageTypes.ERROR);
                return;
            }
            this._text[0] = String.valueOf(this._text[0]) + newKey;
            this._xCursor += this._font.getCharWidth(newKey);
            this._stateInsertKey = 1;
            this._timeInsert = System.currentTimeMillis();
        } else {
            char charNumber;
            char newKey;
            char lastChar = this.checkLowerUpperCase(this._letterXnum[number].charAt(this._indiceSubNumero));
            this._xCursor -= this._font.getCharWidth(lastChar);
            ++this._indiceSubNumero;
            if (this._indiceSubNumero >= this._letterXnum[number].length()) {
                this._indiceSubNumero = 0;
            }
            if (!this._font.hasCharacter(newKey = this.checkLowerUpperCase(charNumber = this._letterXnum[number].charAt(this._indiceSubNumero)))) {
                J2DM_Console.getInstance().addLog("J2DM_InputTextSpecial::specialKeyPressed", "The keyCode " + keyCode + " does not exist in Font", J2DM_ConsoleMessageTypes.ERROR);
                return;
            }
            this._text[0] = String.valueOf(this._text[0].substring(0, this._text[0].length() - 1)) + newKey;
            this._xCursor += this._font.getCharWidth(newKey);
            this._timeInsert = System.currentTimeMillis();
        }
        this._lastKeyPressed = keyCode;
    }

    public void specialKeyPressed(int keyCode) {
        super.specialKeyPressed(keyCode);
        System.out.println("specialKeyPressed():" + keyCode);
        if (keyCode == -7) {
            this.deleteKey();
        }
    }

    public void draw(J2DM_Graphics g) {
        long newTimeInsert;
        super.draw(g);
        if (this._stateInsertKey == 1 && (newTimeInsert = System.currentTimeMillis()) - this._timeInsert > (long)this._replaceTime) {
            this._stateInsertKey = 0;
        }
    }
}

