/*
 * Decompiled with CFR 0.152.
 */
package tv.ingames.j2dm.ingames;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import tv.ingames.j2dm.core.J2DM_AbstractGameLoop;
import tv.ingames.j2dm.ingames.J2DM_GameData;
import tv.ingames.j2dm.ingames.J2DM_Releases;
import tv.ingames.j2dm.system.debug.console.J2DM_Console;
import tv.ingames.j2dm.system.debug.console.J2DM_ConsoleMessageTypes;
import tv.ingames.j2dm.utils.J2DM_Utils;

public class J2DM_Ingames {
    private static J2DM_Ingames _instance;
    private Hashtable _table;
    private int _release;
    private int _gameId;
    private int _platform;

    private J2DM_Ingames() {
        this.init();
    }

    public static J2DM_Ingames getInstance() {
        if (_instance == null) {
            _instance = new J2DM_Ingames();
        }
        return _instance;
    }

    private void init() {
        this._release = J2DM_AbstractGameLoop.getCurrentRelease();
        this._gameId = J2DM_AbstractGameLoop.getCurrentGameId();
        this._platform = J2DM_Releases.getCurrentPlatformFromRelease(this._release);
        this._table = new Hashtable();
        J2DM_GameData gameData = new J2DM_GameData();
        gameData.setGameId(0);
        gameData.setGameName("Crystal Balls");
        gameData.setBlackberryAdId(25434);
        if (this._platform == 0) {
            gameData.setUrlVendor("http://appworld.blackberry.com/webstore/vendor/2872");
            gameData.setUrlFreeVersion("http://appworld.blackberry.com/webstore/content/12827?lang=en");
            gameData.setUrlPaidVersion("http://appworld.blackberry.com/webstore/content/11229?lang=en");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/crystalBalls.php");
            gameData.setInnerActiveDistChannel("635");
            switch (this._release) {
                case 0: {
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls_BB");
                    break;
                }
                case 1: {
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls_BB_Getjar");
                    break;
                }
                case 2: {
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls_BB_mobi");
                }
            }
        } else if (this._platform == 1) {
            gameData.setUrlVendor("http://store.ovi.com/publisher/ingames/");
            gameData.setUrlFreeVersion("http://store.ovi.com/content/75740");
            gameData.setUrlPaidVersion("http://store.ovi.com/content/75728");
            switch (this._release) {
                case 100: {
                    gameData.setInnerActiveDistChannel("551");
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls_OVI");
                    break;
                }
                case 101: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls_J2ME_Getjar");
                    break;
                }
                case 102: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls_J2ME_mobie");
                }
            }
        } else if (this._platform == 2) {
            gameData.setUrlVendor("https://play.google.com/store/apps/developer?id=ingames");
            gameData.setUrlFreeVersion("");
            gameData.setUrlPaidVersion("market://details?id=tv.ingames.crystalBallsII.platform");
            gameData.setFlurryAdSpace("CrystalBalls_AndroidMarketFree");
        }
        this._table.put("0", gameData);
        gameData = new J2DM_GameData();
        gameData.setGameId(1);
        gameData.setGameName("Crash Balls");
        gameData.setBlackberryAdId(0);
        if (this._platform == 0) {
            gameData.setUrlVendor("http://appworld.blackberry.com/webstore/vendor/2872");
            gameData.setUrlFreeVersion("http://appworld.blackberry.com/webstore/content/30288?lang=en");
            gameData.setUrlPaidVersion("http://appworld.blackberry.com/webstore/content/29714?lang=en");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/crashBalls.php");
            gameData.setInnerActiveDistChannel("635");
            switch (this._release) {
                case 0: {
                    gameData.setInnerActiveIdContent("Ingame_CrashBalls_BB");
                    break;
                }
                case 1: {
                    gameData.setInnerActiveIdContent("Ingame_CrashBalls_BB_Getjar");
                    break;
                }
                case 2: {
                    gameData.setInnerActiveIdContent("Ingame_CrashBalls_BB_mobi");
                }
            }
        } else if (this._platform == 1) {
            gameData.setUrlVendor("http://store.ovi.com/publisher/ingames/");
            gameData.setUrlFreeVersion("http://store.ovi.com/content/113249");
            gameData.setUrlPaidVersion("http://store.ovi.com/content/113245");
            switch (this._release) {
                case 100: {
                    gameData.setInnerActiveDistChannel("551");
                    gameData.setInnerActiveIdContent("Ingame_CrashBalls_OVI");
                    break;
                }
                case 101: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("Ingame_CrashBalls_J2ME_Getjar");
                    break;
                }
                case 102: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("Ingame_CrashBalls_J2ME_mobie");
                }
            }
        }
        this._table.put("1", gameData);
        gameData = new J2DM_GameData();
        gameData.setGameId(2);
        gameData.setGameName("Cube Match");
        gameData.setBlackberryAdId(33846);
        if (this._platform == 0) {
            gameData.setUrlVendor("http://appworld.blackberry.com/webstore/vendor/2872");
            gameData.setUrlFreeVersion("http://appworld.blackberry.com/webstore/content/50671?lang=en");
            gameData.setUrlPaidVersion("http://appworld.blackberry.com/webstore/content/50670?lang=en");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/cubeMatch.php");
            gameData.setInnerActiveDistChannel("635");
            switch (this._release) {
                case 0: {
                    gameData.setInnerActiveIdContent("InGame_CubeMatch_BB");
                    break;
                }
                case 1: {
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 2: {
                    gameData.setInnerActiveIdContent("");
                }
            }
        } else if (this._platform == 1) {
            gameData.setUrlVendor("http://store.ovi.com/publisher/ingames/");
            gameData.setUrlFreeVersion("http://store.ovi.com/content/163277");
            gameData.setUrlPaidVersion("http://store.ovi.com/content/163168");
            switch (this._release) {
                case 100: {
                    gameData.setInnerActiveDistChannel("551");
                    gameData.setInnerActiveIdContent("InGame_CubeMatch_Ovi");
                    break;
                }
                case 101: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 102: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                }
            }
        }
        this._table.put("2", gameData);
        gameData = new J2DM_GameData();
        gameData.setGameId(3);
        gameData.setGameName("Egyptian Jewels");
        gameData.setBlackberryAdId(33249);
        if (this._platform == 0) {
            gameData.setUrlVendor("http://appworld.blackberry.com/webstore/vendor/2872");
            gameData.setUrlFreeVersion("http://appworld.blackberry.com/webstore/content/56807?lang=en");
            gameData.setUrlPaidVersion("http://appworld.blackberry.com/webstore/content/56806?lang=en");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/egyptianJewels.php");
            gameData.setInnerActiveDistChannel("635");
            switch (this._release) {
                case 0: {
                    gameData.setInnerActiveIdContent("Ingame_EgyptianJewels_BB");
                    break;
                }
                case 1: {
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 2: {
                    gameData.setInnerActiveIdContent("");
                }
            }
        } else if (this._platform == 1) {
            gameData.setUrlVendor("http://store.ovi.com/publisher/ingames/");
            gameData.setUrlFreeVersion("http://store.ovi.com/content/209047");
            gameData.setUrlPaidVersion("http://store.ovi.com/content/209045");
            switch (this._release) {
                case 100: {
                    gameData.setInnerActiveDistChannel("551");
                    gameData.setInnerActiveIdContent("Ingame_EgyptianJewels_OVI");
                    break;
                }
                case 101: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 102: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                }
            }
        }
        this._table.put("3", gameData);
        gameData = new J2DM_GameData();
        gameData.setGameId(4);
        gameData.setGameName("Crystal Balls II");
        gameData.setOceanParam1(83538);
        gameData.setOceanParam2(18500);
        gameData.setBlackberryAdId(86317);
        if (this._platform == 0) {
            gameData.setUrlVendor("http://appworld.blackberry.com/webstore/vendor/2872");
            gameData.setUrlFreeVersion("http://appworld.blackberry.com/webstore/content/83309");
            gameData.setUrlPaidVersion("http://appworld.blackberry.com/webstore/content/83312");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/crystalBallsII.php");
            gameData.setInnerActiveDistChannel("635");
            switch (this._release) {
                case 0: {
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls2_BB");
                    break;
                }
                case 1: {
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 2: {
                    gameData.setInnerActiveIdContent("");
                }
            }
        } else if (this._platform == 1) {
            gameData.setUrlVendor("http://store.ovi.com/publisher/ingames/");
            gameData.setUrlFreeVersion("http://store.ovi.com/content/271170");
            gameData.setUrlPaidVersion("http://store.ovi.com/content/271183");
            switch (this._release) {
                case 100: {
                    gameData.setInnerActiveDistChannel("551");
                    gameData.setInnerActiveIdContent("Ingame_CrystalBalls2_J2ME_OVI");
                    break;
                }
                case 101: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 102: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                }
            }
        }
        this._table.put("4", gameData);
        gameData = new J2DM_GameData();
        gameData.setGameId(5);
        gameData.setGameName("Explosive Bomb");
        gameData.setBlackberryAdId(86317);
        if (this._platform == 0) {
            gameData.setUrlVendor("http://appworld.blackberry.com/webstore/vendor/2872");
            gameData.setUrlFreeVersion("");
            gameData.setUrlPaidVersion("");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/explosiveBomb.php");
            gameData.setInnerActiveDistChannel("635");
            switch (this._release) {
                case 0: {
                    gameData.setInnerActiveIdContent("Ingame_ExplosiveBomb_BB");
                    break;
                }
                case 1: {
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 2: {
                    gameData.setInnerActiveIdContent("");
                }
            }
        } else if (this._platform == 1) {
            gameData.setUrlVendor("http://store.ovi.com/publisher/ingames/");
            gameData.setUrlFreeVersion("http://store.ovi.com/content/274814");
            gameData.setUrlPaidVersion("http://store.ovi.com/content/274815");
            gameData.setUrlPhp("http://www.ingames.tv/mobile/adServiceManager/crystalBallsII.php");
            switch (this._release) {
                case 100: {
                    gameData.setInnerActiveDistChannel("551");
                    gameData.setInnerActiveIdContent("Ingame_ExplosiveBomb_OVI");
                    break;
                }
                case 101: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                    break;
                }
                case 102: {
                    gameData.setInnerActiveDistChannel("636");
                    gameData.setInnerActiveIdContent("");
                }
            }
        }
        this._table.put("5", gameData);
    }

    public J2DM_GameData getMyGameData() {
        if (this._table.containsKey(String.valueOf(this._gameId))) {
            return (J2DM_GameData)this._table.get(String.valueOf(this._gameId));
        }
        J2DM_Console.getInstance().addLog("J2DM_Ingames::getMyGameData", "The actual gameId has no data, gameId=" + this._gameId, J2DM_ConsoleMessageTypes.FRAMEWORK_ERROR);
        return null;
    }

    public J2DM_GameData[] getGameDataSpam() {
        Vector<J2DM_GameData> gameDataVector = new Vector<J2DM_GameData>();
        Enumeration e = this._table.keys();
        while (e.hasMoreElements()) {
            J2DM_GameData gameData;
            String idGameString = (String)e.nextElement();
            int idGame = Integer.parseInt(idGameString);
            if (idGame == this._gameId || (gameData = (J2DM_GameData)this._table.get(idGameString)).getUrlFreeVersion() == "") continue;
            gameDataVector.addElement(gameData);
        }
        int cant = gameDataVector.size();
        J2DM_GameData[] gameDataArray = new J2DM_GameData[cant];
        int i = 0;
        while (i < cant) {
            gameDataArray[i] = (J2DM_GameData)gameDataVector.elementAt(i);
            ++i;
        }
        return gameDataArray;
    }

    public J2DM_GameData[] getAllGameData() {
        Vector<J2DM_GameData> gameDataVector = new Vector<J2DM_GameData>();
        Enumeration e = this._table.keys();
        while (e.hasMoreElements()) {
            String idGameString = (String)e.nextElement();
            J2DM_GameData gameData = (J2DM_GameData)this._table.get(idGameString);
            gameDataVector.addElement(gameData);
        }
        int cant = gameDataVector.size();
        J2DM_GameData[] gameDataArray = new J2DM_GameData[cant];
        int i = 0;
        while (i < cant) {
            gameDataArray[i] = (J2DM_GameData)gameDataVector.elementAt(i);
            ++i;
        }
        return gameDataArray;
    }

    public String getMailSupportIngames() {
        return "support@ingames.tv";
    }

    public J2DM_GameData getRandomDataBanner() {
        J2DM_GameData[] dataSpam = this.getGameDataSpam();
        J2DM_GameData dataBanner = dataSpam[Math.abs(J2DM_Utils.getRandom() % dataSpam.length)];
        return dataBanner;
    }
}

